/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.model.resource;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ExtensibleURIConverterImpl;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.emf.henshin.model.HenshinPackage;
import org.eclipse.emf.henshin.model.TransformationSystem;
import org.eclipse.emf.henshin.model.resource.HenshinResourceFactory;

public class HenshinResourceSet
extends ResourceSetImpl {
    private URI baseDir;

    public HenshinResourceSet(String baseDir) {
        EcorePackage.eINSTANCE.getName();
        HenshinPackage.eINSTANCE.getName();
        try {
            Class<?> clazz = Class.forName("org.eclipse.emf.henshin.trace.impl.TracePackageImpl");
            if (clazz != null) {
                clazz.getMethod("init", new Class[0]).invoke(clazz, new Object[0]);
            }
        }
        catch (Throwable throwable) {}
        this.registerXMIResourceFactories("henshin", "ecore", "xmi");
        if (baseDir != null) {
            if (!(baseDir = new File(baseDir).getAbsolutePath()).endsWith(File.separator)) {
                baseDir = String.valueOf(baseDir) + File.separator;
            }
            this.baseDir = URI.createFileURI((String)baseDir);
            this.setURIConverter((URIConverter)new BaseDirURIConverter());
        }
    }

    public HenshinResourceSet() {
        this(null);
    }

    public URI getBaseDir() {
        return this.baseDir;
    }

    public void registerXMIResourceFactories(String ... fileExtensions) {
        Map map = this.getResourceFactoryRegistry().getExtensionToFactoryMap();
        String[] stringArray = fileExtensions;
        int n = fileExtensions.length;
        int n2 = 0;
        while (n2 < n) {
            String extension = stringArray[n2];
            Object factory = "henshin".equals(extension) ? new HenshinResourceFactory() : ("ecore".equals(extension) ? new EcoreResourceFactoryImpl() : new XMIResourceFactoryImpl());
            if (!map.containsKey(extension)) {
                map.put(extension, factory);
            }
            ++n2;
        }
    }

    public List<EPackage> registerDynamicEPackages(String ecorePath) {
        ArrayList<EPackage> result = new ArrayList<EPackage>();
        try {
            Resource resource = this.getResource(ecorePath);
            TreeIterator it = resource.getAllContents();
            while (it.hasNext()) {
                EObject next = (EObject)it.next();
                if (!(next instanceof EPackage)) continue;
                result.add((EPackage)next);
                this.getPackageRegistry().put((Object)((EPackage)next).getNsURI(), (Object)next);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return result;
    }

    public Resource getResource(String path) {
        return this.getResource(URI.createFileURI((String)path), true);
    }

    public EObject getObject(String path) {
        Resource resource = this.getResource(path);
        if (resource != null && !resource.getContents().isEmpty()) {
            return (EObject)resource.getContents().get(0);
        }
        return null;
    }

    public TransformationSystem getTransformationSystem(String path) {
        return (TransformationSystem)this.getObject(path);
    }

    public void saveObject(EObject object, String path) {
        URI uri = URI.createFileURI((String)path);
        Resource resource = this.createResource(uri);
        resource.getContents().clear();
        resource.getContents().add((Object)object);
        HashMap<String, Boolean> options = new HashMap<String, Boolean>();
        options.put("SCHEMA_LOCATION", Boolean.TRUE);
        try {
            resource.save(options);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private class BaseDirURIConverter
    extends ExtensibleURIConverterImpl {
        private BaseDirURIConverter() {
        }

        public URI normalize(URI uri) {
            if (uri.isFile() && uri.isRelative() && HenshinResourceSet.this.baseDir != null) {
                return uri.resolve(HenshinResourceSet.this.baseDir);
            }
            return super.normalize(uri);
        }
    }
}

