/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.statespace.external.prism;

import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.statespace.State;
import org.eclipse.emf.henshin.statespace.StateSpace;
import org.eclipse.emf.henshin.statespace.StateSpaceIndex;
import org.eclipse.emf.henshin.statespace.StateSpacePlugin;
import org.eclipse.emf.henshin.statespace.Transition;
import org.eclipse.emf.henshin.statespace.external.AbstractStateSpaceExporter;
import org.eclipse.emf.henshin.statespace.external.prism.MDPLabel;
import org.eclipse.emf.henshin.statespace.external.prism.PRISMUtil;
import org.eclipse.emf.henshin.statespace.tuples.SimpleTupleGenerator;
import org.eclipse.emf.henshin.statespace.tuples.Tuple;
import org.eclipse.emf.henshin.statespace.tuples.TupleGenerator;
import org.eclipse.emf.henshin.statespace.tuples.TupleUtil;

public class MDPStateSpaceExporter
extends AbstractStateSpaceExporter {
    public void export(StateSpace stateSpace, URI uri, String parameters, IProgressMonitor monitor) throws IOException {
        int stateCount = stateSpace.getStates().size();
        monitor.beginTask("Exporting state space...", 3 * stateCount);
        boolean explicit = "tra".equalsIgnoreCase(uri.fileExtension());
        this.tuples = TupleUtil.generateTuples((TupleGenerator)new SimpleTupleGenerator(), (StateSpaceIndex)this.index, (boolean)true, (IProgressMonitor)new SubProgressMonitor(monitor, stateCount));
        Map<String, List<Rule>> probRules = PRISMUtil.getProbabilisticRules(stateSpace);
        File file = new File(uri.toFileString());
        OutputStreamWriter writer = MDPStateSpaceExporter.createWriter(file);
        Map<String, String> probs = PRISMUtil.getAllProbs(stateSpace, explicit);
        if (!explicit) {
            writer.write(PRISMUtil.getModelHeader("mdp"));
            for (String ruleName : probRules.keySet()) {
                List<Rule> rules = probRules.get(ruleName);
                if (rules.size() <= 1) continue;
                int i = 0;
                while (i < rules.size()) {
                    String key = PRISMUtil.getProbKey((Rule)rules.get(i), i);
                    String value = probs.get(key);
                    writer.write("const double " + key);
                    if (value != null && !PRISMUtil.Range.isRange(value)) {
                        writer.write(" = " + value);
                    }
                    writer.write(";\n");
                    ++i;
                }
            }
            writer.write("\nmodule " + uri.trimFileExtension().lastSegment() + "\n\n");
        }
        if (explicit) {
            writer.write(String.valueOf(stateCount) + " " + stateSpace.getTransitionCount() + "\n");
        } else {
            writer.write(PRISMUtil.getVariableDeclarations(this.tuples, false));
        }
        int removedIllegal = 0;
        for (State s : stateSpace.getStates()) {
            Map<MDPLabel, List<Transition>> trs = MDPLabel.getTransitionsByLabel(s);
            int transitionIndex = 0;
            for (MDPLabel l : trs.keySet()) {
                List<Transition> ts = trs.get(l);
                if (ts.isEmpty()) continue;
                String label = l.getTransition().getRule().getName();
                List<Rule> rules = probRules.get(label);
                boolean allEnabled = true;
                for (Rule r : rules) {
                    boolean enabled = false;
                    for (Transition t : ts) {
                        if (t.getRule() != r) continue;
                        enabled = true;
                        break;
                    }
                    if (enabled) continue;
                    allEnabled = false;
                    break;
                }
                if (!allEnabled) {
                    ++removedIllegal;
                    continue;
                }
                if (!explicit) {
                    writer.write("\t[" + label + "] " + PRISMUtil.getPRISMState((Tuple)this.tuples.get(s.getIndex()), false) + " -> ");
                }
                boolean first = true;
                for (Transition t : ts) {
                    String prob;
                    if (!first) {
                        writer.write(explicit ? "\n" : " + ");
                    }
                    String probKey = PRISMUtil.getProbKey(t.getRule(), rules.indexOf(t.getRule()));
                    if (explicit) {
                        prob = rules.size() > 1 ? probs.get(probKey) : "1";
                        writer.write(String.valueOf(s.getIndex()) + " " + transitionIndex + " " + t.getTarget().getIndex() + " " + prob);
                    } else {
                        prob = rules.size() > 1 ? String.valueOf(probKey) + ":" : "";
                        writer.write(String.valueOf(prob) + PRISMUtil.getPRISMState((Tuple)this.tuples.get(t.getTarget().getIndex()), true));
                    }
                    first = false;
                }
                if (explicit) {
                    writer.write("\n");
                    ++transitionIndex;
                    continue;
                }
                writer.write(";\n");
            }
            monitor.worked(1);
            if (monitor.isCanceled()) break;
        }
        if (removedIllegal > 0) {
            StateSpacePlugin.INSTANCE.logWarning("Removed " + removedIllegal + " illegal probabilistic transitions");
        }
        if (!explicit) {
            writer.write("\nendmodule\n\n");
            writer.write("init\n\t");
            int i = 0;
            while (i < stateSpace.getInitialStates().size()) {
                Tuple t = (Tuple)this.tuples.get(((State)stateSpace.getInitialStates().get(i)).getIndex());
                writer.write(PRISMUtil.getPRISMState(t, false));
                if (i < stateSpace.getInitialStates().size() - 1) {
                    writer.write(" | ");
                }
                ++i;
            }
            writer.write("\nendinit\n");
        }
        if (parameters != null) {
            try {
                String expanded = PRISMUtil.expandLabels(parameters, this.index, this.tuples, (IProgressMonitor)new SubProgressMonitor(monitor, stateCount));
                if (explicit) {
                    OutputStreamWriter labelsWriter = MDPStateSpaceExporter.createWriter(new File(uri.toFileString().replaceAll(".tra", ".lab")));
                    labelsWriter.write(expanded);
                    labelsWriter.close();
                } else {
                    writer.write("\n" + expanded + "\n");
                }
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        if (explicit) {
            OutputStreamWriter statesWriter = MDPStateSpaceExporter.createWriter(new File(uri.toFileString().replaceAll(".tra", ".sta")));
            statesWriter.write(String.valueOf(PRISMUtil.getVariableDeclarations(this.tuples, true)) + "\n");
            int i = 0;
            while (i < stateCount) {
                statesWriter.write(String.valueOf(i) + ":" + this.tuples.get(i) + "\n");
                ++i;
            }
            statesWriter.close();
        }
        writer.close();
        if (!monitor.isCanceled()) {
            monitor.done();
        }
    }

    public String getName() {
        return "PRISM MDP";
    }

    public String[] getFileExtensions() {
        return new String[]{"nm", "tra"};
    }
}

