/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.statespace.util;

import java.util.List;
import org.eclipse.emf.ecore.EClass;

public class ObjectKeyHelper {
    public static EClass getObjectType(int objectKey, List<EClass> identityTypes) {
        int index = (objectKey >>> 24 & 0xFF) - 1;
        if (index >= 0 && index < identityTypes.size()) {
            return identityTypes.get(index);
        }
        return null;
    }

    public static String getObjectTypePrefix(int objectKey) {
        int index = (objectKey >>> 24 & 0xFF) - 1;
        return String.valueOf((char)(97 + index));
    }

    public static int getObjectID(int objectKey) {
        return objectKey & 0xFFFFFF;
    }

    public static int createObjectKey(EClass type, int id, List<EClass> identityTypes) {
        int typeId = identityTypes.indexOf(type) + 1;
        if (typeId == 0) {
            id = 0;
        }
        return (typeId & 0xFF) << 24 | id & 0xFFFFFF;
    }
}

