/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.interpreter.ui.wizard;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.henshin.HenshinModelExporter;
import org.eclipse.emf.henshin.HenshinModelPlugin;
import org.eclipse.emf.henshin.model.Module;
import org.eclipse.emf.henshin.model.resource.HenshinResourceSet;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class HenshinModelExportWizard
extends Wizard
implements IExportWizard {
    private ChooseExporterPage chooseExporterPage;
    private FileCreationPage fileCreationPage;
    private IWorkbench workbench;
    private Module module;
    private IStructuredSelection selection;
    private String baseName;
    private ImageDescriptor wizban = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.ui", (String)"$nl$/icons/full/wizban/export_wiz.png");

    public HenshinModelExportWizard() {
        this.setNeedsProgressMonitor(true);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle("Export Transformation Model");
        this.workbench = workbench;
        this.selection = selection;
        if (selection != null) {
            Iterator iterator = selection.iterator();
            while (iterator.hasNext() && this.module == null) {
                Object current = iterator.next();
                if (current instanceof Module) {
                    this.module = (Module)current;
                    continue;
                }
                if (!(current instanceof IFile)) continue;
                HenshinResourceSet resourceSet = new HenshinResourceSet();
                URI fileURI = URI.createPlatformResourceURI((String)((IFile)current).getFullPath().toString(), (boolean)true);
                try {
                    this.module = (Module)resourceSet.getResource(fileURI, true).getContents().get(0);
                }
                catch (Throwable t) {
                    HenshinModelPlugin.INSTANCE.logError("Error loading transformation model from file " + fileURI.toFileString(), t);
                }
            }
        }
        if (this.module == null) {
            throw new RuntimeException("Module not set");
        }
        this.baseName = this.module.eResource().getURI().trimFileExtension().lastSegment();
    }

    public void addPages() {
        this.chooseExporterPage = new ChooseExporterPage("exporter-selection");
        this.addPage((IWizardPage)this.chooseExporterPage);
        this.fileCreationPage = new FileCreationPage("file-creation", this.selection);
        this.addPage((IWizardPage)this.fileCreationPage);
    }

    private void updateFileName(String ext) {
        String directory = this.module.eResource().getURI().trimSegments(1).toPlatformString(true);
        IContainer container = (IContainer)ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(directory));
        this.fileCreationPage.setContainerFullPath(container.getFullPath());
        String filename = String.valueOf(this.baseName) + "." + ext;
        int i = 1;
        while (container.findMember(filename) != null) {
            filename = String.valueOf(this.baseName) + i + "." + ext;
            ++i;
        }
        this.fileCreationPage.setFileName(filename);
    }

    private static String printAllowedExtensions(HenshinModelExporter exporter) {
        String[] allowed = exporter.getExportFileExtensions();
        String pretty = "";
        int i = 0;
        while (i < allowed.length) {
            pretty = String.valueOf(pretty) + "*." + allowed[i];
            if (i < allowed.length - 1) {
                pretty = String.valueOf(pretty) + ", ";
            }
            ++i;
        }
        return pretty;
    }

    public void setModule(Module module) {
        this.module = module;
    }

    public boolean performFinish() {
        try {
            final IFile file = this.getFile();
            final HenshinModelExporter exporter = this.getExporter();
            WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

                protected void execute(IProgressMonitor monitor) {
                    IStatus status = HenshinModelExportWizard.this.performExport(exporter, file, monitor);
                    if (status.getSeverity() == 4) {
                        MessageDialog.openError((Shell)HenshinModelExportWizard.this.getShell(), (String)"Export Transformation Model", (String)status.getMessage());
                        HenshinModelPlugin.INSTANCE.logError("Error exporting transformation model: " + status.getMessage(), status.getException());
                    }
                    if (status.getSeverity() == 2) {
                        MessageDialog.openWarning((Shell)HenshinModelExportWizard.this.getShell(), (String)"Export Transformation Model", (String)status.getMessage());
                        HenshinModelPlugin.INSTANCE.logError(status.getMessage(), status.getException());
                    }
                }
            };
            this.getContainer().run(false, false, (IRunnableWithProgress)operation);
            file.getParent().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
            if (file.exists()) {
                this.openExportedFile(file);
            }
            return true;
        }
        catch (Throwable t) {
            HenshinModelPlugin.INSTANCE.logError("Error exporting transformation model", t);
            return false;
        }
    }

    protected IStatus performExport(HenshinModelExporter exporter, IFile file, IProgressMonitor monitor) {
        IStatus status;
        monitor.beginTask("Exporting transformation model...", -1);
        URI fileURI = URI.createFileURI((String)file.getLocation().toOSString());
        try {
            try {
                status = exporter.doExport(this.module, fileURI);
            }
            catch (Throwable t) {
                status = new Status(4, "org.eclipse.emf.henshin.model", "Error running exporter", t);
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
        return status;
    }

    protected void openExportedFile(IFile file) {
        try {
            IWorkbenchWindow window = this.workbench.getActiveWorkbenchWindow();
            IWorkbenchPage page = window.getActivePage();
            IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
        }
        catch (Throwable t) {
            HenshinModelPlugin.INSTANCE.logError("Error opening exported file.", t);
        }
    }

    public IFile getFile() {
        return this.fileCreationPage.getFile();
    }

    public HenshinModelExporter getExporter() {
        return this.chooseExporterPage.getExporter();
    }

    protected class ChooseExporterPage
    extends WizardPage {
        private List<HenshinModelExporter> exporters;
        private int current;

        public ChooseExporterPage(String pageId) {
            super(pageId);
            this.current = 0;
            this.setDescription("Choose an exporter");
            if (HenshinModelExportWizard.this.wizban != null) {
                this.setImageDescriptor(HenshinModelExportWizard.this.wizban);
            }
            this.exporters = new ArrayList(HenshinModelPlugin.INSTANCE.getExporters().values());
            Collections.sort(this.exporters, new Comparator<HenshinModelExporter>(){

                @Override
                public int compare(HenshinModelExporter o1, HenshinModelExporter o2) {
                    return String.valueOf(o1.getExporterName()).compareTo(String.valueOf(o2.getExporterName()));
                }
            });
        }

        public void createControl(Composite parent) {
            Composite container = new Composite(parent, 0);
            container.setLayout((Layout)new FillLayout());
            final org.eclipse.swt.widgets.List list = new org.eclipse.swt.widgets.List(container, 2048);
            for (HenshinModelExporter exporter : this.exporters) {
                list.add(String.valueOf(exporter.getExporterName()) + " (" + HenshinModelExportWizard.printAllowedExtensions(exporter) + ")");
            }
            list.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    ChooseExporterPage.this.current = list.getSelectionIndex();
                    ChooseExporterPage.this.updateFilePage();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                    ChooseExporterPage.this.getContainer().showPage((IWizardPage)HenshinModelExportWizard.this.fileCreationPage);
                }
            });
            list.select(this.current);
            this.updateFilePage();
            this.setControl((Control)container);
        }

        private void updateFilePage() {
            String[] fileExts;
            if (HenshinModelExportWizard.this.fileCreationPage != null && this.current < this.exporters.size() && (fileExts = this.exporters.get(this.current).getExportFileExtensions()).length > 0) {
                HenshinModelExportWizard.this.updateFileName(fileExts[0]);
            }
        }

        public HenshinModelExporter getExporter() {
            return this.exporters.get(this.current);
        }
    }

    protected class FileCreationPage
    extends WizardNewFileCreationPage {
        public FileCreationPage(String pageId, IStructuredSelection selection) {
            super(pageId, selection);
            this.setDescription("Choose the target file for the export ");
            if (HenshinModelExportWizard.this.wizban != null) {
                this.setImageDescriptor(HenshinModelExportWizard.this.wizban);
            }
        }

        protected boolean validatePage() {
            if (!super.validatePage()) {
                return false;
            }
            String extension = new Path(this.getFileName()).getFileExtension();
            String[] allowed = HenshinModelExportWizard.this.getExporter().getExportFileExtensions();
            boolean ok = false;
            int i = 0;
            while (i < allowed.length) {
                if (String.valueOf(allowed[i]).equals(extension)) {
                    ok = true;
                }
                ++i;
            }
            if (!ok) {
                this.setErrorMessage("Invalid file extension, should be one of " + HenshinModelExportWizard.printAllowedExtensions(HenshinModelExportWizard.this.getExporter()));
                return false;
            }
            return true;
        }

        public IFile getFile() {
            return ResourcesPlugin.getWorkspace().getRoot().getFile(this.getContainerFullPath().append(this.getFileName()));
        }
    }
}

