/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.interpreter.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.DynamicEObjectImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.henshin.interpreter.EGraph;
import org.eclipse.emf.henshin.interpreter.Engine;
import org.eclipse.emf.henshin.interpreter.Match;
import org.eclipse.emf.henshin.interpreter.RuleApplication;
import org.eclipse.emf.henshin.interpreter.UnitApplication;
import org.eclipse.emf.henshin.interpreter.impl.EGraphImpl;
import org.eclipse.emf.henshin.interpreter.impl.UnitApplicationImpl;
import org.eclipse.emf.henshin.interpreter.util.EGraphIsomorphyChecker;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.model.Unit;

public class InterpreterUtil {
    public static List<Match> findAllMatches(Engine engine, Rule rule, EGraph graph, Match partialMatch) {
        ArrayList<Match> matches = new ArrayList<Match>();
        for (Match match : engine.findMatches(rule, graph, partialMatch)) {
            matches.add(match);
        }
        return matches;
    }

    public static void executeOrDie(UnitApplication application) {
        if (!application.execute(null)) {
            if (application instanceof RuleApplication) {
                throw new AssertionError((Object)("Error executing transformation rule '" + application.getUnit().getName() + "'"));
            }
            throw new AssertionError((Object)("Error executing transformation unit '" + application.getUnit().getName() + "'"));
        }
    }

    public static boolean applyToResource(Unit unit, Engine engine, Resource resource) {
        EGraphImpl graph = new EGraphImpl(resource);
        UnitApplicationImpl application = new UnitApplicationImpl(engine, graph, unit, null);
        HashSet<EObject> oldRoots = new HashSet<EObject>();
        oldRoots.addAll(graph.getRoots());
        boolean result = application.execute(null);
        List<EObject> roots = graph.getRoots();
        Iterator it = resource.getContents().iterator();
        while (it.hasNext()) {
            if (roots.contains(it.next())) continue;
            it.remove();
        }
        for (EObject root : roots) {
            if (oldRoots.contains(root)) continue;
            resource.getContents().add((Object)root);
        }
        return result;
    }

    public static boolean areIsomorphic(EGraph graph1, EGraph graph2) {
        return new EGraphIsomorphyChecker(graph1, null).isIsomorphicTo(graph2, null);
    }

    public static boolean areIsomorphic(Resource resource1, Resource resource2) {
        return InterpreterUtil.areIsomorphic(new EGraphImpl(resource1), new EGraphImpl(resource2));
    }

    public static int countEdges(EGraph graph) {
        int links = 0;
        for (EObject object : graph) {
            for (EReference ref : object.eClass().getEAllReferences()) {
                if (ref.isMany()) {
                    links += ((EList)object.eGet((EStructuralFeature)ref)).size();
                    continue;
                }
                if (object.eGet((EStructuralFeature)ref) == null) continue;
                ++links;
            }
        }
        return links;
    }

    public static String objectToString(Object object) {
        EClass eclass;
        if (object instanceof String) {
            return "'" + object + "'";
        }
        if (object instanceof DynamicEObjectImpl && (eclass = ((DynamicEObjectImpl)object).eClass()) != null) {
            String type = eclass.getName();
            EPackage epackage = eclass.getEPackage();
            while (epackage != null) {
                type = String.valueOf(epackage.getName()) + "." + type;
                epackage = epackage.getESuperPackage();
            }
            String args = "";
            for (EAttribute att : eclass.getEAllAttributes()) {
                args = String.valueOf(args) + ", " + att.getName() + "=" + InterpreterUtil.objectToString(((DynamicEObjectImpl)object).eGet((EStructuralFeature)att));
            }
            return String.valueOf(type) + "@" + Integer.toHexString(object.hashCode()) + " (dynamic" + args + ")";
        }
        return String.valueOf(object);
    }
}

