/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.testframework;

import java.util.Iterator;
import org.eclipse.emf.henshin.interpreter.EGraph;
import org.eclipse.emf.henshin.interpreter.Engine;
import org.eclipse.emf.henshin.interpreter.InterpreterFactory;
import org.eclipse.emf.henshin.interpreter.Match;
import org.eclipse.emf.henshin.interpreter.RuleApplication;
import org.eclipse.emf.henshin.model.Rule;

public class Rules {
    public static void assertRuleHasMatch(Rule rule, EGraph graph, Match partialMatch, Engine engine) throws AssertionError {
        if (!engine.findMatches(rule, graph, partialMatch).iterator().hasNext()) {
            throw new AssertionError((Object)("expected: Rule " + rule.getName() + " has matches, but has none"));
        }
    }

    public static void assertRuleHasNoMatch(Rule rule, EGraph graph, Match partialMatch, Engine engine) throws AssertionError {
        if (engine.findMatches(rule, graph, partialMatch).iterator().hasNext()) {
            throw new AssertionError((Object)("expected: Rule " + rule.getName() + " has no matches, but has one"));
        }
    }

    public static void assertRuleHasNMatches(Rule rule, EGraph graph, Match partialMatch, Engine engine, int n) throws AssertionError {
        int found = 0;
        Iterator iterator = engine.findMatches(rule, graph, partialMatch).iterator();
        while (iterator.hasNext()) {
            Match cfr_ignored_0 = (Match)iterator.next();
            ++found;
        }
        if (found != n) {
            throw new AssertionError((Object)("expected: Rule " + rule.getName() + " has " + n + " matches, but has " + found));
        }
    }

    public static void assertRuleCanBeAppliedMultipleTimes(Rule rule, EGraph graph, Engine engine) throws AssertionError {
        RuleApplication ra = InterpreterFactory.INSTANCE.createRuleApplication(engine);
        ra.setEGraph(graph);
        ra.setRule(rule);
        Rules.assertRuleCanBeAppliedMultipleTimes(ra);
    }

    public static void assertRuleCanBeAppliedMultipleTimes(RuleApplication ra) throws AssertionError {
        boolean success = ra.execute(null);
        if (success) {
            ra.setCompleteMatch(null);
            success = ra.execute(null);
        }
        if (!success) {
            throw new AssertionError((Object)("expected: Rule " + ra.getRule().getName() + " can be applied multiple times."));
        }
    }

    public static void assertRuleCanBeAppliedNTimes(Rule r, EGraph graph, Engine engine, int n) throws AssertionError, Exception {
        RuleApplication ra = InterpreterFactory.INSTANCE.createRuleApplication(engine);
        ra.setEGraph(graph);
        ra.setRule(r);
        Rules.assertRuleCanBeAppliedNTimes(ra, n);
    }

    public static void assertRuleCanBeAppliedNTimes(RuleApplication ra, int n) throws AssertionError, Exception {
        if (n < 0) {
            throw new Exception("n needs to be positive.");
        }
        boolean success = true;
        int i = 0;
        while (i < n) {
            success = ra.execute(null);
            if (!success) break;
            ra.setCompleteMatch(null);
            ++i;
        }
        if (!success) {
            throw new AssertionError((Object)("expected: Rule " + ra.getRule().getName() + " can be applied at least " + n + " times"));
        }
    }

    public static void assertRuleCanBeApplied(Rule r, EGraph graph, Engine engine) throws AssertionError {
        RuleApplication ra = InterpreterFactory.INSTANCE.createRuleApplication(engine);
        ra.setEGraph(graph);
        ra.setRule(r);
        Rules.assertRuleCanBeApplied(ra);
    }

    public static void assertRuleCanBeApplied(RuleApplication ra) throws AssertionError {
        if (!ra.execute(null)) {
            throw new AssertionError((Object)("expected: Rule " + ra.getRule().getName() + " can be applied."));
        }
    }
}

