/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.statespace.hashcodes;

import java.util.HashMap;
import org.eclipse.emf.henshin.statespace.EqualityHelper;
import org.eclipse.emf.henshin.statespace.Model;
import org.eclipse.emf.henshin.statespace.State;
import org.eclipse.emf.henshin.statespace.StateSpace;
import org.eclipse.emf.henshin.statespace.hashcodes.TotalHashCodeHelper;

public class StateSpaceHashCodeUtil {
    public static int computeHashCode(Model model, EqualityHelper equalityHelper) {
        if (model == null) {
            throw new NullPointerException("Cannot compute hashcode for null model");
        }
        if (model.getResource() == null) {
            throw new NullPointerException("Cannot compute hashcode for without model resource");
        }
        TotalHashCodeHelper hashCodeHelper = new TotalHashCodeHelper(equalityHelper);
        return hashCodeHelper.hashCode(model);
    }

    public static double getHashCodeCollisions(StateSpace stateSpace) {
        HashMap<Integer, Integer> numStatesPerHash = new HashMap<Integer, Integer>();
        for (State state : stateSpace.getStates()) {
            int hashcode = state.getHashCode();
            Integer numStates = (Integer)numStatesPerHash.get(hashcode);
            if (numStates == null) {
                numStatesPerHash.put(hashcode, 1);
                continue;
            }
            numStatesPerHash.put(hashcode, numStates + 1);
        }
        int sum = 0;
        for (Integer count : numStatesPerHash.values()) {
            sum += count.intValue();
        }
        double average = (double)sum / (double)numStatesPerHash.values().size();
        return average;
    }
}

