/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.diagram.parsers;

import java.util.ArrayList;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.henshin.diagram.parsers.AbstractParser;
import org.eclipse.emf.henshin.model.Edge;
import org.eclipse.emf.henshin.model.HenshinPackage;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParserEditStatus;
import org.eclipse.gmf.runtime.common.ui.services.parser.ParserEditStatus;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;

public class EdgeTypeParser
extends AbstractParser {
    public EdgeTypeParser() {
        super(new EAttribute[]{HenshinPackage.eINSTANCE.getNamedElement_Name()});
    }

    public String getPrintString(IAdaptable element, int flags) {
        Edge edge = (Edge)element.getAdapter(EObject.class);
        return edge.getType() != null ? edge.getType().getName() : "?";
    }

    public String getEditString(IAdaptable element, int flags) {
        return this.getPrintString(element, flags);
    }

    public ICommand getParseCommand(IAdaptable element, final String value, int flags) {
        final Edge edge = (Edge)element.getAdapter(EObject.class);
        TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)edge);
        if (editingDomain == null) {
            return UnexecutableCommand.INSTANCE;
        }
        AbstractTransactionalCommand command = new AbstractTransactionalCommand(editingDomain, "Parse Edge Type", null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                return EdgeTypeParser.this.doParsing(value, edge);
            }
        };
        return command;
    }

    private CommandResult doParsing(String value, Edge edge) {
        Edge origin;
        Rule rule = (Rule)edge.getGraph().eContainer();
        Node source = edge.getSource();
        if (source.getType() == null) {
            return CommandResult.newErrorCommandResult((String)"Source type must be set");
        }
        EReference type = null;
        for (EReference reference : source.getType().getEReferences()) {
            if (!value.equalsIgnoreCase(reference.getName())) continue;
            type = reference;
        }
        if (type == null) {
            return CommandResult.newErrorCommandResult((String)("Unknown reference: " + value));
        }
        ArrayList<Edge> edges = new ArrayList<Edge>();
        edges.add(edge);
        Edge image = rule.getMappings().getImage(edge, rule.getRhs());
        if (image != null) {
            edges.add(image);
        }
        if ((origin = rule.getMappings().getOrigin(edge)) != null) {
            edges.add(origin);
        }
        for (Edge current : edges) {
            current.setType(type);
        }
        if (edge.getType().getEOpposite() != null) {
            ArrayList<Edge> oppositeEdges = new ArrayList<Edge>();
            for (Edge imageTargetOutgoingEdge : image.getTarget().getOutgoing()) {
                if (!imageTargetOutgoingEdge.getType().equals(image.getType()) || !imageTargetOutgoingEdge.getTarget().equals(image.getSource())) continue;
                oppositeEdges.add(imageTargetOutgoingEdge);
            }
            for (Edge originTargetOutgoingEdge : origin.getTarget().getOutgoing()) {
                if (!originTargetOutgoingEdge.getType().equals(origin.getType()) || !originTargetOutgoingEdge.getTarget().equals(origin.getSource())) continue;
                oppositeEdges.add(originTargetOutgoingEdge);
            }
        }
        return CommandResult.newOKCommandResult();
    }

    @Override
    protected boolean isAffectingFeature(Object feature) {
        return feature == HenshinPackage.eINSTANCE.getEdge_Type();
    }

    public IParserEditStatus isValidEditString(IAdaptable element, String editString) {
        return ParserEditStatus.EDITABLE_STATUS;
    }
}

