/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.interpreter.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.DynamicEObjectImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.henshin.interpreter.ApplicationMonitor;
import org.eclipse.emf.henshin.interpreter.Assignment;
import org.eclipse.emf.henshin.interpreter.EGraph;
import org.eclipse.emf.henshin.interpreter.Engine;
import org.eclipse.emf.henshin.interpreter.Match;
import org.eclipse.emf.henshin.interpreter.RuleApplication;
import org.eclipse.emf.henshin.interpreter.UnitApplication;
import org.eclipse.emf.henshin.interpreter.impl.AssignmentImpl;
import org.eclipse.emf.henshin.interpreter.impl.EGraphImpl;
import org.eclipse.emf.henshin.interpreter.impl.UnitApplicationImpl;
import org.eclipse.emf.henshin.interpreter.util.EGraphIsomorphyChecker;
import org.eclipse.emf.henshin.interpreter.util.PartialMatchReport;
import org.eclipse.emf.henshin.model.Module;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.model.Unit;

public class InterpreterUtil {
    public static List<Match> findAllMatches(Engine engine, Rule rule, EGraph graph, Match partialMatch) {
        ArrayList<Match> matches = new ArrayList<Match>();
        for (Match match : engine.findMatches(rule, graph, partialMatch)) {
            matches.add(match);
        }
        return matches;
    }

    public static List<Match> findAllMatches(Engine engine, Module module, EGraph graph) {
        ArrayList<Match> matches = new ArrayList<Match>();
        for (Unit unit : module.getUnits()) {
            if (!(unit instanceof Rule)) continue;
            matches.addAll(InterpreterUtil.findAllMatches(engine, (Rule)unit, graph, null));
        }
        return matches;
    }

    public static List<Match> findMaximalPartialMatches(Engine engine, Module module, EGraph graph) {
        ArrayList<Match> matches = new ArrayList<Match>();
        for (Unit unit : module.getUnits()) {
            if (!(unit instanceof Rule)) continue;
            List<Object> newMatches = new ArrayList();
            newMatches = InterpreterUtil.findAllMatches(engine, (Rule)unit, graph, null);
            if (newMatches.isEmpty()) {
                newMatches = InterpreterUtil.findPartialMatchesPerRule((Rule)unit, engine, graph);
            }
            if (newMatches.isEmpty()) continue;
            matches.addAll(InterpreterUtil.removeEmptyAndDuplicatedMatches(newMatches));
        }
        return matches;
    }

    public static PartialMatchReport findAndReportMaximalPartialMatches(Engine engine, Module module, EGraph graph) {
        ArrayList<Match> matches = new ArrayList<Match>();
        PartialMatchReport partialMatchReport = new PartialMatchReport(module, matches);
        for (Unit unit : module.getUnits()) {
            if (!(unit instanceof Rule)) continue;
            List<Object> newMatches = new ArrayList();
            newMatches = InterpreterUtil.findAllMatches(engine, (Rule)unit, graph, null);
            if (newMatches.isEmpty()) {
                newMatches = InterpreterUtil.findPartialMatchesPerRule((Rule)unit, engine, graph);
            }
            if (!newMatches.isEmpty()) {
                newMatches = InterpreterUtil.removeEmptyAndDuplicatedMatches(newMatches);
            }
            partialMatchReport.collectPartialMatchInfos((Rule)unit, newMatches);
            matches.addAll(newMatches);
        }
        return partialMatchReport;
    }

    private static List<Match> removeEmptyAndDuplicatedMatches(List<Match> matches) {
        ArrayList<Match> resultingMatches = new ArrayList<Match>();
        for (Match match : matches) {
            if (match.getNodeTargets().isEmpty()) continue;
            boolean addMatch = true;
            for (Match resultingMatch : resultingMatches) {
                if (!(match.getNodeTargets().containsAll(resultingMatch.getNodeTargets()) & resultingMatch.getNodeTargets().containsAll(match.getNodeTargets()))) continue;
                addMatch = false;
                break;
            }
            if (!addMatch) continue;
            resultingMatches.add(match);
        }
        return resultingMatches;
    }

    private static List<Match> findPartialMatchesPerRule(Rule rule, Engine engine, EGraph graph) {
        ArrayList<Match> matches = new ArrayList<Match>();
        List<Rule> newRules = InterpreterUtil.reduceRule(rule);
        for (Rule newRule : newRules) {
            matches.addAll(InterpreterUtil.findAllMatches(engine, newRule, graph, null));
        }
        while (matches.isEmpty()) {
            for (Rule newRule : newRules) {
                matches.addAll(InterpreterUtil.findPartialMatchesPerRule(newRule, engine, graph));
            }
        }
        return matches;
    }

    private static List<Rule> reduceRule(Rule rule) {
        ArrayList<Rule> newRules = new ArrayList<Rule>();
        EList nodes = rule.getLhs().getNodes();
        int i = 0;
        while (i < nodes.size()) {
            Rule newRule = (Rule)EcoreUtil.copy((EObject)rule);
            newRule.getLhs().removeNode((Node)newRule.getLhs().getNodes().get(i));
            newRules.add(newRule);
            ++i;
        }
        return newRules;
    }

    public static void executeOrDie(UnitApplication application) {
        if (!application.execute(null)) {
            if (application instanceof RuleApplication) {
                throw new AssertionError((Object)("Error executing rule '" + application.getUnit().getName() + "'"));
            }
            throw new AssertionError((Object)("Error executing unit '" + application.getUnit().getName() + "'"));
        }
    }

    public static boolean applyToResource(Unit unit, Engine engine, Resource resource) {
        return InterpreterUtil.applyToResource(new AssignmentImpl(unit), engine, resource, null);
    }

    public static boolean applyToResource(Assignment assignment, Engine engine, Resource resource, ApplicationMonitor monitor) {
        EGraphImpl graph = new EGraphImpl(resource);
        UnitApplicationImpl application = new UnitApplicationImpl(engine, graph, assignment.getUnit(), assignment);
        HashSet<EObject> oldRoots = new HashSet<EObject>();
        oldRoots.addAll(graph.getRoots());
        boolean result = application.execute(monitor);
        List<EObject> roots = graph.getRoots();
        Iterator it = resource.getContents().iterator();
        while (it.hasNext()) {
            if (roots.contains(it.next())) continue;
            it.remove();
        }
        for (EObject root : roots) {
            if (oldRoots.contains(root)) continue;
            resource.getContents().add((Object)root);
        }
        return result;
    }

    public static boolean areIsomorphic(EGraph graph1, EGraph graph2) {
        return new EGraphIsomorphyChecker(graph1, null).isIsomorphicTo(graph2, null);
    }

    public static boolean areIsomorphic(Resource resource1, Resource resource2) {
        return InterpreterUtil.areIsomorphic(new EGraphImpl(resource1), new EGraphImpl(resource2));
    }

    public static int countEdges(EGraph graph) {
        int links = 0;
        for (EObject object : graph) {
            for (EReference ref : object.eClass().getEAllReferences()) {
                if (ref.isMany()) {
                    links += ((EList)object.eGet((EStructuralFeature)ref)).size();
                    continue;
                }
                if (object.eGet((EStructuralFeature)ref) == null) continue;
                ++links;
            }
        }
        return links;
    }

    public static String objectToString(Object object) {
        EClass eclass;
        if (object instanceof String) {
            return "'" + object + "'";
        }
        if (object instanceof DynamicEObjectImpl && (eclass = ((DynamicEObjectImpl)object).eClass()) != null) {
            String type = eclass.getName();
            EPackage epackage = eclass.getEPackage();
            while (epackage != null) {
                type = String.valueOf(epackage.getName()) + "." + type;
                epackage = epackage.getESuperPackage();
            }
            String args = "";
            for (EAttribute att : eclass.getEAllAttributes()) {
                args = String.valueOf(args) + ", " + att.getName() + "=" + InterpreterUtil.objectToString(((DynamicEObjectImpl)object).eGet((EStructuralFeature)att));
            }
            return String.valueOf(type) + "@" + Integer.toHexString(object.hashCode()) + " (dynamic" + args + ")";
        }
        return String.valueOf(object);
    }
}

