/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.giraph.templates;

import java.util.Map;

public class HenshinUtilTemplate {
    protected static String nl;
    public final String NL = nl == null ? System.getProperties().getProperty("line.separator") : nl;
    protected final String TEXT_1 = "package ";
    protected final String TEXT_2 = ";" + this.NL + this.NL + "import java.io.ByteArrayOutputStream;" + this.NL + "import java.io.IOException;" + this.NL + "import java.nio.ByteBuffer;" + this.NL + "import java.nio.IntBuffer;" + this.NL + "import java.nio.LongBuffer;" + this.NL + "import java.util.Arrays;" + this.NL + "import java.util.ArrayList;" + this.NL + "import java.util.HashSet;" + this.NL + "import java.util.List;" + this.NL + "import java.util.LinkedHashSet;" + this.NL + "import java.util.Set;" + this.NL + "import java.util.UUID;" + this.NL + this.NL + "import org.apache.giraph.aggregators.BasicAggregator;" + this.NL + "import org.apache.giraph.edge.Edge;" + this.NL + "import org.apache.giraph.edge.EdgeFactory;" + this.NL + "import org.apache.giraph.graph.Vertex;" + this.NL + "import org.apache.giraph.io.formats.TextVertexInputFormat;" + this.NL + "import org.apache.giraph.io.formats.TextVertexOutputFormat;" + this.NL + "import org.apache.hadoop.io.BytesWritable;" + this.NL + "import org.apache.hadoop.io.ByteWritable;" + this.NL + "import org.apache.hadoop.io.Text;" + this.NL + "import org.apache.hadoop.mapreduce.InputSplit;" + this.NL + "import org.apache.hadoop.mapreduce.TaskAttemptContext;" + this.NL + "import org.json.JSONArray;" + this.NL + "import org.json.JSONException;" + this.NL + this.NL + "/**" + this.NL + " * Henshin utility classes and methods." + this.NL + " */" + this.NL + "public class HenshinUtil {" + this.NL + this.NL + "\t/**" + this.NL + "\t * Length of integers in bytes." + this.NL + "\t */" + this.NL + "\tprivate static final int INT_LENGTH = Integer.SIZE / Byte.SIZE;" + this.NL + this.NL + "\t/**" + this.NL + "\t * Private constructor." + this.NL + "\t */" + this.NL + "\tprivate HenshinUtil() {" + this.NL + "\t\t// Prevent instantiation" + this.NL + "\t}" + this.NL + this.NL + "\t/**" + this.NL + "\t * Remove duplicate matches." + this.NL + "\t * @param matches List of matches." + this.NL + "\t * @return Filtered list." + this.NL + "\t */" + this.NL + "\tpublic static List<Match> removeDuplicateMatches(Iterable<Match> matches) {" + this.NL + "\t\tSet<Match> result = new LinkedHashSet<Match>();" + this.NL + "\t\tfor (Match m : matches) {" + this.NL + "\t\t\tresult.add(m);" + this.NL + "\t\t}" + this.NL + "\t\treturn new ArrayList<Match>(result);" + this.NL + "\t}" + this.NL + this.NL + "\t/**" + this.NL + "\t * Remove non-injective matches." + this.NL + "\t * @param matches List of matches." + this.NL + "\t * @return Filtered list." + this.NL + "\t */" + this.NL + "\tpublic static List<Match> removeNonInjectiveMatches(Iterable<Match> matches) {" + this.NL + "\t\tList<Match> result = new ArrayList<Match>();" + this.NL + "\t\tfor (Match m : matches) {" + this.NL + "\t\t\tif (m.isInjective()) {" + this.NL + "\t\t\t\tresult.add(m);" + this.NL + "\t\t\t}" + this.NL + "\t\t}" + this.NL + "\t\treturn result;" + this.NL + "\t}" + this.NL + this.NL + "\t/**" + this.NL + "\t * Henshin data." + this.NL + "\t */" + this.NL + "\tpublic abstract static class Bytes extends BytesWritable {" + this.NL + this.NL + "\t\t/**" + this.NL + "\t\t * Default constructor." + this.NL + "\t\t */" + this.NL + "\t\tpublic Bytes() {" + this.NL + "\t\t\tsuper();" + this.NL + "\t\t}" + this.NL + this.NL + "\t\t/**" + this.NL + "\t\t * Extra constructor." + this.NL + "\t\t * @param data The data." + this.NL + "\t\t */" + this.NL + "\t\tpublic Bytes(byte[] data) {" + this.NL + "\t\t\tsuper(data);" + this.NL + "\t\t}" + this.NL + this.NL + "\t\t/**" + this.NL + "\t\t * Set the size." + this.NL + "\t\t * @param size The new size." + this.NL + "\t\t */" + this.NL + "\t\t@Override" + this.NL + "\t\tpublic void setSize(int size) {" + this.NL + "\t\t\tif (size != getCapacity()) {" + this.NL + "\t\t\t\tsetCapacity(size);" + this.NL + "\t\t\t}" + this.NL + "\t\t\tsuper.setSize(size);" + this.NL + "\t\t}" + this.NL + this.NL + "\t\t/**" + this.NL + "\t\t * Pretty-print this bytes object." + this.NL + "\t\t * @return The printed string." + this.NL + "\t\t */" + this.NL + "\t\t@Override" + this.NL + "\t\tpublic String toString() {" + this.NL + "\t\t\tbyte[] bytes = getBytes();" + this.NL + "\t\t\tStringBuffer result = new StringBuffer();" + this.NL + "\t\t\tfor (int i = 0; i < bytes.length; i++) {" + this.NL + "\t\t\t\tresult.append(bytes[i]);" + this.NL + "\t\t\t\tif (i < bytes.length - 1) {" + this.NL + "\t\t\t\t\tresult.append(\",\");" + this.NL + "\t\t\t\t}" + this.NL + "\t\t\t}" + this.NL + "\t\t\treturn \"[\" + result + \"]\";" + this.NL + "\t\t}" + this.NL + this.NL + "\t}" + this.NL + this.NL + "\t/**" + this.NL + "\t * Henshin vertex ID." + this.NL + "\t */" + this.NL + "\tpublic static class VertexId extends Bytes {" + this.NL + this.NL + "\t\t/**" + this.NL + "\t\t * Default constructor." + this.NL + "\t\t */" + this.NL + "\t\tpublic VertexId() {" + this.NL + "\t\t\tsuper();" + this.NL + "\t\t}" + this.NL + this.NL + "\t\t/**" + this.NL + "\t\t * Extra constructor." + this.NL + "\t\t * @param data The data." + this.NL + "\t\t */" + this.NL + "\t\tpublic VertexId(byte[] data) {" + this.NL + "\t\t\tsuper(data);" + this.NL + "\t\t}" + this.NL + this.NL + "\t\t/**" + this.NL + "\t\t * Create a new random vertex ID." + this.NL + "\t\t * The vertex ID is derived from a random UUID." + this.NL + "\t\t * @return The new vertex ID." + this.NL + "\t\t */" + this.NL + "\t\tpublic static VertexId randomVertexId() {" + this.NL + "\t\t\tUUID uuid = UUID.randomUUID();" + this.NL + "\t\t\tbyte[] bytes = new byte[(Long.SIZE / Byte.SIZE) * 2];" + this.NL + "\t\t\tByteBuffer buffer = ByteBuffer.wrap(bytes);" + this.NL + "\t\t\tLongBuffer longBuffer = buffer.asLongBuffer();" + this.NL + "\t\t\tlongBuffer.put(new long[] {" + this.NL + "\t\t\t\tuuid.getMostSignificantBits()," + this.NL + "\t\t\t\tuuid.getLeastSignificantBits()" + this.NL + "\t\t\t});" + this.NL + "\t\t\treturn new VertexId(bytes);" + this.NL + "\t\t}" + this.NL + this.NL + "\t\t/**" + this.NL + "\t\t * Create an extended version of this vertex ID." + this.NL + "\t\t * @param value The value to be appended to this vertex ID." + this.NL + "\t\t * @return The extended version of this vertex ID." + this.NL + "\t\t */" + this.NL + "\t\tpublic VertexId append(byte value) {" + this.NL + "\t\t\tbyte[] bytes = getBytes();" + this.NL + "\t\t\tbytes = Arrays.copyOf(bytes, bytes.length + 1);" + this.NL + "\t\t\tbytes[bytes.length - 1] = value;" + this.NL + "\t\t\treturn new VertexId(bytes);" + this.NL + "\t\t}" + this.NL + this.NL + "\t}" + this.NL + this.NL + "\t/**" + this.NL + "\t * Henshin match object." + this.NL + "\t */" + this.NL + "\tpublic static class Match extends Bytes {" + this.NL + this.NL + "\t\t/**" + this.NL + "\t\t * Empty match." + this.NL + "\t\t */" + this.NL + "\t\tpublic static final Match EMPTY = new Match();" + this.NL + this.NL + "\t\t/**" + this.NL + "\t\t * Default constructor." + this.NL + "\t\t */" + this.NL + "\t\tpublic Match() {" + this.NL + "\t\t\tsuper();" + this.NL + "\t\t}" + this.NL + this.NL + "\t\t/**" + this.NL + "\t\t * Extra constructor." + this.NL + "\t\t * @param segment The segment of this match." + this.NL + "\t\t */" + this.NL + "\t\tpublic Match(int segment) {" + this.NL + "\t\t\tsuper(new byte[] {" + this.NL + "\t\t\t\t(byte) (segment >>> 24)," + this.NL + "\t\t\t\t(byte) (segment >>> 16)," + this.NL + "\t\t\t\t(byte) (segment >>> 8)," + this.NL + "\t\t\t\t(byte) segment });" + this.NL + "\t\t}" + this.NL + this.NL + "\t\t/**" + this.NL + "\t\t * Extra constructor." + this.NL + "\t\t * @param data The data." + this.NL + "\t\t */" + this.NL + "\t\tpublic Match(byte[] data) {" + this.NL + "\t\t\tsuper(data);" + this.NL + "\t\t}" + this.NL + this.NL + "\t\t/**" + this.NL + "\t\t * Get the segment of this match." + this.NL + "\t\t * @return The segment." + this.NL + "\t\t */" + this.NL + "\t\tpublic int getSegment() {" + this.NL + "\t\t\tbyte[] bytes = getBytes();" + this.NL + "\t\t\treturn bytes[0] << 24 |" + this.NL + "\t\t\t\t(bytes[1] & 0xFF) << 16 |" + this.NL + "\t\t\t\t(bytes[2] & 0xFF) << 8 |" + this.NL + "\t\t\t\t(bytes[3] & 0xFF);" + this.NL + "\t\t}" + this.NL + this.NL + "\t\t/**" + this.NL + "\t\t * Get the size of this match." + this.NL + "\t\t * @return The match size." + this.NL + "\t\t */" + this.NL + "\t\tpublic int getMatchSize() {" + this.NL + "\t\t\tbyte[] bytes = getBytes();" + this.NL + "\t\t\tint d = 4;" + this.NL + "\t\t\tint size = 0;" + this.NL + "\t\t\twhile (d < bytes.length) {" + this.NL + "\t\t\t\td += bytes[d] + 1;" + this.NL + "\t\t\t\tsize++;" + this.NL + "\t\t\t}" + this.NL + "\t\t\treturn size;" + this.NL + "\t\t}" + this.NL + this.NL + "\t\t/**" + this.NL + "\t\t * Get the vertex ID of a matched node." + this.NL + "\t\t * @param vertexIndex Index of the next vertex." + this.NL + "\t\t * @return The vertex ID." + this.NL + "\t\t */" + this.NL + "\t\tpublic VertexId getVertexId(int vertexIndex) {" + this.NL + "\t\t\tbyte[] bytes = getBytes();" + this.NL + "\t\t\tint d = 4;" + this.NL + "\t\t\tfor (int i = 0; i < vertexIndex; i++) {" + this.NL + "\t\t\t\tif (d >= bytes.length) {" + this.NL + "\t\t\t\t\treturn null;" + this.NL + "\t\t\t\t}" + this.NL + "\t\t\t\td += bytes[d] + 1;" + this.NL + "\t\t\t}" + this.NL + "\t\t\tif (d >= bytes.length) {" + this.NL + "\t\t\t\treturn null;" + this.NL + "\t\t\t}" + this.NL + "\t\t\treturn new VertexId(" + this.NL + "\t\t\t\tArrays.copyOfRange(bytes, d + 1, d + 1 + bytes[d]));" + this.NL + "\t\t}" + this.NL + this.NL + "\t\t/**" + this.NL + "\t\t * Get the index of a vertex ID of a matched node." + this.NL + "\t\t * @param vertexId A vertex ID." + this.NL + "\t\t * @return The index of the vertex ID or -1." + this.NL + "\t\t */" + this.NL + "\t\tpublic int indexOf(VertexId vertexId) {" + this.NL + "\t\t\tint i = 0;" + this.NL + "\t\t\tVertexId id;" + this.NL + "\t\t\tdo {" + this.NL + "\t\t\t\tid = getVertexId(i);" + this.NL + "\t\t\t\tif (vertexId.equals(id)) {" + this.NL + "\t\t\t\t\treturn i;" + this.NL + "\t\t\t\t}" + this.NL + "\t\t\t\ti++;" + this.NL + "\t\t\t} while (id != null);" + this.NL + "\t\t\treturn -1;" + this.NL + "\t\t}" + this.NL + this.NL + "\t\t/**" + this.NL + "\t\t * Returns true if this match is injective." + this.NL + "\t\t * @return true if this match is injective." + this.NL + "\t\t */" + this.NL + "\t\tpublic boolean isInjective() {" + this.NL + "\t\t\tSet<VertexId> ids = new HashSet<VertexId>();" + this.NL + "\t\t\tint i = 0;" + this.NL + "\t\t\tVertexId id;" + this.NL + "\t\t\tdo {" + this.NL + "\t\t\t\tid = getVertexId(i++);" + this.NL + "\t\t\t\tif (id != null && !ids.add(id)) {" + this.NL + "\t\t\t\t\treturn false;" + this.NL + "\t\t\t\t}" + this.NL + "\t\t\t} while (id != null);" + this.NL + "\t\t\treturn true;" + this.NL + "\t\t}" + this.NL + this.NL + "\t\t/**" + this.NL + "\t\t * Create an extended version of this (partial) match." + this.NL + "\t\t * @param vertexId The ID of the next matched vertex." + this.NL + "\t\t * @return The extended match object." + this.NL + "\t\t */" + this.NL + "\t\tpublic Match append(VertexId vertexId) {" + this.NL + "\t\t\tbyte[] bytes = getBytes();" + this.NL + "\t\t\tbyte[] id = vertexId.getBytes();" + this.NL + "\t\t\tbyte[] result = Arrays.copyOf(bytes, bytes.length + 1 + id.length);" + this.NL + "\t\t\tresult[bytes.length] = (byte) id.length;" + this.NL + "\t\t\tSystem.arraycopy(id, 0, result, bytes.length + 1, id.length);" + this.NL + "\t\t\treturn new Match(result);" + this.NL + "\t\t}" + this.NL + this.NL + "\t\t/**" + this.NL + "\t\t * Create an extended version of this (partial) match." + this.NL + "\t\t * @param match Another partial match for the next matched vertices." + this.NL + "\t\t * @return The extended match object." + this.NL + "\t\t */" + this.NL + "\t\tpublic Match append(Match match) {" + this.NL + "\t\t\tbyte[] bytes1 = getBytes();" + this.NL + "\t\t\tbyte[] bytes2 = match.getBytes();" + this.NL + "\t\t\tbytes1 = Arrays.copyOf(bytes1, bytes1.length + bytes2.length - 4);" + this.NL + "\t\t\tSystem.arraycopy(bytes2, 4," + this.NL + "\t\t\t\tbytes1, bytes1.length - bytes2.length + 4, bytes2.length - 4);" + this.NL + "\t\t\treturn new Match(bytes1);" + this.NL + "\t\t}" + this.NL + this.NL + "\t\t/**" + this.NL + "\t\t * Remove a vertex ID of a matched node." + this.NL + "\t\t * @param vertexIndex Index of the vertex ID." + this.NL + "\t\t * @return The new match." + this.NL + "\t\t */" + this.NL + "\t\tpublic Match remove(int vertexIndex) {" + this.NL + "\t\t\tbyte[] bytes = getBytes();" + this.NL + "\t\t\tint d = 4;" + this.NL + "\t\t\tfor (int i = 0; i < vertexIndex; i++) {" + this.NL + "\t\t\t\tif (d >= bytes.length) {" + this.NL + "\t\t\t\t\treturn null;" + this.NL + "\t\t\t\t}" + this.NL + "\t\t\t\td += bytes[d] + 1;" + this.NL + "\t\t\t}" + this.NL + "\t\t\tif (d >= bytes.length) {" + this.NL + "\t\t\t\treturn null;" + this.NL + "\t\t\t}" + this.NL + "\t\t\tbyte[] result = Arrays.copyOf(bytes, bytes.length - bytes[d] - 1);" + this.NL + "\t\t\tif (d < result.length) {" + this.NL + "\t\t\t\tSystem.arraycopy(bytes, d + 1 + bytes[d]," + this.NL + "\t\t\t\t\tresult, d, result.length - d);" + this.NL + "\t\t\t}" + this.NL + "\t\t\treturn new Match(result);" + this.NL + "\t\t}" + this.NL + this.NL + "\t\t/**" + this.NL + "\t\t * Create a copy of this match." + this.NL + "\t\t * @return The copy." + this.NL + "\t\t */" + this.NL + "\t\tpublic Match copy() {" + this.NL + "\t\t\treturn new Match(getBytes());" + this.NL + "\t\t}" + this.NL + this.NL + "\t\t/**" + this.NL + "\t\t * Pretty-print this match." + this.NL + "\t\t * @return The printed string." + this.NL + "\t\t */" + this.NL + "\t\t@Override" + this.NL + "\t\tpublic String toString() {" + this.NL + "\t\t\tbyte[] bytes = getBytes();" + this.NL + "\t\t\tStringBuffer result = new StringBuffer();" + this.NL + "\t\t\tint i = 4;" + this.NL + "\t\t\twhile (i < bytes.length) {" + this.NL + "\t\t\t\tint len = bytes[i++];" + this.NL + "\t\t\t\tresult.append(\"[\");" + this.NL + "\t\t\t\tfor (int j = 0; j < len; j++) {" + this.NL + "\t\t\t\t\tresult.append(bytes[i + j]);" + this.NL + "\t\t\t\t\tif (j < len - 1) {" + this.NL + "\t\t\t\t\t\tresult.append(\",\");" + this.NL + "\t\t\t\t\t}" + this.NL + "\t\t\t\t}" + this.NL + "\t\t\t\tresult.append(\"]\");" + this.NL + "\t\t\t\ti += len;" + this.NL + "\t\t\t\tif (i < bytes.length - 1) {" + this.NL + "\t\t\t\t\tresult.append(\",\");" + this.NL + "\t\t\t\t}" + this.NL + "\t\t\t}" + this.NL + "\t\t\tif (bytes.length > 0) {" + this.NL + "\t\t\t\treturn getSegment() + \":[\" + result + \"]\";" + this.NL + "\t\t\t} else {" + this.NL + "\t\t\t\treturn \"[\" + result + \"]\";" + this.NL + "\t\t\t}" + this.NL + "\t\t}" + this.NL + this.NL + "\t}" + this.NL + this.NL + "\t/**" + this.NL + "\t * Henshin application stack." + this.NL + "\t */" + this.NL + "\tpublic static class ApplicationStack extends Bytes {" + this.NL + this.NL + "\t\t/**" + this.NL + "\t\t * Default constructor." + this.NL + "\t\t */" + this.NL + "\t\tpublic ApplicationStack() {" + this.NL + "\t\t\tsuper();" + this.NL + "\t\t}" + this.NL + this.NL;
    protected final String TEXT_3 = "\t\t/**" + this.NL + "\t\t * Extra constructor." + this.NL + "\t\t * @param data The data." + this.NL + "\t\t */" + this.NL + "\t\tpublic ApplicationStack(byte[] data) {" + this.NL + "\t\t\tsuper(data);" + this.NL + "\t\t}" + this.NL + this.NL + "\t\t/**" + this.NL + "\t\t * Get the size of this application stack." + this.NL + "\t\t * @return the size of this application stack." + this.NL + "\t\t */" + this.NL + "\t\tpublic int getStackSize() {" + this.NL + "\t\t\treturn (getBytes().length / INT_LENGTH) / 3;" + this.NL + "\t\t}" + this.NL + this.NL + "\t\t/**" + this.NL + "\t\t * Get the unit index at an absolute position." + this.NL + "\t\t * @param position An absolute position in the stack." + this.NL + "\t\t * @return the unit index or -1." + this.NL + "\t\t */" + this.NL + "\t\tpublic int getUnit(int position) {" + this.NL + "\t\t\tIntBuffer intBuf = ByteBuffer.wrap(getBytes()).asIntBuffer();" + this.NL + "\t\t\tif (position < 0 || position * 3 >= intBuf.limit()) {" + this.NL + "\t\t\t\treturn -1;" + this.NL + "\t\t\t}" + this.NL + "\t\t\treturn intBuf.get(position * 3);" + this.NL + "\t\t}" + this.NL + this.NL + "\t\t/**" + this.NL + "\t\t * Get the segment index at an absolute position." + this.NL + "\t\t * @param position An absolute position in the stack." + this.NL + "\t\t * @return the segment index or -1." + this.NL + "\t\t */" + this.NL + "\t\tpublic int getSegment(int position) {" + this.NL + "\t\t\tIntBuffer intBuf = ByteBuffer.wrap(getBytes()).asIntBuffer();" + this.NL + "\t\t\tif (position < 0 || (position * 3) + 1 >= intBuf.limit()) {" + this.NL + "\t\t\t\treturn -1;" + this.NL + "\t\t\t}" + this.NL + "\t\t\treturn intBuf.get((position * 3) + 1);" + this.NL + "\t\t}" + this.NL + this.NL + "\t\t/**" + this.NL + "\t\t * Get the microstep at an absolute position." + this.NL + "\t\t * @param position An absolute position in the stack." + this.NL + "\t\t * @return the microstp or -1." + this.NL + "\t\t */" + this.NL + "\t\tpublic int getMicrostep(int position) {" + this.NL + "\t\t\tIntBuffer intBuf = ByteBuffer.wrap(getBytes()).asIntBuffer();" + this.NL + "\t\t\tif (position < 0 || (position * 3) + 2 >= intBuf.limit()) {" + this.NL + "\t\t\t\treturn -1;" + this.NL + "\t\t\t}" + this.NL + "\t\t\treturn intBuf.get((position * 3) + 2);" + this.NL + "\t\t}" + this.NL + this.NL + "\t\t/**" + this.NL + "\t\t * Get the unit index at the last position." + this.NL + "\t\t * @return the unit index or -1." + this.NL + "\t\t */" + this.NL + "\t\tpublic int getLastUnit() {" + this.NL + "\t\t\treturn getUnit(getStackSize() - 1);" + this.NL + "\t\t}" + this.NL + this.NL + "\t\t/**" + this.NL + "\t\t * Get the segment index at the last position." + this.NL + "\t\t * @return the segment index or -1." + this.NL + "\t\t */" + this.NL + "\t\tpublic int getLastSegment() {" + this.NL + "\t\t\treturn getSegment(getStackSize() - 1);" + this.NL + "\t\t}" + this.NL + this.NL + "\t\t/**" + this.NL + "\t\t * Get the microstep at the last position." + this.NL + "\t\t * @return the microstep or -1." + this.NL + "\t\t */" + this.NL + "\t\tpublic int getLastMicrostep() {" + this.NL + "\t\t\treturn getMicrostep(getStackSize() - 1);" + this.NL + "\t\t}" + this.NL + this.NL + "\t\t/**" + this.NL + "\t\t * Create an extended version of this application stack." + this.NL + "\t\t * @param unit The new unit index." + this.NL + "\t\t * @param segment The new segment index." + this.NL + "\t\t * @param microstep The new microstep." + this.NL + "\t\t * @return The extended version of this application stack." + this.NL + "\t\t */" + this.NL + "\t\tpublic ApplicationStack append(int unit, int segment, int microstep) {" + this.NL + "\t\t\tbyte[] bytes = getBytes();" + this.NL + "\t\t\tbytes = Arrays.copyOf(bytes, bytes.length + (INT_LENGTH * 3));" + this.NL + "\t\t\tIntBuffer intBuffer = ByteBuffer.wrap(bytes).asIntBuffer();" + this.NL + "\t\t\tintBuffer.put((bytes.length / INT_LENGTH) - 3, unit);" + this.NL + "\t\t\tintBuffer.put((bytes.length / INT_LENGTH) - 2, segment);" + this.NL + "\t\t\tintBuffer.put((bytes.length / INT_LENGTH) - 1, microstep);" + this.NL + "\t\t\treturn new ApplicationStack(bytes);" + this.NL + "\t\t}" + this.NL + this.NL + "\t\t/**" + this.NL + "\t\t * Create a new version of this application stack without the last entry." + this.NL + "\t\t * @return The new version of this application stack." + this.NL + "\t\t */" + this.NL + "\t\tpublic ApplicationStack removeLast() {" + this.NL + "\t\t\tbyte[] bytes = getBytes();" + this.NL + "\t\t\tbytes = Arrays.copyOf(bytes," + this.NL + "\t\t\t\tMath.max(0, bytes.length - (INT_LENGTH * 3)));" + this.NL + "\t\t\treturn new ApplicationStack(bytes);" + this.NL + "\t\t}" + this.NL + this.NL + "\t}" + this.NL + this.NL + "\t/**" + this.NL + "\t * Aggregator class for application stacks." + this.NL + "\t */" + this.NL + "\tpublic static class ApplicationStackAggregator extends" + this.NL + "\t\tBasicAggregator<ApplicationStack> {" + this.NL + this.NL + "\t\t@Override" + this.NL + "\t\tpublic void aggregate(ApplicationStack stack) {" + this.NL + "\t\t\t// no action" + this.NL + "\t\t}" + this.NL + this.NL + "\t\t@Override" + this.NL + "\t\tpublic ApplicationStack createInitialValue() {" + this.NL + "\t\t\treturn new ApplicationStack();" + this.NL + "\t\t}" + this.NL + this.NL + "\t}" + this.NL + this.NL + "\t/**" + this.NL + "\t * Henshin input format." + this.NL + "\t */" + this.NL + "\tpublic static class InputFormat extends" + this.NL + "\t\tTextVertexInputFormat<VertexId, ByteWritable, ByteWritable> {" + this.NL + this.NL + "\t\t@Override" + this.NL + "\t\tpublic TextVertexReader createVertexReader(InputSplit split," + this.NL + "\t\t\tTaskAttemptContext context) {" + this.NL + "\t\t\treturn new InputReader();" + this.NL + "\t\t}" + this.NL + this.NL + "\t\t/**" + this.NL + "\t\t * Henshin input reader." + this.NL + "\t\t */" + this.NL + "\t\tclass InputReader extends" + this.NL + "\t\t\tTextVertexReaderFromEachLineProcessedHandlingExceptions<JSONArray," + this.NL + "\t\t\t\tJSONException> {" + this.NL + this.NL + "\t\t\t@Override" + this.NL + "\t\t\tprotected JSONArray preprocessLine(Text line) throws JSONException {" + this.NL + "\t\t\t\treturn new JSONArray(line.toString());" + this.NL + "\t\t\t}" + this.NL + this.NL + "\t\t\t@Override" + this.NL + "\t\t\tprotected VertexId getId(JSONArray jsonVertex)" + this.NL + "\t\t\t\tthrows JSONException, IOException {" + this.NL + "\t\t\t\treturn jsonArrayToVertexId(jsonVertex.getJSONArray(0));" + this.NL + "\t\t\t}" + this.NL + this.NL + "\t\t\t/**" + this.NL + "\t\t\t * Convert a JSON array to a VertexId object." + this.NL + "\t\t\t * @param jsonArray The JSON array to be converted." + this.NL + "\t\t\t * @return The corresponding VertexId." + this.NL + "\t\t\t */" + this.NL + "\t\t\tprivate VertexId jsonArrayToVertexId(JSONArray jsonArray)" + this.NL + "\t\t\t\tthrows JSONException {" + this.NL + "\t\t\t\tByteArrayOutputStream out = new ByteArrayOutputStream();" + this.NL + "\t\t\t\tfor (int i = 0; i < jsonArray.length(); i++) {" + this.NL + "\t\t\t\t\tint value = jsonArray.getInt(i);" + this.NL + "\t\t\t\t\tif (value < 256) {" + this.NL + "\t\t\t\t\t\tout.write(value);" + this.NL + "\t\t\t\t\t} else {" + this.NL + "\t\t\t\t\t\tout.write(value >> 24);" + this.NL + "\t\t\t\t\t\tout.write(value >> 16);" + this.NL + "\t\t\t\t\t\tout.write(value >> 8);" + this.NL + "\t\t\t\t\t\tout.write(value);" + this.NL + "\t\t\t\t\t}" + this.NL + "\t\t\t\t}" + this.NL + "\t\t\t\treturn new VertexId(out.toByteArray());" + this.NL + "\t\t\t}" + this.NL + this.NL + "\t\t\t@Override" + this.NL + "\t\t\tprotected ByteWritable getValue(JSONArray jsonVertex)" + this.NL + "\t\t\t\tthrows JSONException, IOException {" + this.NL + "\t\t\t\treturn new ByteWritable((byte) jsonVertex.getInt(1));" + this.NL + "\t\t\t}" + this.NL + this.NL + "\t\t\t@Override" + this.NL + "\t\t\tprotected Iterable<Edge<VertexId, ByteWritable>> getEdges(" + this.NL + "\t\t\t\tJSONArray jsonVertex) throws JSONException, IOException {" + this.NL + "\t\t\t\tJSONArray jsonEdgeArray = jsonVertex.getJSONArray(2);" + this.NL + "\t\t\t\tList<Edge<VertexId, ByteWritable>> edges =" + this.NL + "\t\t\t\t\tnew ArrayList<Edge<VertexId, ByteWritable>>(jsonEdgeArray.length());" + this.NL + "\t\t\t\tfor (int i = 0; i < jsonEdgeArray.length(); ++i) {" + this.NL + "\t\t\t\t\tJSONArray jsonEdge = jsonEdgeArray.getJSONArray(i);" + this.NL + "\t\t\t\t\tedges.add(EdgeFactory.create(" + this.NL + "\t\t\t\t\t\tjsonArrayToVertexId(jsonEdge.getJSONArray(0))," + this.NL + "\t\t\t\t\t\tnew ByteWritable((byte) jsonEdge.getInt(1))));" + this.NL + "\t\t\t\t}" + this.NL + "\t\t\t\treturn edges;" + this.NL + "\t\t\t}" + this.NL + this.NL + "\t\t\t@Override" + this.NL + "\t\t\tprotected Vertex<VertexId, ByteWritable, ByteWritable>" + this.NL + "\t\t\thandleException(Text line, JSONArray jsonVertex, JSONException e) {" + this.NL + "\t\t\t\tthrow new IllegalArgumentException(" + this.NL + "\t\t\t\t\t\"Couldn't get vertex from line \" + line, e);" + this.NL + "\t\t\t}" + this.NL + "\t\t}" + this.NL + "\t}" + this.NL + this.NL + "\t/**" + this.NL + "\t * Henshin output format." + this.NL + "\t */" + this.NL + "\tpublic static class OutputFormat extends" + this.NL + "\t\tTextVertexOutputFormat<VertexId, ByteWritable, ByteWritable> {" + this.NL + this.NL + "\t\t@Override" + this.NL + "\t\tpublic TextVertexWriter createVertexWriter(TaskAttemptContext context)" + this.NL + "\t\t\tthrows IOException, InterruptedException {" + this.NL + "\t\t\treturn new OutputWriter();" + this.NL + "\t\t}" + this.NL + this.NL + "\t\t/**" + this.NL + "\t\t * Henshin output writer." + this.NL + "\t\t */" + this.NL + "\t\tclass OutputWriter extends TextVertexWriterToEachLine {" + this.NL + this.NL + "\t\t\t@Override" + this.NL + "\t\t\tprotected Text convertVertexToLine(" + this.NL + "\t\t\t\tVertex<VertexId, ByteWritable, ByteWritable> vertex)" + this.NL + "\t\t\t\tthrows IOException {" + this.NL + this.NL + "\t\t\t\tJSONArray vertexArray = new JSONArray();" + this.NL + "\t\t\t\tJSONArray idArray = new JSONArray();" + this.NL + "\t\t\t\tbyte[] id = vertex.getId().getBytes();" + this.NL + "\t\t\t\tfor (int i = 0; i < id.length; i++) {" + this.NL + "\t\t\t\t\tidArray.put(id[i]);" + this.NL + "\t\t\t\t}" + this.NL + "\t\t\t\tvertexArray.put(idArray);" + this.NL + "\t\t\t\tvertexArray.put(vertex.getValue().get());" + this.NL + "\t\t\t\tJSONArray allEdgesArray = new JSONArray();" + this.NL + "\t\t\t\tfor (Edge<VertexId, ByteWritable> edge : vertex.getEdges()) {" + this.NL + "\t\t\t\t\tJSONArray edgeArray = new JSONArray();" + this.NL + "\t\t\t\t\tJSONArray targetIdArray = new JSONArray();" + this.NL + "\t\t\t\t\tbyte[] targetId = edge.getTargetVertexId().getBytes();" + this.NL + "\t\t\t\t\tfor (int i = 0; i < targetId.length; i++) {" + this.NL + "\t\t\t\t\t\ttargetIdArray.put(targetId[i]);" + this.NL + "\t\t\t\t\t}" + this.NL + "\t\t\t\t\tedgeArray.put(targetIdArray);" + this.NL + "\t\t\t\t\tedgeArray.put(edge.getValue().get());" + this.NL + "\t\t\t\t\tallEdgesArray.put(edgeArray);" + this.NL + "\t\t\t\t}" + this.NL + "\t\t\t\tvertexArray.put(allEdgesArray);" + this.NL + "\t\t\t\treturn new Text(vertexArray.toString());" + this.NL + "\t\t\t}" + this.NL + "\t\t}" + this.NL + "\t}" + this.NL + this.NL + "}";
    protected final String TEXT_4 = this.NL;

    public static synchronized HenshinUtilTemplate create(String lineSeparator) {
        nl = lineSeparator;
        HenshinUtilTemplate result = new HenshinUtilTemplate();
        nl = null;
        return result;
    }

    public String generate(Object argument) {
        StringBuffer stringBuffer = new StringBuffer();
        Map args = (Map)argument;
        String packageName = (String)args.get("packageName");
        stringBuffer.append("package ");
        stringBuffer.append(packageName);
        stringBuffer.append(this.TEXT_2);
        stringBuffer.append(this.TEXT_3);
        stringBuffer.append(this.TEXT_4);
        return stringBuffer.toString();
    }
}

