/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.interpreter.impl;

import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.emf.henshin.interpreter.RuleApplication;
import org.eclipse.emf.henshin.interpreter.UnitApplication;
import org.eclipse.emf.henshin.interpreter.impl.BasicApplicationMonitor;
import org.eclipse.emf.henshin.model.Rule;

public class ProfilingApplicationMonitor
extends BasicApplicationMonitor {
    protected long startTime = 0L;
    protected Map<Rule, Long> durations = new LinkedHashMap<Rule, Long>();
    protected Map<Rule, Integer> executions = new LinkedHashMap<Rule, Integer>();

    @Override
    public void notifyExecute(UnitApplication application, boolean success) {
        if (this.startTime == 0L) {
            this.startTime = System.currentTimeMillis();
            return;
        }
        if (!(application instanceof RuleApplication)) {
            return;
        }
        Rule rule = (Rule)application.getUnit();
        long finishTime = System.currentTimeMillis();
        long executionTime = finishTime - this.startTime;
        Integer count = this.executions.get(rule);
        count = count == null ? Integer.valueOf(1) : Integer.valueOf(count + 1);
        this.executions.put(rule, count);
        Long duration = this.durations.get(rule);
        duration = duration == null ? Long.valueOf(executionTime) : Long.valueOf(duration + executionTime);
        this.durations.put(rule, duration);
        this.startTime = finishTime;
    }

    public void printStats() {
        for (Rule rule : this.executions.keySet()) {
            System.out.println("Stats for rule '" + rule.getName() + "':");
            System.out.println(" - Number of Executions: " + this.executions.get(rule));
            System.out.println(" - Total execution time: " + this.durations.get(rule) + "ms");
            System.out.println(" - Aver. execution time: " + this.durations.get(rule) / (long)this.executions.get(rule).intValue() + "ms\n");
        }
    }
}

