/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.model.staticanalysis;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.henshin.model.Edge;
import org.eclipse.emf.henshin.model.GraphElement;
import org.eclipse.emf.henshin.model.ModelElement;
import org.eclipse.emf.henshin.model.NestedCondition;
import org.eclipse.emf.henshin.model.Node;

public class Path {
    final List<Node> nodes = new ArrayList<Node>();
    final List<Edge> edges = new ArrayList<Edge>();

    public boolean isCyclic() {
        int length = this.nodes.size();
        int i = 0;
        while (i < length) {
            Node n = this.nodes.get(i);
            int j = i + 1;
            while (j < length) {
                if (this.nodes.get(j) == n) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    public Node firstNode() {
        return this.nodes.get(0);
    }

    public Node lastNode() {
        return this.nodes.get(this.nodes.size() - 1);
    }

    public void append(Path path) {
        int i = 0;
        while (i < path.edges.size()) {
            this.nodes.add(path.nodes.get(i + 1));
            this.edges.add(path.edges.get(i));
            ++i;
        }
    }

    public Path copy() {
        Path copy = new Path();
        copy.nodes.addAll(this.nodes);
        copy.edges.addAll(this.edges);
        return copy;
    }

    public boolean isViaPAC() {
        ArrayList<ModelElement> elems = new ArrayList<ModelElement>();
        elems.addAll(this.nodes);
        elems.addAll(this.edges);
        for (GraphElement graphElement : elems) {
            NestedCondition nested;
            if (!graphElement.getGraph().isNestedCondition() || !(nested = (NestedCondition)graphElement.getGraph().eContainer()).isPAC()) continue;
            return true;
        }
        return false;
    }

    public void retract() {
        boolean changed = true;
        while (changed) {
            NestedCondition nested;
            ModelElement origin;
            changed = false;
            int i = 0;
            while (i < this.nodes.size()) {
                Node node = this.nodes.get(i);
                if (node.getGraph() != null && node.getGraph().isNestedCondition() && (origin = (nested = (NestedCondition)node.getGraph().eContainer()).getMappings().getOrigin(node)) != null) {
                    this.nodes.set(i, (Node)origin);
                    changed = true;
                }
                ++i;
            }
            i = 0;
            while (i < this.edges.size()) {
                Edge edge = this.edges.get(i);
                if (edge.getGraph() != null && edge.getGraph().isNestedCondition() && (origin = (nested = (NestedCondition)edge.getGraph().eContainer()).getMappings().getOrigin(edge)) != null) {
                    this.edges.set(i, (Edge)origin);
                    changed = true;
                }
                ++i;
            }
        }
    }

    public List<EReference> toReferenceList(boolean revertInverse) {
        ArrayList<EReference> refs = new ArrayList<EReference>();
        int i = 0;
        while (i < this.edges.size()) {
            Node source = this.nodes.get(i);
            Edge edge = this.edges.get(i);
            Node realSource = edge.getSource();
            while (realSource.getGraph() != source.getGraph()) {
                NestedCondition nested = (NestedCondition)realSource.getGraph().eContainer();
                realSource = nested.getMappings().getOrigin(realSource);
            }
            if (realSource == source || !revertInverse) {
                refs.add(edge.getType());
            } else {
                EReference opp = edge.getType().getEOpposite();
                if (opp != null) {
                    refs.add(opp);
                } else {
                    return null;
                }
            }
            ++i;
        }
        return refs;
    }

    public boolean isViaNestedCondition() {
        for (Edge edge : this.edges) {
            if (edge.getGraph() == null || !edge.getGraph().isNestedCondition()) continue;
            return true;
        }
        return false;
    }
}

