/*
 * Decompiled with CFR 0.152.
 */
package agg.gui;

import agg.gui.event.EditEvent;
import agg.gui.event.EditEventListener;
import agg.gui.options.AbstractOptionGUI;
import agg.gui.options.GraTraOptionGUI;
import agg.gui.options.OptionGUI;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class AGGPreferences
implements EditEventListener {
    private final JMenu mainMenu;
    private final Vector<JMenu> menus;
    private final Vector<JMenuItem> defaults;
    private final JMenuItem optionsMenu;
    private JCheckBoxMenuItem typesOnTop;
    private JCheckBoxMenuItem undirected;
    private JCheckBoxMenuItem nonparallel;
    private JCheckBoxMenuItem checkEmptyAttrs;
    protected final OptionGUI optionGUI;

    public AGGPreferences(JFrame f) {
        this.optionGUI = new OptionGUI(f, " Options ", false);
        this.menus = new Vector(2);
        this.mainMenu = new JMenu("Preferences", true);
        this.mainMenu.setMnemonic('P');
        this.optionsMenu = new JMenuItem("Options...");
        this.optionsMenu.setMnemonic('O');
        this.defaults = new Vector();
        this.makePreferencesMenu();
    }

    @Override
    public void editEventOccurred(EditEvent e) {
        if (e.getMsg() == -10 && e.getMessage().equals("Preferences")) {
            this.mainMenu.doClick();
        }
    }

    public Enumeration<JMenu> getMenus() {
        return this.menus.elements();
    }

    public OptionGUI getOptionGUI() {
        return this.optionGUI;
    }

    public void showOptionGUI() {
        if (!this.optionGUI.isVisible()) {
            AbstractOptionGUI optgui = this.optionGUI.getGuiComponent("Transformation");
            if (optgui instanceof GraTraOptionGUI) {
                ((GraTraOptionGUI)optgui).update();
            }
            this.optionGUI.setVisible(true);
            this.optionGUI.toFront();
        } else {
            this.optionGUI.setVisible(false);
            this.optionGUI.setVisible(true);
            this.optionGUI.toFront();
        }
    }

    public void showOptionGUI(int kind) {
        this.showOptionGUI();
        this.optionGUI.selectOptions(kind);
    }

    protected void makePreferencesMenu() {
        this.mainMenu.setEnabled(true);
        this.mainMenu.add(this.optionsMenu);
        this.optionsMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AGGPreferences.this.showOptionGUI();
            }
        });
        this.addDefaults();
        this.menus.addElement(this.mainMenu);
    }

    public void addActionListenerOfDefaults(ActionListener al) {
        int i = 0;
        while (i < this.defaults.size()) {
            JMenuItem item = this.defaults.get(i);
            if (item instanceof JMenu) {
                JMenu m = (JMenu)item;
                int j = 0;
                while (j < m.getItemCount()) {
                    JMenuItem mi = m.getItem(j);
                    if (mi != null) {
                        mi.addActionListener(al);
                    }
                    ++j;
                }
            } else if (item instanceof JCheckBoxMenuItem) {
                ((JCheckBoxMenuItem)item).addActionListener(al);
            }
            ++i;
        }
    }

    private void addDefaults() {
        this.mainMenu.addSeparator();
        final JMenu font = new JMenu("Font", true);
        font.setMnemonic('F');
        String[] fontLabels = new String[]{"Plain", "Bold"};
        String[] fontCommands = new String[]{"plain", "bold"};
        char[] fontMnemonics = new char[]{'b', 'p'};
        font.setText("Font".concat("         ( Plain ) "));
        int i = 0;
        while (i < fontLabels.length) {
            JMenuItem mi = new JMenuItem(fontLabels[i]);
            mi.setActionCommand(fontCommands[i]);
            mi.setMnemonic(fontMnemonics[i]);
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    font.setText("Font".concat("         ( ").concat(((JMenuItem)e.getSource()).getText()).concat(" ) "));
                }
            });
            font.add(mi);
            ++i;
        }
        this.defaults.add(font);
        this.mainMenu.add(font);
        final JMenu size = new JMenu("Font Size", true);
        size.setMnemonic('z');
        String[] sizeLabels = new String[]{"LARGE", "large", "small", "tiny"};
        String[] sizeCommands = new String[]{"LARGE", "large", "small", "tiny"};
        char[] sizeMnemonics = new char[]{'G', 'l', 's', 'y'};
        size.setText("Font Size".concat("  ( LARGE ) "));
        int i2 = 0;
        while (i2 < sizeLabels.length) {
            JMenuItem mi = new JMenuItem(sizeLabels[i2]);
            mi.setActionCommand(sizeCommands[i2]);
            mi.setMnemonic(sizeMnemonics[i2]);
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    size.setText("Font Size".concat("  ( ").concat(((JMenuItem)e.getSource()).getText()).concat(" ) "));
                }
            });
            size.add(mi);
            ++i2;
        }
        this.defaults.add(size);
        this.mainMenu.add(size);
        final JMenu scale = new JMenu("Zoom", true);
        scale.setMnemonic('s');
        String[] scaleLabels = new String[]{"0.2", "0.3", "0.5", "0.7", "1.0", "1.5", "2.0"};
        String[] scaleCommands = new String[]{"0.2", "0.3", "0.5", "0.7", "1.0", "1.5", "2.0"};
        char[] scaleMnemonics = new char[]{'0', '3', '5', '7', '.', '1', '2'};
        scale.setText("Zoom".concat("        ( 1.0 ) "));
        int i3 = 0;
        while (i3 < scaleLabels.length) {
            JMenuItem mi = new JMenuItem(scaleLabels[i3]);
            mi.setEnabled(true);
            mi.setActionCommand(scaleCommands[i3]);
            mi.setMnemonic(scaleMnemonics[i3]);
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    scale.setText("Zoom".concat("        ( ").concat(((JMenuItem)e.getSource()).getText()).concat(" ) "));
                }
            });
            scale.add(mi);
            ++i3;
        }
        scale.addSeparator();
        JCheckBoxMenuItem scaleGraphOnly = new JCheckBoxMenuItem("Host Graph", true);
        scaleGraphOnly.setActionCommand("scaleGraphOnly");
        scale.add(scaleGraphOnly);
        this.defaults.add(scale);
        this.mainMenu.add(scale);
        this.mainMenu.addSeparator();
        this.nonparallel = new JCheckBoxMenuItem("No Parallel Edges of Graphs", false);
        this.nonparallel.setActionCommand("nonparallelArcs");
        this.defaults.add(this.nonparallel);
        this.mainMenu.add(this.nonparallel);
        this.undirected = new JCheckBoxMenuItem("Undirected Edges of Graphs", false);
        this.undirected.setToolTipText("This setting is effective for new GraGra only.");
        this.undirected.setActionCommand("undirectedArcs");
        this.defaults.add(this.undirected);
        this.mainMenu.add(this.undirected);
        this.mainMenu.addSeparator();
        this.checkEmptyAttrs = new JCheckBoxMenuItem("Check Empty Attributes", false);
        this.checkEmptyAttrs.setToolTipText("Check Empty Attributes of new objects in the RHS and Hostgraphs.");
        this.checkEmptyAttrs.setActionCommand("checkEmptyAttrs");
        this.defaults.add(this.checkEmptyAttrs);
        this.mainMenu.add(this.checkEmptyAttrs);
        JMenu showAttributes = new JMenu("Show Attributes", true);
        JCheckBoxMenuItem showAttrsOfGraph = new JCheckBoxMenuItem("Graph", true);
        showAttrsOfGraph.setActionCommand("showAttributesOfGraph");
        showAttributes.add(showAttrsOfGraph);
        JCheckBoxMenuItem showAttrsOfRule = new JCheckBoxMenuItem("Rule", true);
        showAttrsOfRule.setActionCommand("showAttributesOfRule");
        showAttributes.add(showAttrsOfRule);
        JCheckBoxMenuItem showAttrsOfTypeGraph = new JCheckBoxMenuItem("Type Graph", true);
        showAttrsOfTypeGraph.setActionCommand("showAttributesOfTypeGraph");
        showAttributes.add(showAttrsOfTypeGraph);
        this.defaults.add(showAttributes);
        this.mainMenu.add(showAttributes);
        this.mainMenu.addSeparator();
        this.typesOnTop = new JCheckBoxMenuItem("Keep Types On Top", false);
        this.typesOnTop.setActionCommand("typesOnTop");
        this.defaults.add(this.typesOnTop);
        this.mainMenu.add(this.typesOnTop);
    }

    public void selectTypesOnTop(boolean b) {
        if (b != this.typesOnTop.isSelected()) {
            this.typesOnTop.doClick();
        }
    }

    public void selectNoArcParallel(boolean b) {
        if (b != this.nonparallel.isSelected()) {
            this.nonparallel.setSelected(b);
        }
    }

    public void selectArcUndirected(boolean b) {
        if (b != this.undirected.isSelected()) {
            this.undirected.setSelected(b);
        }
    }

    public void selectCheckEmptyAttrs(boolean b) {
        if (b != this.checkEmptyAttrs.isSelected()) {
            this.checkEmptyAttrs.setSelected(b);
        }
    }
}

