/*
 * Decompiled with CFR 0.152.
 */
package agg.gui.saveload;

import agg.editor.impl.EdGraGra;
import agg.gui.ProgressBar;
import agg.gui.event.SaveEvent;
import agg.gui.event.SaveEventListener;
import agg.gui.saveload.AGGFileFilter;
import agg.gui.saveload.ExtensionFileFilter;
import agg.gui.saveload.LoadSaveStatus;
import agg.util.XMLHelper;
import agg.xt_basis.GraGra;
import java.io.File;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

public class GraGraSave {
    private ProgressBar bar;
    private Vector<SaveEventListener> saveListeners = new Vector();
    private JFrame applFrame;
    private JFileChooser chooser;
    private ExtensionFileFilter filterXML;
    private EdGraGra gra;
    private GraGra basis;
    private String dirName = "";
    private String fileName = "";

    public GraGraSave(JFrame fr) {
        this(fr, "", "");
    }

    public GraGraSave(JFrame fr, String dname, String fname) {
        this.applFrame = fr;
        this.dirName = dname;
        this.fileName = fname;
        this.chooser = !this.dirName.equals("") ? new JFileChooser(this.dirName) : new JFileChooser(System.getProperty("user.dir"));
        this.filterXML = new AGGFileFilter("ggx", "AGG Files XML (.ggx)");
        this.chooser.addChoosableFileFilter(this.filterXML);
        this.chooser.setFileFilter(this.filterXML);
        this.bar = this.createProgressBar();
    }

    public FileFilter getFileFilter() {
        return this.chooser.getFileFilter();
    }

    public void setFileFilter(FileFilter filter) {
        this.chooser.setFileFilter(filter);
    }

    public void setExtensionFileFilter(ExtensionFileFilter filter) {
        this.chooser.setFileFilter(filter);
    }

    public boolean saveAs() {
        this.fireSave(new SaveEvent(this, 0, ""));
        int returnVal = this.chooser.showSaveDialog(this.applFrame);
        this.dirName = this.chooser.getCurrentDirectory().toString();
        if (returnVal == 0) {
            if (this.chooser.getSelectedFile() != null && !this.chooser.getSelectedFile().getName().equals("")) {
                this.fileName = this.chooser.getSelectedFile().getName();
                return this.save();
            }
            this.fireSave(new SaveEvent(this, 3, ""));
        } else {
            this.fireSave(new SaveEvent(this, 3, ""));
        }
        return false;
    }

    public boolean save() {
        if (this.gra == null) {
            this.fireSave(new SaveEvent(this, -1, "GraGra object is null"));
            return false;
        }
        this.fireSave(new SaveEvent(this, 0, ""));
        if (this.dirName.equals("")) {
            this.dirName = System.getProperty("user.dir");
        }
        if (!this.dirName.endsWith(File.separator)) {
            this.dirName = String.valueOf(this.dirName) + File.separator;
        }
        if (this.fileName.equals("")) {
            return this.saveAs();
        }
        if (this.chooser.getFileFilter() == this.filterXML && !this.fileName.endsWith(".ggx")) {
            this.fileName = this.fileName.concat(".ggx");
        }
        XMLHelper xmlh = new XMLHelper();
        xmlh.addTopObject(this.gra);
        if (!xmlh.save_to_xml(String.valueOf(this.dirName) + this.fileName)) {
            this.fireSave(new SaveEvent(this, 4, "Write file Error!", String.valueOf(this.dirName) + this.fileName));
            JOptionPane.showMessageDialog(this.applFrame, "Write file exception for the folder: " + this.dirName, "   IO File Error", 0);
            return false;
        }
        this.gra.setDirName(this.dirName);
        this.gra.setFileName(this.fileName);
        this.gra.getTypeSet().setResourcesPath(this.dirName);
        this.gra.setChanged(false);
        this.fireSave(new SaveEvent(this, 6, String.valueOf(this.dirName) + this.fileName));
        return true;
    }

    public boolean saveAsBase() {
        this.fireSave(new SaveEvent(this, 0, ""));
        int returnVal = this.chooser.showSaveDialog(this.applFrame);
        this.dirName = this.chooser.getCurrentDirectory().toString();
        if (returnVal == 0) {
            if (this.chooser.getSelectedFile() != null && !this.chooser.getSelectedFile().getName().equals("")) {
                this.fileName = this.chooser.getSelectedFile().getName();
                return this.saveBase();
            }
            this.fireSave(new SaveEvent(this, 3, ""));
        } else {
            this.fireSave(new SaveEvent(this, 3, ""));
        }
        return false;
    }

    public boolean saveBase() {
        if (this.basis == null) {
            return false;
        }
        if (this.dirName.equals("")) {
            this.dirName = System.getProperty("user.dir");
        }
        if (!this.dirName.endsWith(File.separator)) {
            this.dirName = String.valueOf(this.dirName) + File.separator;
        }
        if (this.fileName.equals("")) {
            return this.saveAsBase();
        }
        if (this.chooser.getFileFilter() == this.filterXML && !this.fileName.endsWith(".ggx")) {
            this.fileName = this.fileName.concat(".ggx");
        }
        XMLHelper xmlh = new XMLHelper();
        xmlh.addTopObject(this.basis);
        if (xmlh.save_to_xml(String.valueOf(this.dirName) + this.fileName)) {
            this.fireSave(new SaveEvent(this, 6, String.valueOf(this.dirName) + this.fileName));
            return true;
        }
        this.fireSave(new SaveEvent(this, 4, "Write file Error!", String.valueOf(this.dirName) + this.fileName));
        JOptionPane.showMessageDialog(this.applFrame, "Write file exception for the folder: " + this.dirName, "   IO File Error", 0);
        return false;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getDirName() {
        return this.dirName;
    }

    public void setDirName(String directory) {
        if (!directory.equals("")) {
            this.dirName = directory;
            this.chooser = new JFileChooser(this.dirName);
            this.filterXML = new AGGFileFilter("ggx", "AGG Files XML (.ggx)");
            this.chooser.addChoosableFileFilter(this.filterXML);
            this.chooser.setFileFilter(this.filterXML);
        }
    }

    public void setGraGra(EdGraGra gragra) {
        this.gra = gragra;
    }

    public void setGraGra(EdGraGra gragra, String dirname, String filename) {
        this.gra = gragra;
        if (dirname != null && !dirname.equals("")) {
            this.dirName = dirname;
        }
        this.fileName = filename;
    }

    public void setBaseGraGra(GraGra gragra) {
        this.basis = gragra;
    }

    public void setBaseGraGra(GraGra gragra, String dirname, String filename) {
        this.basis = gragra;
        if (dirname != null && !dirname.equals("")) {
            this.dirName = dirname;
        }
        this.dirName = dirname;
        this.fileName = filename;
    }

    public EdGraGra getGraGra() {
        return this.gra;
    }

    public GraGra getBaseGraGra() {
        return this.basis;
    }

    public void setFrame(JFrame f) {
        this.applFrame = f;
        if (this.bar != null) {
            this.bar.setFrame(f);
        }
    }

    public synchronized void addSaveEventListener(SaveEventListener l) {
        if (!this.saveListeners.contains(l)) {
            this.saveListeners.addElement(l);
        }
    }

    public synchronized void removeSaveEventListener(SaveEventListener l) {
        if (this.saveListeners.contains(l)) {
            this.saveListeners.removeElement(l);
        }
    }

    private void fireSave(SaveEvent e) {
        int i = 0;
        while (i < this.saveListeners.size()) {
            this.saveListeners.elementAt(i).saveEventOccurred(e);
            ++i;
        }
    }

    private ProgressBar createProgressBar() {
        ProgressBar pbar = new ProgressBar("Save");
        pbar.setFrame(this.applFrame);
        pbar.setLabel("Saving File ...");
        pbar.setFinishText("Saving  done");
        pbar.setToolTipText("Save Status");
        pbar.setFinishAppend(false);
        LoadSaveStatus.setMaximum(1000);
        return pbar;
    }
}

