/*
 * Decompiled with CFR 0.152.
 */
package agg.editor.impl;

import agg.attribute.facade.impl.DefaultInformationFacade;
import agg.attribute.handler.AttrHandler;
import agg.attribute.impl.DeclMember;
import agg.attribute.impl.DeclTuple;
import agg.editor.impl.EdArc;
import agg.editor.impl.EdGraph;
import agg.editor.impl.EdGraphObject;
import agg.editor.impl.EdNode;
import agg.editor.impl.EdType;
import agg.gui.event.TypeEvent;
import agg.gui.event.TypeEventListener;
import agg.xt_basis.Arc;
import agg.xt_basis.Graph;
import agg.xt_basis.Type;
import agg.xt_basis.TypeException;
import agg.xt_basis.TypeGraph;
import agg.xt_basis.TypeGraphArc;
import agg.xt_basis.TypeSet;
import java.awt.Color;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class EdTypeSet {
    private final Vector<EdType> nodeTypes = new Vector();
    private final Vector<EdType> arcTypes = new Vector();
    private final Hashtable<EdType, List<EdGraphObject>> nodeTypeUsers = new Hashtable();
    private final Hashtable<EdType, List<EdGraphObject>> arcTypeUsers = new Hashtable();
    private final Hashtable<EdType, List<EdGraphObject>> typeGraphNodeUsers = new Hashtable();
    private final Hashtable<EdType, Hashtable<TypeGraphArc, List<EdGraphObject>>> typeGraphArcUsers = new Hashtable();
    private EdType selectedNodeType;
    private EdType selectedArcType;
    private EdType defaultNodeType;
    private EdType defaultArcType;
    private boolean iconable;
    private String resourcesPath = System.getProperty("user.dir");
    private boolean typeKeyChanged;
    private final Vector<TypeEventListener> typeEventListeners = new Vector();
    private EdGraph edTypeGraph;
    private TypeSet bTypeSet;

    public EdTypeSet() {
    }

    public EdTypeSet(TypeSet baseTypeSet) {
        this.bTypeSet = baseTypeSet;
        this.initTypesFromTypeSet();
    }

    public void trimToSize() {
        this.nodeTypes.trimToSize();
        this.arcTypes.trimToSize();
        this.typeEventListeners.trimToSize();
    }

    public void dispose() {
        this.typeEventListeners.clear();
        this.defaultNodeType = null;
        this.defaultArcType = null;
        this.selectedNodeType = null;
        this.selectedArcType = null;
        if (this.edTypeGraph != null) {
            this.edTypeGraph.dispose();
            this.edTypeGraph = null;
        }
        this.arcTypeUsers.clear();
        this.nodeTypeUsers.clear();
        this.typeGraphArcUsers.clear();
        this.typeGraphNodeUsers.clear();
        while (!this.nodeTypes.isEmpty()) {
            this.nodeTypes.get(0).dispose();
            this.nodeTypes.remove(0);
        }
        while (!this.arcTypes.isEmpty()) {
            this.arcTypes.get(0).dispose();
            this.arcTypes.remove(0);
        }
        this.bTypeSet = null;
    }

    public void finalize() {
    }

    public TypeSet getBasisTypeSet() {
        return this.bTypeSet;
    }

    public void setBasisTypeSet(TypeSet typeSet) {
        this.bTypeSet = typeSet;
        this.initTypesFromTypeSet();
    }

    public EdGraph getTypeGraph() {
        return this.edTypeGraph;
    }

    public boolean setTypeGraph(EdGraph typeGraphLayout) {
        if (typeGraphLayout != null) {
            if (this.bTypeSet.compareTo(typeGraphLayout.getTypeSet().getBasisTypeSet())) {
                Vector<Type> v = typeGraphLayout.getBasisGraph().getUsedTypes();
                this.bTypeSet.adaptTypes(v.elements(), false);
                this.refreshTypes();
                this.edTypeGraph = typeGraphLayout;
                this.bTypeSet.setTypeGraph(this.edTypeGraph.getBasisGraph());
                this.edTypeGraph.update();
                return true;
            }
            return false;
        }
        return false;
    }

    public EdGraph createTypeGraph() {
        Graph typeGraph = this.bTypeSet.getTypeGraph();
        if (typeGraph == null) {
            typeGraph = this.bTypeSet.createTypeGraph();
        }
        this.edTypeGraph = new EdGraph(typeGraph, this);
        this.edTypeGraph.setCurrentLayoutToDefault(true);
        this.edTypeGraph.markTypeGraph(true);
        return this.edTypeGraph;
    }

    protected void removeTypeGraph() {
        this.edTypeGraph = null;
    }

    public void destroyTypeGraph() {
        this.edTypeGraph.dispose();
        this.edTypeGraph = null;
    }

    public EdType createType(Type baseType) {
        if (baseType == null) {
            return null;
        }
        String addRepr = baseType.getAdditionalRepr();
        if (addRepr.equals("")) {
            baseType.setAdditionalRepr(":RECT:java.awt.Color[r=0,g=0,b=0]:[NODE]:");
        }
        Vector<String> v = this.getAdditionalReprOfBasisType(baseType);
        String shapeStr = v.elementAt(0);
        String colorStr = v.elementAt(1);
        String filledStr = v.elementAt(2);
        String imageFileNameStr = v.elementAt(3);
        String markStr = v.elementAt(4);
        int shape = -1;
        shape = shapeStr.equals("RECT") ? 51 : (shapeStr.equals("ROUNDRECT") ? 54 : (shapeStr.equals("CIRCLE") ? 52 : (shapeStr.equals("OVAL") ? 53 : (shapeStr.equals("SOLID_LINE") ? 61 : (shapeStr.equals("DASH_LINE") ? 62 : (shapeStr.equals("DOT_LINE") ? 63 : 51))))));
        String r_str = colorStr.substring(colorStr.indexOf("r=") + 2, colorStr.indexOf(",g="));
        String g_str = colorStr.substring(colorStr.indexOf("g=") + 2, colorStr.indexOf(",b="));
        String b_str = colorStr.substring(colorStr.indexOf("b=") + 2, colorStr.indexOf("]"));
        Color color = new Color(Integer.valueOf(r_str), Integer.valueOf(g_str), Integer.valueOf(b_str));
        boolean filled = filledStr.equals("FILLED") || filledStr.equals("BOLD");
        EdType eType = new EdType(baseType, shape, color, filled, imageFileNameStr);
        eType.setResourcesPath(this.resourcesPath);
        if (markStr.equals("[NODE]")) {
            eType.setIconable(this.iconable);
            this.addAlphabeticalSorted(eType, this.nodeTypes);
            this.fireTypeEvent(new TypeEvent(this, eType, 1));
        } else if (markStr.equals("[EDGE]")) {
            this.addAlphabeticalSorted(eType, this.arcTypes);
            this.fireTypeEvent(new TypeEvent(this, eType, 2));
        }
        return eType;
    }

    public EdType createNodeType(String name, int shape, Color color) {
        Type bType = null;
        EdType eType = null;
        if (this.isNewType(this.nodeTypes, name, shape, color)) {
            if (this.bTypeSet != null) {
                bType = this.bTypeSet.createNodeType(false);
                eType = new EdType(name, shape, color, "", bType);
            } else {
                eType = new EdType(name, shape, color, "");
            }
            eType.setIconable(this.iconable);
            this.addAlphabeticalSorted(eType, this.nodeTypes);
            this.fireTypeEvent(new TypeEvent(this, eType, 1));
        }
        return eType;
    }

    public EdType createNodeType(String name, int shape, Color color, String iconFileName) {
        Type bType = null;
        EdType eType = null;
        if (this.isNewType(this.nodeTypes, name, shape, color)) {
            if (this.bTypeSet != null) {
                bType = this.bTypeSet.createNodeType(false);
                eType = new EdType(name, shape, color, iconFileName, bType);
            } else {
                eType = new EdType(name, shape, color, iconFileName);
            }
            eType.setIconable(this.iconable);
            this.addAlphabeticalSorted(eType, this.nodeTypes);
            this.fireTypeEvent(new TypeEvent(this, eType, 1));
        }
        return eType;
    }

    public EdType createNodeType(String name, int shape, Color color, boolean filledShape, String iconFileName) {
        Type bType = null;
        EdType eType = null;
        if (this.isNewType(this.nodeTypes, name, shape, color, filledShape)) {
            if (this.bTypeSet != null) {
                bType = this.bTypeSet.createNodeType(false);
                eType = new EdType(name, shape, color, filledShape, iconFileName, bType);
            } else {
                eType = new EdType(name, shape, color, filledShape, iconFileName);
            }
            eType.setIconable(this.iconable);
            this.addAlphabeticalSorted(eType, this.nodeTypes);
            this.fireTypeEvent(new TypeEvent(this, eType, 1));
        }
        return eType;
    }

    public EdType createNodeType(Type baseType) {
        if (baseType == null) {
            return null;
        }
        if (baseType.getAdditionalRepr().equals("")) {
            return this.createDefaultNodeType(baseType);
        }
        String shapeStr = "";
        String colorStr = "";
        String filledStr = "";
        String imageFileNameStr = "";
        int shape = -1;
        Vector<String> v = this.getAdditionalReprOfBasisType(baseType);
        shapeStr = v.elementAt(0);
        colorStr = v.elementAt(1);
        filledStr = v.elementAt(2);
        imageFileNameStr = v.elementAt(3);
        shape = shapeStr.equals("RECT") ? 51 : (shapeStr.equals("ROUNDRECT") ? 54 : (shapeStr.equals("CIRCLE") ? 52 : (shapeStr.equals("OVAL") ? 53 : 51)));
        String r_str = colorStr.substring(colorStr.indexOf("r=") + 2, colorStr.indexOf(",g="));
        String g_str = colorStr.substring(colorStr.indexOf("g=") + 2, colorStr.indexOf(",b="));
        String b_str = colorStr.substring(colorStr.indexOf("b=") + 2, colorStr.indexOf("]"));
        Color color = new Color(Integer.valueOf(r_str), Integer.valueOf(g_str), Integer.valueOf(b_str));
        boolean filled = filledStr.equals("FILLED");
        EdType eType = new EdType(baseType, shape, color, filled, imageFileNameStr);
        eType.setResourcesPath(this.resourcesPath);
        eType.setIconable(this.iconable);
        this.addAlphabeticalSorted(eType, this.nodeTypes);
        return eType;
    }

    public EdType getDefaultNodeType() {
        return this.defaultNodeType;
    }

    public EdType createDefaultNodeType(Type baseType) {
        if (baseType == null) {
            return this.defaultNodeType;
        }
        EdType eType = null;
        if (this.isNewType(this.nodeTypes, baseType.getStringRepr(), 51, Color.black)) {
            eType = new EdType(baseType, 51, Color.black, false, "");
            eType.setIconable(this.iconable);
            this.addAlphabeticalSorted(eType, this.nodeTypes);
            this.fireTypeEvent(new TypeEvent(this, eType, 1));
        } else {
            eType = this.getType(this.nodeTypes, baseType.getStringRepr(), 51, Color.black, false);
        }
        return eType;
    }

    public EdType createNodeType(Type baseType, String name, int shape, Color color) {
        if (this.isNewType(this.nodeTypes, name, shape, color, false)) {
            EdType eType = new EdType(name, shape, color, false, "", baseType);
            eType.setIconable(this.iconable);
            this.addAlphabeticalSorted(eType, this.nodeTypes);
            return eType;
        }
        return null;
    }

    public EdType createNodeType(Type baseType, String name, int shape, Color color, String iconFileName) {
        if (this.isNewType(this.nodeTypes, name, shape, color, false)) {
            EdType eType = new EdType(name, shape, color, false, iconFileName, baseType);
            eType.setIconable(true);
            this.addAlphabeticalSorted(eType, this.nodeTypes);
            return eType;
        }
        return null;
    }

    public EdType createNodeType(Type baseType, String name, int shape, Color color, boolean filledshape, String iconFileName) {
        if (this.isNewType(this.nodeTypes, name, shape, color, filledshape)) {
            EdType eType = new EdType(name, shape, color, filledshape, iconFileName, baseType);
            eType.setIconable(true);
            this.addAlphabeticalSorted(eType, this.nodeTypes);
            return eType;
        }
        return null;
    }

    public void addNodeType(EdType t) {
        t.setIconable(this.iconable);
        this.addAlphabeticalSorted(t, this.nodeTypes);
        this.fireTypeEvent(new TypeEvent(this, t, 1));
    }

    public boolean containsNodeType(String name, int shape, Color color, boolean filledshape) {
        int i = 0;
        while (i < this.nodeTypes.size()) {
            EdType t = this.nodeTypes.get(i);
            if (t.getName().equals(name) && t.getShape() == shape && t.getColor().equals(color)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected EdType getNodeTypeByBasis(Type baseType) {
        int i = 0;
        while (i < this.nodeTypes.size()) {
            EdType t = this.nodeTypes.get(i);
            if (t.getBasisType() == baseType) {
                return t;
            }
            ++i;
        }
        return null;
    }

    protected EdType getArcTypeByBasis(Type baseType) {
        int i = 0;
        while (i < this.arcTypes.size()) {
            EdType t = this.arcTypes.get(i);
            if (t.getBasisType() == baseType) {
                return t;
            }
            ++i;
        }
        return null;
    }

    public EdType getNodeType(Type baseType, String name, int shape, Color color, boolean filledShape) {
        EdType t = null;
        Type bt = null;
        if (this.bTypeSet.containsType(baseType)) {
            bt = baseType;
        }
        if (bt != null) {
            t = this.createNodeType(bt, name, shape, color, filledShape, "");
        } else {
            DeclTuple decl;
            t = this.createNodeType(name, shape, color, filledShape, "");
            if (t != null && (decl = (DeclTuple)baseType.getAttrType()) != null) {
                t.getBasisType().createAttributeType();
                AttrHandler javaHandler = DefaultInformationFacade.self().getJavaHandler();
                int num = decl.getNumberOfEntries();
                int i = 0;
                while (i < num) {
                    DeclMember mem = (DeclMember)decl.getMemberAt(i);
                    t.getBasisType().getAttrType().addMember(javaHandler, mem.getTypeName(), mem.getName());
                    ++i;
                }
            }
        }
        if (t == null) {
            t = this.getType(this.nodeTypes, name, shape, color, filledShape);
        }
        return t;
    }

    public EdType createArcType(String name, int shape, Color color, boolean filledShape) {
        Type bType = null;
        EdType eType = null;
        if (this.isNewType(this.arcTypes, name, shape, color, filledShape)) {
            if (this.bTypeSet != null) {
                bType = this.bTypeSet.createArcType(false);
                eType = new EdType(name, shape, color, filledShape, "", bType);
            } else {
                eType = new EdType(name, shape, color, filledShape, "");
            }
            this.addAlphabeticalSorted(eType, this.arcTypes);
            this.fireTypeEvent(new TypeEvent(this, eType, 2));
        }
        return eType;
    }

    public EdType createArcType(String name, int shape, Color color) {
        return this.createArcType(name, shape, color, false);
    }

    public EdType createArcType(Type baseType) {
        if (baseType == null) {
            return null;
        }
        if (baseType.getAdditionalRepr().equals("")) {
            return this.createDefaultArcType(baseType);
        }
        String shapeStr = "";
        String colorStr = "";
        String filledStr = "";
        int shape = -1;
        Vector<String> v = this.getAdditionalReprOfBasisType(baseType);
        shapeStr = v.elementAt(0);
        colorStr = v.elementAt(1);
        filledStr = v.elementAt(2);
        shape = shapeStr.equals("SOLID_LINE") ? 61 : (shapeStr.equals("DASH_LINE") ? 62 : (shapeStr.equals("DOT_LINE") ? 63 : 61));
        String r_str = colorStr.substring(colorStr.indexOf("r=") + 2, colorStr.indexOf(",g="));
        String g_str = colorStr.substring(colorStr.indexOf("g=") + 2, colorStr.indexOf(",b="));
        String b_str = colorStr.substring(colorStr.indexOf("b=") + 2, colorStr.indexOf("]"));
        Color color = new Color(Integer.valueOf(r_str), Integer.valueOf(g_str), Integer.valueOf(b_str));
        boolean filled = filledStr.equals("BOLD");
        EdType eType = new EdType(baseType, shape, color, filled, "");
        this.addAlphabeticalSorted(eType, this.arcTypes);
        return eType;
    }

    public EdType getDefaultArcType() {
        return this.defaultArcType;
    }

    public EdType createDefaultArcType(Type baseType) {
        if (baseType == null) {
            return this.defaultArcType;
        }
        EdType eType = null;
        if (this.isNewType(this.arcTypes, baseType.getStringRepr(), 61, Color.black)) {
            eType = new EdType(baseType, 61, Color.black, false, "");
            this.addAlphabeticalSorted(eType, this.arcTypes);
            this.fireTypeEvent(new TypeEvent(this, eType, 2));
        } else {
            eType = this.getType(this.arcTypes, baseType.getStringRepr(), 61, Color.black, false);
        }
        return eType;
    }

    public EdType createArcType(Type baseType, String name, int shape, Color color) {
        if (this.isNewType(this.arcTypes, name, shape, color, false)) {
            EdType eType = new EdType(name, shape, color, false, "", baseType);
            this.addAlphabeticalSorted(eType, this.arcTypes);
            return eType;
        }
        return null;
    }

    public EdType createArcType(Type baseType, String name, int shape, Color color, boolean bold) {
        if (this.isNewType(this.arcTypes, name, shape, color, bold)) {
            EdType eType = new EdType(name, shape, color, bold, "", baseType);
            this.addAlphabeticalSorted(eType, this.arcTypes);
            return eType;
        }
        return null;
    }

    public void addArcType(EdType t) {
        this.addAlphabeticalSorted(t, this.arcTypes);
        this.fireTypeEvent(new TypeEvent(this, t, 2));
    }

    public boolean containsArcType(String name, int shape, Color color) {
        int i = 0;
        while (i < this.arcTypes.size()) {
            EdType t = this.arcTypes.get(i);
            if (t.getName().equals(name) && t.getShape() == shape && t.getColor().equals(color)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public EdType getArcType(Type baseType, String name, int shape, Color color, boolean bold) {
        EdType t = null;
        Type bt = null;
        if (this.bTypeSet.containsType(baseType)) {
            bt = baseType;
        }
        if (bt != null) {
            t = this.createArcType(bt, name, shape, color, bold);
        } else {
            DeclTuple decl;
            t = this.createArcType(name, shape, color, bold);
            if (t != null && (decl = (DeclTuple)baseType.getAttrType()) != null) {
                t.getBasisType().createAttributeType();
                AttrHandler javaHandler = DefaultInformationFacade.self().getJavaHandler();
                int num = decl.getNumberOfEntries();
                int i = 0;
                while (i < num) {
                    DeclMember mem = (DeclMember)decl.getMemberAt(i);
                    t.getBasisType().getAttrType().addMember(javaHandler, mem.getTypeName(), mem.getName());
                    ++i;
                }
            }
        }
        if (t == null) {
            t = this.getType(this.arcTypes, name, shape, color, bold);
        }
        return t;
    }

    private int addAlphabeticalSorted(EdType type, Vector<EdType> types) {
        int indx = -1;
        String name = type.getName();
        if (types.isEmpty()) {
            types.add(type);
        } else {
            int i = 0;
            while (i < types.size()) {
                EdType t = types.get(i);
                String n = t.getName();
                if (name.compareTo(n) < 0) {
                    types.add(i, type);
                    break;
                }
                if (name.compareTo(n) == 0) {
                    if (i + 1 >= types.size()) break;
                    types.add(i + 1, type);
                    break;
                }
                ++i;
            }
            if (types.indexOf(type) == -1) {
                types.add(type);
            }
        }
        indx = types.indexOf(type);
        return indx;
    }

    public boolean isEmpty() {
        return this.nodeTypes.isEmpty() && this.arcTypes.isEmpty();
    }

    public boolean hasTypeKeyChanged() {
        return this.typeKeyChanged;
    }

    public void unsetTypeKeyChanged() {
        this.typeKeyChanged = false;
        this.unsetTypeKeyChangedOfAllTypes();
    }

    public Vector<EdType> getNodeTypes() {
        return this.nodeTypes;
    }

    public void setNodeTypes(Vector<EdType> newNodeTypes) {
        this.nodeTypes.clear();
        this.nodeTypes.addAll(newNodeTypes);
    }

    public Vector<EdType> getArcTypes() {
        return this.arcTypes;
    }

    public void setArcTypes(Vector<EdType> newArcTypes) {
        this.arcTypes.clear();
        this.arcTypes.addAll(newArcTypes);
    }

    public EdType getSelectedNodeType() {
        return this.selectedNodeType;
    }

    public void setSelectedNodeType(EdType et) {
        this.selectedNodeType = et;
    }

    public EdType getSelectedArcType() {
        return this.selectedArcType;
    }

    public void setSelectedArcType(EdType et) {
        this.selectedArcType = et;
    }

    public void renameType(EdType aType, String newName) {
        aType.setName(newName);
    }

    public boolean redefineType(EdType aType, String newName, int newShape, Color newColor, boolean filled, String newImageFileName, String newComment) {
        aType.setTypeKeyChanged(false);
        if (aType.redefineType(newName, newShape, newColor, filled, newImageFileName, newComment)) {
            this.typeKeyChanged = aType.hasTypeKeyChanged();
            return true;
        }
        return false;
    }

    private void unsetTypeKeyChangedOfAllTypes() {
        int i = 0;
        while (i < this.nodeTypes.size()) {
            this.nodeTypes.get(i).setTypeKeyChanged(false);
            ++i;
        }
        i = 0;
        while (i < this.arcTypes.size()) {
            this.arcTypes.get(i).setTypeKeyChanged(false);
            ++i;
        }
    }

    public void removeType(EdType aType) throws TypeException {
        if (aType.getAdditionalReprOfBasisType().contains("[NODE]")) {
            this.removeNodeType(aType);
        } else if (aType.getAdditionalReprOfBasisType().contains("[EDGE]")) {
            this.removeArcType(aType);
        }
    }

    public void removeNodeType(EdType aType) throws TypeException {
        if (!this.nodeTypes.contains(aType)) {
            throw new TypeException("Cannot delete this type from the node type list! \nThe type:  <" + aType.getName() + ">  is not a node type!");
        }
        this.bTypeSet.destroyType(aType.getBasisType());
        this.nodeTypes.removeElement(aType);
        this.removeNodeTypeUsers(aType);
    }

    public void removeArcType(EdType aType) throws TypeException {
        if (!this.arcTypes.contains(aType)) {
            throw new TypeException("Cannot delete this type from the edge type list! \nThe type:  <" + aType.getName() + ">  is not an edge type!");
        }
        this.bTypeSet.destroyType(aType.getBasisType());
        this.removeArcTypeUsers(aType);
        this.arcTypes.removeElement(aType);
    }

    private void initTypesFromTypeSet() {
        this.nodeTypes.clear();
        this.arcTypes.clear();
        Enumeration<Type> types = this.bTypeSet.getTypes();
        while (types.hasMoreElements()) {
            Type t = types.nextElement();
            if (t.getStringRepr().equals("") && t.getAdditionalRepr().equals("")) {
                try {
                    this.bTypeSet.destroyType(t);
                }
                catch (TypeException e) {
                    System.out.println("EdTypeSet: " + e.getMessage());
                }
                continue;
            }
            this.createType(t);
        }
        Graph typeGraph = this.bTypeSet.getTypeGraph();
        if (typeGraph != null && (this.edTypeGraph == null || typeGraph != this.edTypeGraph.getBasisGraph())) {
            this.edTypeGraph = new EdGraph(typeGraph, this);
            this.edTypeGraph.markTypeGraph(true);
        }
    }

    public void refreshAttrInstances() {
        EdGraphObject go;
        int j;
        List<EdGraphObject> list;
        boolean typeHasAttrs;
        EdType t;
        int i = 0;
        while (i < this.arcTypes.size()) {
            t = this.arcTypes.get(i);
            typeHasAttrs = t.getBasisType().hasAnyAttrMember();
            if (t.hasAttrTypeChanged()) {
                list = this.getTypeUsers(t);
                j = 0;
                while (j < list.size()) {
                    go = (EdArc)list.get(j);
                    if (((EdArc)go).getBasisArc() != null && ((EdArc)go).getBasisArc().getType() != null) {
                        if (typeHasAttrs) {
                            if (((EdArc)go).getBasisArc().getAttribute() == null) {
                                ((EdArc)go).getBasisArc().createAttributeInstance();
                            }
                        } else if (((EdArc)go).getBasisArc().getAttribute() != null) {
                            ((EdArc)go).getBasisArc().disposeAttributeInstance();
                        }
                    } else {
                        list.remove(j);
                        --j;
                    }
                    ++j;
                }
            }
            t.setAttrTypeChanged(false);
            if (!typeHasAttrs) {
                t.getBasisType().removeAttributeType();
            }
            ++i;
        }
        i = 0;
        while (i < this.nodeTypes.size()) {
            t = this.nodeTypes.get(i);
            typeHasAttrs = t.getBasisType().hasAnyAttrMember();
            if (t.hasAttrTypeChanged()) {
                list = this.getTypeUsers(t);
                j = 0;
                while (j < list.size()) {
                    go = (EdNode)list.get(j);
                    if (((EdNode)go).getBasisNode() != null && ((EdNode)go).getBasisNode().getType() != null) {
                        if (typeHasAttrs) {
                            if (((EdNode)go).getBasisNode().getAttribute() == null) {
                                ((EdNode)go).getBasisNode().createAttributeInstance();
                            }
                        } else if (((EdNode)go).getBasisNode().getAttribute() != null) {
                            ((EdNode)go).getBasisNode().disposeAttributeInstance();
                        }
                    } else {
                        list.remove(j);
                        --j;
                    }
                    ++j;
                }
            }
            t.setAttrTypeChanged(false);
            if (!typeHasAttrs) {
                t.getBasisType().removeAttributeType();
            }
            ++i;
        }
    }

    public void refreshTypeUsersAfterAttrTypeChanged() {
        EdGraphObject go;
        int j;
        List<EdGraphObject> list;
        EdType t;
        int i = 0;
        while (i < this.nodeTypes.size()) {
            t = this.nodeTypes.get(i);
            if (t.hasAttrTypeChanged()) {
                list = this.getTypeUsers(t);
                j = 0;
                while (j < list.size()) {
                    go = (EdNode)list.get(j);
                    if (((EdNode)go).getBasisNode() != null) {
                        if (((EdNode)go).getBasisNode().getAttribute() == null) {
                            ((EdNode)go).getBasisNode().createAttributeInstance();
                        }
                    } else {
                        list.remove(j);
                        --j;
                    }
                    ++j;
                }
            }
            t.setAttrTypeChanged(false);
            ++i;
        }
        i = 0;
        while (i < this.arcTypes.size()) {
            t = this.arcTypes.get(i);
            if (t.hasAttrTypeChanged()) {
                list = this.getTypeUsers(t);
                j = 0;
                while (j < list.size()) {
                    go = (EdArc)list.get(j);
                    if (((EdArc)go).getBasisArc() != null) {
                        if (((EdArc)go).getBasisArc().getAttribute() == null) {
                            ((EdArc)go).getBasisArc().createAttributeInstance();
                        }
                    } else {
                        list.remove(j);
                        --j;
                    }
                    ++j;
                }
            }
            t.setAttrTypeChanged(false);
            ++i;
        }
    }

    public void refreshTypes() {
        boolean hasChanged = false;
        Enumeration<Type> types = this.bTypeSet.getTypes();
        while (types.hasMoreElements()) {
            Type t = types.nextElement();
            if (this.getType(t) != null) continue;
            if (t.getAdditionalRepr().indexOf(":[NODE]:") >= 0) {
                this.createNodeType(t);
                hasChanged = true;
                continue;
            }
            if (t.getAdditionalRepr().indexOf(":[EDGE]:") < 0) continue;
            this.createArcType(t);
            hasChanged = true;
        }
        if (hasChanged) {
            this.fireTypeEvent(new TypeEvent(this, 11));
        }
    }

    public void refreshTypes(boolean byNameOnly) {
        boolean hasChanged = false;
        Enumeration<Type> types = this.bTypeSet.getTypes();
        while (types.hasMoreElements()) {
            Type t = types.nextElement();
            EdType type = this.getType(t);
            if (type == null && byNameOnly) {
                type = this.getTypeForName(t);
            }
            if (type != null) continue;
            if (t.getAdditionalRepr().indexOf(":[NODE]:") >= 0) {
                this.createNodeType(t);
                hasChanged = true;
                continue;
            }
            if (t.getAdditionalRepr().indexOf(":[EDGE]:") < 0) continue;
            this.createArcType(t);
            hasChanged = true;
        }
        if (hasChanged) {
            this.fireTypeEvent(new TypeEvent(this, 11));
        }
    }

    public boolean isNewType(Vector<EdType> types, String name, int shape, Color color) {
        boolean result = true;
        int i = 0;
        while (i < types.size()) {
            EdType et = types.elementAt(i);
            if (et.name.equals(name) && et.shape == shape && et.color.equals(color)) {
                result = false;
                break;
            }
            ++i;
        }
        return result;
    }

    public boolean isNewType(Vector<EdType> types, String name, int shape, Color color, boolean filledShape) {
        boolean result = true;
        int i = 0;
        while (i < types.size()) {
            EdType et = types.elementAt(i);
            if (et.name.equals(name) && et.shape == shape && et.color.equals(color) && et.filled == filledShape) {
                result = false;
                break;
            }
            ++i;
        }
        return result;
    }

    public boolean isNewType(Vector<EdType> types, EdType t) {
        if (t == null) {
            return false;
        }
        boolean result = true;
        int i = 0;
        while (i < types.size()) {
            EdType et = types.elementAt(i);
            if (et.name.equals(t.getBasisType().getStringRepr()) && et.shape == t.getShape() && et.color.equals(t.getColor())) {
                result = false;
                break;
            }
            ++i;
        }
        return result;
    }

    public void setAdditionalReprOfBasisType() {
        EdType t;
        int i = 0;
        while (i < this.nodeTypes.size()) {
            t = this.nodeTypes.elementAt(i);
            if (t.getBasisType().getAdditionalRepr() == null || t.getBasisType().getAdditionalRepr().equals("") || t.hasOldAdditionalRepr()) {
                t.setAdditionalReprOfBasisType();
            }
            ++i;
        }
        i = 0;
        while (i < this.arcTypes.size()) {
            t = this.arcTypes.elementAt(i);
            if (t.getBasisType().getAdditionalRepr() == null || t.getBasisType().getAdditionalRepr().equals("") || t.hasOldAdditionalRepr()) {
                t.setAdditionalReprOfBasisType();
            }
            ++i;
        }
    }

    protected void enrichAdditionalReprOfNodeType() {
        int i = 0;
        while (i < this.nodeTypes.size()) {
            this.nodeTypes.get(i).enrichAdditionalRepr();
            ++i;
        }
    }

    public boolean basisTypeReprComplete() {
        EdType t;
        int i = 0;
        while (i < this.nodeTypes.size()) {
            t = this.nodeTypes.elementAt(i);
            if (t.getBasisType().getAdditionalRepr() == null || t.getBasisType().getAdditionalRepr().equals("") || t.hasOldAdditionalRepr()) {
                return false;
            }
            ++i;
        }
        i = 0;
        while (i < this.arcTypes.size()) {
            t = this.arcTypes.elementAt(i);
            if (t.getBasisType().getAdditionalRepr() == null || t.getBasisType().getAdditionalRepr().equals("") || t.hasOldAdditionalRepr()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public EdType getType(Vector<EdType> types, String name, int shape, Color color) {
        int i = 0;
        while (i < types.size()) {
            EdType et = types.elementAt(i);
            if (et.name.equals(name) && et.shape == shape && et.color.equals(color)) {
                return et;
            }
            ++i;
        }
        return null;
    }

    public EdType getType(Vector<EdType> types, String name, int shape, Color color, boolean filledShape) {
        int i = 0;
        while (i < types.size()) {
            EdType et = types.elementAt(i);
            if (et.name.equals(name) && et.shape == shape && et.color.equals(color) && et.filled == filledShape) {
                return et;
            }
            ++i;
        }
        return null;
    }

    public EdType getType(Type t) {
        EdType et;
        int i = 0;
        while (i < this.nodeTypes.size()) {
            et = this.nodeTypes.elementAt(i);
            if (et.getBasisType() == t || et.getBasisType().compareTo(t)) {
                return et;
            }
            ++i;
        }
        i = 0;
        while (i < this.arcTypes.size()) {
            et = this.arcTypes.elementAt(i);
            if (et.getBasisType() == t || et.getBasisType().compareTo(t)) {
                return et;
            }
            ++i;
        }
        return null;
    }

    public EdType getNodeType(Type t) {
        int i = 0;
        while (i < this.nodeTypes.size()) {
            EdType et = this.nodeTypes.elementAt(i);
            if (et.getBasisType().compareTo(t)) {
                return et;
            }
            ++i;
        }
        return null;
    }

    public EdType getArcType(Type t) {
        int i = 0;
        while (i < this.arcTypes.size()) {
            EdType et = this.arcTypes.elementAt(i);
            if (et.getBasisType().compareTo(t)) {
                return et;
            }
            ++i;
        }
        return null;
    }

    public EdType getTypeForName(Type t) {
        EdType et;
        int i = 0;
        while (i < this.nodeTypes.size()) {
            et = this.nodeTypes.elementAt(i);
            if (et.getBasisType().getName().equals(t.getName())) {
                return et;
            }
            ++i;
        }
        i = 0;
        while (i < this.arcTypes.size()) {
            et = this.arcTypes.elementAt(i);
            if (et.getBasisType().getName().equals(t.getName())) {
                return et;
            }
            ++i;
        }
        return null;
    }

    public EdType getTypeForName(String tname) {
        EdType et;
        int i = 0;
        while (i < this.nodeTypes.size()) {
            et = this.nodeTypes.elementAt(i);
            if (et.getName().equals(tname)) {
                return et;
            }
            ++i;
        }
        i = 0;
        while (i < this.arcTypes.size()) {
            et = this.arcTypes.elementAt(i);
            if (et.getName().equals(tname)) {
                return et;
            }
            ++i;
        }
        return null;
    }

    public EdType getNodeTypeForName(String tname) {
        int i = 0;
        while (i < this.nodeTypes.size()) {
            EdType et = this.nodeTypes.elementAt(i);
            if (et.getName().equals(tname)) {
                return et;
            }
            ++i;
        }
        return null;
    }

    public EdType getArcTypeForName(String tname) {
        int i = 0;
        while (i < this.arcTypes.size()) {
            EdType et = this.arcTypes.elementAt(i);
            if (et.getName().equals(tname)) {
                return et;
            }
            ++i;
        }
        return null;
    }

    public Vector<String> getAdditionalReprOfBasisType(Type baseType) {
        Vector<String> v = new Vector<String>();
        String addRepr = baseType.getAdditionalRepr();
        String shapeStr = "";
        String colorStr = "";
        String filledStr = "";
        String imageFileNameStr = "";
        String markStr = "[]";
        if (addRepr.equals("[NODE]") || addRepr.equals("[EDGE]")) {
            markStr = addRepr.toString();
            addRepr = "";
        }
        String[] test = addRepr.split(":");
        int i = 0;
        while (i < test.length) {
            String testStr = test[i];
            if (testStr.indexOf("RECT") != -1 || testStr.indexOf("ROUND") != -1 || testStr.indexOf("CIRCLE") != -1 || testStr.indexOf("OVAL") != -1 || testStr.indexOf("IMAGE") != -1 || testStr.indexOf("SOLID_LINE") != -1 || testStr.indexOf("DASH_LINE") != -1 || testStr.indexOf("DOT_LINE") != -1) {
                shapeStr = testStr;
            } else if (testStr.indexOf("Color") != -1) {
                colorStr = testStr;
            } else if (testStr.indexOf("FILLED") != -1 || testStr.indexOf("BOLD") != -1) {
                filledStr = testStr;
            } else if (testStr.indexOf(".jpg") != -1 || testStr.indexOf(".gif") != -1 || testStr.indexOf(".xpm") != -1) {
                imageFileNameStr = testStr;
            } else if (testStr.indexOf("[NODE]") != -1 || testStr.indexOf("[EDGE]") != -1) {
                markStr = testStr;
            }
            ++i;
        }
        if (shapeStr.equals("")) {
            if (markStr.equals("[NODE]")) {
                shapeStr = "RECT";
            } else if (markStr.equals("[EDGE]")) {
                shapeStr = "SOLID_LINE";
            }
        }
        if (colorStr.equals("")) {
            colorStr = "java.awt.Color[r=0,g=0,b=0]";
        }
        imageFileNameStr = baseType.getImageFilename();
        v.add(shapeStr);
        v.add(colorStr);
        v.add(filledStr);
        v.add(imageFileNameStr);
        v.add(markStr);
        return v;
    }

    public void setNodeIconable(boolean iconableNode) {
        this.iconable = iconableNode;
        int i = 0;
        while (i < this.nodeTypes.size()) {
            EdType t = this.nodeTypes.elementAt(i);
            t.setIconable(iconableNode);
            ++i;
        }
    }

    public void setResourcesPath(String path) {
        this.resourcesPath = path;
        int i = 0;
        while (i < this.nodeTypes.size()) {
            EdType t = this.nodeTypes.elementAt(i);
            t.setResourcesPath(this.resourcesPath);
            ++i;
        }
    }

    public synchronized void addTypeEventListener(TypeEventListener l) {
        if (!this.typeEventListeners.contains(l)) {
            this.typeEventListeners.addElement(l);
        }
    }

    public synchronized void removeTypeEventListener(TypeEventListener l) {
        if (this.typeEventListeners.contains(l)) {
            this.typeEventListeners.removeElement(l);
        }
    }

    public void fireTypeChangedEvent() {
        this.fireTypeEvent(new TypeEvent(this, 3));
    }

    private void fireTypeEvent(TypeEvent e) {
        if (this.typeEventListeners != null) {
            Vector<TypeEventListener> listeners = this.typeEventListeners;
            int i = 0;
            while (i < listeners.size()) {
                listeners.elementAt(i).typeEventOccurred(e);
                ++i;
            }
        }
    }

    public void setAttrTypeChanged(Type t, boolean b) {
        this.getType(t).setAttrTypeChanged(b);
        Vector<Type> list = t.getChildren();
        int i = 0;
        while (i < list.size()) {
            Type ch = (Type)list.get(i);
            this.getType(ch).setAttrTypeChanged(b);
            ++i;
        }
    }

    public void addTypeUser(EdType t, EdGraphObject go) {
        if (t.isNodeType()) {
            this.addTypeUserToTypeContainer(t, go, this.nodeTypeUsers);
            if (!go.isElementOfTypeGraph()) {
                this.addTypeUserToTypeGraphNodeContainer(t, go, this.typeGraphNodeUsers);
            }
        } else if (t.isArcType()) {
            this.addTypeUserToTypeContainer(t, go, this.arcTypeUsers);
            if (!go.isElementOfTypeGraph()) {
                this.addTypeUserToTypeGraphArcContainer(t, go, this.typeGraphArcUsers);
            }
        }
    }

    private void addTypeUserToTypeContainer(EdType t, EdGraphObject go, Hashtable<EdType, List<EdGraphObject>> container) {
        List<EdGraphObject> list = container.get(t);
        if (list == null) {
            list = new Vector<EdGraphObject>();
            container.put(t, list);
        }
        list.add(go);
    }

    private void addTypeUserToTypeGraphNodeContainer(EdType t, EdGraphObject go, Hashtable<EdType, List<EdGraphObject>> container) {
        if (t.getBasisType().getTypeGraphNode() != null) {
            List<EdGraphObject> list = container.get(t);
            if (list == null) {
                list = new Vector<EdGraphObject>();
                container.put(t, list);
            }
            list.add(go);
        }
    }

    private void addTypeUserToTypeGraphArcContainer(EdType t, EdGraphObject go, Hashtable<EdType, Hashtable<TypeGraphArc, List<EdGraphObject>>> container) {
        TypeGraphArc tga = this.getTypeGraphArc(t.getBasisType(), ((Arc)go.getBasisObject()).getSourceType(), ((Arc)go.getBasisObject()).getTargetType());
        if (tga != null) {
            List<EdGraphObject> list;
            Hashtable<TypeGraphArc, List<EdGraphObject>> tCntnr = container.get(t);
            if (tCntnr == null) {
                tCntnr = new Hashtable();
                container.put(t, tCntnr);
            }
            if ((list = tCntnr.get(tga)) == null) {
                list = new Vector<EdGraphObject>();
                tCntnr.put(tga, list);
            }
            list.add(go);
        }
    }

    private TypeGraphArc getTypeGraphArc(Type t, Type src, Type tar) {
        Arc typeArc;
        if (this.bTypeSet.getTypeGraph() != null && (typeArc = ((TypeGraph)this.bTypeSet.getTypeGraph()).getTypeGraphArc(t, src, tar)) != null) {
            return t.getTypeGraphArc(typeArc.getSourceType(), typeArc.getTargetType());
        }
        return null;
    }

    public void removeTypeUser(EdType t, EdGraphObject go) {
        if (t.isNodeType()) {
            this.removeTypeUserFromTypeContainer(t, go, this.nodeTypeUsers);
            this.removeTypeUserFromTypeGraphNodeContainer(t, go, this.typeGraphNodeUsers);
        } else if (t.isArcType()) {
            this.removeTypeUserFromTypeContainer(t, go, this.arcTypeUsers);
            this.removeTypeUserFromTypeGraphArcContainer(t, go, this.typeGraphArcUsers);
        }
    }

    public void removeArcTypeUser(EdType t, EdGraphObject go, EdType nType) {
        if (t.isArcType()) {
            this.removeTypeUserFromTypeContainer(t, go, this.arcTypeUsers);
            this.removeTypeUserFromTypeGraphArcContainer(t, go, this.typeGraphArcUsers, nType);
        }
    }

    private void removeTypeUserFromTypeContainer(EdType t, EdGraphObject go, Hashtable<EdType, List<EdGraphObject>> container) {
        List<EdGraphObject> list = container.get(t);
        if (list != null) {
            list.remove(go);
            if (list.isEmpty()) {
                container.remove(t);
            }
        }
    }

    private void removeTypeUserFromTypeGraphNodeContainer(EdType t, EdGraphObject go, Hashtable<EdType, List<EdGraphObject>> container) {
        List<EdGraphObject> list;
        if (t.getBasisType().getTypeGraphNode() != null && (list = container.get(t)) != null) {
            list.remove(go);
            if (list.isEmpty()) {
                container.remove(t);
            }
        }
    }

    private void removeTypeUserFromTypeGraphArcContainer(EdType t, EdGraphObject go, Hashtable<EdType, Hashtable<TypeGraphArc, List<EdGraphObject>>> container) {
        List<EdGraphObject> list;
        Hashtable<TypeGraphArc, List<EdGraphObject>> tCntnr;
        TypeGraphArc tga;
        if (this.edTypeGraph != null && (tga = this.getTypeGraphArc(t.getBasisType(), ((EdArc)go).getSource().getBasisObject().getType(), ((EdArc)go).getTarget().getBasisObject().getType())) != null && (tCntnr = container.get(t)) != null && (list = tCntnr.get(tga)) != null) {
            list.remove(go);
            if (list.isEmpty()) {
                tCntnr.remove(tga);
            }
        }
    }

    private void removeTypeUserFromTypeGraphArcContainer(EdType t, EdGraphObject go, Hashtable<EdType, Hashtable<TypeGraphArc, List<EdGraphObject>>> container, EdType nType) {
        List<EdGraphObject> list;
        Hashtable<TypeGraphArc, List<EdGraphObject>> tCntnr;
        TypeGraphArc tga;
        Type tarT;
        Type srcT = ((EdArc)go).getSource().getBasisObject() == null || ((EdArc)go).getSource().getBasisObject().getType() == null ? nType.getBasisType() : ((EdArc)go).getSource().getBasisObject().getType();
        Type type = tarT = ((EdArc)go).getTarget().getBasisObject() == null || ((EdArc)go).getTarget().getBasisObject().getType() == null ? nType.getBasisType() : ((EdArc)go).getTarget().getBasisObject().getType();
        if (this.edTypeGraph != null && (tga = this.getTypeGraphArc(t.getBasisType(), srcT, tarT)) != null && (tCntnr = container.get(t)) != null && (list = tCntnr.get(tga)) != null) {
            list.remove(go);
            if (list.isEmpty()) {
                tCntnr.remove(tga);
            }
        }
    }

    public boolean hasTypeUser(EdType t) {
        if (t.isNodeType()) {
            return this.nodeTypeUsers.get(t) != null && !this.nodeTypeUsers.get(t).isEmpty();
        }
        if (t.isArcType()) {
            return this.arcTypeUsers.get(t) != null && !this.arcTypeUsers.get(t).isEmpty();
        }
        return false;
    }

    public List<EdGraphObject> getTypeUsers(EdType t) {
        List<EdGraphObject> list = new Vector<EdGraphObject>();
        if (t.isNodeType() && this.nodeTypeUsers.get(t) != null) {
            list = this.nodeTypeUsers.get(t);
        } else if (t.isArcType() && this.arcTypeUsers.get(t) != null) {
            list = this.arcTypeUsers.get(t);
        }
        return list;
    }

    public Vector<Type> getTypeOfInheritedArcsInUse(Type childType, Type parentType) {
        Vector<Type> result = new Vector<Type>();
        Vector<Arc> inhArcs = this.bTypeSet.getInheritedArcs(parentType);
        int i = 0;
        while (i < inhArcs.size()) {
            Type arcType = inhArcs.get(i).getType();
            EdType t = this.getArcType(arcType);
            List<EdGraphObject> users = this.arcTypeUsers.get(t);
            int j = 0;
            while (j < users.size()) {
                EdGraphObject go = users.get(j);
                if (((Arc)go.getBasisObject()).getSourceType().compareTo(childType) && !result.contains(arcType)) {
                    result.add(arcType);
                }
                ++j;
            }
            ++i;
        }
        return result;
    }

    public Vector<EdArc> getTypeArcOfInheritedArcsInUse(Type childType, Type parentType) {
        Vector<EdArc> result = new Vector<EdArc>();
        Vector<Arc> inhArcs = this.bTypeSet.getInheritedArcs(parentType);
        int i = 0;
        while (i < inhArcs.size()) {
            Type arcType = inhArcs.get(i).getType();
            EdType t = this.getArcType(arcType);
            List<EdGraphObject> users = this.arcTypeUsers.get(t);
            int j = 0;
            while (j < users.size()) {
                EdGraphObject go = users.get(j);
                if (((Arc)go.getBasisObject()).getSourceType().compareTo(childType) && !result.contains(arcType)) {
                    result.add((EdArc)go);
                }
                ++j;
            }
            ++i;
        }
        return result;
    }

    public boolean isTypeUsed(EdType t) {
        if (this.hasTypeUser(t)) {
            return true;
        }
        return this.isChildTypeUsed(t);
    }

    private boolean isChildTypeUsed(EdType t) {
        Vector<Type> allChildren = t.getBasisType().getAllChildren();
        if (!allChildren.isEmpty()) {
            int i = 1;
            while (i < allChildren.size()) {
                Type ch = allChildren.get(i);
                if (this.hasTypeUser(this.getType(ch))) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public boolean isTypeGraphNodeUsed(EdType t) {
        List<EdGraphObject> list;
        if (t.isNodeType() && t.getBasisType().getTypeGraphNode() != null && (list = this.typeGraphNodeUsers.get(t.getBasisType().getTypeGraphNode())) != null && !list.isEmpty()) {
            return list.size() != 1 || !list.get(0).isElementOfTypeGraph();
        }
        return false;
    }

    public boolean isChildTypeGraphNodeUsed(EdType t) {
        Vector<Type> allChildren = t.getBasisType().getAllChildren();
        if (!allChildren.isEmpty()) {
            int i = 1;
            while (i < allChildren.size()) {
                Type ch = allChildren.get(i);
                EdType et = this.getNodeTypeByBasis(ch);
                if (et != null && this.isTypeGraphNodeUsed(et)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public boolean isTypeGraphArcUsed(EdType t, EdType src, EdType tar) {
        List<EdGraphObject> list;
        Hashtable<TypeGraphArc, List<EdGraphObject>> tCntnr;
        TypeGraphArc tga;
        if (t.isArcType() && this.edTypeGraph != null && (tga = this.getTypeGraphArc(t.getBasisType(), src.getBasisType(), tar.getBasisType())) != null && (tCntnr = this.typeGraphArcUsers.get(t)) != null && (list = tCntnr.get(tga)) != null && !list.isEmpty()) {
            return list.size() != 1 || !list.get(0).isElementOfTypeGraph();
        }
        return false;
    }

    public boolean isClanUsed(Type t) {
        boolean used = false;
        List<Type> clan = this.bTypeSet.getClan(t);
        int i = 0;
        while (i < clan.size() && !used) {
            Type ch = clan.get(i);
            EdType et = this.getNodeTypeByBasis(ch);
            if (et != null && this.isTypeGraphNodeUsed(et)) {
                used = true;
            }
            ++i;
        }
        return used;
    }

    public boolean isArcDirected() {
        return this.bTypeSet.isArcDirected();
    }

    public boolean isArcParallel() {
        return this.bTypeSet.isArcParallel();
    }

    private void removeNodeTypeUsers(EdType t) {
        if (this.nodeTypeUsers.get(t) != null) {
            this.nodeTypeUsers.get(t).clear();
            this.nodeTypeUsers.remove(t);
        }
        if (this.typeGraphNodeUsers.get(t) != null) {
            this.typeGraphNodeUsers.get(t).clear();
            this.typeGraphNodeUsers.remove(t);
        }
    }

    private void removeArcTypeUsers(EdType t) {
        if (this.arcTypeUsers.get(t) != null) {
            this.arcTypeUsers.get(t).clear();
            this.arcTypeUsers.remove(t);
        }
        if (this.typeGraphArcUsers.get(t) != null) {
            Iterator<List<EdGraphObject>> iter = this.typeGraphArcUsers.get(t).values().iterator();
            while (iter.hasNext()) {
                iter.next().clear();
            }
            this.typeGraphArcUsers.remove(t);
        }
    }
}

