/*
 * Decompiled with CFR 0.152.
 */
package agg.gui.treeview.nodedata;

import agg.editor.impl.EdGraph;
import agg.gui.treeview.nodedata.GraGraTreeNodeDataAdapter;
import javax.swing.tree.DefaultMutableTreeNode;

public class TypeGraphTreeNodeData
extends GraGraTreeNodeDataAdapter {
    private Object data;
    private EdGraph eGraph;
    private String string = "";
    private DefaultMutableTreeNode treeNode;

    public TypeGraphTreeNodeData(EdGraph typegraph) {
        this.setTypeGraph(typegraph);
    }

    public TypeGraphTreeNodeData(String s) {
        this.data = s;
        this.string = s;
    }

    public TypeGraphTreeNodeData(Object obj) {
        if (obj instanceof EdGraph) {
            this.setTypeGraph((EdGraph)obj);
        } else if (obj instanceof String) {
            new TypeGraphTreeNodeData((String)obj);
        }
    }

    @Override
    public void dispose() {
        this.eGraph = null;
        this.data = null;
        this.treeNode = null;
    }

    private void setTypeGraph(EdGraph graph) {
        if (graph.getBasisGraph().isTypeGraph()) {
            this.data = graph;
            this.string = graph.getBasisGraph().getName();
            this.eGraph = graph;
        }
    }

    @Override
    public void setData(Object obj) {
        if (obj instanceof EdGraph) {
            this.setTypeGraph((EdGraph)obj);
        } else if (obj instanceof String) {
            this.string = (String)obj;
            this.data = obj;
            this.eGraph = null;
        } else {
            this.eGraph = null;
            this.string = null;
            this.data = null;
        }
    }

    @Override
    public Object getData() {
        return this.data;
    }

    @Override
    public void setString(String str) {
        String newString;
        if (str == null) {
            return;
        }
        this.string = newString = str.replaceAll(" ", "");
        String s = newString;
        String mode = "";
        if (newString.length() >= 3 && newString.substring(0, 3).equals("[D]")) {
            s = newString.substring(newString.indexOf("]") + 1, newString.length());
        } else if (newString.length() >= 3 && newString.substring(0, 3).equals("[E]")) {
            s = newString.substring(newString.indexOf("]") + 1, newString.length());
        } else if (newString.length() >= 4 && newString.substring(0, 4).equals("[Em]")) {
            s = newString.substring(newString.indexOf("]") + 1, newString.length());
        } else if (newString.length() >= 5) {
            if (newString.substring(0, 5).equals("[Emm]")) {
                s = newString.substring(newString.indexOf("]") + 1, newString.length());
            } else if (newString.substring(0, 5).equals("[Inh]")) {
                s = newString.substring(newString.indexOf("]") + 1, newString.length());
            }
        } else {
            switch (this.eGraph.getGraGra().getBasisGraGra().getTypeSet().getLevelOfTypeGraphCheck()) {
                case 0: {
                    mode = "[D]";
                    break;
                }
                case 5: {
                    mode = "[Inh]";
                    break;
                }
                case 10: {
                    mode = "[E]";
                    break;
                }
                case 20: {
                    mode = "[Em]";
                    break;
                }
                case 30: {
                    mode = "[Emm]";
                    break;
                }
                default: {
                    mode = "[D]";
                }
            }
        }
        this.string = String.valueOf(mode) + newString + "    ";
        if (!this.eGraph.getBasisGraph().getName().equals(s)) {
            this.eGraph.getBasisGraph().setName(s);
            this.eGraph.getGraGra().setChanged(true);
        }
    }

    @Override
    public String string() {
        return this.string;
    }

    @Override
    public String toString() {
        return this.string;
    }

    @Override
    public EdGraph getGraph() {
        return this.eGraph;
    }

    @Override
    public void setTreeNode(DefaultMutableTreeNode node) {
        this.treeNode = node;
    }

    @Override
    public DefaultMutableTreeNode getTreeNode() {
        return this.treeNode;
    }

    @Override
    public boolean isGraph() {
        return true;
    }

    @Override
    public boolean isTypeGraph() {
        return true;
    }

    @Override
    public String getToolTipText() {
        String toolTipText = " Type graph with node and edge types ";
        if (!this.eGraph.getBasisGraph().getTextualComment().equals("")) {
            toolTipText = " " + this.eGraph.getBasisGraph().getTextualComment();
        }
        return toolTipText;
    }
}

