/*
 * Decompiled with CFR 0.152.
 */
package agg.parser;

import agg.parser.AbstractParser;
import agg.parser.ParserErrorEvent;
import agg.parser.ParserMessageEvent;
import agg.parser.RuleInstances;
import agg.util.Pair;
import agg.xt_basis.BaseFactory;
import agg.xt_basis.GraGra;
import agg.xt_basis.Graph;
import agg.xt_basis.Match;
import agg.xt_basis.MorphCompletionStrategy;
import agg.xt_basis.OrdinaryMorphism;
import java.util.EmptyStackException;
import java.util.Stack;

public class SimpleParser
extends AbstractParser
implements Runnable {
    protected boolean stop = false;
    protected boolean correct;

    public SimpleParser(GraGra grammar, Graph hostGraph, Graph stopGraph) {
        super(grammar, hostGraph, stopGraph, null);
    }

    @Override
    public void run() {
        this.fireParserEvent(new ParserMessageEvent(this, "Starting parser. Please wait ..."));
        this.parse();
        if (this.stop) {
            this.fireParserEvent(new ParserMessageEvent(this, "Stopping parser."));
        } else {
            this.fireParserEvent(new ParserMessageEvent(this, "Finishing parser. Result is " + this.correct + "."));
        }
    }

    public void stop() {
        this.stop = true;
    }

    public boolean wasStopped() {
        return this.stop;
    }

    @Override
    public boolean parse() {
        Stack<Pair<Graph, RuleInstances>> stack = new Stack<Pair<Graph, RuleInstances>>();
        this.correct = true;
        RuleInstances eri = new RuleInstances();
        this.fireParserEvent(new ParserMessageEvent(this, "Starting simple parser ..."));
        boolean ruleApplied = false;
        while (!this.stop && !this.getHostGraph().isIsomorphicTo(this.stopGraph) && this.correct) {
            this.fireParserEvent(new ParserMessageEvent(this, "Searching for match!"));
            Match m = this.findMatch(this.getHostGraph(), this.grammar.getRuleIterator(), eri);
            if (m != null) {
                ruleApplied = false;
                OrdinaryMorphism copyMorph = this.getHostGraph().isomorphicCopy();
                if (copyMorph != null) {
                    this.fireParserEvent(new ParserMessageEvent(copyMorph, "IsoCopy"));
                    eri.add(m);
                    Pair<Graph, RuleInstances> tmpPair = new Pair<Graph, RuleInstances>(this.getHostGraph(), eri);
                    stack.push(tmpPair);
                    eri = new RuleInstances();
                    this.setHostGraph(copyMorph.getImage());
                    OrdinaryMorphism tmpMorph = m.compose(copyMorph);
                    Match n = tmpMorph.makeMatch(m.getRule());
                    n.setCompletionStrategy((MorphCompletionStrategy)this.grammar.getMorphismCompletionStrategy().clone(), true);
                    boolean found = true;
                    while (!n.isValid() && found) {
                        if (n.nextCompletion()) continue;
                        found = false;
                    }
                    if (found && this.applyRule(n)) {
                        ruleApplied = true;
                        try {
                            Thread.sleep(this.delay);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            }
            if (m != null && ruleApplied) continue;
            try {
                Pair tmpPair = (Pair)stack.pop();
                this.setHostGraph((Graph)tmpPair.first);
                eri = (RuleInstances)tmpPair.second;
            }
            catch (EmptyStackException ioe) {
                this.fireParserEvent(new ParserErrorEvent(this, "ERROR: This graph is not part of the language"));
                this.correct = false;
            }
        }
        while (!stack.empty()) {
            try {
                this.fireParserEvent(new ParserMessageEvent(this, "Cleaning stack."));
                Pair tmpPair = (Pair)stack.pop();
                Graph g = (Graph)tmpPair.first;
                BaseFactory.theFactory().destroyGraph(g);
                ((RuleInstances)tmpPair.second).finalize();
            }
            catch (EmptyStackException emptyStackException) {
                // empty catch block
            }
        }
        this.fireParserEvent(new ParserMessageEvent(this, "Stopping parser. Result is " + this.correct + "."));
        return this.correct;
    }
}

