/*
 * Decompiled with CFR 0.152.
 */
package agg.ruleappl;

import agg.parser.CriticalPairOption;
import agg.ruleappl.ApplicabilityChecker;
import agg.ruleappl.MatchSequence;
import agg.ruleappl.ObjectFlow;
import agg.util.Pair;
import agg.util.Triple;
import agg.util.XMLHelper;
import agg.xt_basis.Arc;
import agg.xt_basis.ConcurrentRule;
import agg.xt_basis.GraGra;
import agg.xt_basis.GraTraEvent;
import agg.xt_basis.GraTraEventListener;
import agg.xt_basis.Graph;
import agg.xt_basis.GraphObject;
import agg.xt_basis.Match;
import agg.xt_basis.Node;
import agg.xt_basis.OrdinaryMorphism;
import agg.xt_basis.Rule;
import agg.xt_basis.agt.KernelRule;
import agg.xt_basis.agt.RuleScheme;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class RuleSequence
implements GraTraEventListener {
    public static final int OBJECT_FLOW_TRANSITIVE_CLOSURE_FAILED = 0;
    public static final int OBJECT_FLOW_PERSISTENT_FAILED = 1;
    public static final String TRAFO_BY_OBJECT_FLOW = "trafoByOF";
    public static final String TRAFO_BY_ARS = "trafoByARS";
    private static final String TRAFO_BY_IN_OUT_PARAM = "trafoByIOP";
    private String name = "RuleSequence";
    private GraGra gragra;
    private CriticalPairOption cpOption;
    private Graph graph;
    private List<Pair<List<Pair<String, String>>, String>> subSequenceList = new Vector<Pair<List<Pair<String, String>>, String>>();
    private final Vector<Rule> rules = new Vector();
    private final Vector<String> ruleNames = new Vector();
    private final Pair<Boolean, String> applResult = new Pair<Boolean, String>(new Boolean(false), "undefined");
    private final Pair<Boolean, String> nonapplResult = new Pair<Boolean, String>(new Boolean(false), "undefined");
    private final Hashtable<String, Pair<Boolean, List<String>>> ruleResults = new Hashtable();
    private final ApplicabilityChecker checker;
    protected boolean checked;
    protected boolean checkAtGraph;
    private final Map<String, List<List<ConcurrentRule>>> concurrentRules = new Hashtable<String, List<List<ConcurrentRule>>>();
    protected final Hashtable<String, ObjectFlow> objectFlow;
    private boolean enabledObjectFlow;
    private boolean completeNodesOF;
    private int objectFlowError = -1;
    private boolean trafoByOF;
    private boolean trafoByARS;
    private int startIndx;
    private boolean usePreviousSequenceResults = true;
    protected MatchSequence matchSequence;

    public RuleSequence(GraGra gra, String name) {
        this.gragra = gra;
        this.name = name;
        this.checker = new ApplicabilityChecker(this, this.gragra);
        this.enabledObjectFlow = true;
        this.usePreviousSequenceResults = true;
        this.checkAtGraph = true;
        if (this.gragra != null) {
            this.graph = this.gragra.getGraph();
        }
        this.subSequenceList = new Vector<Pair<List<Pair<String, String>>, String>>();
        this.objectFlow = new Hashtable();
        this.matchSequence = new MatchSequence(this);
        this.matchSequence.setObjectFlow(this.objectFlow);
        this.completeNodesOF = false;
    }

    public RuleSequence(GraGra gra, String name, CriticalPairOption option) {
        this(gra, name);
        this.cpOption = option;
    }

    public RuleSequence(GraGra gra, String name, CriticalPairOption option, List<Pair<List<Pair<String, String>>, String>> ruleSubSequenceList) {
        this(gra, name, option);
        this.makeFlatSequence();
    }

    public RuleSequence(GraGra gra, String name, List<Pair<List<Pair<String, String>>, String>> ruleSubSequenceList) {
        this(gra, name);
        this.makeFlatSequence();
    }

    public boolean isObjFlowDefined() {
        return !this.objectFlow.isEmpty();
    }

    public Hashtable<String, ObjectFlow> getObjectFlow() {
        return this.objectFlow;
    }

    public void setCriticalPairOption(CriticalPairOption option) {
        this.cpOption = option;
        this.checker.setCriticalPairOption(option);
    }

    public CriticalPairOption getCriticalPairOption() {
        return this.cpOption;
    }

    public void setName(String aName) {
        this.name = aName;
    }

    public String getName() {
        return this.name;
    }

    public void refresh() {
        this.clear();
        this.makeFlatSequence();
    }

    public List<Pair<List<Pair<String, String>>, String>> getSubSequenceList() {
        return this.subSequenceList;
    }

    public void setSubsequenceList(List<Pair<List<Pair<String, String>>, String>> list) {
        this.subSequenceList = list;
    }

    private void copySubsequenceList(List<Pair<List<Pair<String, String>>, String>> list) {
        this.subSequenceList.clear();
        int i = 0;
        while (i < list.size()) {
            Pair<List<Pair<String, String>>, String> pseg = list.get(i);
            Vector<Pair<String, String>> sublist = new Vector<Pair<String, String>>();
            int j = 0;
            while (j < ((List)pseg.first).size()) {
                Pair pRule = (Pair)((List)pseg.first).get(j);
                sublist.add(new Pair<String, String>((String)pRule.first, (String)pRule.second));
                ++j;
            }
            this.subSequenceList.add(new Pair(sublist, (String)pseg.second));
            ++i;
        }
    }

    public void makeFlatSequence() {
        this.rules.clear();
        this.ruleNames.clear();
        int i = 0;
        while (i < this.subSequenceList.size()) {
            Pair<List<Pair<String, String>>, String> pseg = this.subSequenceList.get(i);
            int seqIters = 2;
            if (!((String)pseg.second).equals("*")) {
                seqIters = Integer.valueOf((String)pseg.second);
            }
            List rList = (List)pseg.first;
            int its = 0;
            while (its < seqIters) {
                int j = 0;
                while (j < rList.size()) {
                    Rule r;
                    Pair pRule = (Pair)rList.get(j);
                    int rIters = 2;
                    if (!((String)pRule.second).equals("*")) {
                        rIters = Integer.valueOf((String)pRule.second);
                    }
                    if ((r = this.gragra.getRuleByQualifiedName((String)pRule.first)) != null) {
                        if (r instanceof RuleScheme) {
                            r = ((RuleScheme)r).getKernelRule();
                        }
                        int itr = 0;
                        while (itr < rIters) {
                            if (r.getRuleScheme() != null && r instanceof KernelRule) {
                                this.rules.add(r.getRuleScheme());
                                this.ruleNames.add(String.valueOf(r.getRuleScheme().getName()) + "." + r.getName());
                            } else {
                                this.rules.add(r);
                                this.ruleNames.add(r.getName());
                            }
                            ++itr;
                        }
                    }
                    ++j;
                }
                ++its;
            }
            ++i;
        }
    }

    public void dispose() {
        this.clear();
        this.gragra = null;
        this.cpOption = null;
    }

    public ApplicabilityChecker getApplicabilityChecker() {
        return this.checker;
    }

    protected Map<String, List<List<ConcurrentRule>>> getConcurrentRulesContainer() {
        return this.concurrentRules;
    }

    protected List<List<ConcurrentRule>> getListsOfConcurrentRules(Rule r, int indx) {
        String key = String.valueOf(r.hashCode()).concat(":").concat(String.valueOf(indx));
        return this.concurrentRules.get(key);
    }

    protected void putListsOfConcurrentRules(Rule r, int indx, List<List<ConcurrentRule>> lists) {
        String key = String.valueOf(r.hashCode()).concat(":").concat(String.valueOf(indx));
        this.concurrentRules.put(key, lists);
    }

    public List<ConcurrentRule> getApplicableConcurrentRules() {
        return this.checker.getApplicableConcurrentRules();
    }

    public Iterator<List<List<ConcurrentRule>>> getConcurrentRules() {
        return this.concurrentRules.values().iterator();
    }

    public void reinit() {
        this.clearResult();
        int i = 0;
        while (i < this.rules.size()) {
            Rule r = this.rules.get(i);
            if (r.getMatch() != null) {
                r.getMatch().dispose();
                r.setMatch(null);
            }
            ++i;
        }
        this.matchSequence.reinit(this);
        this.removeEmptyObjFlow();
    }

    public void clear() {
        this.matchSequence.clear();
        this.objectFlow.clear();
        this.rules.clear();
        this.ruleNames.clear();
        this.clearResult();
    }

    public void clearObjFlow() {
        this.objectFlow.clear();
    }

    public void clearResult() {
        this.concurrentRules.clear();
        this.clearApplResult();
        this.clearNonApplResult();
        this.ruleResults.clear();
    }

    private void clearApplResult() {
        this.applResult.first = new Boolean(false);
        this.applResult.second = "undefined";
        this.checked = false;
    }

    private void clearNonApplResult() {
        this.nonapplResult.first = new Boolean(false);
        this.nonapplResult.second = "undefined";
        this.checked = false;
    }

    public GraGra getGraGra() {
        return this.gragra;
    }

    public void setCheckAtGraph(boolean b) {
        this.checkAtGraph = b;
    }

    public boolean doesCheckAtGraph() {
        return this.checkAtGraph;
    }

    public void setGraph(Graph g) {
        this.removeObjFlowOfGraph();
        this.clearResult();
        this.graph = g;
    }

    public Graph getGraph() {
        return this.graph;
    }

    public void setTrafoByObjFlow(boolean b) {
        this.trafoByOF = b;
    }

    public boolean isTrafoByObjFlow() {
        return this.trafoByOF;
    }

    public void setTrafoByARS(boolean b) {
        this.trafoByARS = b;
    }

    public boolean isTrafoByARS() {
        return this.trafoByARS;
    }

    public void setUsePreviousSequenceResults(boolean b) {
        this.usePreviousSequenceResults = b;
    }

    public boolean makeUseOfPreviousSequenceResults() {
        return this.usePreviousSequenceResults;
    }

    public void setStartIndexOfCheck(int indx) {
        this.startIndx = indx;
    }

    public int getStartIndexOfCheck() {
        return this.startIndx;
    }

    public Rule getStartRule() {
        if (!this.rules.isEmpty()) {
            if (this.startIndx >= 0 && this.startIndx < this.rules.size()) {
                return this.rules.get(this.startIndx);
            }
            return this.rules.get(0);
        }
        return null;
    }

    public void enableObjFlow(boolean b) {
        this.enabledObjectFlow = b;
    }

    public boolean isObjFlowEnabled() {
        return this.enabledObjectFlow;
    }

    public void enableCompleteObjFlowOfNodes(boolean b) {
        this.completeNodesOF = b;
    }

    public boolean isCompleteObjFlowOfNodesEnabled() {
        return this.completeNodesOF;
    }

    public boolean isObjFlowActive() {
        return this.enabledObjectFlow && !this.objectFlow.isEmpty();
    }

    public boolean isGraphUsedInObjFlow() {
        Enumeration<String> keys = this.objectFlow.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            String[] keyItems = key.split(":");
            if (!keyItems[0].equals("0")) continue;
            return true;
        }
        return false;
    }

    public boolean containsRuleLoop() {
        int i = 0;
        while (i < this.subSequenceList.size()) {
            Pair<List<Pair<String, String>>, String> pseg = this.subSequenceList.get(i);
            int j = 0;
            while (j < ((List)pseg.first).size()) {
                Pair pRule = (Pair)((List)pseg.first).get(j);
                if ("*".equals(pRule.second)) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    public boolean containsOneRuleIterationOnly() {
        boolean result = !this.isEmpty();
        int i = 0;
        while (i < this.subSequenceList.size()) {
            Pair<List<Pair<String, String>>, String> pseg = this.subSequenceList.get(i);
            int j = 0;
            while (j < ((List)pseg.first).size()) {
                Pair pRule = (Pair)((List)pseg.first).get(j);
                if (!"1".equals(pRule.second)) {
                    result = false;
                }
                ++j;
            }
            ++i;
        }
        return result;
    }

    public boolean hasOneSubsequence() {
        return this.subSequenceList.size() == 1;
    }

    public boolean containsRuleScheme() {
        int i = 0;
        while (i < this.rules.size()) {
            Rule r = this.rules.get(i);
            if (r.getRuleScheme() != null) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void addRule(Rule r) {
        this.rules.add(r);
        this.ruleNames.add(r.getName());
        if (this.subSequenceList.isEmpty()) {
            Vector l = new Vector();
            Pair p = new Pair(l, "1");
            this.subSequenceList.add(p);
        }
        ((List)this.subSequenceList.get((int)0).first).add(new Pair<String, String>(r.getName(), "1"));
    }

    public boolean addRule(String rname) {
        if (this.gragra.getRule(rname) != null) {
            Rule r0;
            Rule r = this.gragra.getRule(rname);
            if (this.gragra.isLayered() && !this.rules.isEmpty() && (r0 = this.rules.get(0)).getLayer() != r.getLayer()) {
                return false;
            }
            this.addRule(this.gragra.getRule(rname));
            return true;
        }
        return false;
    }

    public void setRules(List<String> sequence) {
        this.clear();
        this.makeRules(sequence);
    }

    public void setRules(Iterator<Rule> sequence) {
        this.clear();
        this.makeRules(sequence);
    }

    public Rule getRule(int indx) {
        if (indx >= 0 && indx < this.rules.size()) {
            return this.rules.get(indx);
        }
        return null;
    }

    public Rule getRule(String rname) {
        int i = 0;
        while (i < this.rules.size()) {
            Rule r = this.rules.get(i);
            if (r.getName().equals(rname)) {
                return r;
            }
            ++i;
        }
        return null;
    }

    public int getIndexOf(Rule r) {
        return this.rules.indexOf(r);
    }

    public List<Rule> getRules() {
        return this.rules;
    }

    public void resetRuleNames(List<String> rnames) {
        this.ruleNames.clear();
        this.ruleNames.addAll(rnames);
        this.resetRules();
    }

    private void resetRules() {
        Vector<Rule> v = new Vector<Rule>(this.rules);
        this.rules.clear();
        int i = 0;
        while (i < this.ruleNames.size()) {
            String rn = this.ruleNames.get(i);
            int j = 0;
            while (j < v.size()) {
                Rule r = v.get(j);
                if (r.getQualifiedName().equals(rn)) {
                    this.rules.add(r);
                    break;
                }
                ++j;
            }
            ++i;
        }
    }

    public List<String> getRuleNames() {
        return new Vector<String>(this.ruleNames);
    }

    public int getSize() {
        return this.rules.size();
    }

    public boolean isEmpty() {
        return this.rules.isEmpty();
    }

    public boolean isValid() {
        boolean ok = true;
        int i = 0;
        while (i < this.rules.size() && ok) {
            Rule r = this.rules.get(i);
            boolean found = false;
            Enumeration<Rule> en = this.gragra.getRules();
            while (en.hasMoreElements() && !found) {
                Rule ru = en.nextElement();
                if (r == ru) {
                    found = true;
                    continue;
                }
                if (ru.getRuleScheme() == null || ru.getRuleScheme().getKernelRule() != r) continue;
                found = true;
            }
            ok = found;
            ++i;
        }
        return ok;
    }

    public boolean containsRuleWithGACs() {
        int i = 0;
        while (i < this.rules.size()) {
            if (this.rules.get(i).hasEnabledACs(true)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String getText() {
        String text = "";
        if (this.graph == null) {
            text = this.getRuleNamesString();
        } else {
            text = text.concat(this.graph.getName());
            text = text.concat(" <= ");
            text = text.concat(this.getRuleNamesString());
        }
        return text;
    }

    public String getToolTipText() {
        String text = "";
        int i = 0;
        while (i < this.subSequenceList.size()) {
            Pair<List<Pair<String, String>>, String> g = this.subSequenceList.get(i);
            String grpStr = "";
            List grpRules = (List)g.first;
            long grpIters = -1L;
            String grpItersStr = (String)g.second;
            if (grpItersStr.equals("*")) {
                grpStr = grpStr.concat("( ");
            } else {
                try {
                    grpIters = new Long((String)g.second);
                    if (grpRules.size() > 1 || grpIters > 1L) {
                        grpStr = grpStr.concat("( ");
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            int j = 0;
            while (j < grpRules.size()) {
                Pair p = (Pair)grpRules.get(j);
                String rulename = (String)p.first;
                grpStr = grpStr.concat(rulename);
                long ruleIters = -1L;
                String ruleItersStr = (String)p.second;
                if (ruleItersStr.equals("*")) {
                    grpStr = grpStr.concat("{");
                    grpStr = grpStr.concat(ruleItersStr);
                    grpStr = grpStr.concat("}");
                } else {
                    ruleIters = new Long((String)p.second);
                    if (ruleIters > 1L) {
                        grpStr = grpStr.concat("{");
                        grpStr = grpStr.concat(String.valueOf(ruleIters));
                        grpStr = grpStr.concat("}");
                    }
                }
                grpStr = grpStr.concat(" ");
                ++j;
            }
            if (grpItersStr.equals("*")) {
                grpStr = grpStr.concat(")");
            } else if (grpRules.size() > 1 || grpIters > 1L) {
                grpStr = grpStr.concat(")");
            }
            if (grpRules.size() > 0) {
                if (grpItersStr.equals("*")) {
                    grpStr = grpStr.concat("{");
                    grpStr = grpStr.concat(grpItersStr);
                    grpStr = grpStr.concat("}");
                } else if (grpIters > 1L) {
                    grpStr = String.valueOf(grpStr) + "{" + grpIters + "}";
                }
            } else {
                grpStr = "()";
            }
            grpStr = grpStr.concat("\n");
            text = text.concat(grpStr);
            ++i;
        }
        if (this.graph != null) {
            text = this.graph.getName().concat(" <= ").concat(text);
        }
        return text;
    }

    public String getRuleNamesString() {
        String str = "( ";
        int i = 0;
        while (i < this.rules.size()) {
            str = str.concat(this.rules.get(i).getName());
            str = str.concat(" ");
            ++i;
        }
        str = str.concat(")");
        return str;
    }

    public Pair<Boolean, String> getApplicabilityResult() {
        return this.applResult;
    }

    public Pair<Boolean, String> getNonApplicabilityResult() {
        return this.nonapplResult;
    }

    private void makeRules(List<String> sequence) {
        int j = 0;
        while (j < sequence.size()) {
            Rule r = this.gragra.getRule(sequence.get(j));
            if (r != null) {
                this.rules.add(r);
                this.ruleNames.add(r.getName());
            }
            ++j;
        }
    }

    private void makeRules(Iterator<Rule> sequence) {
        while (sequence.hasNext()) {
            Rule r = sequence.next();
            this.rules.add(r);
            this.ruleNames.add(r.getName());
        }
    }

    public void removeRule(int indx) {
        if (indx >= 0 && indx < this.rules.size()) {
            Rule r = this.rules.get(indx);
            this.removeObjFlowOfRule(r, indx);
            this.rules.remove(indx);
            this.ruleNames.remove(indx);
            this.clearResult();
        }
    }

    public void removeRule(Rule r) {
        if (this.rules.contains(r)) {
            int indx = this.rules.indexOf(r);
            this.removeObjFlowOfRule(r, indx);
            this.rules.remove(r);
            this.ruleNames.remove(indx);
            this.clearResult();
        }
    }

    private void removeObjFlowOfRule(Rule r, int indx) {
        int ind = indx;
        if (this.graph != null) {
            ++ind;
        }
        Enumeration<String> keys = this.objectFlow.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            String[] keyItems = key.split(":");
            if (Integer.valueOf(keyItems[0]) != ind && Integer.valueOf(keyItems[1]) != ind) continue;
            this.objectFlow.remove(key);
            keys = this.objectFlow.keys();
            break;
        }
    }

    public RuleSequence getCopy() {
        RuleSequence seq = new RuleSequence(this.gragra, this.name.concat("_copy"), this.cpOption);
        seq.setCriticalPairOption(this.cpOption);
        seq.setRules(this.getRules().iterator());
        seq.setGraph(this.graph);
        seq.copySubsequenceList(this.subSequenceList);
        if (!seq.getRuleNames().equals(this.getRuleNames())) {
            seq.resetRuleNames(this.getRuleNames());
        }
        seq.copyObjFlow(this.getObjectFlow());
        seq.enableCompleteObjFlowOfNodes(this.completeNodesOF);
        seq.tryToApplyResultsOfRuleSequence(this);
        return seq;
    }

    private void copyObjFlow(Hashtable<String, ObjectFlow> objFlow) {
        Enumeration<String> keys = objFlow.keys();
        while (keys.hasMoreElements()) {
            String k = keys.nextElement();
            ObjectFlow flow = objFlow.get(k);
            ObjectFlow f = new ObjectFlow(flow.srcOfOutput, flow.srcOfInput, flow.indxOfOutput, flow.indxOfInput, new Hashtable<Object, Object>(flow.outputInputMap));
            this.objectFlow.put(k, f);
        }
    }

    public void moveRule(int from, int to) {
        if (from >= 0 && from < this.rules.size() && to >= 0 && to < this.rules.size()) {
            Rule r = this.rules.get(from);
            this.clearResult();
            this.move(r, from, to);
        }
    }

    private void move(Rule r, int from, int to) {
        this.rules.remove(from);
        this.ruleNames.remove(from);
        this.rules.add(to, r);
        this.ruleNames.add(to, r.getName());
    }

    public boolean isChecked() {
        return this.checked;
    }

    public void uncheck() {
        this.clearResult();
        this.checked = false;
    }

    public void setDepthOfConcurrentRule(int d) {
        this.checker.setDepthOfConcurrentRule(d);
    }

    public int getDepthOfConcurrentRule() {
        return this.checker.getDepthOfConcurrentRule();
    }

    public void setCompleteConcurrency(boolean b) {
        this.checker.setCompleteConcurrency(b);
    }

    public boolean getCompleteConcurrency() {
        return this.checker.getCompleteConcurrency();
    }

    public boolean getCompleteCPAOfConcurrency() {
        return this.checker.getCompleteCPAOfConcurrency();
    }

    public void setCompleteCPAOfConcurrency(boolean b) {
        this.checker.setCompleteCPAOfConcurrency(b);
    }

    public void setIgnoreDanglingEdgeOfDelNode(boolean b) {
        this.checker.setIgnoreDanglingEdgeOfDelNode(b);
    }

    public boolean getIgnoreDanglingEdgeOfDelNode() {
        return this.checker.getIgnoreDanglingEdgeOfDelNode();
    }

    public boolean check() {
        if (this.checked) {
            this.reinit();
            this.matchSequence.reinit(this);
        }
        if (!this.isObjFlowValid()) {
            return false;
        }
        boolean result = this.checker.check();
        this.checked = true;
        return result;
    }

    public MatchSequence getMatchSequence() {
        return this.matchSequence;
    }

    protected void saveConcurrentRules() {
        System.out.println("saveConcurrentRules...  (for test only)");
        boolean dosave = false;
        int nn = 0;
        int i = 0;
        while (i < this.rules.size()) {
            Rule r = this.rules.get(i);
            String key = String.valueOf(r.hashCode()).concat(":").concat(String.valueOf(i));
            List<List<ConcurrentRule>> lists = this.concurrentRules.get(key);
            if (lists != null) {
                if (!lists.isEmpty()) {
                    dosave = true;
                }
                int j = 0;
                while (j < lists.size()) {
                    List<ConcurrentRule> list = lists.get(j);
                    int k = 0;
                    while (k < list.size()) {
                        Rule cr = list.get(k).getRule();
                        this.gragra.addRule(cr);
                        ++nn;
                        ++k;
                    }
                    ++j;
                }
            }
            ++i;
        }
        if (dosave) {
            String aname = "CR_".concat(this.gragra.getName()).concat(".ggx");
            XMLHelper xmlh = new XMLHelper();
            xmlh.addTopObject(this.gragra);
            xmlh.save_to_xml(aname);
            int i2 = 0;
            while (i2 < nn) {
                int indx = this.gragra.getListOfRules().size() - 1;
                this.gragra.getListOfRules().remove(indx);
                ++i2;
            }
        }
    }

    public Hashtable<String, Pair<Boolean, List<String>>> getRuleResults() {
        return this.ruleResults;
    }

    public Pair<Boolean, List<String>> getRuleResult(int indx, String ruleName, String criterion) {
        String key = this.makeRuleKey(indx, ruleName, criterion);
        return this.ruleResults.get(key);
    }

    public boolean getRuleApplicabilityResult(int indx, String ruleName) {
        boolean result = false;
        if (indx == 0) {
            String criterion = "initialization";
            String key = this.makeRuleKey(indx, ruleName, criterion);
            Pair<Boolean, List<String>> pair = this.ruleResults.get(key);
            if (pair != null) {
                result = (Boolean)pair.first;
            }
        } else {
            String criterion = "pure-enabling-predecessor";
            String key = this.makeRuleKey(indx, ruleName, criterion);
            Pair<Boolean, List<String>> pair = this.ruleResults.get(key);
            if (pair != null) {
                boolean bl = result = result || (Boolean)pair.first != false;
            }
            if (!(pair != null && result || (pair = this.ruleResults.get(key = this.makeRuleKey(indx, ruleName, criterion = "direct-enabling-predecessor"))) == null)) {
                boolean bl = result = result || (Boolean)pair.first != false;
            }
            if (!(pair != null && result || (pair = this.ruleResults.get(key = this.makeRuleKey(indx, ruleName, criterion = "partial-enabling-predecessor"))) == null)) {
                boolean bl = result = result || (Boolean)this.ruleResults.get((Object)key).first != false;
            }
            if (!(pair != null && result || (pair = this.ruleResults.get(key = this.makeRuleKey(indx, ruleName, criterion = "predecessor-not-needed"))) == null)) {
                result = result || (Boolean)this.ruleResults.get((Object)key).first != false;
            }
        }
        return result;
    }

    public boolean getRuleNonApplicabilityResult(int indx, String ruleName) {
        boolean result = false;
        String criterion = "initialization-error";
        String key = this.makeRuleKey(indx, ruleName, criterion);
        Pair<Boolean, List<String>> pair = this.ruleResults.get(key);
        if (pair != null && !(result = ((Boolean)pair.first).booleanValue()) && (pair = this.ruleResults.get(key = this.makeRuleKey(indx, ruleName, criterion = "no-enabling-predecessor"))) != null) {
            result = result || (Boolean)pair.first != false;
        }
        return result;
    }

    private String makeRuleKey(int indx, String rName, String criterion) {
        String ruleKey = String.valueOf(indx);
        ruleKey = ruleKey.concat(rName);
        ruleKey = ruleKey.concat(criterion);
        return ruleKey;
    }

    public void setRuleResult(int indx, String ruleName, boolean result, String criterion, String otherRuleName) {
        Vector<String> v = new Vector<String>();
        v.add(criterion);
        v.add(otherRuleName);
        Pair pair = new Pair(result, v);
        String key = this.makeRuleKey(indx, ruleName, criterion);
        this.ruleResults.put(key, pair);
    }

    public void setApplicabilityResult(boolean result, String criterion) {
        if ("undefined".equals(this.applResult.second) || ((Boolean)this.applResult.first).booleanValue() && !result) {
            this.applResult.first = new Boolean(result);
            this.applResult.second = criterion;
        }
    }

    public void setNonApplicabilityResult(boolean result, String criterion) {
        if ("undefined".equals(this.nonapplResult.second) || !((Boolean)this.nonapplResult.first).booleanValue() && result) {
            this.nonapplResult.first = new Boolean(result);
            this.nonapplResult.second = criterion;
        }
    }

    @Override
    public void graTraEventOccurred(GraTraEvent e) {
        if (e.getMessage() == 2) {
            Match match = e.getMatch();
            OrdinaryMorphism comatch = match.getCoMorphism();
            this.matchSequence.addComatch(match.getRule(), comatch);
        }
    }

    public boolean containsObjFlow(Hashtable<String, ObjectFlow> objFlow) {
        Vector<String> keys1 = new Vector<String>(this.objectFlow.keySet());
        Vector<String> keys2 = new Vector<String>(objFlow.keySet());
        if (keys1.isEmpty() && !keys2.isEmpty() || !keys1.isEmpty() && keys2.isEmpty()) {
            return false;
        }
        if (keys1.containsAll(keys2)) {
            int i = 0;
            while (i < keys2.size()) {
                ObjectFlow flow2 = objFlow.get(keys2.get(i));
                ObjectFlow flow1 = this.objectFlow.get(flow2.getKey());
                if (flow1 == null || !flow1.compareTo(flow2)) {
                    return false;
                }
                ++i;
            }
        } else {
            return false;
        }
        return true;
    }

    public boolean extendsRuleList(List<String> ruleList) {
        if (this.ruleNames.size() < ruleList.size()) {
            return false;
        }
        int i = 0;
        while (i < ruleList.size()) {
            if (!ruleList.get(i).equals(this.ruleNames.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean extendsRuleSequence(RuleSequence ruleSeq) {
        return (this.graph != null && ruleSeq.getGraph() != null && this.graph.getName().equals(ruleSeq.getGraph().getName()) || this.graph == null && ruleSeq.getGraph() == null) && this.extendsRuleList(ruleSeq.getRuleNames()) && this.containsObjFlow(ruleSeq.getObjectFlow());
    }

    public int tryToApplyResultsOfRuleSequence(RuleSequence ruleSeq) {
        int res = 0;
        if (this.usePreviousSequenceResults && ruleSeq != null && ruleSeq.isChecked() && !this.checked && this.extendsRuleSequence(ruleSeq) && this.getDepthOfConcurrentRule() == ruleSeq.getDepthOfConcurrentRule() && this.getCompleteConcurrency() == ruleSeq.getCompleteConcurrency() && this.getCompleteCPAOfConcurrency() == ruleSeq.getCompleteCPAOfConcurrency()) {
            Hashtable<String, Pair<Boolean, List<String>>> table = ruleSeq.getRuleResults();
            Enumeration<String> keys = table.keys();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                Pair<Boolean, List<String>> p = table.get(key);
                Pair p1 = new Pair((Boolean)p.first, new Vector((Collection)p.second));
                this.getRuleResults().put(key, p1);
            }
            Pair<Boolean, String> applRes = ruleSeq.getApplicabilityResult();
            this.applResult.first = (Boolean)applRes.first;
            this.applResult.second = (String)applRes.second;
            Pair<Boolean, String> nonapplRes = ruleSeq.getNonApplicabilityResult();
            this.nonapplResult.first = (Boolean)nonapplRes.first;
            this.nonapplResult.second = (String)nonapplRes.second;
            this.tryToApplyDoneMatchesOfRuleSequence(ruleSeq);
            res = ruleSeq.getRules().size();
        }
        return res;
    }

    private void tryToApplyDoneMatchesOfRuleSequence(RuleSequence ruleSeq) {
        List<Rule> otherRules = ruleSeq.matchSequence.rules;
        int i = 0;
        while (i < otherRules.size()) {
            Rule r = otherRules.get(i);
            Rule preRule = i == 0 ? null : otherRules.get(i - 1);
            Hashtable match = new Hashtable(ruleSeq.matchSequence.matches.get(i));
            this.matchSequence.matches.add(match);
            this.matchSequence.rules.add(r);
            if (preRule != null) {
                if (ruleSeq.matchSequence.imgObj2Rule.get(i - 1) != null) {
                    this.matchSequence.imgObj2Rule.put(i - 1, preRule);
                } else if (ruleSeq.matchSequence.imgObj2ConcurrentRule.get(i) != null) {
                    this.matchSequence.imgObj2ConcurrentRule.put(i, ruleSeq.matchSequence.imgObj2ConcurrentRule.get(i));
                }
            }
            ++i;
        }
    }

    public Hashtable<GraphObject, GraphObject> getInput2outputMapIntoGraphAbovePreRule(Rule targetRule, int targetIndx, List<ObjectFlow> targetObjFlowList, Rule rule, int ruleIndx, Hashtable<GraphObject, GraphObject> input2postInput, Graph g) {
        Hashtable<GraphObject, GraphObject> map = new Hashtable<GraphObject, GraphObject>();
        Rule preRule = this.getRule(ruleIndx - 1);
        if (preRule != null) {
            boolean done;
            List<ObjectFlow> preObjFlowList = this.getObjFlowForRule(preRule, ruleIndx - 1);
            if (preObjFlowList.isEmpty()) {
                return map;
            }
            boolean alreadyChecked = rule == targetRule;
            List<ObjectFlow> objFlowList = this.getObjFlowForRule(rule, ruleIndx);
            if (objFlowList.isEmpty() && rule != targetRule) {
                objFlowList = targetObjFlowList;
                alreadyChecked = true;
            }
            if (!(done = this.reflectObjFlow(preObjFlowList, objFlowList, map, input2postInput, g)) && !alreadyChecked) {
                objFlowList = targetObjFlowList;
                this.reflectObjFlow(preObjFlowList, objFlowList, map, input2postInput, g);
            }
        }
        return map;
    }

    private boolean reflectObjFlow(List<ObjectFlow> preObjFlowList, List<ObjectFlow> objFlowList, Hashtable<GraphObject, GraphObject> map, Hashtable<GraphObject, GraphObject> input2postInput, Graph g) {
        boolean result = false;
        if (!objFlowList.isEmpty() && !preObjFlowList.isEmpty()) {
            int i = 0;
            while (i < objFlowList.size()) {
                ObjectFlow objFlow = objFlowList.get(i);
                List<Object> inputObjs = objFlow.getInputs();
                int k = 0;
                while (k < inputObjs.size()) {
                    GraphObject inObj = (GraphObject)inputObjs.get(k);
                    int j = 0;
                    while (j < preObjFlowList.size()) {
                        ObjectFlow preObjFlow = preObjFlowList.get(j);
                        GraphObject connectedInObj = (GraphObject)objFlow.getConnectedInput(preObjFlow, inObj);
                        GraphObject connectedOutObj = (GraphObject)objFlow.getConnectedOutput(preObjFlow, inObj);
                        if (connectedOutObj != null) {
                            if (g.isElement(connectedOutObj)) {
                                if (input2postInput.isEmpty()) {
                                    map.put(inObj, connectedOutObj);
                                    result = true;
                                } else if (connectedInObj != null && input2postInput.get(connectedInObj) != null) {
                                    map.put(input2postInput.get(connectedInObj), connectedOutObj);
                                    input2postInput.remove(connectedInObj);
                                    result = true;
                                }
                            } else if (connectedInObj != null) {
                                input2postInput.put(connectedInObj, inObj);
                                result = true;
                            }
                        }
                        ++j;
                    }
                    ++k;
                }
                ++i;
            }
        }
        return result;
    }

    public Hashtable<GraphObject, GraphObject> getReflectedObjectFlowOfGraphAndPreRule(ConcurrentRule cr, List<ObjectFlow> targetObjFlowList, Rule rule, int ruleIndx, Hashtable<GraphObject, GraphObject> input2postInput, Graph g) {
        Hashtable<GraphObject, GraphObject> map = new Hashtable<GraphObject, GraphObject>();
        Rule preRule = this.getRule(ruleIndx - 1);
        if (preRule != null) {
            boolean done;
            List<ObjectFlow> preObjFlowList = this.getObjFlowForRule(preRule, ruleIndx - 1);
            if (preObjFlowList.isEmpty()) {
                return map;
            }
            boolean alreadyChecked = false;
            List<ObjectFlow> objFlowList = this.getObjFlowForRule(rule, ruleIndx);
            if (objFlowList.isEmpty()) {
                objFlowList = targetObjFlowList;
                alreadyChecked = true;
            }
            if (!(done = this.reflectObjFlow(cr, preRule, preObjFlowList, objFlowList, map, input2postInput, g)) && !alreadyChecked) {
                objFlowList = targetObjFlowList;
                this.reflectObjFlow(cr, preRule, preObjFlowList, objFlowList, map, input2postInput, g);
            }
        }
        return map;
    }

    public void removeEmptyObjFlow() {
        Enumeration<String> keys = this.objectFlow.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            ObjectFlow objFlow = this.objectFlow.get(key);
            if (!objFlow.isEmpty()) continue;
            this.objectFlow.remove(key);
            keys = this.objectFlow.keys();
        }
    }

    private boolean reflectObjFlow(ConcurrentRule cr, Rule preRule, List<ObjectFlow> preObjFlowList, List<ObjectFlow> objFlowList, Hashtable<GraphObject, GraphObject> map, Hashtable<GraphObject, GraphObject> input2postInput, Graph g) {
        boolean result = false;
        if (!objFlowList.isEmpty() && !preObjFlowList.isEmpty()) {
            int i = 0;
            while (i < objFlowList.size()) {
                ObjectFlow objFlow = objFlowList.get(i);
                Hashtable<Object, Object> outInMap = objFlow.getMapping();
                Enumeration<Object> outs = outInMap.keys();
                while (outs.hasMoreElements()) {
                    Object out = outs.nextElement();
                    if (!(out instanceof GraphObject) || !preRule.getRight().isElement((GraphObject)out)) continue;
                    Enumeration<GraphObject> inverse = preRule.getInverseImage((GraphObject)out);
                    while (inverse.hasMoreElements()) {
                        GraphObject prein = inverse.nextElement();
                        int j = 0;
                        while (j < preObjFlowList.size()) {
                            ObjectFlow preObjFlow = preObjFlowList.get(j);
                            Hashtable<Object, Object> preOutInMap = preObjFlow.getMapping();
                            Enumeration<Object> preOuts = preOutInMap.keys();
                            while (preOuts.hasMoreElements()) {
                                GraphObject inObj;
                                GraphObject crInObj;
                                Object preOut = preOuts.nextElement();
                                if (!(preOut instanceof GraphObject) || prein != preObjFlow.getMapping().get(preOut) || (crInObj = cr.getLeftEmbedding(inObj = (GraphObject)objFlow.getMapping().get(out))) == null) continue;
                                if (g.isElement((GraphObject)preOut)) {
                                    if (input2postInput.isEmpty()) {
                                        map.put(crInObj, (GraphObject)preOut);
                                        result = true;
                                        continue;
                                    }
                                    if (input2postInput.get(prein) == null) continue;
                                    map.put(input2postInput.get(prein), (GraphObject)preOut);
                                    input2postInput.remove(prein);
                                    result = true;
                                    continue;
                                }
                                if (!preRule.getRight().isElement((GraphObject)preOut)) continue;
                                input2postInput.put(prein, crInObj);
                                result = true;
                            }
                            ++j;
                        }
                    }
                }
                ++i;
            }
        }
        return result;
    }

    public void addObjFlow(ObjectFlow objFlow) {
        if (objFlow != null) {
            int indx1 = objFlow.getIndexOfOutput();
            int indx2 = objFlow.getIndexOfInput();
            if (indx1 >= 0 && indx2 > indx1) {
                String keyStr = objFlow.getKey();
                this.objectFlow.put(keyStr, objFlow);
            }
        }
    }

    public void removeObjFlow(ObjectFlow objFlow) {
        if (objFlow != null) {
            int indx1 = objFlow.getIndexOfOutput();
            int indx2 = objFlow.getIndexOfInput();
            if (indx1 >= 0 && indx2 > indx1) {
                String keyStr = objFlow.getKey();
                this.objectFlow.remove(keyStr);
            }
        }
    }

    public void removeObjFlowOfGraph() {
        if (this.graph != null) {
            Enumeration<String> keys = this.objectFlow.keys();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                String[] keyItems = key.split(":");
                if (!keyItems[0].equals("0")) continue;
                this.objectFlow.remove(key);
                keys = this.objectFlow.keys();
            }
        }
    }

    public void removeObjFlow() {
        this.objectFlow.clear();
    }

    public ObjectFlow getObjFlowForRules(Rule r1, int indx_r1, Rule r2, int indx_r2) {
        int i1 = indx_r1;
        int i2 = indx_r2;
        if (this.graph != null) {
            ++i1;
            ++i2;
        }
        Enumeration<String> keys = this.objectFlow.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            ObjectFlow objFlow = this.objectFlow.get(key);
            if (objFlow.getSourceOfOutput() != r1 || objFlow.getIndexOfOutput() != i1 || objFlow.getSourceOfInput() != r2 || objFlow.indxOfInput != i2) continue;
            return objFlow;
        }
        return null;
    }

    public ObjectFlow getObjFlowForGraphAndRule(Rule r, int indx_r) {
        int i = indx_r;
        if (this.graph == null) {
            return null;
        }
        ++i;
        Enumeration<String> keys = this.objectFlow.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            ObjectFlow objFlow = this.objectFlow.get(key);
            if (objFlow.getSourceOfOutput() != this.graph || objFlow.getSourceOfInput() != r || objFlow.indxOfInput != i) continue;
            return objFlow;
        }
        return null;
    }

    public List<ObjectFlow> getObjFlowForRule(Rule r, int indx) {
        Vector<ObjectFlow> list = new Vector<ObjectFlow>();
        if (indx < 0) {
            return list;
        }
        int i = indx;
        if (this.graph != null) {
            ++i;
        }
        Enumeration<String> keys = this.objectFlow.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            String[] keyItems = key.split(":");
            if (Integer.valueOf(keyItems[1]) != i) continue;
            list.add(this.objectFlow.get(key));
        }
        return list;
    }

    public List<ObjectFlow> getObjFlowFromGraph() {
        Vector<ObjectFlow> list = new Vector<ObjectFlow>();
        if (this.graph != null) {
            Enumeration<String> keys = this.objectFlow.keys();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                String[] keyItems = key.split(":");
                if (Integer.valueOf(keyItems[0]) != 0) continue;
                list.add(this.objectFlow.get(key));
            }
        }
        return list;
    }

    public List<ObjectFlow> getObjFlowFromRule(Rule r, int indx) {
        Vector<ObjectFlow> list = new Vector<ObjectFlow>();
        if (indx < 0) {
            return list;
        }
        int i = indx;
        if (this.graph != null) {
            ++i;
        }
        Enumeration<String> keys = this.objectFlow.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            String[] keyItems = key.split(":");
            if (Integer.valueOf(keyItems[0]) != i) continue;
            list.add(this.objectFlow.get(key));
        }
        return list;
    }

    public int getSizeOfObjFlowForRule(Rule r, int indx) {
        if (indx < 0) {
            return 0;
        }
        int i = indx;
        if (this.graph != null) {
            ++i;
        }
        int size = 0;
        Enumeration<String> keys = this.objectFlow.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            String[] keyItems = key.split(":");
            if (Integer.valueOf(keyItems[1]) != i) continue;
            size += this.objectFlow.get(key).getSizeOfInput();
        }
        return size;
    }

    private List<Pair<Rule, Integer>> getNextRuleOfObjFlow(Object outputSource, int itsIndx) {
        Vector<Pair<Rule, Integer>> list = new Vector<Pair<Rule, Integer>>();
        if (itsIndx < 0) {
            return list;
        }
        Enumeration<String> keys = this.objectFlow.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            String[] keyItems = key.split(":");
            if (Integer.valueOf(keyItems[0]) != itsIndx || this.objectFlow.get(key).getSourceOfOutput() != outputSource) continue;
            Rule r2 = (Rule)this.objectFlow.get(key).getSourceOfInput();
            list.add(new Pair<Rule, Integer>(r2, Integer.valueOf(keyItems[1])));
        }
        return list;
    }

    private GraphObject getConnectedInputForOutput(Object ouputSource, int itsIndx, GraphObject out, Rule r2) {
        if (itsIndx < 0) {
            return null;
        }
        Enumeration<String> keys = this.objectFlow.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            String[] keyItems = key.split(":");
            if (Integer.valueOf(keyItems[0]) != itsIndx || this.objectFlow.get(key).getSourceOfOutput() != ouputSource || this.objectFlow.get(key).getSourceOfInput() != r2) continue;
            return (GraphObject)this.objectFlow.get(key).getMapping().get(out);
        }
        return null;
    }

    private List<GraphObject> getOutputObjsOfOutput(Object output, int itsIndx) {
        Vector<GraphObject> list = new Vector<GraphObject>();
        if (itsIndx < 0) {
            return list;
        }
        Enumeration<String> keys = this.objectFlow.keys();
        while (keys.hasMoreElements()) {
            ObjectFlow objFlow;
            String key = keys.nextElement();
            String[] keyItems = key.split(":");
            if (Integer.valueOf(keyItems[0]) != itsIndx || this.objectFlow.get(key).getSourceOfOutput() != output || (objFlow = this.objectFlow.get(key)).getSourceOfOutput() != output) continue;
            Enumeration<Object> outputs = objFlow.getMapping().keys();
            while (outputs.hasMoreElements()) {
                Object obj = outputs.nextElement();
                if (list.contains(obj)) continue;
                list.add((GraphObject)obj);
            }
        }
        return list;
    }

    private void getClosuresOfObjFlow(Object outputSource, int itsIndx, GraphObject outObj, List<Triple<GraphObject, Rule, Integer>> closures) {
        if (itsIndx < 0) {
            return;
        }
        List<Pair<Rule, Integer>> nextRule = this.getNextRuleOfObjFlow(outputSource, itsIndx);
        int r = 0;
        while (r < nextRule.size()) {
            Pair<Rule, Integer> pair = nextRule.get(r);
            Rule rule = (Rule)pair.first;
            GraphObject inputObj = this.getConnectedInputForOutput(outputSource, itsIndx, outObj, rule);
            if (inputObj != null) {
                closures.add(new Triple<GraphObject, Rule, Integer>(inputObj, rule, (Integer)pair.second));
                GraphObject rhsObj = rule.getImage(inputObj);
                if (rhsObj != null) {
                    this.getClosuresOfObjFlow(rule, (Integer)pair.second, rhsObj, closures);
                }
            }
            ++r;
        }
    }

    public int getMessageOfInvalidObjectFlow() {
        return this.objectFlowError;
    }

    public boolean isObjFlowValid() {
        this.objectFlowError = -1;
        if (this.objectFlow != null && !this.objectFlow.isEmpty()) {
            Vector<Rule> tmp = new Vector<Rule>(this.rules);
            if (this.graph != null) {
                tmp.add(0, (Rule)((Object)this.graph));
            }
            boolean closureOK = true;
            int i = 0;
            while (i < tmp.size() && closureOK) {
                Object outputSource = tmp.get(i);
                List<GraphObject> rOutputs = this.getOutputObjsOfOutput(outputSource, i);
                if (!rOutputs.isEmpty()) {
                    int j = 0;
                    while (j < rOutputs.size() && closureOK) {
                        GraphObject outObj = rOutputs.get(j);
                        Vector<Triple<GraphObject, Rule, Integer>> closures = new Vector<Triple<GraphObject, Rule, Integer>>();
                        this.getClosuresOfObjFlow(outputSource, i, outObj, closures);
                        if (!this.isObjFlowTransitive(closures)) {
                            this.objectFlowError = 0;
                            closureOK = false;
                        } else if (!this.isObjFlowPersistent(closures)) {
                            this.objectFlowError = 1;
                            closureOK = false;
                        }
                        ++j;
                    }
                }
                ++i;
            }
            return closureOK;
        }
        return true;
    }

    private boolean isObjFlowTransitive(List<Triple<GraphObject, Rule, Integer>> closures) {
        int k = 0;
        while (k < closures.size() - 1) {
            Triple<GraphObject, Rule, Integer> triple = closures.get(k);
            GraphObject go1 = (GraphObject)triple.first;
            int l = 1;
            while (l < closures.size()) {
                Triple<GraphObject, Rule, Integer> triple2 = closures.get(l);
                GraphObject go2 = (GraphObject)triple2.first;
                if (go1.getContext() == go2.getContext() && go1 != go2) {
                    return false;
                }
                ++l;
            }
            ++k;
        }
        return true;
    }

    public void tryCompleteObjFlowTransClosure() {
        this.tryCompleteArcsOF();
        Vector<Object> tmp = new Vector<Object>(this.rules);
        boolean withGraph = false;
        if (this.graph != null) {
            if (tmp.get(0) != this.graph) {
                tmp.add(0, this.graph);
            }
            withGraph = true;
        }
        this.completeNodeTC(tmp, withGraph);
        this.completeNodeTC1(tmp, withGraph);
    }

    private void completeNodeTC(Vector<Object> tmp, boolean withGraph) {
        int i = 0;
        while (i < tmp.size() - 1) {
            Object outSrc = tmp.get(i);
            if (outSrc instanceof Rule) {
                int j = i + 1;
                while (j < tmp.size() - 1) {
                    Object inSrc1 = tmp.get(j);
                    Object inSrc2 = tmp.get(j + 1);
                    if (inSrc1 instanceof Rule && inSrc2 instanceof Rule) {
                        for (GraphObject graphObject : ((Rule)outSrc).getRight().getNodesSet()) {
                            this.tryCompleteNodeTC(graphObject, (Rule)outSrc, i, (Rule)inSrc1, j, (Rule)inSrc2, j + 1, withGraph);
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private void completeNodeTC1(Vector<Object> tmp, boolean withGraph) {
        int c = withGraph ? -1 : 0;
        int i = 0;
        while (i < tmp.size() - 1) {
            Object outSrc = tmp.get(i);
            int j = i + 1;
            Object inSrc = tmp.get(j);
            ObjectFlow of = null;
            if (outSrc instanceof Rule) {
                of = this.getObjFlowForRules((Rule)outSrc, i + c, (Rule)inSrc, j + c);
            } else if (outSrc instanceof Graph) {
                of = this.getObjFlowForGraphAndRule((Rule)inSrc, j + c);
            }
            if (of != null && i >= 1 && tmp.get(i - 1) instanceof Rule) {
                Enumeration<GraphObject> elems = ((Rule)inSrc).getLeft().getElements();
                block1: while (elems.hasMoreElements()) {
                    GraphObject go_in = elems.nextElement();
                    if (!of.isInputObject(go_in) || i - 1 < 0) continue;
                    GraphObject go_out = (GraphObject)of.getOutput(go_in);
                    Triple<GraphObject, Rule, Integer> result = this.tryCompleteTransClosure(go_out, (Rule)tmp.get(i - 1), i - 1, (Rule)tmp.get(j - 1), j - 1, withGraph);
                    int l = i - 1;
                    int k = j - 1;
                    while (result != null) {
                        ObjectFlow of1 = this.getObjFlowForRules((Rule)result.second, (Integer)result.third + c, (Rule)inSrc, j + c);
                        if (of1 == null) {
                            of1 = new ObjectFlow(result.second, inSrc, (Integer)result.third, j);
                            of1.addMapping(result.first, go_in);
                            this.addObjFlow(of1);
                        } else if (!of1.isInputObject(go_in)) {
                            of1.addMapping(result.first, go_in);
                        }
                        if (--l < 0 || --k < 0 || !(tmp.get(l) instanceof Rule) || !(tmp.get(k) instanceof Rule)) continue block1;
                        result = this.tryCompleteTransClosure((GraphObject)result.first, (Rule)tmp.get(l), l, (Rule)tmp.get(k), k, withGraph);
                    }
                }
            }
            ++i;
        }
    }

    private void tryCompleteNodeOF(GraphObject go_in, Object inSrc, int inIndx, List<Object> tmp) {
        ObjectFlow of = null;
        int c = 0;
        if (this.graph != null && tmp.get(0) == this.graph) {
            --c;
        }
        int i = tmp.size() - 1;
        while (i >= 0) {
            Object outSrc = tmp.get(i);
            if (outSrc instanceof Rule) {
                of = this.getObjFlowForRules((Rule)outSrc, i + c, (Rule)inSrc, inIndx + c);
            } else if (outSrc instanceof Graph) {
                of = this.getObjFlowForGraphAndRule((Rule)inSrc, inIndx + c);
            }
            GraphObject go_out = null;
            if (outSrc instanceof Rule) {
                List<GraphObject> objs = ((Rule)outSrc).getElementsToCreate();
                int l = 0;
                while (l < objs.size()) {
                    go_out = objs.get(l);
                    if (go_out.compareTo(go_in)) break;
                    go_out = null;
                    ++l;
                }
                if (go_out == null) {
                    objs = ((Rule)outSrc).getCodomainObjects();
                    l = 0;
                    while (l < objs.size()) {
                        go_out = objs.get(l);
                        if (go_out.compareTo(go_in)) break;
                        go_out = null;
                        ++l;
                    }
                }
                if (go_out != null) {
                    if (of == null) {
                        of = new ObjectFlow((Rule)outSrc, inSrc, i, inIndx);
                        this.addObjFlow(of);
                    }
                    this.addObjFlow(of);
                    of.addMapping(go_out, go_in);
                    break;
                }
            }
            --i;
        }
    }

    private Triple<GraphObject, Rule, Integer> tryCompleteTransClosure(GraphObject go_out, Rule r_out, int j, Rule r_in, int i, boolean withGraph) {
        int c = withGraph ? -1 : 0;
        Enumeration<GraphObject> en = r_in.getInverseImage(go_out);
        if (en.hasMoreElements()) {
            GraphObject go = en.nextElement();
            ObjectFlow of = this.getObjFlowForRules(r_out, j + c, r_in, i + c);
            if (of != null && of.isInputObject(go)) {
                GraphObject go_out_j = (GraphObject)of.getOutput(go);
                return new Triple<GraphObject, Rule, Integer>(go_out_j, r_out, j);
            }
        }
        return null;
    }

    private void tryCompleteNodeTC(GraphObject go_out, Rule r_out, int j, Rule r_in1, int i1, Rule r_in2, int i2, boolean withGraph) {
        int c;
        int n = c = withGraph ? -1 : 0;
        if (i2 > i1) {
            ObjectFlow of1 = this.getObjFlowForRules(r_out, j + c, r_in1, i1 + c);
            if (of1 != null) {
                GraphObject go_out3;
                ObjectFlow of2 = this.getObjFlowForRules(r_out, j + c, r_in2, i2 + c);
                Object go_in1 = of1.getInput(go_out);
                if (go_in1 != null && (go_out3 = r_in1.getImage((GraphObject)go_in1)) != null) {
                    if (of2 != null) {
                        Object go_in3;
                        ObjectFlow of3 = this.getObjFlowForRules(r_in1, i1 + c, r_in2, i2 + c);
                        Object go_in2 = of2.getInput(go_out);
                        if (go_in2 != null) {
                            if (of3 == null) {
                                of3 = new ObjectFlow(r_in1, r_in2, i1, i2);
                                this.addObjFlow(of3);
                            }
                            if (of3.getInput(go_out3) == null) {
                                of3.addMapping(go_out3, (GraphObject)go_in2);
                            }
                        } else if (of3 != null && (go_in3 = of3.getInput(go_out3)) != null) {
                            of2.addMapping(go_out, (GraphObject)go_in3);
                        }
                    } else {
                        Object go_in3;
                        ObjectFlow of3 = this.getObjFlowForRules(r_in1, i1 + c, r_in2, i2 + c);
                        if (of3 != null && (go_in3 = of3.getInput(go_out3)) != null) {
                            of2 = new ObjectFlow(r_out, r_in2, j, i2);
                            this.addObjFlow(of2);
                            of2.addMapping(go_out, (GraphObject)go_in3);
                        }
                    }
                }
            } else {
                Enumeration<GraphObject> en;
                Object go_out3;
                ObjectFlow of3;
                Object go_in2;
                ObjectFlow of2 = this.getObjFlowForRules(r_out, j + c, r_in2, i2 + c);
                if (of2 != null && (go_in2 = of2.getInput(go_out)) != null && (of3 = this.getObjFlowForRules(r_in1, i1 + c, r_in2, i2 + c)) != null && (go_out3 = of3.getOutput(go_in2)) != null && (en = r_in1.getInverseImage((GraphObject)go_out3)).hasMoreElements()) {
                    of1 = new ObjectFlow(r_out, r_in1, j, i1);
                    this.addObjFlow(of1);
                    of1.addMapping(go_out, en.nextElement());
                }
            }
        }
    }

    private void tryCompleteArcsOF() {
        Enumeration<String> keys = this.objectFlow.keys();
        while (keys.hasMoreElements()) {
            Rule r1;
            ObjectFlow of = this.objectFlow.get(keys.nextElement());
            int indxR1 = of.getIndexOfOutput();
            if (this.graph != null) {
                --indxR1;
            }
            if ((r1 = this.getRule(indxR1)) == null) continue;
            Object outSrc = of.getSourceOfOutput();
            Object inSrc = of.getSourceOfInput();
            Graph inG = ((Rule)inSrc).getLeft();
            Graph outG = ((Rule)outSrc).getRight();
            block1: for (Arc a : outG.getArcsCollection()) {
                if (this.completeNodesOF) {
                    Enumeration<GraphObject> gosL1;
                    Node inNode;
                    if (of.isOutputObject(a.getSource()) && !of.isOutputObject(a.getTarget())) {
                        inNode = (Node)of.getInput(a.getSource());
                        Iterator<Arc> outgoings = inNode.getOutgoingArcs();
                        while (outgoings.hasNext()) {
                            Arc outgoing = outgoings.next();
                            if (!outgoing.getTarget().getType().isParentOf(a.getTarget().getType())) continue;
                            Node goL1 = null;
                            gosL1 = r1.getInverseImage(a.getTarget());
                            if (gosL1.hasMoreElements()) {
                                goL1 = (Node)gosL1.nextElement();
                            }
                            if (goL1 == null) {
                                if (outgoing.getTarget().isAttrMemConstantValDifferent(a.getTarget())) continue;
                                of.addMapping(a.getTarget(), outgoing.getTarget());
                            } else {
                                if (outgoing.getTarget().isAttrMemConstantValDifferent(a.getTarget(), goL1)) continue;
                                of.addMapping(a.getTarget(), outgoing.getTarget());
                            }
                            break;
                        }
                    } else if (!of.isOutputObject(a.getSource()) && of.isOutputObject(a.getTarget())) {
                        inNode = (Node)of.getInput(a.getTarget());
                        Iterator<Arc> incomings = inNode.getIncomingArcs();
                        while (incomings.hasNext()) {
                            Arc incoming = incomings.next();
                            if (!incoming.getSource().getType().isParentOf(a.getSource().getType())) continue;
                            Node goL1 = null;
                            gosL1 = r1.getInverseImage(a.getSource());
                            if (gosL1.hasMoreElements()) {
                                goL1 = (Node)gosL1.nextElement();
                            }
                            if (goL1 == null) {
                                if (incoming.getSource().isAttrMemConstantValDifferent(a.getSource())) continue;
                                of.addMapping(a.getSource(), incoming.getSource());
                            } else {
                                if (incoming.getSource().isAttrMemConstantValDifferent(a.getSource(), goL1)) continue;
                                of.addMapping(a.getSource(), incoming.getSource());
                            }
                            break;
                        }
                    }
                }
                if (!of.isOutputObject(a.getSource()) || !of.isOutputObject(a.getTarget()) || of.isOutputObject(a)) continue;
                Node src = (Node)of.getInput(a.getSource());
                Node tar = (Node)of.getInput(a.getTarget());
                Vector<Arc> list = inG.getArcs(a.getType(), src, tar);
                if (list == null || list.isEmpty()) continue;
                int i = 0;
                while (i < list.size()) {
                    Arc a1 = (Arc)list.get(0);
                    if (a1.getType().isParentOf(a.getType())) {
                        Arc goL1 = null;
                        Enumeration<GraphObject> gosL1 = r1.getInverseImage(a);
                        if (gosL1.hasMoreElements()) {
                            goL1 = (Arc)gosL1.nextElement();
                        }
                        if (goL1 == null) {
                            if (!a1.isAttrMemConstantValDifferent(a)) {
                                of.addMapping(a, a1);
                                continue block1;
                            }
                        } else if (!a1.isAttrMemConstantValDifferent(a, goL1)) {
                            of.addMapping(a, a1);
                            continue block1;
                        }
                    }
                    ++i;
                }
            }
        }
    }

    private boolean isObjFlowPersistent(List<Triple<GraphObject, Rule, Integer>> closures) {
        int k = 0;
        while (k < closures.size() - 1) {
            Triple<GraphObject, Rule, Integer> triple = closures.get(k);
            GraphObject go1 = (GraphObject)triple.first;
            Rule r1 = (Rule)triple.second;
            int indx1 = (Integer)triple.third;
            int l = 1;
            while (l < closures.size()) {
                Triple<GraphObject, Rule, Integer> triple2 = closures.get(l);
                GraphObject go2 = (GraphObject)triple2.first;
                Rule r2 = (Rule)triple2.second;
                int indx2 = (Integer)triple2.third;
                if (go1 != go2) {
                    if (indx1 < indx2 && r1.getImage(go1) == null) {
                        return false;
                    }
                    if (indx2 < indx1 && r2.getImage(go2) == null) {
                        return false;
                    }
                }
                ++l;
            }
            ++k;
        }
        return true;
    }

    public static void printObjFlow(RuleSequence currentSequence) {
        System.out.println();
        Hashtable<String, ObjectFlow> objectFlows = currentSequence.getObjectFlow();
        int i = 0;
        while (i <= currentSequence.getRules().size() - 1) {
            int j = i + 1;
            while (j <= currentSequence.getRules().size()) {
                ObjectFlow of = objectFlows.get(String.valueOf(i) + ":" + j);
                if (of != null) {
                    System.out.println("Object flow:  " + i + ":" + j + "  from  " + of.getNameOfOutput() + "  to  " + of.getNameOfInput());
                    for (Object oneKey : of.getMapping().keySet()) {
                        GraphObject value = (GraphObject)of.getMapping().get(oneKey);
                        GraphObject key = (GraphObject)oneKey;
                        System.out.println("Map:  from  " + key.getObjectName() + ":" + key.getType().getName() + "  to  " + value.getObjectName() + ":" + value.getType().getName());
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    public void trimToSize() {
        this.rules.trimToSize();
        this.ruleNames.trimToSize();
        ((Vector)this.subSequenceList).trimToSize();
    }
}

