/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.examples.apibasics;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.henshin.examples.apibasics.boxing.Box;
import org.eclipse.emf.henshin.examples.apibasics.boxing.Boxing;
import org.eclipse.emf.henshin.examples.apibasics.boxing.BoxingPackage;
import org.eclipse.emf.henshin.interpreter.ApplicationMonitor;
import org.eclipse.emf.henshin.interpreter.EGraph;
import org.eclipse.emf.henshin.interpreter.Engine;
import org.eclipse.emf.henshin.interpreter.UnitApplication;
import org.eclipse.emf.henshin.interpreter.impl.EGraphImpl;
import org.eclipse.emf.henshin.interpreter.impl.EngineImpl;
import org.eclipse.emf.henshin.interpreter.impl.LoggingApplicationMonitor;
import org.eclipse.emf.henshin.interpreter.impl.UnitApplicationImpl;
import org.eclipse.emf.henshin.model.Module;
import org.eclipse.emf.henshin.model.resource.HenshinResourceSet;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class TestRule {
    private static final String BASEDIR = "src/org/eclipse/emf/henshin/examples/apibasics/models";
    private static Engine engine;
    private static Resource modelResource;
    private static EObject model;
    private static List<EObject> roots;
    private static Module module;
    private static UnitApplication unitApp;
    private static HenshinResourceSet rs;

    TestRule() {
    }

    @BeforeAll
    public static void setup() {
        rs = new HenshinResourceSet(BASEDIR);
        rs.getPackageRegistry().put((Object)BoxingPackage.eINSTANCE.getNsURI(), (Object)BoxingPackage.eINSTANCE);
        engine = new EngineImpl(new String[0]);
    }

    @BeforeEach
    public void resetUnitApp() {
        if (modelResource != null) {
            modelResource.unload();
        }
        rs.getResource("rulesStatic.henshin").unload();
        module = rs.getModule("rulesStatic.henshin");
        unitApp = new UnitApplicationImpl(engine);
    }

    @Test
    void testItemIsAlreadyStored() {
        modelResource = rs.getResource("../testModels/storedItem.xmi");
        roots = modelResource.getContents();
        unitApp.setEGraph((EGraph)new EGraphImpl(roots));
        unitApp.setUnit(module.getUnit("addItemToBox"));
        Assertions.assertFalse((boolean)unitApp.execute((ApplicationMonitor)new LoggingApplicationMonitor()));
    }

    @Test
    void testItemGetsStored() {
        modelResource = rs.getResource("../testModels/unstoredItem.xmi");
        roots = modelResource.getContents();
        unitApp.setEGraph((EGraph)new EGraphImpl(roots));
        unitApp.setUnit(module.getUnit("addItemToBox"));
        Assertions.assertTrue((boolean)unitApp.execute(null));
        Boxing boxing = (Boxing)unitApp.getEGraph().getRoots().get(0);
        Assertions.assertTrue((((Box)boxing.getBoxes().get(0)).getStores().get(0) == boxing.getItems().get(0) ? 1 : 0) != 0);
    }
}

