/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.ocl2ac.tool.commands;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import laxcondition.Condition;
import nestedcondition.NestedCondition;
import nestedcondition.NestedConstraint;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.henshin.model.And;
import org.eclipse.emf.henshin.model.Formula;
import org.eclipse.emf.henshin.model.HenshinFactory;
import org.eclipse.emf.henshin.model.Module;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.ocl2ac.gc2ac.core.Integrator;
import org.eclipse.emf.henshin.ocl2ac.gc2ac.core.Lefter;
import org.eclipse.emf.henshin.ocl2ac.ocl2gc.util.TranslatorResourceSet;
import org.eclipse.emf.henshin.ocl2ac.tool.commands.LaxCond2GCCommand;

public class LaxCond2AppCondCommand {
    private static final String HENSHIN = ".henshin";
    private IFile henshinFile = null;
    private Rule rule = null;
    private Condition compactCondition;
    public long translationTime = 0L;

    public LaxCond2AppCondCommand() {
    }

    public LaxCond2AppCondCommand(IFile henshinFile) {
        this.henshinFile = henshinFile;
    }

    public void integrateAndleft(Condition compactCondition, Rule rule) {
        if (rule != null) {
            this.rule = rule;
            this.compactCondition = compactCondition;
            Module module = rule.getModule();
            EcoreUtil.Copier copy = new EcoreUtil.Copier();
            Rule ruleCopyOriginal = (Rule)copy.copy((EObject)rule);
            copy.copyReferences();
            String UpdatedRuleName = String.valueOf(rule.getName()) + "_updated_" + compactCondition.getName();
            if (module.getUnit(UpdatedRuleName) != null) {
                Date date = new GregorianCalendar().getTime();
                SimpleDateFormat sdf = new SimpleDateFormat("yyMMddHHmmss");
                UpdatedRuleName = String.valueOf(UpdatedRuleName) + sdf.format(date);
            }
            rule.setName(UpdatedRuleName);
            long start = System.currentTimeMillis();
            LaxCond2GCCommand compactCondition2NGC = new LaxCond2GCCommand();
            NestedConstraint nestedConstraint = compactCondition2NGC.translate(compactCondition);
            Integrator integrator = new Integrator(nestedConstraint, rule);
            integrator.integrate();
            NestedCondition condition = integrator.getShiftedCondition();
            nestedConstraint.setDomain(condition.getDomain());
            nestedConstraint.setCondition(condition);
            Formula existingFormula = rule.getLhs().getFormula();
            Lefter lefter = new Lefter(rule);
            lefter.left();
            if (existingFormula != null) {
                And henshinAnd = HenshinFactory.eINSTANCE.createAnd();
                henshinAnd.setLeft(existingFormula);
                henshinAnd.setRight(rule.getLhs().getFormula());
                rule.getLhs().setFormula((Formula)henshinAnd);
            }
            long stop = System.currentTimeMillis();
            this.translationTime = stop - start;
            module.getUnits().add((Object)ruleCopyOriginal);
            this.persistTheUpdatedRuleInPlace(module);
        }
    }

    private void persistTheUpdatedRuleInPlace(Module module) {
        String path = this.henshinFile.getLocation().toOSString();
        TranslatorResourceSet resourceSet = new TranslatorResourceSet(path);
        resourceSet.saveEObject((EObject)module, path);
        try {
            this.henshinFile.getParent().refreshLocal(2, null);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }
}

