/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.ocl2ac.tool.commands;

import graph.GraphFactory;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import laxcondition.Condition;
import laxcondition.LaxCondition;
import laxcondition.LaxconditionFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.emf.henshin.ocl2ac.ocl2gc.core.Translator;
import org.eclipse.ocl.pivot.Constraint;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.Model;
import org.eclipse.ocl.pivot.PivotFactory;
import org.eclipse.ocl.pivot.PivotPackage;

public class OCL2LaxCondCommand
extends Translator {
    public HashMap<Condition, List<String>> mapCon2Var;

    public OCL2LaxCondCommand(IFile oclasFile, IFile ecoreFile) {
        this.oclasFile = oclasFile;
        this.ecoreFile = ecoreFile;
        this.invariants = new BasicEList();
        this.laxconditionFactory = LaxconditionFactory.eINSTANCE;
        this.mapCon2Var = new HashMap();
        this.graphFactory = GraphFactory.eINSTANCE;
        this.oclFactory = PivotFactory.eINSTANCE;
        this.varIndex = 1;
        this.initModels();
        this.prepareOCLModel();
        this.refactorOCLModel();
    }

    protected void initModels() {
        URI uriOclAS = URI.createPlatformResourceURI((String)this.oclasFile.getFullPath().toString(), (boolean)true);
        URI uriEcore = URI.createPlatformResourceURI((String)this.ecoreFile.getFullPath().toString(), (boolean)true);
        if (uriOclAS != null && uriEcore != null) {
            PivotPackage.eINSTANCE.eClass();
            Resource.Factory.Registry reg = Resource.Factory.Registry.INSTANCE;
            Map m = reg.getExtensionToFactoryMap();
            m.put("*.oclas", new XMIResourceFactoryImpl());
            ResourceSetImpl resSet = new ResourceSetImpl();
            Resource resourceOclAS = resSet.getResource(uriOclAS, true);
            this.oclModel = (Model)resourceOclAS.getContents().get(0);
            Resource resourceEcore = resSet.getResource(uriEcore, true);
            EPackage dynamicEPackage = (EPackage)resourceEcore.getContents().get(0);
            this.setTypeModel(EPackage.Registry.INSTANCE.getEPackage(dynamicEPackage.getNsURI()));
            if (this.getTypeModel() == null) {
                this.setTypeModel(dynamicEPackage);
            }
            System.out.println(this.getTypeModel());
        }
    }

    public List<Condition> getSetofLaxConditions() {
        long start = System.currentTimeMillis();
        new GregorianCalendar().getTime();
        ArrayList<Condition> arrayList = new ArrayList<Condition>();
        System.out.println("### The number of OCL Invariants is: " + this.invariants.size() + " ####");
        for (Constraint inv : this.invariants) {
            System.out.println("=====[ Invariant Name: " + inv.getName() + " ]=====");
            if (inv.getOwnedSpecification() == null) continue;
            ExpressionInOCL exprInOcl = null;
            exprInOcl = (ExpressionInOCL)inv.getOwnedSpecification();
            System.out.println("---[ Invariant Body: " + exprInOcl.getOwnedBody() + " ]---");
            if (exprInOcl.getOwnedBody() == null) continue;
            try {
                Condition condition = this.laxconditionFactory.createCondition();
                condition.setName(inv.getName());
                condition.setTypeGraph(this.getTypeModel());
                LaxCondition laxCondition = this.translate_I(inv);
                if (laxCondition == null) continue;
                condition.setLaxCondition(laxCondition);
                this.mapCon2Var.put(condition, this.varNames);
                this.varNames = new ArrayList();
                arrayList.add(condition);
            }
            catch (Exception e) {
                System.err.println("The OCL constraint " + inv.getName() + " is not well translated");
                System.out.println(e.getMessage());
            }
        }
        long stop = System.currentTimeMillis();
        System.out.println(stop - start);
        return arrayList;
    }
}

