/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.ocl2ac.utils.henshin.simplification;

import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.emf.henshin.interpreter.ApplicationMonitor;
import org.eclipse.emf.henshin.interpreter.EGraph;
import org.eclipse.emf.henshin.interpreter.Engine;
import org.eclipse.emf.henshin.interpreter.Match;
import org.eclipse.emf.henshin.interpreter.UnitApplication;
import org.eclipse.emf.henshin.interpreter.impl.EGraphImpl;
import org.eclipse.emf.henshin.interpreter.impl.EngineImpl;
import org.eclipse.emf.henshin.interpreter.impl.ProfilingApplicationMonitor;
import org.eclipse.emf.henshin.interpreter.impl.UnitApplicationImpl;
import org.eclipse.emf.henshin.interpreter.util.InterpreterUtil;
import org.eclipse.emf.henshin.model.Module;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.model.Unit;
import org.eclipse.emf.henshin.model.resource.HenshinResourceSet;

public class NasHenshinCommand {
    private EObject root;
    private Engine engine;
    private EGraph graph;
    private Module grammarModule;
    private String henshinFilePathName;
    private UnitApplication mainUnitApplication;
    private ProfilingApplicationMonitor monitor;

    public NasHenshinCommand(String henshinFilePathName, EObject root) {
        this.root = root;
        this.henshinFilePathName = henshinFilePathName;
        this.initGrammar();
    }

    private void initGrammar() {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
        URI uri = URI.createFileURI((String)this.henshinFilePathName);
        Resource resource = resourceSet.getResource(uri, true);
        this.grammarModule = (Module)resource.getContents().get(0);
        this.graph = new EGraphImpl(this.root);
        this.engine = new EngineImpl(new String[0]);
        this.engine.getOptions().put("DETERMINISTIC", false);
    }

    public UnitApplication prepareUnitApplication(Unit unit) {
        this.mainUnitApplication = new UnitApplicationImpl(this.engine, this.graph, unit, null);
        return this.mainUnitApplication;
    }

    public boolean run(Unit unit) {
        this.mainUnitApplication = new UnitApplicationImpl(this.engine, this.graph, unit, null);
        this.monitor = new ProfilingApplicationMonitor();
        return this.mainUnitApplication.execute((ApplicationMonitor)this.monitor);
    }

    public boolean run(UnitApplication mainUnitApplication) {
        this.monitor = new ProfilingApplicationMonitor();
        return mainUnitApplication.execute((ApplicationMonitor)this.monitor);
    }

    public void save() {
        HenshinResourceSet hrs = new HenshinResourceSet();
        hrs.saveEObject(this.getRoot(), this.getRoot().eResource().getURI());
    }

    public List<Match> findAllMatches(Rule rule) {
        return InterpreterUtil.findAllMatches((Engine)this.engine, (Rule)rule, (EGraph)this.graph, null);
    }

    public EObject getRoot() {
        return this.root;
    }

    public Module getGrammarModule() {
        return this.grammarModule;
    }
}

