/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.rulegen.matching;

import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.EMFCompare;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.scope.DefaultComparisonScope;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.henshin.rulegen.matching.IMatcher;
import org.eclipse.emf.henshin.rulegen.matching.Matching;

public class EMFCompareMatcherAdapter
implements IMatcher {
    private Matching matching;

    @Override
    public Matching createMatching(Resource modelA, Resource modelB) {
        this.matching = new Matching();
        DefaultComparisonScope emfScope = new DefaultComparisonScope((Notifier)modelA, (Notifier)modelB, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)emfScope);
        EList matches = comparison.getMatches();
        this.populateCorrespondences((EList<Match>)matches);
        return this.matching;
    }

    private void populateCorrespondences(EList<Match> matches) {
        for (Match match : matches) {
            this.populateCorrespondence(match);
        }
    }

    private void populateCorrespondence(Match match) {
        if (match.getLeft() != null && match.getRight() != null) {
            this.matching.addCorrespondence(match.getLeft(), match.getRight());
        }
        for (Match subMatch : match.getSubmatches()) {
            this.populateCorrespondence(subMatch);
        }
    }

    @Override
    public boolean canHandle(Resource modelA, Resource modelB) {
        return true;
    }
}

