/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.variability.mergein.mining.core;

import de.parsemis.Miner;
import de.parsemis.graph.Graph;
import de.parsemis.miner.general.Fragment;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.henshin.variability.mergein.mining.MiningManager;
import org.eclipse.emf.henshin.variability.mergein.mining.core.HenshinGraphToParsemisConverter;
import org.eclipse.emf.henshin.variability.mergein.mining.core.ParsemisParserSerializer;
import org.eclipse.emf.henshin.variability.mergein.mining.core.ResultFragmentSorter;
import org.eclipse.emf.henshin.variability.mergein.mining.labels.IEdgeLabel;
import org.eclipse.emf.henshin.variability.mergein.mining.labels.INodeLabel;
import org.eclipse.emf.henshin.variability.mergein.normalize.HenshinGraph;

public class TransformationSystemMiner {
    private MiningManager manager;

    public TransformationSystemMiner(MiningManager man) {
        this.manager = man;
    }

    public void createParsemisInputGraphs() {
        HenshinGraphToParsemisConverter minableGraphCreator = new HenshinGraphToParsemisConverter();
        for (HenshinGraph ruleGraph : this.manager.getRuleGraphs()) {
            Graph<INodeLabel, IEdgeLabel> parsemisGraph = minableGraphCreator.createParsemisGraph(ruleGraph);
            this.manager.addParsemisGraph(ruleGraph, parsemisGraph);
        }
    }

    public void doGraphMining() {
        if (this.manager.getSettings() == null) {
            return;
        }
        this.createParsemisInputGraphs();
        ArrayList<Graph<INodeLabel, IEdgeLabel>> graphs = new ArrayList<Graph<INodeLabel, IEdgeLabel>>();
        graphs.addAll(this.manager.getParsemisGraphs());
        Collection minedFragmentsCollection = Miner.mine(graphs, this.manager.getSettings());
        this.manager.setMinedFragments(new ArrayList<Fragment<INodeLabel, IEdgeLabel>>());
        this.manager.getMinedFragments().addAll(minedFragmentsCollection);
        ResultFragmentSorter.sort(this.manager.getMinedFragments());
        if (this.manager.getMinedFragments() != null && this.manager.getMinedFragments().size() != 0) {
            ParsemisParserSerializer ser = new ParsemisParserSerializer();
            for (Fragment<INodeLabel, IEdgeLabel> fragment : this.manager.getMinedFragments()) {
                ser.serialize((Graph<INodeLabel, IEdgeLabel>)fragment.toGraph());
            }
        } else {
            System.err.println("\tThere were no frequent subgraphs found.");
        }
    }
}

