/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.examples.java2statemachine;

import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.henshin.interpreter.EGraph;
import org.eclipse.emf.henshin.interpreter.Engine;
import org.eclipse.emf.henshin.interpreter.UnitApplication;
import org.eclipse.emf.henshin.interpreter.impl.EGraphImpl;
import org.eclipse.emf.henshin.interpreter.impl.EngineImpl;
import org.eclipse.emf.henshin.interpreter.impl.UnitApplicationImpl;
import org.eclipse.emf.henshin.interpreter.util.InterpreterUtil;
import org.eclipse.emf.henshin.model.Module;
import org.eclipse.emf.henshin.model.resource.HenshinResourceSet;

public class Java2StateMachine {
    public static final String PATH = "src/org/eclipse/emf/henshin/examples/java2statemachine";
    public static final String JAVA_MODEL_SMALL = "1-java-model-small.xmi";
    public static final String JAVA_MODEL_MEDIUM = "2-java-model-medium.xmi";
    public static final String JAVA_MODEL_BIG = "3-java-model-big.xmi";
    public static final String REFERENCE_STATE_MACHINE = "reference-statemachine.xmi";

    public static void run(String path, String javaModel, String referenceModel, boolean saveResult) {
        System.out.println("Loading Java2StateMachine transformation...");
        HenshinResourceSet resourceSet = new HenshinResourceSet(path);
        Module module = resourceSet.getModule("java2statemachine.henshin", false);
        EObject rootPackage = null;
        List compilationUnits = null;
        for (EPackage imported : module.getImports()) {
            if (!"containers".equals(imported.getName())) continue;
            EClass packageClass = (EClass)imported.getEClassifier("Package");
            rootPackage = imported.getEFactoryInstance().create(packageClass);
            EReference ref = (EReference)packageClass.getEStructuralFeature("compilationUnits");
            compilationUnits = (List)rootPackage.eGet((EStructuralFeature)ref);
            break;
        }
        System.out.println("Loading Java input model in '" + javaModel + "'");
        Resource javaResource = resourceSet.getResource(javaModel);
        for (EObject object : javaResource.getContents()) {
            if (!"CompilationUnit".equals(object.eClass().getName())) continue;
            compilationUnits.add(object);
        }
        EGraphImpl graph = new EGraphImpl(rootPackage);
        System.out.println("Model has " + graph.size() + " objects");
        EngineImpl engine = new EngineImpl(new String[0]);
        engine.getOptions().put("SORT_VARIABLES", false);
        UnitApplicationImpl unitApp = new UnitApplicationImpl((Engine)engine);
        unitApp.setEGraph((EGraph)graph);
        unitApp.setUnit(module.getUnit("Start"));
        System.out.println("Generating state machine...");
        long time = System.currentTimeMillis();
        InterpreterUtil.executeOrDie((UnitApplication)unitApp);
        time = System.currentTimeMillis() - time;
        System.out.println("Generation took " + time + "ms.");
        EObject statemachine = (EObject)unitApp.getResultParameterValue("sm");
        if (saveResult) {
            resourceSet.saveEObject(statemachine, "generated-statemachine.xmi");
            System.out.println("Saved generated state machine in 'generated-statemachine.xmi'");
        } else {
            ResourceImpl dummyResource = new ResourceImpl();
            dummyResource.getContents().add((Object)statemachine);
        }
        if (referenceModel != null) {
            Resource reference = resourceSet.getResource(REFERENCE_STATE_MACHINE);
            if (InterpreterUtil.areIsomorphic((Resource)reference, (Resource)statemachine.eResource())) {
                System.out.println("Generated state machine is correct.");
            } else {
                throw new AssertionError((Object)"Generated state machine is not correct!");
            }
        }
    }

    public static void main(String[] args) {
        Java2StateMachine.run(PATH, JAVA_MODEL_SMALL, REFERENCE_STATE_MACHINE, false);
    }
}

