/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.examples.javaimports;

import java.util.Iterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.henshin.interpreter.EGraph;
import org.eclipse.emf.henshin.interpreter.Engine;
import org.eclipse.emf.henshin.interpreter.UnitApplication;
import org.eclipse.emf.henshin.interpreter.impl.EGraphImpl;
import org.eclipse.emf.henshin.interpreter.impl.EngineImpl;
import org.eclipse.emf.henshin.interpreter.impl.RuleApplicationImpl;
import org.eclipse.emf.henshin.interpreter.util.InterpreterUtil;
import org.eclipse.emf.henshin.model.Module;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.model.resource.HenshinResourceSet;

public class JavaImportsExample {
    public static final String PATH = "src/org/eclipse/emf/henshin/examples/javaimports";

    public static void run(String path) {
        HenshinResourceSet resourceSet = new HenshinResourceSet(path);
        Module module = resourceSet.getModule("javaimports.henshin", false);
        EGraphImpl graph = new EGraphImpl();
        Thread thread = Thread.currentThread();
        thread.setContextClassLoader((ClassLoader)new InterpreterUtil.DelegatingClassLoader(thread.getContextClassLoader(), new ClassLoader[]{JavaImportsExample.class.getClassLoader()}));
        EngineImpl engine = new EngineImpl(new String[0]);
        RuleApplicationImpl app = new RuleApplicationImpl((Engine)engine, (EGraph)graph, (Rule)module.getUnit("simple"), null);
        String value = "hello world";
        app.setParameterValue("x", (Object)value);
        InterpreterUtil.executeOrDie((UnitApplication)app);
        Iterator graphIt = graph.iterator();
        EObject newObj = null;
        if (graphIt.hasNext()) {
            newObj = (EObject)graphIt.next();
        }
        if (newObj == null) {
            throw new RuntimeException("Unexpected result of rule application: no graph node was created (expected one node)");
        }
        String newValue = (String)newObj.eGet(newObj.eClass().getEStructuralFeature("stringValue"));
        if (!newValue.equals(value.toUpperCase())) {
            throw new RuntimeException("Unexpected string value: \"" + newValue + "\" (expected \"" + value.toUpperCase() + "\")");
        }
        System.out.println("Java Imports Example: Found correct value: \"" + newValue + "\"");
    }

    public static void main(String[] args) {
        JavaImportsExample.run(PATH);
    }
}

