/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.ocl2ac.utils.henshin.simplification;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.henshin.interpreter.Match;
import org.eclipse.emf.henshin.model.And;
import org.eclipse.emf.henshin.model.Attribute;
import org.eclipse.emf.henshin.model.BinaryFormula;
import org.eclipse.emf.henshin.model.Edge;
import org.eclipse.emf.henshin.model.Graph;
import org.eclipse.emf.henshin.model.NestedCondition;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Not;
import org.eclipse.emf.henshin.model.Or;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.model.UnaryFormula;
import org.eclipse.emf.henshin.ocl2ac.utils.Activator;
import org.eclipse.emf.henshin.ocl2ac.utils.henshin.simplification.NasHenshinCommand;
import org.osgi.framework.Bundle;

public class HenshinNACSimplifier {
    private static final String PATTERN_HENSHIN_RELATIVE_PATH_NAME = "pattern/patterns.henshin";
    private static final String PATTERN_HENSHIN_PATH_NAME = HenshinNACSimplifier.getFullPath("pattern/patterns.henshin");
    private static final String FIND_NC_GR_OR = "find_NC_GR_OR";
    private static final String FIND_NC_GR_NOT_OR = "find_NC_GR_NOT_OR";
    private static final String FIND_NOTNOT = "find_NotNot";
    private static final String FIND_NC_GR_AND = "find_NC_GR_AND";
    private static final String FIND_NC_GR_NOT_AND = "find_NC_GR_NOT_AND";
    private static ArrayList<Graph> lsAndGraphs = new ArrayList();
    private static ArrayList<Graph> lsOrGraphs = new ArrayList();

    public static void simplifyOrGraphsInAC(Rule rule) {
        NasHenshinCommand henCmd = new NasHenshinCommand(PATTERN_HENSHIN_PATH_NAME, (EObject)rule.getLhs().getFormula());
        Rule rulePattern = (Rule)henCmd.getGrammarModule().getUnit(FIND_NC_GR_OR);
        List<Match> matches = henCmd.findAllMatches(rulePattern);
        Iterator<Match> iterator = matches.iterator();
        HenshinNACSimplifier.markAndRemoveUnwantedGraphsInOr(rulePattern, iterator);
        Rule rulePattern2 = (Rule)henCmd.getGrammarModule().getUnit(FIND_NC_GR_NOT_OR);
        List<Match> matches2 = henCmd.findAllMatches(rulePattern2);
        Iterator<Match> iterator2 = matches2.iterator();
        HenshinNACSimplifier.markAndRemoveUnwantedGraphsInOr(rulePattern2, iterator2);
    }

    public static void simplifyAndGraphsInAC(Rule rule) {
        NasHenshinCommand henCmd = new NasHenshinCommand(PATTERN_HENSHIN_PATH_NAME, (EObject)rule.getLhs().getFormula());
        Rule rulePattern = (Rule)henCmd.getGrammarModule().getUnit(FIND_NC_GR_AND);
        List<Match> matches = henCmd.findAllMatches(rulePattern);
        Iterator<Match> iterator = matches.iterator();
        HenshinNACSimplifier.markAndRemoveUnwantedGraphsInAnd(rulePattern, iterator);
        Rule rulePattern2 = (Rule)henCmd.getGrammarModule().getUnit(FIND_NC_GR_NOT_AND);
        List<Match> matches2 = henCmd.findAllMatches(rulePattern2);
        Iterator<Match> iterator2 = matches2.iterator();
        HenshinNACSimplifier.markAndRemoveUnwantedGraphsInAnd(rulePattern2, iterator2);
    }

    public static void eliminateNotNotFromNAC(Rule rule) {
        NasHenshinCommand henCmd = new NasHenshinCommand(PATTERN_HENSHIN_PATH_NAME, (EObject)rule.getLhs().getFormula());
        Rule rulePattern3 = (Rule)henCmd.getGrammarModule().getUnit(FIND_NOTNOT);
        List<Match> matches3 = henCmd.findAllMatches(rulePattern3);
        for (Match match : matches3) {
            Not outerNot = (Not)match.getParameterValue(rulePattern3.getParameter("outerNot"));
            Not innerNot = (Not)match.getParameterValue(rulePattern3.getParameter("innerNot"));
            if (outerNot.eContainer() instanceof Graph) {
                ((Graph)outerNot.eContainer()).setFormula(innerNot.getChild());
                continue;
            }
            if (!(outerNot.eContainer() instanceof BinaryFormula)) continue;
            BinaryFormula binaryFormula = (BinaryFormula)outerNot.eContainer();
            if (binaryFormula.getLeft() == outerNot) {
                binaryFormula.setLeft(innerNot.getChild());
                continue;
            }
            if (binaryFormula.getRight() != outerNot) continue;
            binaryFormula.setRight(innerNot.getChild());
        }
    }

    private static void markAndRemoveUnwantedGraphsInOr(Rule rulePattern, Iterator<Match> iterator) {
        while (iterator.hasNext()) {
            Match match = iterator.next();
            Or orContainer = (Or)match.getParameterValue(rulePattern.getParameter("paramOR"));
            lsOrGraphs.clear();
            HenshinNACSimplifier.collecGraphsOfOnlyORs(orContainer);
            if (lsOrGraphs.size() <= 0) continue;
            int i = 0;
            while (i < lsOrGraphs.size() - 1) {
                int j = i + 1;
                while (j < lsOrGraphs.size()) {
                    if (HenshinNACSimplifier.isSubGraph(lsOrGraphs.get(i), lsOrGraphs.get(j))) {
                        System.out.println(String.valueOf(lsOrGraphs.get(i).getName()) + " is subgraphof " + lsOrGraphs.get(j).getName());
                        lsOrGraphs.set(j, null);
                    } else if (HenshinNACSimplifier.isSubGraph(lsOrGraphs.get(j), lsOrGraphs.get(i))) {
                        System.out.println(String.valueOf(lsOrGraphs.get(j).getName()) + " is subgraphof " + lsOrGraphs.get(i).getName());
                        lsOrGraphs.set(i, null);
                        break;
                    }
                    ++j;
                }
                ++i;
            }
            lsOrGraphs.removeIf(Objects::isNull);
            HenshinNACSimplifier.removeMarkedGraphs(orContainer);
        }
    }

    private static void markAndRemoveUnwantedGraphsInAnd(Rule rulePattern, Iterator<Match> iterator) {
        while (iterator.hasNext()) {
            Match match = iterator.next();
            And andContainer = (And)match.getParameterValue(rulePattern.getParameter("paramAND"));
            lsAndGraphs.clear();
            HenshinNACSimplifier.collecGraphsOfOnlyANDs(andContainer);
            if (lsAndGraphs.size() <= 0) continue;
            int i = 0;
            while (i < lsAndGraphs.size() - 1) {
                int j = i + 1;
                while (j < lsAndGraphs.size()) {
                    if (HenshinNACSimplifier.isSubGraph(lsAndGraphs.get(i), lsAndGraphs.get(j))) {
                        System.out.println(String.valueOf(lsAndGraphs.get(i).getName()) + " is subgraphof " + lsAndGraphs.get(j).getName());
                        lsAndGraphs.set(i, null);
                        break;
                    }
                    if (HenshinNACSimplifier.isSubGraph(lsAndGraphs.get(j), lsAndGraphs.get(i))) {
                        System.out.println(String.valueOf(lsAndGraphs.get(j).getName()) + " is subgraphof " + lsAndGraphs.get(i).getName());
                        lsAndGraphs.set(j, null);
                    }
                    ++j;
                }
                ++i;
            }
            lsAndGraphs.removeIf(Objects::isNull);
            HenshinNACSimplifier.removeMarkedGraphs(andContainer);
        }
    }

    private static void collecGraphsOfOnlyORs(Or or) {
        Graph conclusion;
        Graph conclusion2;
        if (or.getLeft() instanceof Or) {
            HenshinNACSimplifier.collecGraphsOfOnlyORs((Or)or.getLeft());
        } else if (or.getLeft() instanceof NestedCondition) {
            NestedCondition leftNC = (NestedCondition)or.getLeft();
            conclusion2 = leftNC.getConclusion();
            lsOrGraphs.add(conclusion2);
        } else if (or.getLeft() instanceof UnaryFormula) {
            Not left = (Not)or.getLeft();
            if (left.getChild() instanceof NestedCondition) {
                NestedCondition leftNC = (NestedCondition)left.getChild();
                conclusion = leftNC.getConclusion();
                lsOrGraphs.add(conclusion);
            }
        } else {
            lsOrGraphs.clear();
            return;
        }
        if (or.getRight() instanceof Or) {
            HenshinNACSimplifier.collecGraphsOfOnlyORs((Or)or.getRight());
        } else if (or.getLeft() instanceof NestedCondition) {
            NestedCondition rightNC = (NestedCondition)or.getRight();
            conclusion2 = rightNC.getConclusion();
            lsOrGraphs.add(conclusion2);
        } else if (or.getRight() instanceof UnaryFormula) {
            Not right = (Not)or.getRight();
            if (right.getChild() instanceof NestedCondition) {
                NestedCondition rightNC = (NestedCondition)right.getChild();
                conclusion = rightNC.getConclusion();
                lsOrGraphs.add(conclusion);
            }
        } else {
            lsOrGraphs.clear();
            return;
        }
    }

    private static void collecGraphsOfOnlyANDs(And and) {
        Graph conclusion;
        Graph conclusion2;
        if (and.getLeft() instanceof And) {
            HenshinNACSimplifier.collecGraphsOfOnlyANDs((And)and.getLeft());
        } else if (and.getLeft() instanceof NestedCondition) {
            NestedCondition leftNC = (NestedCondition)and.getLeft();
            conclusion2 = leftNC.getConclusion();
            lsAndGraphs.add(conclusion2);
        } else if (and.getLeft() instanceof UnaryFormula) {
            Not left = (Not)and.getLeft();
            if (left.getChild() instanceof NestedCondition) {
                NestedCondition leftNC = (NestedCondition)left.getChild();
                conclusion = leftNC.getConclusion();
                lsAndGraphs.add(conclusion);
            }
        } else {
            lsAndGraphs.clear();
            return;
        }
        if (and.getRight() instanceof And) {
            HenshinNACSimplifier.collecGraphsOfOnlyANDs((And)and.getRight());
        } else if (and.getLeft() instanceof NestedCondition) {
            NestedCondition rightNC = (NestedCondition)and.getRight();
            conclusion2 = rightNC.getConclusion();
            lsAndGraphs.add(conclusion2);
        } else if (and.getRight() instanceof UnaryFormula) {
            Not right = (Not)and.getRight();
            if (right.getChild() instanceof NestedCondition) {
                NestedCondition rightNC = (NestedCondition)right.getChild();
                conclusion = rightNC.getConclusion();
                lsAndGraphs.add(conclusion);
            }
        } else {
            lsAndGraphs.clear();
            return;
        }
    }

    private static void removeMarkedGraphs(Or or) {
        NestedCondition rightNC;
        Not right;
        NestedCondition leftNC;
        Graph conclusion;
        Not left;
        Graph conclusion2;
        if (or.getLeft() instanceof Or) {
            HenshinNACSimplifier.collecGraphsOfOnlyORs((Or)or.getLeft());
        } else if (or.getLeft() instanceof NestedCondition) {
            NestedCondition leftNC2 = (NestedCondition)or.getLeft();
            conclusion2 = leftNC2.getConclusion();
            if (!lsOrGraphs.contains(conclusion2)) {
                or.setLeft(null);
                HenshinNACSimplifier.refactorLeftChild((BinaryFormula)or);
            }
        } else if (or.getLeft() instanceof UnaryFormula && (left = (Not)or.getLeft()).getChild() instanceof NestedCondition && !lsOrGraphs.contains(conclusion = (leftNC = (NestedCondition)left.getChild()).getConclusion())) {
            or.setLeft(null);
            HenshinNACSimplifier.refactorLeftChild((BinaryFormula)or);
        }
        if (or.getRight() instanceof Or) {
            HenshinNACSimplifier.collecGraphsOfOnlyORs((Or)or.getRight());
        } else if (or.getLeft() instanceof NestedCondition) {
            NestedCondition rightNC2 = (NestedCondition)or.getRight();
            conclusion2 = rightNC2.getConclusion();
            if (!lsOrGraphs.contains(conclusion2)) {
                or.setRight(null);
                HenshinNACSimplifier.refactorRightChild((BinaryFormula)or);
            }
        } else if (or.getRight() instanceof UnaryFormula && (right = (Not)or.getRight()).getChild() instanceof NestedCondition && !lsOrGraphs.contains(conclusion = (rightNC = (NestedCondition)right.getChild()).getConclusion())) {
            or.setRight(null);
            HenshinNACSimplifier.refactorRightChild((BinaryFormula)or);
        }
    }

    private static void removeMarkedGraphs(And and) {
        NestedCondition rightNC;
        Not right;
        NestedCondition leftNC;
        Graph conclusion;
        Not left;
        Graph conclusion2;
        if (and.getLeft() instanceof And) {
            HenshinNACSimplifier.collecGraphsOfOnlyANDs((And)and.getLeft());
        } else if (and.getLeft() instanceof NestedCondition) {
            NestedCondition leftNC2 = (NestedCondition)and.getLeft();
            conclusion2 = leftNC2.getConclusion();
            if (!lsAndGraphs.contains(conclusion2)) {
                and.setLeft(null);
                HenshinNACSimplifier.refactorLeftChild((BinaryFormula)and);
            }
        } else if (and.getLeft() instanceof UnaryFormula && (left = (Not)and.getLeft()).getChild() instanceof NestedCondition && !lsAndGraphs.contains(conclusion = (leftNC = (NestedCondition)left.getChild()).getConclusion())) {
            and.setLeft(null);
            HenshinNACSimplifier.refactorLeftChild((BinaryFormula)and);
        }
        if (and.getRight() instanceof And) {
            HenshinNACSimplifier.collecGraphsOfOnlyANDs((And)and.getRight());
        } else if (and.getLeft() instanceof NestedCondition) {
            NestedCondition rightNC2 = (NestedCondition)and.getRight();
            conclusion2 = rightNC2.getConclusion();
            if (!lsAndGraphs.contains(conclusion2)) {
                and.setRight(null);
                HenshinNACSimplifier.refactorRightChild((BinaryFormula)and);
            }
        } else if (and.getRight() instanceof UnaryFormula && (right = (Not)and.getRight()).getChild() instanceof NestedCondition && !lsAndGraphs.contains(conclusion = (rightNC = (NestedCondition)right.getChild()).getConclusion())) {
            and.setRight(null);
            HenshinNACSimplifier.refactorRightChild((BinaryFormula)and);
        }
    }

    private static void refactorRightChild(BinaryFormula bnf) {
        if (bnf.eContainer() instanceof Graph) {
            Graph gc = (Graph)bnf.eContainer();
            gc.setFormula(bnf.getLeft());
        } else if (bnf.eContainer() instanceof BinaryFormula) {
            BinaryFormula conf = (BinaryFormula)bnf.eContainer();
            if (conf.getLeft() == bnf) {
                conf.setLeft(bnf.getLeft());
            } else if (conf.getRight() == bnf) {
                conf.setRight(bnf.getLeft());
            }
        } else if (bnf.eContainer() instanceof Not) {
            Not not = (Not)bnf.eContainer();
            not.setChild(bnf.getLeft());
        }
    }

    private static void refactorLeftChild(BinaryFormula bnf) {
        if (bnf.eContainer() instanceof Graph) {
            Graph gc = (Graph)bnf.eContainer();
            gc.setFormula(bnf.getRight());
        } else if (bnf.eContainer() instanceof BinaryFormula) {
            BinaryFormula b = (BinaryFormula)bnf.eContainer();
            if (b.getLeft() == bnf) {
                b.setLeft(bnf.getRight());
            } else if (b.getRight() == bnf) {
                b.setRight(bnf.getRight());
            }
        } else if (bnf.eContainer() instanceof Not) {
            Not not = (Not)bnf.eContainer();
            not.setChild(bnf.getRight());
        }
    }

    private static Attribute getBy(Attribute a, EList<Attribute> ls) {
        for (Attribute b : ls) {
            if (b.getType() != a.getType() || b.getValue() != a.getValue()) continue;
            return b;
        }
        return null;
    }

    public static boolean isSubGraph(Graph graphA, Graph graphB) {
        HashMap<Node, Node> mappingNodeA2NodeB = new HashMap<Node, Node>();
        for (Node nodeA : graphA.getNodes()) {
            for (Node nodeB : graphB.getNodes()) {
                if (nodeA.getType() != nodeB.getType() || !HenshinNACSimplifier.getNames(nodeB.getName()).containsAll(HenshinNACSimplifier.getNames(nodeA.getName())) || !nodeB.getAttributes().containsAll((Collection)nodeA.getAttributes())) continue;
                boolean attISO = true;
                for (Attribute a : nodeA.getAttributes()) {
                    if (HenshinNACSimplifier.getBy(a, (EList<Attribute>)nodeB.getAttributes()) != null) continue;
                    attISO = false;
                }
                if (!attISO) continue;
                mappingNodeA2NodeB.put(nodeA, nodeB);
            }
        }
        if (graphA.getNodes().size() != mappingNodeA2NodeB.size()) {
            return false;
        }
        for (Edge edgeA : graphA.getEdges()) {
            Node srcEdgeA = edgeA.getSource();
            Node tgtEdgeA = edgeA.getTarget();
            boolean edgeIsMapped = false;
            for (Edge edgeB : graphB.getEdges()) {
                Node srcEdgeB = edgeB.getSource();
                Node tgtEdgeB = edgeB.getTarget();
                if (edgeA.getType() != edgeB.getType() || mappingNodeA2NodeB.get(srcEdgeA) != srcEdgeB || mappingNodeA2NodeB.get(tgtEdgeA) != tgtEdgeB) continue;
                edgeIsMapped = true;
                break;
            }
            if (edgeIsMapped) continue;
            return false;
        }
        return true;
    }

    private static List<String> getNames(String name) {
        String[] names = name.split("=");
        return Arrays.asList(names);
    }

    private static String getFullPath(String path) {
        URL url = FileLocator.find((Bundle)Activator.getDefault().getBundle(), (IPath)new Path(path), (Map)Collections.EMPTY_MAP);
        URL fileUrl = null;
        try {
            fileUrl = FileLocator.toFileURL((URL)url);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return fileUrl.getPath();
    }
}

