/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.statespace.external.prism;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.statespace.State;
import org.eclipse.emf.henshin.statespace.StateSpace;
import org.eclipse.emf.henshin.statespace.StateSpaceIndex;
import org.eclipse.emf.henshin.statespace.StateSpacePlugin;
import org.eclipse.emf.henshin.statespace.StateValidator;
import org.eclipse.emf.henshin.statespace.Validator;

public class PRISMUtil {
    public static final String STATE_VARIABLE = "s";
    public static final String PRISM_PATH_KEY = "prismPath";
    public static final String PRISM_ARGS_KEY = "prismArgs";
    public static final String PRISM_EXPERIMENT_KEY = "prismExperiment";

    protected static Process invokePRISM(StateSpace stateSpace, File modelFile, File formulaFile, String[] args, Map<String, String> constants, boolean allowExperiments, IProgressMonitor monitor) throws Exception {
        String arg;
        int n;
        Object object;
        File path = PRISMUtil.getPRISMPath(stateSpace);
        String baseArgs = PRISMUtil.getPRISMArgs(stateSpace);
        ArrayList<String> command = new ArrayList<String>();
        command.add(path != null ? new File(String.valueOf(path.getAbsolutePath()) + File.separator + "prism").getAbsolutePath() : "prism");
        if (modelFile.getName().endsWith(".tra")) {
            command.add("-importtrans");
            command.add(modelFile.getAbsolutePath());
            command.add("-importstates");
            command.add(modelFile.getAbsolutePath().replaceAll(".tra", ".sta"));
        } else {
            command.add(modelFile.getAbsolutePath());
        }
        if (formulaFile != null) {
            command.add(formulaFile.getAbsolutePath());
        }
        if (baseArgs != null) {
            object = baseArgs.split(" ");
            int n2 = ((String[])object).length;
            n = 0;
            while (n < n2) {
                arg = object[n];
                command.add(arg.trim());
                ++n;
            }
        }
        if (args != null) {
            object = args;
            int n2 = args.length;
            n = 0;
            while (n < n2) {
                arg = object[n];
                command.add(arg.trim());
                ++n;
            }
        }
        String cons = "";
        if (constants != null && !constants.isEmpty()) {
            boolean first = true;
            for (Map.Entry entry : constants.entrySet()) {
                if (!first) {
                    cons = String.valueOf(cons) + ",";
                }
                if (!Range.isRange((String)entry.getValue())) continue;
                cons = String.valueOf(cons) + (String)entry.getKey() + "=" + (String)entry.getValue();
                first = false;
            }
        }
        if (cons.length() > 0) {
            command.add("-const");
            command.add(cons);
        }
        File script = new File(String.valueOf(modelFile.getParentFile().getAbsolutePath()) + File.separator + "last-prism-command.sh");
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(script)));
        bufferedWriter.write("#!/bin/bash\n\n");
        for (String item : command) {
            bufferedWriter.write(String.valueOf(item) + " ");
        }
        bufferedWriter.write("\n");
        bufferedWriter.close();
        script.setExecutable(true);
        return Runtime.getRuntime().exec(command.toArray(new String[0]), null, path);
    }

    public static String expandLabels(String template, StateSpaceIndex index, IProgressMonitor monitor) throws Exception {
        int sections = -1;
        String dummy1 = template;
        String dummy2 = template;
        do {
            dummy1 = dummy2;
            dummy2 = dummy2.replaceFirst("<<<", "xxx");
            ++sections;
        } while (!dummy1.equals(dummy2));
        monitor.beginTask("Expanding labels...", sections);
        int i = 0;
        while (i < sections) {
            template = PRISMUtil.doExpandLabels(template, index, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            ++i;
        }
        monitor.done();
        return template;
    }

    private static String doExpandLabels(String template, StateSpaceIndex index, IProgressMonitor monitor) throws Exception {
        int propStart;
        int start = template.indexOf("<<<");
        if (start < 0) {
            return template;
        }
        int end = template.indexOf(">>>", start);
        end = end < 0 ? template.length() : (end += 3);
        String toReplace = template.substring(start, end);
        String type = "";
        int i = propStart = 3;
        while (i < toReplace.length()) {
            if (Character.isWhitespace(toReplace.charAt(i))) break;
            type = String.valueOf(type) + toReplace.charAt(i);
            ++i;
        }
        if (type.endsWith(":")) {
            type = type.substring(0, type.length() - 1);
            ++propStart;
        }
        StateValidator validator = null;
        for (Validator v : StateSpacePlugin.INSTANCE.getValidators().values()) {
            if (!v.getName().startsWith(type) || !(v instanceof StateValidator)) continue;
            validator = (StateValidator)v;
            break;
        }
        if (validator == null) {
            throw new RuntimeException("Unknown validator \"" + type + "\"");
        }
        String theProperty = toReplace.substring(propStart + type.length(), toReplace.length() - 3).trim();
        validator.setStateSpaceIndex(index);
        validator.setProperty(theProperty);
        String result = "";
        NullProgressMonitor nullMonitor = new NullProgressMonitor();
        monitor.beginTask("Expanding labels...", index.getStateSpace().getStateCount());
        AbstractList targets = new ArrayList<State>();
        int steps = 0;
        for (State state : index.getStateSpace().getStates()) {
            if (validator.validate(state, (IProgressMonitor)nullMonitor).isValid()) {
                targets.add(state);
            }
            if (steps++ % 5000 == 0) {
                index.clearCache();
            }
            monitor.worked(1);
            if (!monitor.isCanceled()) continue;
            return template;
        }
        if (targets.size() == 0) {
            result = "false";
        } else if (targets.size() == index.getStateSpace().getStateCount()) {
            result = "true";
        } else {
            boolean negate;
            boolean bl = negate = targets.size() > index.getStateSpace().getStateCount() / 2;
            if (negate) {
                Vector negated = new Vector(index.getStateSpace().getStates());
                negated.removeAll(targets);
                targets = negated;
            }
            for (State state : targets) {
                if (result.length() > 0) {
                    result = String.valueOf(result) + " | ";
                }
                result = String.valueOf(result) + PRISMUtil.getPRISMState(state.getIndex(), null, false);
                if (!monitor.isCanceled()) continue;
                return template;
            }
            if (negate) {
                result = "!(" + result + ")";
            }
        }
        String expanded = String.valueOf(template.substring(0, start)) + result + template.substring(end);
        monitor.done();
        return expanded;
    }

    public static String getRateKey(Rule rule) {
        return "rate" + PRISMUtil.capitalize(PRISMUtil.removeWhiteSpace(rule.getName()));
    }

    public static String getRate(StateSpace stateSpace, Rule rule) {
        String rate = (String)stateSpace.getProperties().get((Object)PRISMUtil.getRateKey(rule));
        if (rate != null && rate.trim().length() == 0) {
            rate = null;
        }
        return rate;
    }

    public static Range getRateAsRange(StateSpace stateSpace, Rule rule) throws ParseException {
        String value = PRISMUtil.getRate(stateSpace, rule);
        return value != null ? new Range(value) : null;
    }

    public static Map<String, String> getAllRates(StateSpace stateSpace, boolean force) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Rule rule : stateSpace.getRules()) {
            String key = PRISMUtil.getRateKey(rule);
            String value = PRISMUtil.getRate(stateSpace, rule);
            if (value != null) {
                map.put(key, value);
                continue;
            }
            if (!force) continue;
            throw new RuntimeException("State space property \"" + key + "\" must be specified.");
        }
        return map;
    }

    public static String getProbKey(Rule rule, int index) {
        return "prob" + PRISMUtil.capitalize(PRISMUtil.removeWhiteSpace(rule.getName())) + (index + 1);
    }

    public static String getProbVar(int index) {
        return "p" + (index + 1);
    }

    public static String getProb(StateSpace stateSpace, Rule rule, int index) {
        String prob = (String)stateSpace.getProperties().get((Object)PRISMUtil.getProbKey(rule, index));
        if (prob != null && prob.trim().length() == 0) {
            prob = null;
        }
        return prob;
    }

    public static Range getProbAsRange(StateSpace stateSpace, Rule rule, int index) throws ParseException {
        String value = PRISMUtil.getProb(stateSpace, rule, index);
        return value != null ? new Range(value) : null;
    }

    public static Map<String, String> getAllProbs(StateSpace stateSpace, boolean force) {
        HashMap<String, String> map = new HashMap<String, String>();
        Map<String, List<Rule>> probRules = PRISMUtil.getProbabilisticRules(stateSpace);
        for (String ruleName : probRules.keySet()) {
            List<Rule> rules = probRules.get(ruleName);
            if (rules.size() <= 1) continue;
            int i = 0;
            while (i < rules.size()) {
                String key = PRISMUtil.getProbKey(rules.get(i), i);
                String value = PRISMUtil.getProb(stateSpace, rules.get(i), i);
                if (value != null && value.trim().length() > 0) {
                    map.put(key, value);
                } else if (force) {
                    throw new RuntimeException("State space property \"" + key + "\" must be specified.");
                }
                ++i;
            }
        }
        return map;
    }

    public static Map<String, List<Rule>> getProbabilisticRules(StateSpace stateSpace) {
        LinkedHashMap<String, List<Rule>> probRules = new LinkedHashMap<String, List<Rule>>();
        for (Rule rule : stateSpace.getRules()) {
            ArrayList<Rule> rules = (ArrayList<Rule>)probRules.get(rule.getName());
            if (rules == null) {
                rules = new ArrayList<Rule>();
                probRules.put(rule.getName(), rules);
            }
            rules.add(rule);
        }
        return probRules;
    }

    public static String getConstants(StateSpace stateSpace) {
        String constants = (String)stateSpace.getProperties().get((Object)"constants");
        if (constants != null) {
            String result = "";
            String[] stringArray = constants.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String part = stringArray[n2];
                if ((part = part.trim()).length() > 0) {
                    result = String.valueOf(result) + "const " + part + ";\n";
                }
                ++n2;
            }
            return result;
        }
        return "";
    }

    public static File getPRISMPath(StateSpace stateSpace) {
        String path = (String)stateSpace.getProperties().get((Object)PRISM_PATH_KEY);
        if (path != null && path.trim().length() > 0) {
            return new File(path.trim());
        }
        return null;
    }

    public static String getPRISMArgs(StateSpace stateSpace) {
        return (String)stateSpace.getProperties().get((Object)PRISM_ARGS_KEY);
    }

    public static String getPRISMExperiment(StateSpace stateSpace) {
        return (String)stateSpace.getProperties().get((Object)PRISM_EXPERIMENT_KEY);
    }

    public static String getVariableDeclarations(int size, boolean explicit) {
        if (explicit) {
            return "(s)";
        }
        return "\ts : [0.." + (size - 1) + "];\n";
    }

    private static String capitalize(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        String first = string.substring(0, 1).toUpperCase();
        if (string.length() == 1) {
            return first;
        }
        return String.valueOf(first) + string.substring(1);
    }

    private static String removeWhiteSpace(String string) {
        string = string.replaceAll(" ", "_");
        string = string.replaceAll("\t", "_");
        string = string.replaceAll("\n", "_");
        return string;
    }

    public static String getModelHeader(String modelType) {
        String h = "// " + modelType.toUpperCase() + " model generated by Henshin on " + new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").format(new Date()) + "\n\n";
        h = String.valueOf(h) + modelType.toLowerCase() + "\n\n";
        return h;
    }

    public static String getPRISMState(int index, String extra, boolean successor) {
        if (extra != null && extra.trim().length() > 0) {
            if (!(extra = extra.trim()).startsWith("(")) {
                extra = "(" + extra + ")";
            }
            extra = "&" + extra;
        } else {
            extra = "";
        }
        if (successor) {
            return "(s'=" + index + ")" + extra;
        }
        return "(s=" + index + ")" + extra;
    }

    public static String getPRISMStates(List<State> states) {
        String r = "";
        int count = states.size();
        int i = 0;
        while (i < count) {
            r = String.valueOf(r) + PRISMUtil.getPRISMState(states.get(i).getIndex(), null, false);
            if (i < count - 1) {
                r = String.valueOf(r) + " | ";
            }
            ++i;
        }
        return r;
    }

    public static class Range {
        public double min = 0.0;
        public double step = 0.0;
        public double max = 0.0;

        public Range(double min, double step, double max) {
            this.min = min;
            this.step = step;
            this.max = max;
        }

        public Range(double constant) {
            this(constant, 0.0, constant);
        }

        public Range(String value) throws ParseException {
            NumberFormat format = NumberFormat.getInstance(Locale.ENGLISH);
            String[] fields = value.split(":");
            if (fields.length == 1) {
                this.min = this.max = format.parse(fields[0]).doubleValue();
            } else if (fields.length == 2) {
                this.min = format.parse(fields[0]).doubleValue();
                this.max = format.parse(fields[1]).doubleValue();
            } else if (fields.length == 3) {
                this.min = format.parse(fields[0]).doubleValue();
                this.step = format.parse(fields[1]).doubleValue();
                this.max = format.parse(fields[2]).doubleValue();
            } else {
                throw new ParseException("Error parsing rate", 0);
            }
        }

        public boolean isConstant() {
            return this.min == this.max;
        }

        public String toString() {
            if (this.isConstant()) {
                return String.valueOf(this.min);
            }
            if (this.step <= 0.0) {
                return String.valueOf(this.min) + ":" + this.max;
            }
            return String.valueOf(this.min) + ":" + this.step + ":" + this.max;
        }

        public static boolean isRange(String value) {
            try {
                Range range = new Range(value);
                return !range.isConstant();
            }
            catch (ParseException parseException) {
                return false;
            }
        }
    }
}

