/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.interpreter.util;

import java.io.IOException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceImpl;
import org.eclipse.emf.henshin.model.resource.HenshinResourceFactory;

public class ModelHelper {
    public static void registerFileExtension(String extension) {
        if ("henshin".equals(extension)) {
            Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put(extension, new HenshinResourceFactory());
        } else {
            Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put(extension, new XMIResourceFactoryImpl());
        }
    }

    public static EPackage registerEPackageByEcoreFile(URI ecoreFileUri) {
        EPackage p = ModelHelper.registerEPackageByEcoreFile(ecoreFileUri, null);
        if (p != null) {
            EPackage.Registry.INSTANCE.put((Object)p.getNsURI(), (Object)p);
        }
        return p;
    }

    public static void registerEPackage(EPackage ePackage) {
        EPackage.Registry.INSTANCE.put((Object)ePackage.getNsURI(), (Object)ePackage);
    }

    public static EPackage registerEPackageByEcoreFile(URI ecoreFileUri, ResourceSet rs) {
        Resource packageResource;
        EPackage result = null;
        if (rs == null) {
            rs = new ResourceSetImpl();
        }
        if ((packageResource = rs.createResource(ecoreFileUri)) != null) {
            EObject tmp;
            try {
                packageResource.load(null);
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
            if (packageResource.getContents() != null && packageResource.getContents().size() > 0 && (tmp = (EObject)packageResource.getContents().get(0)) != null && tmp instanceof EPackage) {
                result = (EPackage)tmp;
                rs.getPackageRegistry().put((Object)result.getNsURI(), (Object)result);
            }
        }
        return result;
    }

    public static EObject loadFile(String filename) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource resource = resourceSet.getResource(URI.createFileURI((String)filename), true);
        return (EObject)resource.getContents().get(0);
    }

    public static void saveFile(String filename, EObject root) {
        XMLResourceImpl resource = new XMLResourceImpl(URI.createFileURI((String)filename));
        resource.getContents().add((Object)root);
        try {
            resource.save(null);
        }
        catch (IOException iOException) {}
    }
}

