/*
 * Decompiled with CFR 0.152.
 */
package agg.convert;

import agg.convert.WSDL2ggx;
import agg.util.XMLHelper;
import agg.xt_basis.GraGra;
import agg.xt_basis.TypeException;
import java.io.IOException;

public class ConverterWSDL {
    private XMLHelper xmlH;
    private GraGra gragra;
    private String fileName;
    private String outputFileName;
    private WSDL2ggx wsdl2agg;

    public ConverterWSDL(String filename) throws IOException, TypeException {
        this.fileName = filename;
        System.out.println("File name:  " + this.fileName);
        if (this.load(this.fileName) && this.convert()) {
            this.outputFileName = this.fileName.replace(".wsdl", ".ggx");
            this.gragra.save(this.outputFileName);
        }
    }

    public GraGra getGrammar() {
        return this.gragra;
    }

    boolean load(String fName) {
        if (fName.endsWith(".wsdl")) {
            this.xmlH = new XMLHelper();
            return this.xmlH.read_from_xml(fName);
        }
        return false;
    }

    boolean convert() {
        this.gragra = new GraGra(true);
        this.gragra.getTypeSet().createTypeGraph();
        this.wsdl2agg = new WSDL2ggx(this.gragra);
        this.xmlH.getTopObject(this.wsdl2agg);
        return this.wsdl2agg.isSuccessful();
    }

    public static void main(String[] args) throws IOException, TypeException {
        String arg = args[0];
        new ConverterWSDL(arg);
    }
}

