/*
 * Decompiled with CFR 0.152.
 */
package agg.gui.browser.impl;

import agg.editor.impl.EdGraGra;
import agg.gui.browser.GraphBrowser;
import agg.gui.browser.impl.GraphBrowserImpl;
import agg.xt_basis.Arc;
import agg.xt_basis.Graph;
import agg.xt_basis.OrdinaryMorphism;
import agg.xt_basis.Rule;
import agg.xt_basis.TypeException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;

public class TestBrowser
extends JPanel {
    static int ITS_WIDTH = 500;
    static int ITS_HEIGHT = 300;
    JFrame f;
    GraphBrowser browser;
    EdGraGra gragra;

    public TestBrowser(JFrame frame) {
        super(true);
        this.setLayout(new BorderLayout());
        this.f = frame;
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(this.createFileMenu());
        menuBar.add(this.createLayoutMenu());
        menuBar.add(this.createBasisMenu());
        this.add((Component)menuBar, "North");
        this.browser = new GraphBrowserImpl();
        this.add((Component)this.browser.getPanel(), "Center");
    }

    JMenu createFileMenu() {
        JMenu file = new JMenu("File", true);
        JMenuItem mi = file.add(new JMenuItem("Load GraGra"));
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TestBrowser.this.gragra = TestBrowser.this.browser.loadGraGra(TestBrowser.this.f);
                if (TestBrowser.this.gragra != null) {
                    TestBrowser.this.browser.setGraph(TestBrowser.this.gragra.getGraph());
                    TestBrowser.this.browser.showGraph();
                }
            }
        });
        mi = file.add(new JMenuItem("Save As"));
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TestBrowser.this.browser.saveAs(TestBrowser.this.f);
            }
        });
        file.add(new JSeparator());
        mi = file.add(new JMenuItem("Show Graph"));
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TestBrowser.this.browser.setGraph(TestBrowser.this.gragra.getGraph());
                TestBrowser.this.browser.showGraph();
            }
        });
        file.add(new JSeparator());
        mi = file.add(new JMenuItem("Update"));
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TestBrowser.this.browser.updateGraphics();
            }
        });
        file.add(new JSeparator());
        mi = file.add(new JMenuItem("Exit"));
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        });
        return file;
    }

    JMenu createLayoutMenu() {
        JMenu layout = new JMenu("Layout", true);
        JMenuItem mi = layout.add(new JMenuItem("Default"));
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TestBrowser.this.defaultLayout();
            }
        });
        return layout;
    }

    void defaultLayout() {
        this.browser.setGraph(this.gragra.getBasisGraGra().getGraph());
        this.browser.showGraph();
    }

    JMenu createBasisMenu() {
        JMenu basis = new JMenu("Basis", true);
        JMenuItem mi = basis.add(new JMenuItem("Modify Graph"));
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TestBrowser.this.modifyBaseGraGra();
            }
        });
        mi = basis.add(new JMenuItem("Show graph"));
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TestBrowser.this.showLG();
            }
        });
        mi = basis.add(new JMenuItem("Show left rule side"));
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TestBrowser.this.showLRS();
            }
        });
        mi = basis.add(new JMenuItem("Show right rule side"));
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TestBrowser.this.showRRS();
            }
        });
        mi = basis.add(new JMenuItem("Show NAC"));
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TestBrowser.this.showNAC();
            }
        });
        return basis;
    }

    void modifyBaseGraGra() {
        JOptionPane.showMessageDialog(this.f, "All arcs will be removed.");
        Graph graph = this.gragra.getBasisGraGra().getGraph();
        Iterator<Arc> arcs = graph.getArcsSet().iterator();
        while (arcs.hasNext()) {
            try {
                graph.destroyArc(arcs.next(), true, false);
            }
            catch (TypeException e) {
                e.printStackTrace();
            }
        }
        this.browser.setGraph(graph);
        this.browser.showGraph();
    }

    void showLG() {
        this.browser.setGraph(this.gragra.getBasisGraGra().getGraph());
        this.browser.showGraph();
    }

    void showLRS() {
        List<Rule> rules = this.gragra.getBasisGraGra().getListOfRules();
        if (!rules.isEmpty()) {
            Rule r = rules.get(0);
            this.browser.setGraph(r.getLeft());
            this.browser.showGraph();
        }
    }

    void showRRS() {
        List<Rule> rules = this.gragra.getBasisGraGra().getListOfRules();
        if (!rules.isEmpty()) {
            Rule r = rules.get(0);
            this.browser.setGraph(r.getRight());
            this.browser.showGraph();
        }
    }

    void showNAC() {
        Rule r;
        Enumeration<OrdinaryMorphism> nacs;
        List<Rule> rules = this.gragra.getBasisGraGra().getListOfRules();
        if (!rules.isEmpty() && (nacs = (r = rules.get(0)).getNACs()).hasMoreElements()) {
            OrdinaryMorphism nac = nacs.nextElement();
            this.browser.setGraph(nac.getImage());
            this.browser.showGraph();
        }
    }

    public static void main(String[] args) {
        WindowAdapter l = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        };
        JFrame frame = new JFrame("AGG Graph Browser (extended)");
        frame.addWindowListener(l);
        frame.setBackground(Color.white);
        frame.setCursor(Cursor.getPredefinedCursor(0));
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        frame.setLocation(screenSize.width / 2 - ITS_WIDTH / 2, screenSize.height / 2 - ITS_HEIGHT / 2);
        frame.setSize(ITS_WIDTH, ITS_HEIGHT);
        TestBrowser testbrowser = new TestBrowser(frame);
        frame.getContentPane().add((Component)testbrowser, "Center");
        frame.setVisible(true);
    }
}

