/*
 * Decompiled with CFR 0.152.
 */
package agg.gui.parser;

import agg.gui.options.AbstractOptionGUI;
import agg.parser.LayerOption;
import agg.parser.OptionEventListener;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.EventObject;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JPanel;

public class LayerOptionGUI
extends AbstractOptionGUI
implements ItemListener,
OptionEventListener {
    JComboBox layerType;
    public static final String RCD_LAYER = "Rule, Creation, Deletion, Rule must delete";
    public static final String RCDN_LAYER = "Rule, Creation, Deletion, Rule must delete, NAC check";
    public static final String WEAK_RCD_LAYER = "Rule, Creation, Deletion";
    public static final String WEAK_RCDN_LAYER = "Rule, Creation, Deletion, NAC check";
    private LayerOption lOption;

    public LayerOptionGUI(LayerOption lOption) {
        this.lOption = lOption;
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(gridbag);
        c.fill = 1;
        c.anchor = 18;
        c.gridwidth = 0;
        c.weighty = 0.0;
        c.weightx = 1.0;
        this.add((Component)this.makeLayerType(), c);
        c.fill = 1;
        c.anchor = 18;
        c.gridwidth = 0;
        c.weighty = 1.0;
        c.weightx = 1.0;
        this.add((Component)new JPanel(), c);
        this.validate();
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(350, 480);
    }

    private JPanel makeLayerType() {
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.gridwidth = -1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.anchor = 17;
        JPanel optionPanel = this.makeInitialOptionPanel(true, "Select algorithm for layer function", c);
        c.gridwidth = 0;
        c.weightx = 1.0;
        optionPanel.add((Component)new JPanel(), c);
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.anchor = 17;
        this.layerType = new JComboBox();
        this.layerType.addItem(RCDN_LAYER);
        this.layerType.addItem(WEAK_RCDN_LAYER);
        this.layerType.addItem(RCD_LAYER);
        this.layerType.addItem(WEAK_RCD_LAYER);
        this.layerType.addItemListener(this);
        optionPanel.add((Component)this.layerType, c);
        c.gridwidth = 0;
        c.weightx = 1.0;
        optionPanel.add((Component)new JPanel(), c);
        return optionPanel;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Object source = e.getSource();
        if (source == this.layerType) {
            if (this.layerType.getSelectedItem().equals(RCDN_LAYER)) {
                this.lOption.setLayer(0);
            } else if (this.layerType.getSelectedItem().equals(WEAK_RCDN_LAYER)) {
                this.lOption.setLayer(2);
            } else if (this.layerType.getSelectedItem().equals(RCD_LAYER)) {
                this.lOption.setLayer(1);
            } else if (this.layerType.getSelectedItem().equals(WEAK_RCD_LAYER)) {
                this.lOption.setLayer(3);
            }
        }
    }

    @Override
    public Icon getIcon() {
        return null;
    }

    @Override
    public String getTabTitle() {
        return "Layer";
    }

    @Override
    public String getTabTip() {
        return "Layer Function";
    }

    @Override
    public void update() {
        switch (this.lOption.getLayer()) {
            case 0: {
                this.layerType.setSelectedItem(RCDN_LAYER);
                break;
            }
            case 2: {
                this.layerType.setSelectedItem(WEAK_RCDN_LAYER);
                break;
            }
            case 1: {
                this.layerType.setSelectedItem(RCD_LAYER);
                break;
            }
            case 3: {
                this.layerType.setSelectedItem(WEAK_RCD_LAYER);
                break;
            }
        }
    }

    @Override
    public void optionEventOccurred(EventObject e) {
        System.out.println("LayerOptionGUI.optionEventOccurred");
        if (e.getSource() instanceof LayerOption) {
            this.update();
        }
    }

    @Override
    public void executeOnClose() {
    }
}

