/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.ocl2ac.ocl2gc.core;

import graph.Graph;
import graph.GraphFactory;
import laxcondition.Condition;
import laxcondition.Formula;
import laxcondition.LaxCondition;
import laxcondition.Operator;
import laxcondition.QuantifiedLaxCondition;
import laxcondition.Quantifier;
import nestedcondition.NestedCondition;
import nestedcondition.NestedConstraint;
import nestedcondition.NestedconditionFactory;
import nestedcondition.QuantifiedCondition;
import nestedcondition.True;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.henshin.ocl2ac.ocl2gc.util.MorphismHelper;
import org.eclipse.emf.henshin.ocl2ac.ocl2gc.util.MorphismPair;

public class Completer {
    private Condition condition = null;
    private NestedConstraint constraint = null;
    private NestedconditionFactory factory = null;
    private GraphFactory graphFactory = null;
    private EPackage typeGraph = null;

    public Completer(Condition condition) {
        this.condition = condition;
        this.factory = NestedconditionFactory.eINSTANCE;
        this.graphFactory = GraphFactory.eINSTANCE;
    }

    public long complete() {
        if (this.condition == null) {
            return -2L;
        }
        this.typeGraph = this.condition.getTypeGraph();
        long start = System.currentTimeMillis();
        this.constraint = this.factory.createNestedConstraint();
        Graph emptyGraph = this.graphFactory.createGraph();
        emptyGraph.setTypegraph(this.typeGraph);
        this.constraint.setDomain(emptyGraph);
        this.constraint.setTypeGraph(this.typeGraph);
        this.constraint.setName(this.condition.getName());
        this.constraint.setCondition(this.complete(this.condition.getLaxCondition(), emptyGraph));
        long stop = System.currentTimeMillis();
        return stop - start;
    }

    private NestedCondition complete(LaxCondition laxCondition, Graph graph) {
        if (laxCondition instanceof laxcondition.True) {
            return this.completeTrue((laxcondition.True)laxCondition, graph);
        }
        if (laxCondition instanceof Formula) {
            Formula formula = (Formula)laxCondition;
            System.out.println("Formula: " + formula + "; Graph: " + graph);
            if (formula.getOp().equals((Object)Operator.NOT)) {
                return this.completeNot(formula, graph);
            }
            if (formula.getOp().equals((Object)Operator.IMPLIES)) {
                return this.completeImplies(formula, graph);
            }
            if (formula.getOp().equals((Object)Operator.EQUIVALENT)) {
                return this.completeEquivalent(formula, graph);
            }
            if (formula.getOp().equals((Object)Operator.XOR)) {
                return this.completeXor(formula, graph);
            }
            if (formula.getOp().equals((Object)Operator.AND)) {
                return this.completeAnd(formula, graph);
            }
            if (formula.getOp().equals((Object)Operator.OR)) {
                return this.completeOr(formula, graph);
            }
        }
        if (laxCondition instanceof QuantifiedLaxCondition) {
            QuantifiedLaxCondition quantifiedLaxCondition = (QuantifiedLaxCondition)laxCondition;
            System.out.println("Q-Lax: " + quantifiedLaxCondition + "; Graph: " + graph);
            System.out.println("Quantifier: " + quantifiedLaxCondition.getQuantifier());
            if (quantifiedLaxCondition.getQuantifier().equals((Object)Quantifier.EXISTS)) {
                return this.completeExists(quantifiedLaxCondition, graph);
            }
            if (quantifiedLaxCondition.getQuantifier().equals((Object)Quantifier.FORALL)) {
                return this.completeForAll(quantifiedLaxCondition, graph);
            }
        }
        return null;
    }

    private NestedCondition completeForAll(QuantifiedLaxCondition quantifiedLaxCondition, Graph domain) {
        EList<MorphismPair> morphismPairs = new EList<MorphismPair>();
        morphismPairs = MorphismHelper.getCompleteMorphisms(domain, quantifiedLaxCondition.getGraph());
        if (morphismPairs.isEmpty()) {
            return this.completeTrue(null, domain);
        }
        if (morphismPairs.size() == 1) {
            return this.getForAllCondition(quantifiedLaxCondition, (MorphismPair)morphismPairs.get(0));
        }
        nestedcondition.Formula cond = this.factory.createFormula();
        cond.setDomain(domain);
        cond.setOperator(Operator.AND);
        for (MorphismPair morphismPair : morphismPairs) {
            cond.getArguments().add((Object)this.getForAllCondition(quantifiedLaxCondition, morphismPair));
        }
        return cond;
    }

    private NestedCondition getForAllCondition(QuantifiedLaxCondition quantifiedLaxCondition, MorphismPair morphismPair) {
        QuantifiedCondition cond = this.factory.createQuantifiedCondition();
        cond.setQuantifier(Quantifier.FORALL);
        cond.setDomain(morphismPair.getP());
        cond.setMorphism(morphismPair.getMorphismP());
        cond.setCodomain(morphismPair.getResultGraph());
        cond.setCondition(this.complete(quantifiedLaxCondition.getCondition(), cond.getCodomain()));
        return cond;
    }

    private NestedCondition completeExists(QuantifiedLaxCondition quantifiedLaxCondition, Graph domain) {
        EList<MorphismPair> morphismPairs = new EList<MorphismPair>();
        morphismPairs = MorphismHelper.getCompleteMorphisms(domain, quantifiedLaxCondition.getGraph());
        if (morphismPairs.isEmpty()) {
            return this.completeTrue(null, domain);
        }
        if (morphismPairs.size() == 1) {
            return this.getExistsCondition(quantifiedLaxCondition, (MorphismPair)morphismPairs.get(0));
        }
        nestedcondition.Formula cond = this.factory.createFormula();
        cond.setDomain(domain);
        cond.setOperator(Operator.OR);
        for (MorphismPair morphismPair : morphismPairs) {
            cond.getArguments().add((Object)this.getExistsCondition(quantifiedLaxCondition, morphismPair));
        }
        return cond;
    }

    private NestedCondition getExistsCondition(QuantifiedLaxCondition quantifiedLaxCondition, MorphismPair morphismPair) {
        QuantifiedCondition cond = this.factory.createQuantifiedCondition();
        cond.setQuantifier(Quantifier.EXISTS);
        cond.setDomain(morphismPair.getP());
        cond.setMorphism(morphismPair.getMorphismP());
        cond.setCodomain(morphismPair.getResultGraph());
        cond.setCondition(this.complete(quantifiedLaxCondition.getCondition(), cond.getCodomain()));
        return cond;
    }

    private NestedCondition completeOr(Formula formula, Graph graph) {
        nestedcondition.Formula cond = this.factory.createFormula();
        cond.setDomain(graph);
        cond.setOperator(Operator.OR);
        for (LaxCondition lax : formula.getArguments()) {
            cond.getArguments().add((Object)this.complete(lax, graph));
        }
        return cond;
    }

    private NestedCondition completeAnd(Formula formula, Graph graph) {
        nestedcondition.Formula cond = this.factory.createFormula();
        cond.setDomain(graph);
        cond.setOperator(Operator.AND);
        for (LaxCondition lax : formula.getArguments()) {
            cond.getArguments().add((Object)this.complete(lax, graph));
        }
        return cond;
    }

    private NestedCondition completeXor(Formula formula, Graph graph) {
        nestedcondition.Formula cond = this.factory.createFormula();
        cond.setDomain(graph);
        cond.setOperator(Operator.XOR);
        cond.getArguments().add((Object)this.complete((LaxCondition)formula.getArguments().get(0), graph));
        cond.getArguments().add((Object)this.complete((LaxCondition)formula.getArguments().get(1), graph));
        return cond;
    }

    private NestedCondition completeEquivalent(Formula formula, Graph graph) {
        nestedcondition.Formula cond = this.factory.createFormula();
        cond.setDomain(graph);
        cond.setOperator(Operator.EQUIVALENT);
        cond.getArguments().add((Object)this.complete((LaxCondition)formula.getArguments().get(0), graph));
        cond.getArguments().add((Object)this.complete((LaxCondition)formula.getArguments().get(1), graph));
        return cond;
    }

    private NestedCondition completeImplies(Formula formula, Graph graph) {
        nestedcondition.Formula cond = this.factory.createFormula();
        cond.setDomain(graph);
        cond.setOperator(Operator.IMPLIES);
        cond.getArguments().add((Object)this.complete((LaxCondition)formula.getArguments().get(0), graph));
        cond.getArguments().add((Object)this.complete((LaxCondition)formula.getArguments().get(1), graph));
        return cond;
    }

    private NestedCondition completeNot(Formula formula, Graph graph) {
        nestedcondition.Formula cond = this.factory.createFormula();
        cond.setDomain(graph);
        cond.setOperator(Operator.NOT);
        cond.getArguments().add((Object)this.complete((LaxCondition)formula.getArguments().get(0), graph));
        return cond;
    }

    private NestedCondition completeTrue(laxcondition.True laxCondition, Graph graph) {
        True cond = this.factory.createTrue();
        cond.setDomain(graph);
        return cond;
    }

    public NestedConstraint getConstraint() {
        if (this.constraint == null) {
            this.constraint = this.factory.createNestedConstraint();
            this.constraint.setName("");
        }
        return this.constraint;
    }
}

