/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.ocl2ac.ocl2gc.core;

import graph.Attribute;
import graph.Edge;
import graph.Graph;
import graph.GraphFactory;
import graph.Node;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import laxcondition.Condition;
import laxcondition.Formula;
import laxcondition.LaxCondition;
import laxcondition.LaxconditionFactory;
import laxcondition.Operator;
import laxcondition.QuantifiedLaxCondition;
import laxcondition.Quantifier;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.emf.henshin.ocl2ac.ocl2gc.util.TranslatorResourceSet;
import org.eclipse.ocl.pivot.BooleanLiteralExp;
import org.eclipse.ocl.pivot.CallExp;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CollectionItem;
import org.eclipse.ocl.pivot.CollectionKind;
import org.eclipse.ocl.pivot.CollectionLiteralExp;
import org.eclipse.ocl.pivot.CollectionLiteralPart;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.Constraint;
import org.eclipse.ocl.pivot.DataType;
import org.eclipse.ocl.pivot.EnumLiteralExp;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.IfExp;
import org.eclipse.ocl.pivot.IntegerLiteralExp;
import org.eclipse.ocl.pivot.Iteration;
import org.eclipse.ocl.pivot.IteratorExp;
import org.eclipse.ocl.pivot.LiteralExp;
import org.eclipse.ocl.pivot.Model;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.OperationCallExp;
import org.eclipse.ocl.pivot.OrderedSetType;
import org.eclipse.ocl.pivot.PivotFactory;
import org.eclipse.ocl.pivot.PivotPackage;
import org.eclipse.ocl.pivot.PrimitiveLiteralExp;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.PropertyCallExp;
import org.eclipse.ocl.pivot.RealLiteralExp;
import org.eclipse.ocl.pivot.SetType;
import org.eclipse.ocl.pivot.StringLiteralExp;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.TypeExp;
import org.eclipse.ocl.pivot.UnlimitedNaturalLiteralExp;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.VariableExp;

public class Translator {
    protected IFile oclasFile = null;
    protected IFile ecoreFile = null;
    public EList<Constraint> invariants = null;
    private EPackage typeModel = null;
    protected Model oclModel = null;
    protected LaxconditionFactory laxconditionFactory = null;
    protected GraphFactory graphFactory = null;
    protected PivotFactory oclFactory = null;
    protected int varIndex;
    protected List<String> varNames;

    public Translator() {
    }

    public Translator(IFile oclasFile, IFile ecoreFile) {
        this.oclasFile = oclasFile;
        this.ecoreFile = ecoreFile;
        this.invariants = new BasicEList();
        this.laxconditionFactory = LaxconditionFactory.eINSTANCE;
        this.graphFactory = GraphFactory.eINSTANCE;
        this.oclFactory = PivotFactory.eINSTANCE;
        this.varIndex = 1;
        this.varNames = new ArrayList<String>();
        this.initModels();
        this.prepareOCLModel();
        this.refactorOCLModel();
    }

    protected void initModels() {
        URI uriOclAS = URI.createPlatformResourceURI((String)this.oclasFile.getFullPath().toString(), (boolean)true);
        URI uriEcore = URI.createPlatformResourceURI((String)this.ecoreFile.getFullPath().toString(), (boolean)true);
        if (uriOclAS != null && uriEcore != null) {
            PivotPackage.eINSTANCE.eClass();
            Resource.Factory.Registry reg = Resource.Factory.Registry.INSTANCE;
            Map m = reg.getExtensionToFactoryMap();
            m.put("*.oclas", new XMIResourceFactoryImpl());
            ResourceSetImpl resSet = new ResourceSetImpl();
            Resource resourceOclAS = resSet.getResource(uriOclAS, true);
            this.oclModel = (Model)resourceOclAS.getContents().get(0);
            Resource resourceEcore = resSet.getResource(uriEcore, true);
            this.setTypeModel((EPackage)resourceEcore.getContents().get(0));
        }
    }

    protected void prepareOCLModel() {
        TreeIterator iter = this.oclModel.eAllContents();
        while (iter.hasNext()) {
            EObject eObject = (EObject)iter.next();
            if (eObject instanceof Class) {
                this.invariants.addAll((Collection)((Class)eObject).getOwnedInvariants());
            }
            if (eObject instanceof OperationCallExp) {
                OperationCallExp operationCallExp = (OperationCallExp)eObject;
                Operation op = operationCallExp.getReferredOperation();
                operationCallExp.setName(op.getName());
            }
            if (eObject instanceof IteratorExp) {
                IteratorExp iteratorExp = (IteratorExp)eObject;
                Iteration iteration = iteratorExp.getReferredIteration();
                iteratorExp.setName(iteration.getName());
            }
            if (!(eObject instanceof LiteralExp)) continue;
            LiteralExp literalExp = (LiteralExp)eObject;
            this.refactorLiteralExpression(literalExp);
        }
    }

    protected void refactorOCLModel() {
        TreeIterator iter = this.oclModel.eAllContents();
        while (iter.hasNext()) {
            EObject eObject = null;
            eObject = (EObject)iter.next();
            if (eObject instanceof OperationCallExp) {
                OperationCallExp operationCallExp = (OperationCallExp)eObject;
                if (operationCallExp.getName().equals("includes") || operationCallExp.getName().equals("excludes")) {
                    this.refactorIncludesExcludes(operationCallExp);
                }
                if (operationCallExp.getName().equals("including") || operationCallExp.getName().equals("excluding")) {
                    this.refactorIncludingExcluding(operationCallExp);
                }
                if (operationCallExp.getName().equals("<>")) {
                    this.refactorNotEquals(operationCallExp);
                }
                if (operationCallExp.getName().equals("isEmpty")) {
                    this.refactorIsEmpty(operationCallExp);
                }
                if (this.isSizeComparison(operationCallExp)) {
                    this.homogenizeSizeComparison(operationCallExp);
                    System.out.println(operationCallExp);
                }
            }
            if (!(eObject instanceof IteratorExp)) continue;
            IteratorExp iteratorExp = (IteratorExp)eObject;
            if (iteratorExp.getName().equals("any")) {
                this.refactorAny(iteratorExp);
            }
            if (!iteratorExp.getName().equals("one")) continue;
            this.refactorOne(iteratorExp);
        }
    }

    protected void refactorAny(IteratorExp iteratorExp) {
        iteratorExp.setName("select");
        Class clazz = ((Variable)iteratorExp.getOwnedIterators().get(0)).getType().isClass();
        OrderedSetType setType = this.oclFactory.createOrderedSetType();
        setType.setElementType((Type)clazz);
        iteratorExp.setType((Type)setType);
    }

    protected void refactorOne(IteratorExp iteratorExp) {
        CallExp expr;
        OperationCallExp equalsExpr = this.oclFactory.createOperationCallExp();
        equalsExpr.setName("=");
        OperationCallExp sizeExpr = this.oclFactory.createOperationCallExp();
        sizeExpr.setName("size");
        equalsExpr.setOwnedSource((OCLExpression)sizeExpr);
        IntegerLiteralExp litExpr = this.oclFactory.createIntegerLiteralExp();
        litExpr.setName(Integer.toString(1));
        equalsExpr.getOwnedArguments().add(litExpr);
        EObject container = iteratorExp.eContainer();
        if (container instanceof CallExp && (expr = (CallExp)container).getOwnedSource() == iteratorExp) {
            expr.setOwnedSource((OCLExpression)equalsExpr);
        }
        if (container instanceof OperationCallExp && (expr = (OperationCallExp)container).getOwnedArguments().get(0) == iteratorExp) {
            expr.getOwnedArguments().clear();
            expr.getOwnedArguments().add(equalsExpr);
        }
        if (container instanceof ExpressionInOCL) {
            expr = (ExpressionInOCL)container;
            expr.setOwnedBody((OCLExpression)equalsExpr);
        }
        if (container instanceof IteratorExp && (expr = (IteratorExp)container).getOwnedBody() == iteratorExp) {
            expr.setOwnedBody((OCLExpression)equalsExpr);
        }
        if (container instanceof IfExp) {
            expr = (IfExp)container;
            if (expr.getOwnedCondition() == iteratorExp) {
                expr.setOwnedCondition((OCLExpression)equalsExpr);
            }
            if (expr.getOwnedThen() == iteratorExp) {
                expr.setOwnedThen((OCLExpression)equalsExpr);
            }
            if (expr.getOwnedElse() == iteratorExp) {
                expr.setOwnedElse((OCLExpression)equalsExpr);
            }
        }
        sizeExpr.setOwnedSource((OCLExpression)iteratorExp);
        Class clazz = ((Variable)iteratorExp.getOwnedIterators().get(0)).getType().isClass();
        OrderedSetType setType = this.oclFactory.createOrderedSetType();
        setType.setElementType((Type)clazz);
        iteratorExp.setType((Type)setType);
        iteratorExp.setName("select");
        this.homogenizeSizeComparison(equalsExpr);
    }

    protected void homogenizeSizeComparison(OperationCallExp operationCallExp) {
        OCLExpression sourceExpr = operationCallExp.getOwnedSource();
        String operation = operationCallExp.getName();
        OCLExpression argumentExpr = (OCLExpression)operationCallExp.getOwnedArguments().get(0);
        int literal = Integer.parseInt(argumentExpr.getName());
        if (operation.equals(">")) {
            operationCallExp.setName(">=");
            ((OCLExpression)operationCallExp.getOwnedArguments().get(0)).setName(Integer.toString(++literal));
        }
        if (operation.equals("=")) {
            OperationCallExp greaterEqualsExpr1 = this.oclFactory.createOperationCallExp();
            greaterEqualsExpr1.setName(">=");
            operationCallExp.setOwnedSource((OCLExpression)greaterEqualsExpr1);
            greaterEqualsExpr1.setOwnedSource(sourceExpr);
            operationCallExp.getOwnedArguments().clear();
            greaterEqualsExpr1.getOwnedArguments().add(argumentExpr);
            operationCallExp.setName("and");
            OperationCallExp notExpr = this.oclFactory.createOperationCallExp();
            notExpr.setName("not");
            operationCallExp.getOwnedArguments().add(notExpr);
            EcoreUtil.Copier copier = new EcoreUtil.Copier();
            OperationCallExp greaterEqualsExpr2 = (OperationCallExp)copier.copy((EObject)greaterEqualsExpr1);
            copier.copyReferences();
            ((OCLExpression)greaterEqualsExpr2.getOwnedArguments().get(0)).setName(Integer.toString(++literal));
            notExpr.setOwnedSource((OCLExpression)greaterEqualsExpr2);
        }
        if (operation.equals("<=")) {
            operationCallExp.setName("<");
            operation = "<";
            ((OCLExpression)operationCallExp.getOwnedArguments().get(0)).setName(Integer.toString(++literal));
        }
        if (operation.equals("<")) {
            operationCallExp.setName("not");
            operationCallExp.getOwnedArguments().clear();
            OperationCallExp greaterEqualsExpr = this.oclFactory.createOperationCallExp();
            greaterEqualsExpr.setName(">=");
            operationCallExp.setOwnedSource((OCLExpression)greaterEqualsExpr);
            greaterEqualsExpr.setOwnedSource(sourceExpr);
            greaterEqualsExpr.getOwnedArguments().add(argumentExpr);
        }
        if (operation.equals("<>")) {
            operationCallExp.setName("not");
            operationCallExp.getOwnedArguments().clear();
            OperationCallExp equalsExpr = this.oclFactory.createOperationCallExp();
            equalsExpr.setName("=");
            operationCallExp.setOwnedSource((OCLExpression)equalsExpr);
            equalsExpr.setOwnedSource(sourceExpr);
            equalsExpr.getOwnedArguments().add(argumentExpr);
            this.homogenizeSizeComparison(equalsExpr);
        }
    }

    protected void refactorIsEmpty(OperationCallExp operationCallExp) {
        OCLExpression expr1 = operationCallExp.getOwnedSource();
        OCLExpression expr2 = null;
        if (operationCallExp.getOwnedArguments().size() > 0) {
            expr2 = (OCLExpression)operationCallExp.getOwnedArguments().get(0);
        }
        OperationCallExp notEmptyExpression = PivotFactory.eINSTANCE.createOperationCallExp();
        notEmptyExpression.setName("notEmpty");
        operationCallExp.setName("not");
        operationCallExp.setOwnedSource((OCLExpression)notEmptyExpression);
        if (expr2 != null) {
            operationCallExp.getOwnedArguments().remove(expr2);
        }
        notEmptyExpression.setOwnedSource(expr1);
        if (expr2 != null) {
            notEmptyExpression.getOwnedArguments().add(expr2);
        }
    }

    protected void refactorNotEquals(OperationCallExp operationCallExp) {
        OCLExpression expr1 = operationCallExp.getOwnedSource();
        OCLExpression expr2 = null;
        if (operationCallExp.getOwnedArguments().size() > 0) {
            expr2 = (OCLExpression)operationCallExp.getOwnedArguments().get(0);
        }
        if (!(expr1.getType() instanceof DataType) && !(expr2.getType() instanceof DataType)) {
            OperationCallExp equalsExpression = PivotFactory.eINSTANCE.createOperationCallExp();
            equalsExpression.setName("=");
            operationCallExp.setName("not");
            operationCallExp.setOwnedSource((OCLExpression)equalsExpression);
            if (expr2 != null) {
                operationCallExp.getOwnedArguments().remove(expr2);
            }
            equalsExpression.setOwnedSource(expr1);
            if (expr2 != null) {
                equalsExpression.getOwnedArguments().add(expr2);
            }
        }
    }

    protected void refactorIncludingExcluding(OperationCallExp operationCallExp) {
        if (operationCallExp.getName().equals("including")) {
            operationCallExp.setName("union");
        } else {
            operationCallExp.setName("-");
        }
        PivotFactory oclFactory = PivotFactory.eINSTANCE;
        CollectionLiteralExp collectionLiteralExp = oclFactory.createCollectionLiteralExp();
        collectionLiteralExp.setKind(CollectionKind.SET);
        CollectionItem item = oclFactory.createCollectionItem();
        OCLExpression expr = (OCLExpression)operationCallExp.getOwnedArguments().get(0);
        operationCallExp.getOwnedArguments().remove(expr);
        item.setOwnedItem(expr);
        collectionLiteralExp.getOwnedParts().add(item);
        operationCallExp.getOwnedArguments().add(collectionLiteralExp);
    }

    protected void refactorIncludesExcludes(OperationCallExp operationCallExp) {
        if (operationCallExp.getName().equals("includes")) {
            operationCallExp.setName("includesAll");
        } else {
            operationCallExp.setName("excludesAll");
        }
        PivotFactory oclFactory = PivotFactory.eINSTANCE;
        CollectionLiteralExp collectionLiteralExp = oclFactory.createCollectionLiteralExp();
        collectionLiteralExp.setKind(CollectionKind.SET);
        CollectionItem item = oclFactory.createCollectionItem();
        OCLExpression expr = (OCLExpression)operationCallExp.getOwnedArguments().get(0);
        operationCallExp.getOwnedArguments().remove(expr);
        item.setOwnedItem(expr);
        collectionLiteralExp.getOwnedParts().add(item);
        operationCallExp.getOwnedArguments().add(collectionLiteralExp);
    }

    protected void refactorLiteralExpression(LiteralExp literalExp) {
        StringLiteralExp exp;
        if (literalExp instanceof StringLiteralExp) {
            exp = (StringLiteralExp)literalExp;
            exp.setName(exp.getStringSymbol());
        }
        if (literalExp instanceof BooleanLiteralExp) {
            exp = (BooleanLiteralExp)literalExp;
            exp.setName(Boolean.toString(exp.isBooleanSymbol()));
        }
        if (literalExp instanceof RealLiteralExp) {
            exp = (RealLiteralExp)literalExp;
            exp.setName(Double.toString(exp.getRealSymbol().doubleValue()));
        }
        if (literalExp instanceof UnlimitedNaturalLiteralExp) {
            exp = (UnlimitedNaturalLiteralExp)literalExp;
            exp.setName(Integer.toString(exp.getUnlimitedNaturalSymbol().intValue()));
        }
        if (literalExp instanceof IntegerLiteralExp) {
            exp = (IntegerLiteralExp)literalExp;
            exp.setName(Integer.toString(exp.getIntegerSymbol().intValue()));
        }
    }

    public long translate() {
        long start = System.currentTimeMillis();
        Date date = new GregorianCalendar().getTime();
        for (Constraint inv : this.invariants) {
            Condition condition = null;
            try {
                condition = this.laxconditionFactory.createCondition();
                condition.setName(inv.getName());
                condition.setTypeGraph(this.getTypeModel());
                condition.setLaxCondition(this.translate_I(inv));
                this.persistLaxCondition(date, condition);
            }
            catch (Exception e) {
                System.err.println("The constraint " + condition.getName() + " is not well translated");
                e.getStackTrace();
            }
        }
        long stop = System.currentTimeMillis();
        return stop - start;
    }

    protected LaxCondition translate_I(Constraint inv) {
        System.out.println("translate_I");
        QuantifiedLaxCondition laxCondition = this.laxconditionFactory.createQuantifiedLaxCondition();
        laxCondition.setQuantifier(Quantifier.FORALL);
        Graph graph = this.graphFactory.createGraph();
        graph.setTypegraph(this.getTypeModel());
        Node node = this.graphFactory.createNode();
        ExpressionInOCL exprInOcl = null;
        exprInOcl = (ExpressionInOCL)inv.getOwnedSpecification();
        node.setName(exprInOcl.getOwnedContext().getName());
        node.setType(this.getEClass(exprInOcl.getOwnedContext().getType().isClass()));
        graph.getNodes().add((Object)node);
        laxCondition.setGraph(graph);
        System.out.println(laxCondition.toString());
        System.out.println(exprInOcl.getOwnedBody().toString());
        LaxCondition translate_E = this.translate_E(exprInOcl.getOwnedBody());
        System.out.println(translate_E.toString());
        laxCondition.setCondition(translate_E);
        return laxCondition;
    }

    protected LaxCondition translate_E(OCLExpression expr) {
        System.out.println(String.valueOf(this.getClass().getName()) + " translate_E()");
        if (expr instanceof BooleanLiteralExp) {
            System.out.println("Rule 2 a");
            if (expr.getName().equals("true")) {
                return this.laxconditionFactory.createTrue();
            }
            if (expr.getName().equals("false")) {
                Formula formula = this.laxconditionFactory.createFormula();
                formula.setOp(Operator.NOT);
                formula.getArguments().add((Object)this.laxconditionFactory.createTrue());
                return formula;
            }
        }
        if (expr instanceof OperationCallExp) {
            OCLExpression typeExpr;
            OCLExpression sourceExpr;
            QuantifiedLaxCondition laxCondition;
            OCLExpression expr2;
            OCLExpression expr1;
            EClass type;
            OperationCallExp opCallExpr = (OperationCallExp)expr;
            if (opCallExpr.getName().equals("not")) {
                System.out.println("Rule 2 b");
                Formula formula = this.laxconditionFactory.createFormula();
                formula.setOp(Operator.NOT);
                formula.getArguments().add((Object)this.translate_E(opCallExpr.getOwnedSource()));
                return formula;
            }
            if (opCallExpr.getName().equals("and")) {
                System.out.println("Rule 2 c");
                Formula formula = this.laxconditionFactory.createFormula();
                formula.setOp(Operator.AND);
                formula.getArguments().add((Object)this.translate_E(opCallExpr.getOwnedSource()));
                formula.getArguments().add((Object)this.translate_E((OCLExpression)opCallExpr.getOwnedArguments().get(0)));
                return formula;
            }
            if (opCallExpr.getName().equals("or")) {
                System.out.println("Rule 2 d");
                Formula formula = this.laxconditionFactory.createFormula();
                formula.setOp(Operator.OR);
                formula.getArguments().add((Object)this.translate_E(opCallExpr.getOwnedSource()));
                formula.getArguments().add((Object)this.translate_E((OCLExpression)opCallExpr.getOwnedArguments().get(0)));
                return formula;
            }
            if (opCallExpr.getName().equals("implies")) {
                System.out.println("Rule 2 e");
                Formula formula = this.laxconditionFactory.createFormula();
                formula.setOp(Operator.OR);
                Formula notFormula = this.laxconditionFactory.createFormula();
                notFormula.setOp(Operator.NOT);
                notFormula.getArguments().add((Object)this.translate_E(opCallExpr.getOwnedSource()));
                formula.getArguments().add((Object)notFormula);
                formula.getArguments().add((Object)this.translate_E((OCLExpression)opCallExpr.getOwnedArguments().get(0)));
                return formula;
            }
            if (opCallExpr.getName().equals("includesAll")) {
                System.out.println("Rule 4 a");
                QuantifiedLaxCondition laxCondition2 = this.laxconditionFactory.createQuantifiedLaxCondition();
                laxCondition2.setQuantifier(Quantifier.FORALL);
                Graph graph = this.graphFactory.createGraph();
                graph.setTypegraph(this.getTypeModel());
                Node node = this.graphFactory.createNode();
                node.setName(this.getNextVarName());
                Type srcOpCallExprType = opCallExpr.getOwnedSource().getType();
                if (srcOpCallExprType instanceof OrderedSetType) {
                    node.setType(this.getEClass(((OrderedSetType)srcOpCallExprType).getElementType().isClass()));
                } else if (srcOpCallExprType instanceof SetType) {
                    node.setType(this.getEClass(((SetType)srcOpCallExprType).getElementType().isClass()));
                } else {
                    node.setType(this.getEClass(((CollectionType)srcOpCallExprType).getElementType().isClass()));
                }
                graph.getNodes().add((Object)node);
                laxCondition2.setGraph(graph);
                Formula formula = this.laxconditionFactory.createFormula();
                formula.setOp(Operator.IMPLIES);
                Node setNode1 = this.getSetNode(node);
                formula.getArguments().add((Object)this.translate_S((OCLExpression)opCallExpr.getOwnedArguments().get(0), setNode1));
                Node setNode2 = this.getSetNode(node);
                formula.getArguments().add((Object)this.translate_S(opCallExpr.getOwnedSource(), setNode2));
                laxCondition2.setCondition((LaxCondition)formula);
                return laxCondition2;
            }
            if (opCallExpr.getName().equals("excludesAll")) {
                System.out.println("Rule 4 b");
                QuantifiedLaxCondition laxCondition3 = this.laxconditionFactory.createQuantifiedLaxCondition();
                laxCondition3.setQuantifier(Quantifier.FORALL);
                Graph graph = this.graphFactory.createGraph();
                graph.setTypegraph(this.getTypeModel());
                Node node = this.graphFactory.createNode();
                node.setName(this.getNextVarName());
                Type srcOpCallExprType = opCallExpr.getOwnedSource().getType();
                if (srcOpCallExprType instanceof OrderedSetType) {
                    node.setType(this.getEClass(((OrderedSetType)srcOpCallExprType).getElementType().isClass()));
                } else if (srcOpCallExprType instanceof SetType) {
                    node.setType(this.getEClass(((SetType)srcOpCallExprType).getElementType().isClass()));
                } else {
                    node.setType(this.getEClass(((CollectionType)srcOpCallExprType).getElementType().isClass()));
                }
                graph.getNodes().add((Object)node);
                laxCondition3.setGraph(graph);
                Formula formula = this.laxconditionFactory.createFormula();
                formula.setOp(Operator.IMPLIES);
                Node setNode1 = this.getSetNode(node);
                formula.getArguments().add((Object)this.translate_S((OCLExpression)opCallExpr.getOwnedArguments().get(0), setNode1));
                Node setNode2 = this.getSetNode(node);
                Formula notFormula = this.laxconditionFactory.createFormula();
                notFormula.setOp(Operator.NOT);
                notFormula.getArguments().add((Object)this.translate_S(opCallExpr.getOwnedSource(), setNode2));
                formula.getArguments().add((Object)notFormula);
                laxCondition3.setCondition((LaxCondition)formula);
                return laxCondition3;
            }
            if (opCallExpr.getName().equals("notEmpty")) {
                System.out.println("Rule 5");
                QuantifiedLaxCondition laxCondition4 = this.laxconditionFactory.createQuantifiedLaxCondition();
                laxCondition4.setQuantifier(Quantifier.EXISTS);
                Graph graph = this.graphFactory.createGraph();
                graph.setTypegraph(this.getTypeModel());
                Node node = this.graphFactory.createNode();
                node.setName(this.getNextVarName());
                Type srcOpCallExprType = opCallExpr.getOwnedSource().getType();
                if (srcOpCallExprType instanceof OrderedSetType) {
                    node.setType(this.getEClass(((OrderedSetType)srcOpCallExprType).getElementType().isClass()));
                } else if (srcOpCallExprType instanceof SetType) {
                    node.setType(this.getEClass(((SetType)srcOpCallExprType).getElementType().isClass()));
                } else {
                    node.setType(this.getEClass(((CollectionType)srcOpCallExprType).getElementType().isClass()));
                }
                graph.getNodes().add((Object)node);
                laxCondition4.setGraph(graph);
                Node setNode = this.getSetNode(node);
                laxCondition4.setCondition(this.translate_S(opCallExpr.getOwnedSource(), setNode));
                return laxCondition4;
            }
            if (opCallExpr.getName().equals(">=") && this.isSizeComparison(opCallExpr)) {
                OperationCallExp sourceOpCallExpr = (OperationCallExp)opCallExpr.getOwnedSource();
                Type srcOpCallExprType = sourceOpCallExpr.getOwnedSource().getType();
                type = null;
                type = srcOpCallExprType instanceof OrderedSetType ? this.getEClass(((OrderedSetType)srcOpCallExprType).getElementType().isClass()) : (srcOpCallExprType instanceof SetType ? this.getEClass(((SetType)srcOpCallExprType).getElementType().isClass()) : this.getEClass(((CollectionType)srcOpCallExprType).getElementType().isClass()));
                int literal = Integer.parseInt(((OCLExpression)opCallExpr.getOwnedArguments().get(0)).getName());
                if (literal > 0) {
                    System.out.println("Rule 6 a");
                    String[] vars = new String[literal];
                    int i = 0;
                    while (i < literal) {
                        vars[i] = this.getNextVarName();
                        ++i;
                    }
                    QuantifiedLaxCondition laxCondition5 = this.laxconditionFactory.createQuantifiedLaxCondition();
                    laxCondition5.setQuantifier(Quantifier.EXISTS);
                    Graph graph = this.graphFactory.createGraph();
                    graph.setTypegraph(this.getTypeModel());
                    int i2 = 0;
                    while (i2 < literal) {
                        Node node = this.graphFactory.createNode();
                        node.setName(vars[i2]);
                        node.setType(type);
                        graph.getNodes().add((Object)node);
                        ++i2;
                    }
                    laxCondition5.setGraph(graph);
                    if (literal == 1) {
                        Node setNode1 = this.graphFactory.createNode();
                        setNode1.setName(vars[0]);
                        setNode1.setType(type);
                        laxCondition5.setCondition(this.translate_S(sourceOpCallExpr.getOwnedSource(), setNode1));
                    } else {
                        Formula formula = this.laxconditionFactory.createFormula();
                        formula.setOp(Operator.AND);
                        int i3 = 0;
                        while (i3 < literal) {
                            Node setNode = this.graphFactory.createNode();
                            setNode.setName(vars[i3]);
                            setNode.setType(type);
                            formula.getArguments().add((Object)this.translate_S(sourceOpCallExpr.getOwnedSource(), setNode));
                            ++i3;
                        }
                        laxCondition5.setCondition((LaxCondition)formula);
                    }
                    return laxCondition5;
                }
                if (literal == 0) {
                    System.out.println("Rule 6 b");
                    return this.laxconditionFactory.createTrue();
                }
            }
            if (opCallExpr.getName().equals("=")) {
                expr1 = opCallExpr.getOwnedSource();
                expr2 = (OCLExpression)opCallExpr.getOwnedArguments().get(0);
                if (expr1.getType() instanceof Class && expr2.getType() instanceof Class && !(expr1.getType() instanceof DataType) && !(expr2.getType() instanceof DataType) && !(expr1.getType() instanceof OrderedSetType) && !(expr2.getType() instanceof OrderedSetType)) {
                    System.out.println("Rule 7 a");
                    laxCondition = this.laxconditionFactory.createQuantifiedLaxCondition();
                    laxCondition.setQuantifier(Quantifier.EXISTS);
                    Graph graph = this.graphFactory.createGraph();
                    graph.setTypegraph(this.getTypeModel());
                    Node node = this.graphFactory.createNode();
                    node.setName(this.getNextVarName());
                    node.setType(this.getEClass(expr1.getType().isClass()));
                    graph.getNodes().add((Object)node);
                    laxCondition.setGraph(graph);
                    Formula formula = this.laxconditionFactory.createFormula();
                    formula.setOp(Operator.AND);
                    Node setNode1 = this.getSetNode(node);
                    Node setNode2 = this.getSetNode(node);
                    formula.getArguments().add((Object)this.translate_N(expr1, setNode1));
                    formula.getArguments().add((Object)this.translate_N(expr2, setNode2));
                    laxCondition.setCondition((LaxCondition)formula);
                    return laxCondition;
                }
                if (expr1.getType() instanceof OrderedSetType && expr2.getType() instanceof OrderedSetType) {
                    System.out.println("Rule 7 b");
                    laxCondition = this.laxconditionFactory.createQuantifiedLaxCondition();
                    laxCondition.setQuantifier(Quantifier.FORALL);
                    Graph graph = this.graphFactory.createGraph();
                    graph.setTypegraph(this.getTypeModel());
                    Node node = this.graphFactory.createNode();
                    node.setName(this.getNextVarName());
                    Type expr1Type = expr1.getType();
                    if (expr1Type instanceof OrderedSetType) {
                        node.setType(this.getEClass(((OrderedSetType)expr1Type).getElementType().isClass()));
                    } else if (expr1Type instanceof SetType) {
                        node.setType(this.getEClass(((SetType)expr1Type).getElementType().isClass()));
                    } else {
                        node.setType(this.getEClass(((CollectionType)expr1Type).getElementType().isClass()));
                    }
                    graph.getNodes().add((Object)node);
                    laxCondition.setGraph(graph);
                    Formula formula = this.laxconditionFactory.createFormula();
                    formula.setOp(Operator.EQUIVALENT);
                    Node setNode1 = this.getSetNode(node);
                    Node setNode2 = this.getSetNode(node);
                    formula.getArguments().add((Object)this.translate_S(expr1, setNode1));
                    formula.getArguments().add((Object)this.translate_S(expr2, setNode2));
                    laxCondition.setCondition((LaxCondition)formula);
                    return laxCondition;
                }
            }
            if (this.isComparisonOperator(opCallExpr)) {
                expr1 = opCallExpr.getOwnedSource();
                expr2 = (OCLExpression)opCallExpr.getOwnedArguments().get(0);
                if (expr1 instanceof PropertyCallExp && expr2 instanceof PrimitiveLiteralExp) {
                    System.out.println("Rule 8");
                    type = this.getEClass(((PropertyCallExp)expr1).getOwnedSource().getType().isClass());
                    QuantifiedLaxCondition laxCondition6 = this.laxconditionFactory.createQuantifiedLaxCondition();
                    laxCondition6.setQuantifier(Quantifier.EXISTS);
                    Graph graph = this.graphFactory.createGraph();
                    graph.setTypegraph(this.getTypeModel());
                    Node node = this.graphFactory.createNode();
                    node.setName(this.getNextVarName());
                    node.setType(type);
                    graph.getNodes().add((Object)node);
                    laxCondition6.setGraph(graph);
                    Formula formula = this.laxconditionFactory.createFormula();
                    formula.setOp(Operator.AND);
                    Node setNode = this.getSetNode(node);
                    formula.getArguments().add((Object)this.translate_N(((PropertyCallExp)expr1).getOwnedSource(), setNode));
                    QuantifiedLaxCondition innerCondition = this.laxconditionFactory.createQuantifiedLaxCondition();
                    innerCondition.setQuantifier(Quantifier.EXISTS);
                    Graph innerGraph = this.graphFactory.createGraph();
                    innerGraph.setTypegraph(this.getTypeModel());
                    Node innerNode = this.graphFactory.createNode();
                    innerNode.setName(node.getName());
                    innerNode.setType(node.getType());
                    Attribute attribute = this.graphFactory.createAttribute();
                    attribute.setType(this.getEAttribute(type, (PropertyCallExp)expr1));
                    attribute.setOp(opCallExpr.getName());
                    attribute.setValue(expr2.getName());
                    innerNode.getAttributes().add((Object)attribute);
                    innerGraph.getNodes().add((Object)innerNode);
                    innerCondition.setGraph(innerGraph);
                    innerCondition.setCondition((LaxCondition)this.laxconditionFactory.createTrue());
                    formula.getArguments().add((Object)innerCondition);
                    laxCondition6.setCondition((LaxCondition)formula);
                    return laxCondition6;
                }
                if (expr1 instanceof PropertyCallExp && expr2 instanceof EnumLiteralExp) {
                    System.out.println("Rule 8 a NN");
                    type = this.getEClass(((PropertyCallExp)expr1).getOwnedSource().getType().isClass());
                    QuantifiedLaxCondition laxCondition7 = this.laxconditionFactory.createQuantifiedLaxCondition();
                    laxCondition7.setQuantifier(Quantifier.EXISTS);
                    Graph graph = this.graphFactory.createGraph();
                    graph.setTypegraph(this.getTypeModel());
                    Node node = this.graphFactory.createNode();
                    node.setName(this.getNextVarName());
                    node.setType(type);
                    graph.getNodes().add((Object)node);
                    laxCondition7.setGraph(graph);
                    Formula formula = this.laxconditionFactory.createFormula();
                    formula.setOp(Operator.AND);
                    Node setNode = this.getSetNode(node);
                    formula.getArguments().add((Object)this.translate_N(((PropertyCallExp)expr1).getOwnedSource(), setNode));
                    QuantifiedLaxCondition innerCondition = this.laxconditionFactory.createQuantifiedLaxCondition();
                    innerCondition.setQuantifier(Quantifier.EXISTS);
                    Graph innerGraph = this.graphFactory.createGraph();
                    innerGraph.setTypegraph(this.getTypeModel());
                    Node innerNode = this.graphFactory.createNode();
                    innerNode.setName(node.getName());
                    innerNode.setType(node.getType());
                    Attribute attribute = this.graphFactory.createAttribute();
                    attribute.setType(this.getEAttribute(type, (PropertyCallExp)expr1));
                    attribute.setOp(opCallExpr.getName());
                    EnumLiteralExp enm = (EnumLiteralExp)expr2;
                    attribute.setValue(enm.getReferredLiteral().getName());
                    innerNode.getAttributes().add((Object)attribute);
                    innerGraph.getNodes().add((Object)innerNode);
                    innerCondition.setGraph(innerGraph);
                    innerCondition.setCondition((LaxCondition)this.laxconditionFactory.createTrue());
                    formula.getArguments().add((Object)innerCondition);
                    laxCondition7.setCondition((LaxCondition)formula);
                    return laxCondition7;
                }
                if (expr1 instanceof PropertyCallExp && expr2 instanceof PropertyCallExp) {
                    String varName = this.getNextVarName();
                    if (this.varNames == null) {
                        this.varNames = new ArrayList<String>();
                    }
                    if (!this.varNames.contains(varName)) {
                        this.varNames.add(varName);
                    }
                    EClass type1 = this.getEClass(((PropertyCallExp)expr1).getOwnedSource().getType().isClass());
                    QuantifiedLaxCondition laxCondition1 = this.laxconditionFactory.createQuantifiedLaxCondition();
                    laxCondition1.setQuantifier(Quantifier.EXISTS);
                    laxcondition.Variable variable = this.laxconditionFactory.createVariable();
                    variable.setName(varName);
                    laxCondition1.getVariables().add((Object)variable);
                    Graph graph1 = this.graphFactory.createGraph();
                    graph1.setTypegraph(this.getTypeModel());
                    Node node1 = this.graphFactory.createNode();
                    node1.setName(this.getNextVarName());
                    node1.setType(type1);
                    graph1.getNodes().add((Object)node1);
                    laxCondition1.setGraph(graph1);
                    Formula formula1 = this.laxconditionFactory.createFormula();
                    formula1.setOp(Operator.AND);
                    Node navigationNode1a = this.getSetNode(node1);
                    Attribute attribute1a = this.graphFactory.createAttribute();
                    attribute1a.setType(this.getEAttribute(type1, (PropertyCallExp)expr1));
                    attribute1a.setOp(opCallExpr.getName());
                    attribute1a.setValue(varName);
                    navigationNode1a.getAttributes().add((Object)attribute1a);
                    LaxCondition innerCondition1a = this.translate_N(((PropertyCallExp)expr1).getOwnedSource(), navigationNode1a);
                    formula1.getArguments().add((Object)innerCondition1a);
                    Node navigationNode1b = this.getSetNode(node1);
                    Attribute attribute1b = this.graphFactory.createAttribute();
                    attribute1b.setType(this.getEAttribute(type1, (PropertyCallExp)expr1));
                    attribute1b.setOp("=");
                    attribute1b.setValue(varName);
                    navigationNode1b.getAttributes().add((Object)attribute1b);
                    LaxCondition innerCondition1b = this.translate_N(((PropertyCallExp)expr2).getOwnedSource(), navigationNode1b);
                    formula1.getArguments().add((Object)innerCondition1b);
                    laxCondition1.setCondition((LaxCondition)formula1);
                    EClass type2a = this.getEClass(((PropertyCallExp)expr1).getOwnedSource().getType().isClass());
                    EClass type2b = this.getEClass(((PropertyCallExp)expr2).getOwnedSource().getType().isClass());
                    QuantifiedLaxCondition laxCondition2 = this.laxconditionFactory.createQuantifiedLaxCondition();
                    laxCondition2.setQuantifier(Quantifier.EXISTS);
                    Graph graph2 = this.graphFactory.createGraph();
                    graph2.setTypegraph(this.getTypeModel());
                    Node node2a = this.graphFactory.createNode();
                    node2a.setName(this.getNextVarName());
                    node2a.setType(type2a);
                    Node node2b = this.graphFactory.createNode();
                    node2b.setName(this.getNextVarName());
                    node2b.setType(type2b);
                    graph2.getNodes().add((Object)node2a);
                    graph2.getNodes().add((Object)node2b);
                    laxCondition2.setGraph(graph2);
                    Formula formula2 = this.laxconditionFactory.createFormula();
                    formula2.setOp(Operator.AND);
                    Node navigationNode2a = this.getSetNode(node2a);
                    Attribute attribute2a = this.graphFactory.createAttribute();
                    attribute2a.setType(this.getEAttribute(type2a, (PropertyCallExp)expr1));
                    attribute2a.setOp(opCallExpr.getName());
                    attribute2a.setValue(varName);
                    navigationNode2a.getAttributes().add((Object)attribute2a);
                    LaxCondition innerCondition2a = this.translate_N(((PropertyCallExp)expr1).getOwnedSource(), navigationNode2a);
                    formula2.getArguments().add((Object)innerCondition2a);
                    Node navigationNode2b = this.getSetNode(node2b);
                    Attribute attribute2b = this.graphFactory.createAttribute();
                    attribute2b.setType(this.getEAttribute(type2b, (PropertyCallExp)expr2));
                    attribute2b.setOp("=");
                    attribute2b.setValue(varName);
                    navigationNode2b.getAttributes().add((Object)attribute2b);
                    LaxCondition innerCondition2b = this.translate_N(((PropertyCallExp)expr2).getOwnedSource(), navigationNode2b);
                    formula2.getArguments().add((Object)innerCondition2b);
                    laxCondition2.setCondition((LaxCondition)formula2);
                    if (this.isIsomorphic(((PropertyCallExp)expr1).getOwnedSource(), ((PropertyCallExp)expr2).getOwnedSource())) {
                        System.out.println("Rule 9 b");
                        return laxCondition1;
                    }
                    if (this.isClanDisjoint(((PropertyCallExp)expr1).getOwnedSource(), ((PropertyCallExp)expr2).getOwnedSource())) {
                        System.out.println("Rule 9 c");
                        return laxCondition2;
                    }
                    System.out.println("Rule 9 a");
                    Formula formula = this.laxconditionFactory.createFormula();
                    formula.setOp(Operator.OR);
                    formula.getArguments().add((Object)laxCondition1);
                    formula.getArguments().add((Object)laxCondition2);
                    return formula;
                }
            }
            if (opCallExpr.getName().equals("oclIsKindOf")) {
                System.out.println("Rule 10 a");
                sourceExpr = opCallExpr.getOwnedSource();
                typeExpr = (OCLExpression)opCallExpr.getOwnedArguments().get(0);
                laxCondition = this.laxconditionFactory.createQuantifiedLaxCondition();
                laxCondition.setQuantifier(Quantifier.EXISTS);
                Graph graph = this.graphFactory.createGraph();
                graph.setTypegraph(this.getTypeModel());
                Node node = this.graphFactory.createNode();
                node.setName(this.getNextVarName());
                node.setType(this.getEClass(((TypeExp)typeExpr).getReferredType().isClass()));
                graph.getNodes().add((Object)node);
                laxCondition.setGraph(graph);
                Node navNode = this.getSetNode(node);
                navNode.setType(this.getEClass(sourceExpr.getType().isClass()));
                laxCondition.setCondition(this.translate_N(sourceExpr, navNode));
                return laxCondition;
            }
            if (opCallExpr.getName().equals("oclIsTypeOf")) {
                System.out.println("Rule 10 b");
                sourceExpr = opCallExpr.getOwnedSource();
                typeExpr = (OCLExpression)opCallExpr.getOwnedArguments().get(0);
                laxCondition = this.laxconditionFactory.createQuantifiedLaxCondition();
                laxCondition.setQuantifier(Quantifier.EXISTS);
                Graph graph = this.graphFactory.createGraph();
                graph.setTypegraph(this.getTypeModel());
                Node node = this.graphFactory.createNode();
                node.setName(this.getNextVarName());
                node.setType(this.getEClass(((TypeExp)typeExpr).getReferredType().isClass()));
                graph.getNodes().add((Object)node);
                laxCondition.setGraph(graph);
                Node navNode = this.getSetNode(node);
                navNode.setType(this.getEClass(sourceExpr.getType().isClass()));
                EList<EClass> subclasses = this.getAllSubclasses(node.getType());
                if (subclasses.isEmpty()) {
                    laxCondition.setCondition(this.translate_N(sourceExpr, navNode));
                } else {
                    Formula and = this.laxconditionFactory.createFormula();
                    and.setOp(Operator.AND);
                    and.getArguments().add((Object)this.translate_N(sourceExpr, navNode));
                    for (EClass subclass : subclasses) {
                        Formula not = this.laxconditionFactory.createFormula();
                        not.setOp(Operator.NOT);
                        QuantifiedLaxCondition innerCondition = this.laxconditionFactory.createQuantifiedLaxCondition();
                        innerCondition.setQuantifier(Quantifier.EXISTS);
                        Graph innerGraph = this.graphFactory.createGraph();
                        innerGraph.setTypegraph(this.getTypeModel());
                        Node innerNode = this.graphFactory.createNode();
                        innerNode.setName(this.getNextVarName());
                        innerNode.setType(subclass);
                        innerGraph.getNodes().add((Object)innerNode);
                        innerCondition.setGraph(innerGraph);
                        innerCondition.setCondition((LaxCondition)this.laxconditionFactory.createTrue());
                        not.getArguments().add((Object)innerCondition);
                        and.getArguments().add((Object)not);
                    }
                    laxCondition.setCondition((LaxCondition)and);
                }
                return laxCondition;
            }
        }
        if (expr instanceof IfExp) {
            System.out.println("Rule 2 f");
            IfExp ifExpr = (IfExp)expr;
            Formula formula = this.laxconditionFactory.createFormula();
            formula.setOp(Operator.OR);
            Formula firstAnd = this.laxconditionFactory.createFormula();
            firstAnd.setOp(Operator.AND);
            firstAnd.getArguments().add((Object)this.translate_E(ifExpr.getOwnedCondition()));
            firstAnd.getArguments().add((Object)this.translate_E(ifExpr.getOwnedThen()));
            formula.getArguments().add((Object)firstAnd);
            Formula secondAnd = this.laxconditionFactory.createFormula();
            secondAnd.setOp(Operator.AND);
            Formula notFormula = this.laxconditionFactory.createFormula();
            notFormula.setOp(Operator.NOT);
            notFormula.getArguments().add((Object)this.translate_E(ifExpr.getOwnedCondition()));
            secondAnd.getArguments().add((Object)notFormula);
            secondAnd.getArguments().add((Object)this.translate_E(ifExpr.getOwnedElse()));
            formula.getArguments().add((Object)secondAnd);
            return formula;
        }
        if (expr instanceof IteratorExp) {
            Node node;
            Graph graph;
            QuantifiedLaxCondition laxCondition;
            IteratorExp itExpr = (IteratorExp)expr;
            if (itExpr.getName().equals("exists")) {
                System.out.println("Rule 3 a");
                laxCondition = this.laxconditionFactory.createQuantifiedLaxCondition();
                laxCondition.setQuantifier(Quantifier.EXISTS);
                graph = this.graphFactory.createGraph();
                graph.setTypegraph(this.getTypeModel());
                node = this.graphFactory.createNode();
                node.setName(((Variable)itExpr.getOwnedIterators().get(0)).getName());
                node.setType(this.getEClass(((Variable)itExpr.getOwnedIterators().get(0)).getType().isClass()));
                graph.getNodes().add((Object)node);
                laxCondition.setGraph(graph);
                Formula formula = this.laxconditionFactory.createFormula();
                formula.setOp(Operator.AND);
                Node setNode = this.getSetNode(node);
                formula.getArguments().add((Object)this.translate_S(itExpr.getOwnedSource(), setNode));
                formula.getArguments().add((Object)this.translate_E(itExpr.getOwnedBody()));
                laxCondition.setCondition((LaxCondition)formula);
                return laxCondition;
            }
            if (itExpr.getName().equals("forAll")) {
                System.out.println("Rule 3 b");
                laxCondition = this.laxconditionFactory.createQuantifiedLaxCondition();
                laxCondition.setQuantifier(Quantifier.FORALL);
                graph = this.graphFactory.createGraph();
                graph.setTypegraph(this.getTypeModel());
                node = this.graphFactory.createNode();
                node.setName(((Variable)itExpr.getOwnedIterators().get(0)).getName());
                node.setType(this.getEClass(((Variable)itExpr.getOwnedIterators().get(0)).getType().isClass()));
                graph.getNodes().add((Object)node);
                laxCondition.setGraph(graph);
                Formula formula = this.laxconditionFactory.createFormula();
                formula.setOp(Operator.IMPLIES);
                Node setNode = this.getSetNode(node);
                formula.getArguments().add((Object)this.translate_S(itExpr.getOwnedSource(), setNode));
                formula.getArguments().add((Object)this.translate_E(itExpr.getOwnedBody()));
                laxCondition.setCondition((LaxCondition)formula);
                return laxCondition;
            }
        }
        return null;
    }

    protected LaxCondition translate_N(OCLExpression expr, Node node) {
        OperationCallExp opCallExpr;
        if (expr instanceof OperationCallExp && (opCallExpr = (OperationCallExp)expr).getName().equals("oclAsType")) {
            System.out.println("Rule 11");
            OCLExpression sourceExpr = opCallExpr.getOwnedSource();
            QuantifiedLaxCondition laxCondition = this.laxconditionFactory.createQuantifiedLaxCondition();
            laxCondition.setQuantifier(Quantifier.EXISTS);
            Graph graph = this.graphFactory.createGraph();
            graph.setTypegraph(this.getTypeModel());
            Node graphNode = this.getSetNode(node);
            graph.getNodes().add((Object)graphNode);
            laxCondition.setGraph(graph);
            Node navNode = this.getSetNode(node);
            navNode.setType(this.getEClass(sourceExpr.getType().isClass()));
            laxCondition.setCondition(this.translate_N(sourceExpr, navNode));
            return laxCondition;
        }
        if (expr instanceof VariableExp) {
            System.out.println("Rule 12 a");
            VariableExp varExpr = (VariableExp)expr;
            String varName = varExpr.getReferredVariable().getName();
            String nodeName = node.getName();
            String newNodeName = String.valueOf(varName) + "=" + nodeName;
            node.setName(newNodeName);
            QuantifiedLaxCondition laxCondition = this.laxconditionFactory.createQuantifiedLaxCondition();
            laxCondition.setQuantifier(Quantifier.EXISTS);
            Graph graph = this.graphFactory.createGraph();
            graph.setTypegraph(this.getTypeModel());
            graph.getNodes().add((Object)node);
            laxCondition.setGraph(graph);
            laxCondition.setCondition((LaxCondition)this.laxconditionFactory.createTrue());
            return laxCondition;
        }
        if (expr instanceof PropertyCallExp) {
            System.out.println("Rule 12 b");
            PropertyCallExp propCallExpr = (PropertyCallExp)expr;
            Property prop = propCallExpr.getReferredProperty();
            OCLExpression sourceExpr = propCallExpr.getOwnedSource();
            EClass sourceType = this.getEClass(sourceExpr.getType().isClass());
            EReference ref = this.getEReference(sourceType, prop);
            QuantifiedLaxCondition laxCondition1 = this.laxconditionFactory.createQuantifiedLaxCondition();
            laxCondition1.setQuantifier(Quantifier.EXISTS);
            Graph graph1 = this.graphFactory.createGraph();
            graph1.setTypegraph(this.getTypeModel());
            Node node1 = this.graphFactory.createNode();
            node1.setName(this.getNextVarName());
            node1.setType(sourceType);
            Edge edge1 = this.graphFactory.createEdge();
            edge1.setType(ref);
            edge1.setSource(node1);
            Node setNode = this.getSetNode(node);
            edge1.setTarget(setNode);
            graph1.getNodes().add((Object)setNode);
            graph1.getNodes().add((Object)node1);
            graph1.getEdges().add((Object)edge1);
            laxCondition1.setGraph(graph1);
            laxCondition1.setCondition(this.translate_N(sourceExpr, this.getSetNode(node1)));
            if (!this.getClan(node.getType()).contains((Object)sourceType)) {
                return laxCondition1;
            }
            QuantifiedLaxCondition laxCondition2 = this.laxconditionFactory.createQuantifiedLaxCondition();
            laxCondition2.setQuantifier(Quantifier.EXISTS);
            Graph graph2 = this.graphFactory.createGraph();
            graph2.setTypegraph(this.getTypeModel());
            Node node2 = this.getSetNode(node1);
            Edge edge2 = this.graphFactory.createEdge();
            edge2.setType(ref);
            edge2.setSource(node2);
            edge2.setTarget(node2);
            graph2.getNodes().add((Object)node2);
            graph2.getEdges().add((Object)edge2);
            laxCondition2.setGraph(graph2);
            laxCondition2.setCondition(this.translate_N(sourceExpr, this.getSetNode(node1)));
            Formula formula = this.laxconditionFactory.createFormula();
            formula.setOp(Operator.OR);
            formula.getArguments().add((Object)laxCondition1);
            formula.getArguments().add((Object)laxCondition2);
            return formula;
        }
        return this.laxconditionFactory.createTrue();
    }

    protected LaxCondition translate_S(OCLExpression expr, Node node) {
        CollectionLiteralExp collectionLiteralExp;
        System.out.println(expr);
        if (expr instanceof PropertyCallExp) {
            System.out.println("Rule 12 c");
            PropertyCallExp propCallExpr = (PropertyCallExp)expr;
            Property prop = propCallExpr.getReferredProperty();
            OCLExpression sourceExpr = propCallExpr.getOwnedSource();
            EClass sourceType = this.getEClass(sourceExpr.getType().isClass());
            EReference ref = this.getEReference(sourceType, prop);
            QuantifiedLaxCondition laxCondition1 = this.laxconditionFactory.createQuantifiedLaxCondition();
            laxCondition1.setQuantifier(Quantifier.EXISTS);
            Graph graph1 = this.graphFactory.createGraph();
            graph1.setTypegraph(this.getTypeModel());
            Node node1 = this.graphFactory.createNode();
            node1.setName(this.getNextVarName());
            node1.setType(sourceType);
            Edge edge1 = this.graphFactory.createEdge();
            edge1.setType(ref);
            edge1.setSource(node1);
            Node setNode = this.getSetNode(node);
            edge1.setTarget(setNode);
            graph1.getNodes().add((Object)setNode);
            graph1.getNodes().add((Object)node1);
            graph1.getEdges().add((Object)edge1);
            laxCondition1.setGraph(graph1);
            laxCondition1.setCondition(this.translate_N(sourceExpr, this.getSetNode(node1)));
            if (!this.getClan(node.getType()).contains((Object)sourceType)) {
                return laxCondition1;
            }
            QuantifiedLaxCondition laxCondition2 = this.laxconditionFactory.createQuantifiedLaxCondition();
            laxCondition2.setQuantifier(Quantifier.EXISTS);
            Graph graph2 = this.graphFactory.createGraph();
            graph2.setTypegraph(this.getTypeModel());
            Node node2 = this.getSetNode(node1);
            Edge edge2 = this.graphFactory.createEdge();
            edge2.setType(ref);
            edge2.setSource(node2);
            edge2.setTarget(node2);
            graph2.getNodes().add((Object)node2);
            graph2.getEdges().add((Object)edge2);
            laxCondition2.setGraph(graph2);
            laxCondition2.setCondition(this.translate_N(sourceExpr, this.getSetNode(node1)));
            Formula formula = this.laxconditionFactory.createFormula();
            formula.setOp(Operator.OR);
            formula.getArguments().add((Object)laxCondition1);
            formula.getArguments().add((Object)laxCondition2);
            return formula;
        }
        if (expr instanceof IteratorExp) {
            IteratorExp itExpr = (IteratorExp)expr;
            Variable iterator = (Variable)itExpr.getOwnedIterators().get(0);
            OCLExpression expr1 = itExpr.getOwnedSource();
            OCLExpression expr2 = itExpr.getOwnedBody();
            if (itExpr.getName().equals("select")) {
                System.out.println("Rule 13 a");
                iterator.setName(node.getName());
                Formula formula = this.laxconditionFactory.createFormula();
                formula.setOp(Operator.AND);
                formula.getArguments().add((Object)this.translate_S(expr1, node));
                formula.getArguments().add((Object)this.translate_E(expr2));
                return formula;
            }
            if (itExpr.getName().equals("reject")) {
                System.out.println("Rule 13 b");
                iterator.setName(node.getName());
                Formula formula = this.laxconditionFactory.createFormula();
                formula.setOp(Operator.AND);
                formula.getArguments().add((Object)this.translate_S(expr1, node));
                Formula notFormula = this.laxconditionFactory.createFormula();
                notFormula.setOp(Operator.NOT);
                notFormula.getArguments().add((Object)this.translate_E(expr2));
                formula.getArguments().add((Object)notFormula);
                return formula;
            }
            if (itExpr.getName().equals("collect")) {
                System.out.println("Rule 14");
                QuantifiedLaxCondition laxcondition = this.laxconditionFactory.createQuantifiedLaxCondition();
                laxcondition.setQuantifier(Quantifier.EXISTS);
                Graph graph1 = this.graphFactory.createGraph();
                graph1.setTypegraph(this.getTypeModel());
                Node node1 = this.graphFactory.createNode();
                node1.setName(iterator.getName());
                node1.setType(this.getEClass(iterator.getType().isClass()));
                graph1.getNodes().add((Object)node1);
                laxcondition.setGraph(graph1);
                Formula formula = this.laxconditionFactory.createFormula();
                formula.setOp(Operator.AND);
                Node node2 = this.getSetNode(node1);
                formula.getArguments().add((Object)this.translate_S(expr1, node2));
                if (expr2.getType() instanceof OrderedSetType) {
                    System.out.println(" from 14: a");
                    formula.getArguments().add((Object)this.translate_S(expr2, node));
                } else {
                    System.out.println(" from 14: b");
                    formula.getArguments().add((Object)this.translate_N(expr2, node));
                }
                laxcondition.setCondition((LaxCondition)formula);
                return laxcondition;
            }
        }
        if (expr instanceof OperationCallExp) {
            OperationCallExp opCallExpr = (OperationCallExp)expr;
            OCLExpression expr1 = opCallExpr.getOwnedSource();
            OCLExpression expr2 = null;
            if (opCallExpr.getOwnedSource() != null && opCallExpr.getName().equals("oclAsSet")) {
                System.out.println("Rule 15 e");
                return this.translate_S(opCallExpr.getOwnedSource(), node);
            }
            if (!opCallExpr.getOwnedArguments().isEmpty()) {
                expr2 = (OCLExpression)opCallExpr.getOwnedArguments().get(0);
                if (expr1.getType() instanceof OrderedSetType && expr2.getType() instanceof OrderedSetType) {
                    Formula formula;
                    if (opCallExpr.getName().equals("union")) {
                        System.out.println("Rule 15 (a)");
                        formula = this.laxconditionFactory.createFormula();
                        formula.setOp(Operator.OR);
                        Node setNode1 = this.getSetNode(node);
                        formula.getArguments().add((Object)this.translate_S(expr1, setNode1));
                        Node setNode2 = this.getSetNode(node);
                        formula.getArguments().add((Object)this.translate_S(expr2, setNode2));
                        return formula;
                    }
                    if (opCallExpr.getName().equals("intersection")) {
                        System.out.println("Rule 15 (b)");
                        formula = this.laxconditionFactory.createFormula();
                        formula.setOp(Operator.AND);
                        Node setNode1 = this.getSetNode(node);
                        formula.getArguments().add((Object)this.translate_S(expr1, setNode1));
                        Node setNode2 = this.getSetNode(node);
                        formula.getArguments().add((Object)this.translate_S(expr2, setNode2));
                        return formula;
                    }
                    if (opCallExpr.getName().equals("-")) {
                        System.out.println("Rule 15 (c)");
                        formula = this.laxconditionFactory.createFormula();
                        formula.setOp(Operator.AND);
                        Node setNode1 = this.getSetNode(node);
                        formula.getArguments().add((Object)this.translate_S(expr1, setNode1));
                        Node setNode2 = this.getSetNode(node);
                        Formula notFormula = this.laxconditionFactory.createFormula();
                        notFormula.setOp(Operator.NOT);
                        notFormula.getArguments().add((Object)this.translate_S(expr2, setNode2));
                        formula.getArguments().add((Object)notFormula);
                        return formula;
                    }
                    if (opCallExpr.getName().equals("symmetricDifference")) {
                        System.out.println("Rule 15 (d)");
                        formula = this.laxconditionFactory.createFormula();
                        formula.setOp(Operator.XOR);
                        Node setNode1 = this.getSetNode(node);
                        formula.getArguments().add((Object)this.translate_S(expr1, setNode1));
                        Node setNode2 = this.getSetNode(node);
                        formula.getArguments().add((Object)this.translate_S(expr2, setNode2));
                        return formula;
                    }
                }
            }
            if (opCallExpr.getName().equals("allInstances")) {
                System.out.println("Rule 16");
                QuantifiedLaxCondition laxCondition = this.laxconditionFactory.createQuantifiedLaxCondition();
                laxCondition.setQuantifier(Quantifier.EXISTS);
                Graph graph = this.graphFactory.createGraph();
                graph.setTypegraph(this.getTypeModel());
                graph.getNodes().add((Object)node);
                laxCondition.setGraph(graph);
                laxCondition.setCondition((LaxCondition)this.laxconditionFactory.createTrue());
                return laxCondition;
            }
        }
        if (expr instanceof CollectionLiteralExp && (collectionLiteralExp = (CollectionLiteralExp)expr).getKind().equals((Object)CollectionKind.SET)) {
            Formula formula;
            if (collectionLiteralExp.getOwnedParts().isEmpty()) {
                System.out.println("Rule 17 a");
                formula = this.laxconditionFactory.createFormula();
                formula.setOp(Operator.NOT);
                formula.getArguments().add((Object)this.laxconditionFactory.createTrue());
                return formula;
            }
            if (collectionLiteralExp.getOwnedParts().size() == 1) {
                System.out.println("Rule 17 b");
                CollectionItem item = (CollectionItem)collectionLiteralExp.getOwnedParts().get(0);
                return this.translate_N(item.getOwnedItem(), node);
            }
            if (collectionLiteralExp.getOwnedParts().size() > 1) {
                System.out.println("Rule 17 c");
                formula = this.laxconditionFactory.createFormula();
                formula.setOp(Operator.OR);
                for (CollectionLiteralPart part : collectionLiteralExp.getOwnedParts()) {
                    CollectionItem item = (CollectionItem)part;
                    formula.getArguments().add((Object)this.translate_N(item.getOwnedItem(), node));
                }
                return formula;
            }
        }
        return this.laxconditionFactory.createTrue();
    }

    protected EReference getEReference(EClass eClass, Property prop) {
        for (EReference ref : eClass.getEAllReferences()) {
            if (!ref.getName().equals(prop.getName())) continue;
            return ref;
        }
        return null;
    }

    protected boolean isIsomorphic(OCLExpression expr1, OCLExpression expr2) {
        if (expr1 instanceof VariableExp && expr2 instanceof VariableExp) {
            VariableExp varExpr1 = (VariableExp)expr1;
            VariableExp varExpr2 = (VariableExp)expr2;
            return varExpr1.getReferredVariable() == varExpr2.getReferredVariable();
        }
        if (expr1 instanceof PropertyCallExp && expr2 instanceof PropertyCallExp) {
            PropertyCallExp propExpr1 = (PropertyCallExp)expr1;
            PropertyCallExp propExpr2 = (PropertyCallExp)expr2;
            if (propExpr1.getReferredProperty() == propExpr2.getReferredProperty()) {
                return this.isIsomorphic(propExpr1.getOwnedSource(), propExpr2.getOwnedSource());
            }
            return false;
        }
        return false;
    }

    protected boolean isClanDisjoint(OCLExpression expr1, OCLExpression expr2) {
        EClass eClass1 = this.getEClass(expr1.getType().isClass());
        EClass eClass2 = this.getEClass(expr2.getType().isClass());
        EList<EClass> clan1 = this.getClan(eClass1);
        EList<EClass> clan2 = this.getClan(eClass2);
        for (EClass eClass : clan1) {
            if (!clan2.contains((Object)eClass)) continue;
            return false;
        }
        return true;
    }

    protected EList<EClass> getClan(EClass eClass) {
        BasicEList eClasses = new BasicEList();
        eClasses.add((Object)eClass);
        eClasses.addAll(this.getAllSubclasses(eClass));
        return eClasses;
    }

    protected EList<EClass> getAllSubclasses(EClass eClass) {
        BasicEList eClasses = new BasicEList();
        if (eClass != null) {
            EPackage ePackage = eClass.getEPackage();
            TreeIterator iter = ePackage.eAllContents();
            while (iter.hasNext()) {
                EClass clazz;
                EObject eObject = (EObject)iter.next();
                if (!(eObject instanceof EClass) || !(clazz = (EClass)eObject).getEAllSuperTypes().contains((Object)eClass)) continue;
                eClasses.add((Object)clazz);
            }
        } else {
            System.err.println("Error: Param is null- getAllSubclasses");
        }
        return eClasses;
    }

    protected EAttribute getEAttribute(EClass type, PropertyCallExp expr) {
        if (expr != null && type != null) {
            Property prop = expr.getReferredProperty();
            for (EAttribute attr : type.getEAllAttributes()) {
                if (!attr.getName().equals(prop.getName())) continue;
                return attr;
            }
        }
        return null;
    }

    protected boolean isComparisonOperator(OperationCallExp opCallExpr) {
        if (opCallExpr.getName().equals("=")) {
            return true;
        }
        if (opCallExpr.getName().equals("<>")) {
            return true;
        }
        if (opCallExpr.getName().equals(">")) {
            return true;
        }
        if (opCallExpr.getName().equals(">=")) {
            return true;
        }
        if (opCallExpr.getName().equals("<")) {
            return true;
        }
        return opCallExpr.getName().equals("<=");
    }

    protected boolean isSizeComparison(OperationCallExp opCallExpr) {
        OCLExpression argExpr;
        OperationCallExp sourceOpCallExpr;
        return opCallExpr.getOwnedSource() instanceof OperationCallExp && (sourceOpCallExpr = (OperationCallExp)opCallExpr.getOwnedSource()).getName().equals("size") && ((argExpr = (OCLExpression)opCallExpr.getOwnedArguments().get(0)) instanceof IntegerLiteralExp || argExpr instanceof RealLiteralExp || argExpr instanceof UnlimitedNaturalLiteralExp);
    }

    protected String getNextVarName() {
        String varName = "var";
        varName = String.valueOf(varName) + this.varIndex;
        ++this.varIndex;
        return varName;
    }

    protected Node getSetNode(Node node) {
        Node setNode = this.graphFactory.createNode();
        setNode.setName(node.getName());
        setNode.setType(node.getType());
        return setNode;
    }

    public void persistLaxCondition(Date date, Condition condition) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyMMddHHmmss");
        String path = this.oclasFile.getParent().getLocation().append("/laxconditions_" + sdf.format(date)).toOSString();
        TranslatorResourceSet resourceSet = new TranslatorResourceSet(path);
        resourceSet.saveEObject((EObject)condition, condition.getName().concat(".laxcondition"));
        try {
            this.oclasFile.getParent().refreshLocal(1, null);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    protected EClass getEClass(Class clazz) {
        for (EClassifier classifier : this.getTypeModel().getEClassifiers()) {
            if (!(classifier instanceof EClass) || !classifier.getName().equals(clazz.getName())) continue;
            return (EClass)classifier;
        }
        return null;
    }

    public EPackage getTypeModel() {
        return this.typeModel;
    }

    protected void setTypeModel(EPackage typeModel) {
        this.typeModel = typeModel;
    }
}

