/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.ocl2ac.tool.commands;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import laxcondition.Condition;
import laxcondition.LaxconditionPackage;
import laxcondition.Variable;
import laxcondition.util.extensions.LaxConditionSimplifier;
import nestedcondition.NestedCondition;
import nestedcondition.NestedConstraint;
import nestedcondition.NestedconditionFactory;
import nestedcondition.util.extensions.NestedConditionSimplifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.henshin.interpreter.EGraph;
import org.eclipse.emf.henshin.interpreter.Engine;
import org.eclipse.emf.henshin.interpreter.Match;
import org.eclipse.emf.henshin.interpreter.impl.EGraphImpl;
import org.eclipse.emf.henshin.interpreter.impl.EngineImpl;
import org.eclipse.emf.henshin.interpreter.util.InterpreterUtil;
import org.eclipse.emf.henshin.model.HenshinFactory;
import org.eclipse.emf.henshin.model.HenshinPackage;
import org.eclipse.emf.henshin.model.Mapping;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Parameter;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.ocl2ac.ocl2gc.core.Completer;
import org.eclipse.swt.widgets.Shell;

public class LaxCond2GCCommand {
    private Shell shell;
    HashMap<Condition, List<String>> mapCon2Var = null;

    public NestedConstraint translate(Condition compactCondition) {
        this.mapCon2Var = new HashMap();
        long start = System.currentTimeMillis();
        this.mapCon2Var.put(compactCondition, this.getDistinctVariableNames(compactCondition));
        this.simplifyLaxCondition(compactCondition);
        NestedConstraint nestedGraphConstraint = this.completeLaxConditions(this.mapCon2Var, compactCondition);
        this.simplifyNestedConstraints(nestedGraphConstraint);
        long stop = System.currentTimeMillis();
        return nestedGraphConstraint;
    }

    private List<String> getDistinctVariableNames(Condition cond) {
        ArrayList<String> varNames = new ArrayList<String>();
        HenshinFactory factory = HenshinFactory.eINSTANCE;
        Rule rule = factory.createRule();
        Parameter param = factory.createParameter("p");
        rule.getParameters().add((Object)param);
        Node sourceLHS = factory.createNode(rule.getLhs(), LaxconditionPackage.Literals.VARIABLE, "");
        sourceLHS.setName(param.getName());
        Node sourceRHS = factory.createNode(rule.getRhs(), LaxconditionPackage.Literals.VARIABLE, "");
        sourceRHS.setName(param.getName());
        Mapping sourceMapping = factory.createMapping(sourceLHS, sourceRHS);
        rule.getMappings().add((Object)sourceMapping);
        HenshinPackage.eINSTANCE.eClass();
        EGraphImpl graph = new EGraphImpl((EObject)cond);
        EngineImpl engine = new EngineImpl(new String[0]);
        List allMatches = InterpreterUtil.findAllMatches((Engine)engine, (Rule)rule, (EGraph)graph, null);
        for (Match m : allMatches) {
            Variable v;
            Object parameterValue = m.getParameterValue(param);
            if (!(parameterValue instanceof Variable) || (v = (Variable)parameterValue).getName() == null || varNames.contains(v.getName())) continue;
            varNames.add(v.getName());
        }
        return varNames;
    }

    private void simplifyNestedConstraints(NestedConstraint nestedconstrain) {
        try {
            NestedConditionSimplifier simplifierNGC = new NestedConditionSimplifier(nestedconstrain);
            simplifierNGC.simplify();
        }
        catch (Exception exception) {
            System.err.println("The nestedconstrain " + nestedconstrain.getName() + " is not simplified well");
        }
    }

    private NestedConstraint completeLaxConditions(HashMap<Condition, List<String>> mapCon2Var, Condition condition) {
        List<String> conditionVarNames = null;
        NestedConstraint nestedConstraint = null;
        try {
            conditionVarNames = mapCon2Var.get(condition);
            Completer completer = new Completer(condition);
            completer.complete();
            nestedConstraint = completer.getConstraint();
            NestedCondition nestedCondition = nestedConstraint.getCondition();
            if (conditionVarNames != null) {
                this.addVariables2Condition(nestedCondition, conditionVarNames);
            }
        }
        catch (Exception exception) {
            System.err.println("The condition " + condition.getName() + " is not completed well");
        }
        return nestedConstraint;
    }

    private void simplifyLaxCondition(Condition condition) {
        try {
            LaxConditionSimplifier simplifier = new LaxConditionSimplifier(condition);
            simplifier.simplify();
        }
        catch (Exception exception) {
            System.err.println("The condition " + condition.getName() + " is not simplified well");
        }
    }

    private void addVariables2Condition(NestedCondition nestedCondition, List<String> conditionVarNames) {
        for (String v : conditionVarNames) {
            nestedcondition.Variable conVar = NestedconditionFactory.eINSTANCE.createVariable();
            conVar.setName(v);
            if (nestedCondition.getVariables().contains((Object)conVar)) continue;
            nestedCondition.getVariables().add((Object)conVar);
        }
    }
}

