/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mint.internal.ui.actions;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.mint.IItemJavaElementDescriptor;
import org.eclipse.emf.mint.IJavaTypeReference;
import org.eclipse.emf.mint.internal.ui.actions.Messages;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.IPackagesViewPart;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class OpenGeneratedAction
extends Action {
    protected final IItemJavaElementDescriptor descriptor;
    protected final Object target;

    public OpenGeneratedAction(IItemJavaElementDescriptor descriptor, Object target) {
        this.descriptor = descriptor;
        this.target = target;
        this.initialize();
    }

    protected void initialize() {
        this.setText(this.descriptor.getDisplayName(this.target));
        IJavaElement element = this.descriptor.getJavaElement(this.target);
        if (element != null && !element.exists()) {
            this.setEnabled(false);
        }
    }

    public void run() {
        Object element = null;
        IStatus status = null;
        switch (this.descriptor.getKind(this.target)) {
            case JAVA_ELEMENT: {
                element = this.descriptor.getJavaElement(this.target);
                break;
            }
            case JAVA_TYPE_REFERENCE: {
                IJavaTypeReference reference = this.descriptor.getJavaTypeReference(this.target);
                if (reference == null) break;
                IJavaProject context = reference.getContext();
                String typeName = reference.getTypeName();
                try {
                    element = context.findType(typeName);
                }
                catch (JavaModelException e) {
                    status = e.getStatus();
                }
                if (element != null) break;
                String msg = NLS.bind((String)Messages.OpenGeneratedAction_LocateError, (Object)typeName, (Object)context.getProject().getName());
                if (status == null) {
                    status = new Status(4, "org.eclipse.emf.mint.ui", 0, msg, null);
                    break;
                }
                MultiStatus multiStatus = new MultiStatus("org.eclipse.emf.mint.ui", 0, msg, null);
                multiStatus.add(status);
                status = multiStatus;
                break;
            }
            case NON_JAVA_RESOURCE: {
                element = this.descriptor.getNonJavaElement(this.target);
            }
        }
        if (element == null) {
            if (status == null) {
                status = new Status(4, "org.eclipse.emf.mint.ui", 0, "Could not open '" + this.descriptor.getDisplayName(this.target) + "'.", null);
            }
            ErrorDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.OpenGeneratedAction_ErrorFindType, null, status);
            return;
        }
        try {
            if (element instanceof ISourceReference) {
                JavaUI.openInEditor((IJavaElement)element);
            } else {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                if (page != null) {
                    if (element instanceof IFile) {
                        IDE.openEditor((IWorkbenchPage)page, (IFile)((IFile)element));
                    } else {
                        IPackagesViewPart view = (IPackagesViewPart)page.showView("org.eclipse.jdt.ui.PackageExplorer");
                        view.selectAndReveal(element);
                    }
                }
            }
        }
        catch (CoreException e) {
            ErrorDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.OpenGeneratedAction_EditorError, (String)Messages.OpenGeneratedAction_ErrorOpenType, (IStatus)e.getStatus());
        }
    }
}

