/*******************************************************************************
 * Copyright (c) 2010 Ecliptical Software Inc. and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Ecliptical Software Inc. - initial API and implementation
 *******************************************************************************/
package org.eclipse.emf.mint.internal.ui.views;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.emf.mint.IItemJavaElementDescriptor;

public class ItemJavaElementDescriptor extends PlatformObject {
	
	public static final Object ERROR_ELEMENT = new Object();

	private final IItemJavaElementDescriptor descriptor;

	private final Object target;

	private Object element;

	public ItemJavaElementDescriptor(IItemJavaElementDescriptor descriptor, Object target) {
		this.descriptor = descriptor;
		this.target = target;
	}

	public IItemJavaElementDescriptor getDescriptor() {
		return descriptor;
	}

	public Object getTarget() {
		return target;
	}

	public Object getElement() {
		return element;
	}

	public void setElement(Object element) {
		if (element == null)
			element = ERROR_ELEMENT;
		
		this.element = element;
	}

	@SuppressWarnings("rawtypes")
	public Object getAdapter(Class adapter) {
		if (element != null) {
			if (adapter.isInstance(element))
				return element;

			if (element instanceof IAdaptable)
				return ((IAdaptable) element).getAdapter(adapter);
		}

		return super.getAdapter(adapter);
	}
}