/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.client.impl;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.cdo.client.AttributeConverter;
import org.eclipse.emf.cdo.client.ClassInfo;
import org.eclipse.emf.cdo.client.MappingProvider;
import org.eclipse.emf.cdo.client.PackageInfo;
import org.eclipse.emf.cdo.client.PackageListener;
import org.eclipse.emf.cdo.client.PackageManager;
import org.eclipse.emf.cdo.client.impl.AnnotationMappingProviderImpl;
import org.eclipse.emf.cdo.client.impl.ClassInfoImpl;
import org.eclipse.emf.cdo.client.impl.PackageInfoImpl;
import org.eclipse.emf.cdo.client.impl.XMLMappingProviderImpl;
import org.eclipse.emf.cdo.client.internal.ClientActivator;
import org.eclipse.emf.cdo.core.OIDEncoder;
import org.eclipse.emf.cdo.mapping.ClassMapping;
import org.eclipse.emf.cdo.mapping.PackageMapping;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceFactoryImpl;
import org.eclipse.net4j.core.Channel;
import org.eclipse.net4j.spring.ValidationException;
import org.eclipse.net4j.spring.impl.ServiceImpl;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageManagerImpl
extends ServiceImpl
implements PackageManager {
    public static final boolean DEFAULT_AUTO_PERSISTENT = true;
    private boolean autoPersistent = true;
    private OIDEncoder oidEncoder;
    private AttributeConverter attributeConverter;
    private transient boolean newPackagesToAnnounce = false;
    private transient Map<EClass, ClassInfo> eClassToClassInfoMap = new HashMap<EClass, ClassInfo>(2111);
    private transient Map<Integer, ClassInfo> cidToClassInfoMap = new HashMap<Integer, ClassInfo>(2111);
    private transient List<PackageInfo> packages = new ArrayList<PackageInfo>();
    private transient List<PackageListener> listeners = new ArrayList<PackageListener>();

    @Override
    public OIDEncoder getOidEncoder() {
        return this.oidEncoder;
    }

    public void setOidEncoder(OIDEncoder oidEncoder) {
        this.doSet("oidEncoder", oidEncoder);
    }

    @Override
    public AttributeConverter getAttributeConverter() {
        return this.attributeConverter;
    }

    public void setAttributeConverter(AttributeConverter attributeConverter) {
        this.doSet("attributeConverter", attributeConverter);
    }

    @Override
    public void addPackage(EPackage ePackage, String mappingFile) {
        if (this.isDebugEnabled()) {
            this.debug("Analyzing package " + ePackage.getNsURI());
        }
        MappingProvider provider = this.getMappingProvider(ePackage, mappingFile);
        PackageInfoImpl packageInfo = new PackageInfoImpl(ePackage, provider.getPackageMapping(), this);
        EList classifiers = ePackage.getEClassifiers();
        for (EClassifier classifier : classifiers) {
            if (!(classifier instanceof EClass)) continue;
            this.addClass((EClass)classifier, packageInfo, provider);
        }
        this.packages.add(packageInfo);
        this.notifyPackageListeners();
        this.newPackagesToAnnounce = true;
    }

    protected void addClass(EClass eClass, PackageInfo packageInfo, MappingProvider provider) {
        ClassMapping classMapping;
        if (this.isDebugEnabled()) {
            this.debug("Analyzing class " + eClass.getName());
        }
        if ((classMapping = provider.getClassMapping(eClass.getName())) != null) {
            ClassInfoImpl classInfo = new ClassInfoImpl(eClass, packageInfo, classMapping);
            this.eClassToClassInfoMap.put(eClass, classInfo);
            packageInfo.addClass(classInfo);
        }
    }

    protected MappingProvider getMappingProvider(EPackage ePackage, String mappingFile) {
        if (mappingFile == null) {
            mappingFile = String.valueOf(ePackage.getName().replace('.', '_')) + ".xml";
        }
        File file = new File(mappingFile);
        mappingFile = file.getAbsolutePath();
        boolean mappingExists = file.exists();
        try {
            if (mappingExists) {
                if (this.isDebugEnabled()) {
                    this.debug("Using mapping file " + mappingFile);
                }
                XMLMappingProviderImpl provider = new XMLMappingProviderImpl(mappingFile);
                return provider;
            }
            if (this.isDebugEnabled()) {
                this.debug("Creating mapping file " + mappingFile);
            }
            AnnotationMappingProviderImpl provider = new AnnotationMappingProviderImpl(ePackage, this.autoPersistent, this.attributeConverter);
            this.saveMappingModel(mappingFile, provider.getPackageMapping());
            return provider;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void notifyPackageListeners() {
        for (PackageListener listener : this.listeners) {
            listener.notifyAddedPackage();
        }
    }

    @Override
    public void addPackageListener(PackageListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removePackageListener(PackageListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public List<PackageInfo> getPackages() {
        return this.packages;
    }

    @Override
    public ClassInfo getClassInfo(EClass eClass) {
        return this.eClassToClassInfoMap.get(eClass);
    }

    @Override
    public ClassInfo getClassInfo(EObject eObject) {
        EClass eClass = eObject.eClass();
        return this.getClassInfo(eClass);
    }

    @Override
    public ClassInfo getClassInfo(int cid) {
        return this.cidToClassInfoMap.get(new Integer(cid));
    }

    @Override
    public Iterator<ClassInfo> getClassInfos() {
        return this.eClassToClassInfoMap.values().iterator();
    }

    public boolean isAutoPersistent() {
        return this.autoPersistent;
    }

    public void setAutoPersistent(boolean autoPersistent) {
        this.doSet("autoPersistent", autoPersistent);
    }

    protected void saveMappingModel(String fileName, PackageMapping model) throws IOException {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Map map = resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap();
        map.put("xml", new XMLResourceFactoryImpl());
        URI uri = URI.createFileURI((String)fileName);
        Resource resource = resourceSet.createResource(uri);
        resource.getContents().add((Object)model);
        resource.save(Collections.EMPTY_MAP);
    }

    @Override
    public void initCID(ClassInfo classInfo) {
        int cid = classInfo.getCID();
        this.cidToClassInfoMap.put(new Integer(cid), classInfo);
    }

    @Override
    public void announceNewPackages(Channel channel) {
        if (this.isDebugEnabled()) {
            this.debug("Announcing new packages");
        }
        if (this.newPackagesToAnnounce) {
            for (PackageInfo packageInfo : this.packages) {
                if (packageInfo.isAnnounced()) continue;
                if (this.isDebugEnabled()) {
                    this.debug("Announcing package " + packageInfo.getFullName());
                }
                packageInfo.announce(channel);
            }
            this.newPackagesToAnnounce = false;
        }
    }

    public void processMappings() {
        List<ClientActivator.MappingElement> elements = ClientActivator.getPlugin().getMappingElements();
        if (elements == null) {
            throw new IllegalStateException("Mapping elements are not parsed yet");
        }
        for (ClientActivator.MappingElement element : elements) {
            String mappingFileName;
            String uri = element.getUri();
            String map = element.getMap();
            EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage(uri);
            if (ePackage == null) {
                throw new ValidationException("There is no EPackage registered under the specified URI " + uri);
            }
            String id = element.configurationElement().getNamespaceIdentifier();
            try {
                Bundle bundle = Platform.getBundle((String)id);
                URL entry = bundle.getEntry(map);
                mappingFileName = entry == null ? null : FileLocator.toFileURL((URL)entry).getFile();
            }
            catch (IOException ex) {
                throw new ValidationException("Error while computing location of bundle " + id, (Throwable)ex);
            }
            this.addPackage(ePackage, mappingFileName);
        }
    }

    protected void validate() throws ValidationException {
        super.validate();
        this.assertNotNull("oidEncoder");
        this.assertNotNull("attributeConverter");
        this.processMappings();
    }

    protected void deactivate() throws Exception {
        this.attributeConverter = null;
        this.cidToClassInfoMap = null;
        this.eClassToClassInfoMap = null;
        this.listeners = null;
        this.oidEncoder = null;
        this.packages = null;
        super.deactivate();
    }
}

