/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.properties.internal.sections;

import java.util.regex.Pattern;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecoretools.properties.internal.Messages;
import org.eclipse.emf.ecoretools.tabbedproperties.sections.AbstractIntegerPropertySection;

public class UpperBoundPropertySection
extends AbstractIntegerPropertySection {
    public static final String UPPER_BOUND_PATTERN = "\\*|\\?|^[-\\d][\\d]*";
    public static final Pattern UPPER_PATTERN = Pattern.compile("\\*|\\?|^[-\\d][\\d]*");

    protected EStructuralFeature getFeature() {
        return EcorePackage.Literals.ETYPED_ELEMENT__UPPER_BOUND;
    }

    protected Integer getFeatureInteger() {
        return new Integer(((ETypedElement)this.getEObject()).getUpperBound());
    }

    protected String getLabelText() {
        return Messages.UpperBoundPropertySection_UpperBound;
    }

    protected boolean isTextValid() {
        return UPPER_PATTERN.matcher(this.getText().getText()).matches();
    }

    protected Object getNewFeatureValue(String newText) {
        String text = newText;
        if ("*".equals(newText)) {
            text = "-1";
        } else if ("?".equals(newText)) {
            text = "-2";
        }
        return new Integer(Integer.parseInt(text));
    }

    protected String getFeatureAsString() {
        Integer upper = this.getFeatureInteger();
        if (upper == -1) {
            return "*";
        }
        if (upper == -2) {
            return "?";
        }
        return this.getFeatureInteger().toString();
    }
}

