/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mint.internal.ui.actions;

import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.CommandEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.ICommandListener;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.mint.internal.ui.MintUI;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionDelegate2;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.services.IServiceLocator;

public abstract class CommandAction
implements IActionDelegate2,
ICommandListener {
    protected final String commandId;
    protected IAction action;
    protected IServiceLocator locator;
    protected IShellProvider shellProvider;
    protected Command cmd;

    protected CommandAction(String commandId) {
        this.commandId = commandId;
    }

    protected void setAction(IAction action) {
        this.action = action;
    }

    protected void setPartSite(IWorkbenchPartSite site) {
        this.init((IServiceLocator)site, (IShellProvider)site);
    }

    protected void setWindow(IWorkbenchWindow window) {
        this.init((IServiceLocator)window, (IShellProvider)window);
    }

    public void init(IAction action) {
        this.setAction(action);
    }

    protected void init(IServiceLocator locator, IShellProvider shellProvider) {
        this.locator = locator;
        this.shellProvider = shellProvider;
        if (this.cmd != null) {
            this.cmd.removeCommandListener((ICommandListener)this);
            this.cmd = null;
        }
        if (locator != null) {
            ICommandService svc = (ICommandService)locator.getService(ICommandService.class);
            this.cmd = svc.getCommand(this.commandId);
            this.cmd.addCommandListener((ICommandListener)this);
            if (this.action != null) {
                this.action.setEnabled(this.cmd.isEnabled());
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void runWithEvent(IAction action, Event event) {
        if (this.cmd != null && this.cmd.isEnabled()) {
            IHandlerService svc = (IHandlerService)this.locator.getService(IHandlerService.class);
            try {
                this.cmd.executeWithChecks(svc.createExecutionEvent(this.cmd, event));
            }
            catch (ExecutionException e) {
                IStatus status = MintUI.getDefault().logError(this.getExecutionErrorMessage(e), e);
                ErrorDialog.openError((Shell)this.shellProvider.getShell(), null, null, (IStatus)status);
            }
            catch (NotDefinedException e) {
                MintUI.getDefault().logError(null, e);
            }
            catch (NotEnabledException e) {
                MintUI.getDefault().logError(null, e);
            }
            catch (NotHandledException e) {
                MintUI.getDefault().logError(null, e);
            }
        }
    }

    protected abstract String getExecutionErrorMessage(ExecutionException var1);

    public final void run(IAction action) {
        throw new UnsupportedOperationException();
    }

    public void dispose() {
        if (this.cmd != null) {
            this.cmd.removeCommandListener((ICommandListener)this);
            this.cmd = null;
        }
    }

    public void commandChanged(CommandEvent e) {
        if (e.isEnabledChanged() && this.action != null) {
            this.action.setEnabled(e.getCommand().isEnabled());
        }
    }
}

