/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.search.core.internal.replace.provisional;

import java.util.Collection;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.search.core.engine.IModelSearchQuery;
import org.eclipse.emf.search.core.internal.replace.provisional.IModelSearchReplaceHandler;
import org.eclipse.emf.search.core.internal.replace.provisional.ModelSearchResultCompositeChange;
import org.eclipse.emf.search.l10n.Messages;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public abstract class AbstractTextualModelSearchReplace
extends Refactoring {
    private IModelSearchQuery modelSearchQuery;
    private String replaceString;
    private Change modelSearchChange;
    private IModelSearchReplaceHandler replaceHandler;

    public AbstractTextualModelSearchReplace(IModelSearchQuery query, IModelSearchReplaceHandler handler) {
        this.modelSearchQuery = query;
        this.replaceHandler = handler;
    }

    protected IModelSearchReplaceHandler getReplaceHandler() {
        return this.replaceHandler;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        if (this.replaceString == null || this.replaceString.equals("")) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.getString("AbstractTextualModelSearchReplace.VoidExpressionError"));
        }
        RefactoringStatus resultingStatus = new RefactoringStatus();
        CompositeChange compositeChange = new CompositeChange(Messages.getString("AbstractTextualModelSearchReplace.ModelSearchChangeQueryLabel"));
        compositeChange.markAsSynthetic();
        boolean hasChanges = false;
        try {
            for (Object o : this.modelSearchQuery.getModelSearchResult().getRootResultHierarchies().keySet()) {
                Collection<Object> matches;
                if (!(o instanceof Resource) || (matches = this.modelSearchQuery.getModelSearchResult().getRootResultHierarchies().get(o)).isEmpty()) continue;
                for (Object m : matches) {
                    ModelSearchResultCompositeChange change = this.createModelSearchChange((Resource)o, this.modelSearchQuery, m, resultingStatus);
                    if (change == null) continue;
                    compositeChange.add((Change)change);
                    hasChanges = true;
                }
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.getString("AbstractTextualModelSearchReplace.DataError"));
        }
        if (!hasChanges && resultingStatus.isOK()) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.getString("AbstractTextualModelSearchReplace.NoChangesError"));
        }
        this.modelSearchChange = compositeChange;
        return resultingStatus;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        String searchString = this.modelSearchQuery.getQueryExpression();
        if (searchString.length() == 0) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.getString("AbstractTextualModelSearchReplace.BlockingVoidExprError"));
        }
        this.modelSearchQuery.run(pm);
        if (this.modelSearchQuery.getModelSearchResult().getTotalMatches() <= 0) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.getString("AbstractTextualModelSearchReplace.NoMatchError"));
        }
        return new RefactoringStatus();
    }

    private ModelSearchResultCompositeChange createModelSearchChange(Resource resource, IModelSearchQuery query, Object match, RefactoringStatus resultingStatus) throws PatternSyntaxException, CoreException {
        return new ModelSearchResultCompositeChange(query, resource, this.getReplaceHandler(), this.replaceString);
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return this.modelSearchChange;
    }

    public String getName() {
        return Messages.getString("AbstractTextualModelSearchReplace.ModelSearchTextReplaceLabel");
    }

    public IModelSearchQuery getModelSearchQuery() {
        return this.modelSearchQuery;
    }

    public String getReplaceString() {
        return this.replaceString;
    }

    public void setReplaceString(String string) {
        this.replaceString = string;
    }

    public Change getChange() {
        return this.modelSearchChange;
    }
}

