/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.core.impl;

import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import org.eclipse.net4j.core.NegotiationException;
import org.eclipse.net4j.core.Negotiator;
import org.eclipse.net4j.spring.ValidationException;
import org.eclipse.net4j.spring.impl.ServiceImpl;

public abstract class AbstractChallengeNegotiator
extends ServiceImpl
implements Negotiator {
    public static final byte[] NEGOTIATION_FAILURE = new byte[1];
    public static final byte[] NEGOTIATION_SUCCESS = new byte[]{1};
    public static final String PBE_WITH_MD5_AND_DES = "PBEWithMD5AndDES";
    public static final String DEFAULT_ALGORITHM_NAME = "PBEWithMD5AndDES";
    private String algorithmName = "PBEWithMD5AndDES";

    public String getAlgorithmName() {
        return this.algorithmName;
    }

    public void setAlgorithmName(String algorithmName) {
        this.doSet("algorithmName", algorithmName);
    }

    public byte[] encrypt(byte[] token, char[] password) throws NegotiationException {
        try {
            byte[] salt = new byte[]{-57, 115, 33, -116, 126, -56, -18, -103};
            PBEParameterSpec pbeParamSpec = new PBEParameterSpec(salt, 20);
            PBEKeySpec pbeKeySpec = new PBEKeySpec(password);
            SecretKeyFactory keyFac = SecretKeyFactory.getInstance(this.algorithmName);
            SecretKey pbeKey = keyFac.generateSecret(pbeKeySpec);
            Cipher pbeCipher = Cipher.getInstance(this.algorithmName);
            pbeCipher.init(1, (Key)pbeKey, pbeParamSpec);
            return pbeCipher.doFinal(token);
        }
        catch (Exception ex) {
            throw new NegotiationException("Could not encrypt token with password", ex);
        }
    }

    protected void validate() throws ValidationException {
        super.validate();
        this.assertNotNull("algorithmName");
    }

    protected void deactivate() throws Exception {
        this.algorithmName = null;
        super.deactivate();
    }
}

