/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.core.impl;

import java.util.HashMap;
import org.eclipse.net4j.core.Executor;
import org.eclipse.net4j.core.Pool;
import org.eclipse.net4j.core.Task;
import org.eclipse.net4j.core.TaskListener;
import org.eclipse.net4j.core.impl.AbstractExecutor;
import org.eclipse.net4j.spring.ValidationException;
import org.eclipse.net4j.util.ImplementationError;

public class DispatchingExecutorImpl
extends AbstractExecutor
implements TaskListener {
    protected HashMap checkouts = new HashMap(211);
    protected Pool executorPool;

    protected void doExecute(Task task, TaskListener listener) throws Exception {
        Executor executor = (Executor)this.executorPool.get();
        this.checkouts.put(task, new TaskInfo(executor, listener));
        executor.execute(task, this);
    }

    public void notifyFinished(Task task) {
        TaskInfo info = (TaskInfo)this.checkouts.remove(task);
        if (info == null) {
            throw new ImplementationError("task not executed by this dispatcher");
        }
        this.executorPool.put(info.getExecutor());
        if (info.getListener() != null) {
            info.getListener().notifyFinished(task);
        }
    }

    public Pool getExecutorPool() {
        return this.executorPool;
    }

    public void setExecutorPool(Pool executorPool) {
        this.doSet("executorPool", executorPool);
    }

    protected void validate() throws ValidationException {
        this.assertNotNull("executorPool");
    }

    protected void deactivate() throws Exception {
        this.checkouts = null;
        this.executorPool = null;
        super.deactivate();
    }

    protected static final class TaskInfo {
        protected Executor executor;
        protected TaskListener listener;

        public TaskInfo(Executor executor, TaskListener listener) {
            this.executor = executor;
            this.listener = listener;
        }

        public Executor getExecutor() {
            return this.executor;
        }

        public TaskListener getListener() {
            return this.listener;
        }
    }
}

