/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.core.impl;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.eclipse.net4j.core.Channel;
import org.eclipse.net4j.core.Multiplexer;
import org.eclipse.net4j.spring.InactiveException;
import org.eclipse.net4j.spring.impl.ServiceImpl;
import org.eclipse.net4j.util.thread.Worker;

public class MultiplexerImpl
extends ServiceImpl
implements Multiplexer {
    protected BlockingQueue<Channel> queue = new LinkedBlockingQueue<Channel>();
    protected Scheduler scheduler;

    public void cancel(Channel channel) {
        throw new UnsupportedOperationException();
    }

    public void schedule(Channel channel) {
        if (this.isDebugEnabled()) {
            this.debug("Scheduling channel " + channel);
        }
        this.queue.offer(channel);
    }

    public int getQueueLength() {
        return this.queue.size();
    }

    protected void activate() throws Exception {
        super.activate();
        this.scheduler = new Scheduler();
        this.scheduler.setDaemon(true);
        this.scheduler.startup();
    }

    protected void deactivate() throws Exception {
        this.scheduler.shutdown(200L);
        this.scheduler = null;
        this.queue = null;
        super.deactivate();
    }

    protected final class Scheduler
    extends Worker {
        public Scheduler() {
            super(String.valueOf(MultiplexerImpl.this.getFullBeanName()) + ".Scheduler");
        }

        public long doWorkStep(int progress) {
            try {
                Channel channel = MultiplexerImpl.this.queue.poll(100L, TimeUnit.MILLISECONDS);
                if (channel != null) {
                    channel.handleTransmission();
                }
            }
            catch (InterruptedException interruptedException) {
                return -1L;
            }
            catch (InactiveException inactiveException) {
                return -1L;
            }
            return 0L;
        }
    }
}

