/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.core.impl;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.net4j.core.Task;
import org.eclipse.net4j.core.TaskListener;
import org.eclipse.net4j.core.impl.AbstractExecutor;
import org.eclipse.net4j.spring.ValidationException;
import org.eclipse.net4j.util.thread.Worker;

public class QueueingExecutorImpl
extends AbstractExecutor {
    private transient List queue = new LinkedList();
    private transient Worker monitor;

    protected void activate() throws Exception {
        super.activate();
        this.monitor = new Monitor();
        this.monitor.setDaemon(true);
        this.monitor.startup();
    }

    protected void deactivate() throws Exception {
        this.monitor.shutdown(200L);
        this.monitor = null;
        this.queue = null;
        super.deactivate();
    }

    protected void validate() throws ValidationException {
        super.validate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doExecute(Task task, TaskListener listener) {
        List list = this.queue;
        synchronized (list) {
            this.queue.add(new TaskInfo(task, listener));
            this.queue.notifyAll();
        }
    }

    private static class TaskInfo {
        private Task task;
        private TaskListener listener;

        public TaskInfo(Task task, TaskListener listener) {
            this.task = task;
            this.listener = listener;
        }

        public TaskListener getListener() {
            return this.listener;
        }

        public Task getTask() {
            return this.task;
        }
    }

    private class Monitor
    extends Worker {
        public Monitor() {
            super(String.valueOf(QueueingExecutorImpl.this.getFullBeanName()) + ".Monitor");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected long doWorkStep(int progress) {
            TaskInfo taskInfo;
            List list = QueueingExecutorImpl.this.queue;
            synchronized (list) {
                try {
                    while (QueueingExecutorImpl.this.queue.isEmpty()) {
                        this.doWait(QueueingExecutorImpl.this.queue);
                    }
                }
                catch (InterruptedException interruptedException) {
                    return -1L;
                }
                taskInfo = (TaskInfo)QueueingExecutorImpl.this.queue.remove(0);
            }
            try {
                taskInfo.getTask().execute();
                if (taskInfo.getListener() != null) {
                    taskInfo.getListener().notifyFinished(taskInfo.getTask());
                }
            }
            catch (Exception ex) {
                QueueingExecutorImpl.this.error("Error while executing task " + taskInfo.getTask(), ex);
            }
            return 0L;
        }
    }
}

