/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.examples.prov.client.ui.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.net4j.core.Channel;
import org.eclipse.net4j.core.Connector;
import org.eclipse.net4j.core.Request;
import org.eclipse.net4j.examples.client.ClientActivator;
import org.eclipse.net4j.examples.client.ui.BusyTemplate;
import org.eclipse.net4j.examples.prov.Site;
import org.eclipse.net4j.examples.prov.client.DensityProvisioningClientPlugin;
import org.eclipse.net4j.examples.prov.client.protocol.LoadSiteRequest;
import org.eclipse.net4j.examples.prov.client.protocol.SaveSiteRequest;
import org.eclipse.net4j.examples.prov.client.ui.DensityProvisioningClientUiPlugin;
import org.eclipse.net4j.examples.prov.client.ui.dialogs.ProvisioningDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class ProvisioningDialogAction
implements IWorkbenchWindowActionDelegate {
    private IWorkbenchWindow window;

    public void run(IAction action) {
        try {
            Channel channel = this.openChannel();
            if (channel == null) {
                MessageDialog.openError((Shell)this.window.getShell(), (String)"Provisioning Administration", (String)"A channel could not be opened.");
                return;
            }
            Site site = this.loadSite(channel);
            if (channel == null) {
                MessageDialog.openError((Shell)this.window.getShell(), (String)"Provisioning Administration", (String)"The site could not be loaded from the Density server.");
                return;
            }
            ProvisioningDialog dialog = new ProvisioningDialog(this.window.getShell(), channel, site);
            int code = dialog.open();
            if (code == 0) {
                this.saveSite(channel, site);
            }
            channel.stop();
        }
        catch (Exception ex) {
            DensityProvisioningClientUiPlugin.getDefault().error("Problem during administration of Provisioning", ex);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
        this.window = window;
    }

    private Channel openChannel() {
        try {
            DensityProvisioningClientPlugin.getContainer();
            Connector connector = ClientActivator.getConnector();
            Channel channel = connector.addChannel("org.eclipse.net4j.examples.prov");
            return channel;
        }
        catch (Exception ex) {
            DensityProvisioningClientUiPlugin.getDefault().error("Could not open provisioning channel", ex);
            return null;
        }
    }

    private Site loadSite(final Channel channel) {
        return (Site)new BusyTemplate(this.window.getShell()){

            protected Object run() throws Exception {
                LoadSiteRequest request = new LoadSiteRequest();
                return (Site)channel.transmit((Request)request);
            }
        }.execute();
    }

    private int saveSite(final Channel channel, final Site site) {
        return (Integer)new BusyTemplate(this.window.getShell()){

            protected Object run() throws Exception {
                SaveSiteRequest request = new SaveSiteRequest(site);
                return channel.transmit((Request)request);
            }
        }.execute();
    }
}

