/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.examples.prov.server.impl;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Date;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.net4j.examples.prov.server.DateFormatter;
import org.eclipse.net4j.examples.prov.server.Httpd;
import org.eclipse.net4j.examples.prov.server.HttpdException;
import org.eclipse.net4j.examples.prov.server.UrlCodec;
import org.eclipse.net4j.spring.ValidationException;
import org.eclipse.net4j.spring.impl.ServiceImpl;
import org.eclipse.net4j.util.thread.Worker;

public abstract class AbstractHttpd
extends ServiceImpl
implements Httpd {
    public static final boolean TRACING = false;
    protected int port;
    protected Map mimeTypes;
    protected DateFormatter dateFormatter;
    protected UrlCodec urlCodec;
    private transient Worker worker;
    private transient ServerSocket serverSocket;

    public void addMimeType(String extension, String mimeType) {
        this.mimeTypes.put(extension, mimeType);
    }

    public String removeMimeType(String extension) {
        return (String)this.mimeTypes.remove(extension);
    }

    public String getMimeType(String extension) {
        return (String)this.mimeTypes.get(extension);
    }

    protected abstract Response serve(String var1, String var2, Properties var3, Properties var4);

    protected void dump(String uri, String method, Properties header, Properties parms) {
        this.debug(String.valueOf(method) + " " + uri);
    }

    protected String encodeUri(String uri) {
        String newUri = "";
        StringTokenizer st = new StringTokenizer(uri, "/ ", true);
        while (st.hasMoreTokens()) {
            String tok = st.nextToken();
            newUri = tok.equals("/") ? String.valueOf(newUri) + "/" : (tok.equals(" ") ? String.valueOf(newUri) + "%20" : String.valueOf(newUri) + this.urlCodec.encode(tok));
        }
        return newUri;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.doSet("port", port);
    }

    protected void validate() throws ValidationException {
        super.validate();
        this.assertNotNull("mimeTypes");
        if (this.port <= 0) {
            throw new ValidationException("Port is not a positive integer");
        }
    }

    protected void activate() throws Exception {
        super.activate();
        try {
            this.serverSocket = new ServerSocket(this.port);
            this.worker = new Worker(String.valueOf(this.getFullBeanName()) + ".Listener"){

                protected long doWorkStep(int progress) {
                    block4: {
                        block3: {
                            if (AbstractHttpd.this.serverSocket != null && !AbstractHttpd.this.serverSocket.isClosed()) break block3;
                            return -1L;
                        }
                        try {
                            Socket socket = AbstractHttpd.this.serverSocket.accept();
                            new Session(socket);
                        }
                        catch (IOException ex) {
                            if (AbstractHttpd.this.serverSocket == null || AbstractHttpd.this.serverSocket.isClosed()) break block4;
                            AbstractHttpd.this.warn("Error while accepting HTTP session", ex);
                        }
                    }
                    return 0L;
                }
            };
            this.worker.setDaemon(true);
            this.worker.startup();
        }
        catch (Exception ex) {
            throw new HttpdException("Error while starting Httpd", ex);
        }
    }

    protected void deactivate() throws Exception {
        if (this.serverSocket != null) {
            this.serverSocket.close();
            this.serverSocket = null;
        }
        if (this.worker != null) {
            this.worker.shutdown(200L);
            this.worker = null;
        }
        this.dateFormatter = null;
        this.mimeTypes = null;
        this.urlCodec = null;
        super.deactivate();
    }

    public Map getMimeTypes() {
        return this.mimeTypes;
    }

    public void setMimeTypes(Map mimeTypes) {
        this.doSet("mimeTypes", mimeTypes);
    }

    public DateFormatter getDateFormatter() {
        return this.dateFormatter;
    }

    public void setDateFormatter(DateFormatter dateFormatter) {
        this.doSet("dateFormatter", dateFormatter);
    }

    public UrlCodec getUrlCodec() {
        return this.urlCodec;
    }

    public void setUrlCodec(UrlCodec urlCodec) {
        this.doSet("urlCodec", urlCodec);
    }

    public static class Response {
        public String status;
        public String mimeType;
        public InputStream data;
        public Properties header = new Properties();

        public Response() {
            this.status = "200 OK";
        }

        public Response(String status, String mimeType, InputStream data) {
            this.status = status;
            this.mimeType = mimeType;
            this.data = data;
        }

        public Response(String status, String mimeType, String txt) {
            this(status, mimeType, new ByteArrayInputStream(txt.getBytes()));
        }

        public void addHeader(String name, String value) {
            this.header.put(name, value);
        }
    }

    private class Session
    extends Worker {
        private static final String LF = "\r\n";
        private Socket socket;

        public Session(Socket s) {
            super(String.valueOf(AbstractHttpd.this.getFullBeanName()) + ".Session");
            this.socket = s;
            this.startup();
        }

        protected long doWorkStep(int progress) {
            InputStream is;
            block14: {
                is = this.socket.getInputStream();
                if (is != null) break block14;
                return 0L;
            }
            try {
                Response r;
                BufferedReader in = new BufferedReader(new InputStreamReader(is));
                StringTokenizer st = new StringTokenizer(in.readLine());
                if (!st.hasMoreTokens()) {
                    this.sendError("400 Bad Request", "BAD REQUEST: Syntax error. Usage: GET /example/file.html");
                }
                String method = st.nextToken();
                if (!st.hasMoreTokens()) {
                    this.sendError("400 Bad Request", "BAD REQUEST: Missing URI. Usage: GET /example/file.html");
                }
                String uri = this.decodePercent(st.nextToken());
                Properties parms = new Properties();
                int qmi = uri.indexOf(63);
                if (qmi >= 0) {
                    this.decodeParms(uri.substring(qmi + 1), parms);
                    uri = this.decodePercent(uri.substring(0, qmi));
                }
                Properties header = new Properties();
                if (st.hasMoreTokens()) {
                    String line = in.readLine();
                    while (line.trim().length() > 0) {
                        int p = line.indexOf(58);
                        header.put(line.substring(0, p).trim(), line.substring(p + 1).trim());
                        line = in.readLine();
                    }
                }
                if (method.equalsIgnoreCase("POST")) {
                    this.decodeParms(in.readLine(), parms);
                }
                if ((r = AbstractHttpd.this.serve(uri, method, header, parms)) == null) {
                    this.sendError("500 Internal Server Error", "SERVER INTERNAL ERROR: Serve() returned a null response.");
                } else {
                    this.sendResponse(r.status, r.mimeType, r.header, r.data);
                }
                in.close();
            }
            catch (IOException ex) {
                try {
                    this.sendError("500 Internal Server Error", "SERVER INTERNAL ERROR: IOException: " + ex.getMessage());
                }
                catch (Throwable throwable) {}
            }
            catch (InterruptedException interruptedException) {}
            return -1L;
        }

        private String decodePercent(String str) throws InterruptedException {
            try {
                StringBuffer sb = new StringBuffer();
                int i = 0;
                while (i < str.length()) {
                    char c = str.charAt(i);
                    switch (c) {
                        case '+': {
                            sb.append(' ');
                            break;
                        }
                        case '%': {
                            sb.append((char)Integer.parseInt(str.substring(i + 1, i + 3), 16));
                            i += 2;
                            break;
                        }
                        default: {
                            sb.append(c);
                        }
                    }
                    ++i;
                }
                return new String(sb.toString().getBytes());
            }
            catch (Exception exception) {
                this.sendError("400 Bad Request", "BAD REQUEST: Bad percent-encoding.");
                return null;
            }
        }

        private void decodeParms(String parms, Properties p) throws InterruptedException {
            if (parms == null) {
                return;
            }
            StringTokenizer st = new StringTokenizer(parms, "&");
            while (st.hasMoreTokens()) {
                String e = st.nextToken();
                int sep = e.indexOf(61);
                if (sep < 0) continue;
                p.put(this.decodePercent(e.substring(0, sep)).trim(), this.decodePercent(e.substring(sep + 1)));
            }
        }

        private void sendError(String status, String msg) throws InterruptedException {
            this.sendResponse(status, "text/plain", null, new ByteArrayInputStream(msg.getBytes()));
            throw new InterruptedException();
        }

        private void sendResponse(String status, String mime, Properties header, InputStream data) {
            try {
                if (status == null) {
                    throw new IllegalArgumentException("status == null");
                }
                OutputStream out = this.socket.getOutputStream();
                PrintWriter pw = new PrintWriter(out);
                this.print(pw, "HTTP/1.0 " + status + " \r\n");
                if (mime != null) {
                    this.print(pw, "Content-Type: " + mime + LF);
                }
                if (header != null) {
                    Enumeration<Object> e = header.keys();
                    while (e.hasMoreElements()) {
                        String key = (String)e.nextElement();
                        String value = header.getProperty(key);
                        this.print(pw, String.valueOf(key) + ": " + value + LF);
                    }
                }
                if (header == null || header.getProperty("Date") == null) {
                    this.print(pw, "Date: " + AbstractHttpd.this.dateFormatter.format(new Date()) + LF);
                }
                this.print(pw, LF);
                pw.flush();
                if (data != null) {
                    byte[] buffer = new byte[2048];
                    int bytesRead = 2048;
                    while (bytesRead == 2048) {
                        bytesRead = data.read(buffer, 0, 2048);
                        out.write(buffer, 0, bytesRead);
                    }
                }
                out.flush();
                out.close();
                if (data != null) {
                    data.close();
                }
            }
            catch (IOException iOException) {
                try {
                    this.socket.close();
                }
                catch (Throwable throwable) {}
            }
        }

        private void print(PrintWriter pw, String string) {
            pw.print(string);
        }
    }
}

