/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.search.engine;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.search.core.engine.IModelSearchQuery;
import org.eclipse.emf.search.core.eval.IModelSearchQueryEvaluator;
import org.eclipse.emf.search.core.parameters.IModelSearchQueryParameters;
import org.eclipse.emf.search.core.results.IModelResultEntry;
import org.eclipse.emf.search.ecore.engine.EcoreMetaModelIntrospector;
import org.eclipse.emf.search.ecore.engine.EcoreModelSearchQuery;
import org.eclipse.emf.search.ecore.results.EcoreModelSearchResultEntry;
import org.eclipse.emf.search.ecore.utils.EcoreModelLoaderUtil;
import org.eclipse.uml2.search.Activator;
import org.eclipse.uml2.search.evaluators.UML2TextualModelSearchQueryEvaluator;
import org.eclipse.uml2.search.l10n.Messages;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.UMLPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UML2ModelSearchQuery
extends EcoreModelSearchQuery {
    public static final String UML2_MODEL_SEARCH_IMAGE_PATH = "icons/uml2.gif";
    public static final String UML2_MODEL_SEARCH_RESULT_IMAGE_PATH = "icons/usearch.gif";

    public String getQueryImagePath() {
        return UML2_MODEL_SEARCH_IMAGE_PATH;
    }

    public String getResultImagePath() {
        return UML2_MODEL_SEARCH_RESULT_IMAGE_PATH;
    }

    public Collection<String> getTargetMetaModelIDs() {
        return Arrays.asList("http://www.eclipse.org/uml2/2.1.0/UML");
    }

    public String getBundleSymbolicName() {
        return Activator.getDefault().getBundle().getSymbolicName();
    }

    public UML2ModelSearchQuery(String expr, IModelSearchQueryParameters parameters) {
        super(expr, parameters);
    }

    public IStatus search(Object resource, boolean notify, IProgressMonitor monitor) {
        try {
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            EObject root = EcoreModelLoaderUtil.openFile((Object)resource, (boolean)false);
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            this.validParticipantMetaElements = EcoreMetaModelIntrospector.discriminateValidMetaElements((EObject)root, UML2SupportedElements.getSupportedElements(this.participantElements));
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            this.getEvaluator().eval((Object)this, resource, notify);
            monitor.setTaskName(this.getLabel());
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
        }
        catch (Exception exception) {
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }

    public IStatus search(Object resource, boolean notify) {
        try {
            EObject root = EcoreModelLoaderUtil.openFile((Object)resource, (boolean)false);
            this.validParticipantMetaElements = EcoreMetaModelIntrospector.discriminateValidMetaElements((EObject)root, UML2SupportedElements.getSupportedElements(this.participantElements));
            this.getEvaluator().eval((Object)this, resource, notify);
        }
        catch (Exception exception) {
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }

    public String getName() {
        switch (this.getKind()) {
            case NORMAL_TEXT: {
                return Messages.getString("UML2ModelSearchQuery.UML2NormalTextMessage");
            }
            case CASE_SENSITIVE: {
                return Messages.getString("UML2ModelSearchQuery.UML2CaseSensitiveMessage");
            }
            case REGULAR_EXPRESSION: {
                return Messages.getString("UML2ModelSearchQuery.UML2RegularExpressionMessage");
            }
        }
        return Messages.getString("UML2ModelSearchQuery.UML2Message");
    }

    private IModelResultEntry buildSearchResultEntryHierarchy(IModelResultEntry intermediate, Object resource, Element current, Element leaf) {
        if (current instanceof Element) {
            EcoreModelSearchResultEntry entryContainer = new EcoreModelSearchResultEntry(null, resource, (Object)current, false);
            entryContainer.addChildren(intermediate);
            intermediate.setParent((IModelResultEntry)entryContainer);
            return this.buildSearchResultEntryHierarchy((IModelResultEntry)entryContainer, resource, current.getOwner(), leaf);
        }
        return intermediate;
    }

    public IModelSearchQueryEvaluator<IModelSearchQuery, ?> getEvaluator() {
        this.evaluator = this.getModelSearchParameters().getEvaluator();
        return this.evaluator != null ? this.evaluator : (this.evaluator = new UML2TextualModelSearchQueryEvaluator());
    }

    public IModelResultEntry buildSearchResultEntryHierarchy(Object resource, Object o) {
        EcoreModelSearchResultEntry mesre = new EcoreModelSearchResultEntry(null, resource, o, true);
        if (o instanceof Element) {
            Element c = (Element)o;
            return this.buildSearchResultEntryHierarchy((IModelResultEntry)mesre, resource, c.getOwner(), c);
        }
        return mesre;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class UML2SupportedElements {
        UML2SupportedElements() {
        }

        private static List<EClassifier> getUML2EClassifiersLiterals() {
            ArrayList<EClassifier> eclassifiersLiteralsList = new ArrayList<EClassifier>();
            try {
                for (Object o : UMLPackage.eINSTANCE.getEClassifiers()) {
                    if (!(o instanceof ENamedElement)) continue;
                    eclassifiersLiteralsList.add((EClassifier)o);
                }
            }
            catch (Throwable t) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.uml2.search", 0, Messages.getString("UML2ModelSearchQuery.uml2ClassifiersWalkErrorMessage"), t));
            }
            return eclassifiersLiteralsList;
        }

        public static List<EClassifier> getSupportedElements(List<? extends Object> participantEClassList) {
            ArrayList<EClassifier> definitiveMetaElementParticipantList = new ArrayList<EClassifier>();
            for (EClassifier eClass : UML2SupportedElements.getUML2EClassifiersLiterals()) {
                if (!participantEClassList.contains(eClass)) continue;
                definitiveMetaElementParticipantList.add(eClass);
            }
            return definitiveMetaElementParticipantList;
        }
    }
}

