/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.dbgen.impl;

import org.eclipse.emf.cdo.dbgen.Column;
import org.eclipse.emf.cdo.dbgen.ColumnType;
import org.eclipse.emf.cdo.dbgen.DBGenFactory;
import org.eclipse.emf.cdo.dbgen.DBGenPackage;
import org.eclipse.emf.cdo.dbgen.Database;
import org.eclipse.emf.cdo.dbgen.Index;
import org.eclipse.emf.cdo.dbgen.IndexType;
import org.eclipse.emf.cdo.dbgen.Table;
import org.eclipse.emf.cdo.dbgen.impl.ColumnImpl;
import org.eclipse.emf.cdo.dbgen.impl.DatabaseImpl;
import org.eclipse.emf.cdo.dbgen.impl.IndexImpl;
import org.eclipse.emf.cdo.dbgen.impl.TableImpl;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;

public class DBGenFactoryImpl
extends EFactoryImpl
implements DBGenFactory {
    public static DBGenFactory init() {
        try {
            DBGenFactory theDBGenFactory = (DBGenFactory)EPackage.Registry.INSTANCE.getEFactory("http://www.eclipse.org/net4j/dbgen.ecore");
            if (theDBGenFactory != null) {
                return theDBGenFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new DBGenFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createDatabase();
            }
            case 1: {
                return this.createTable();
            }
            case 2: {
                return this.createColumn();
            }
            case 3: {
                return this.createIndex();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 4: {
                return this.createColumnTypeFromString(eDataType, initialValue);
            }
            case 5: {
                return this.createIndexTypeFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 4: {
                return this.convertColumnTypeToString(eDataType, instanceValue);
            }
            case 5: {
                return this.convertIndexTypeToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public Database createDatabase() {
        DatabaseImpl database = new DatabaseImpl();
        return database;
    }

    public Table createTable() {
        TableImpl table = new TableImpl();
        return table;
    }

    public Column createColumn() {
        ColumnImpl column = new ColumnImpl();
        return column;
    }

    public Index createIndex() {
        IndexImpl index = new IndexImpl();
        return index;
    }

    public ColumnType createColumnTypeFromString(EDataType eDataType, String initialValue) {
        ColumnType result = ColumnType.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertColumnTypeToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public IndexType createIndexTypeFromString(EDataType eDataType, String initialValue) {
        IndexType result = IndexType.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertIndexTypeToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public DBGenPackage getDBGenPackage() {
        return (DBGenPackage)this.getEPackage();
    }

    public static DBGenPackage getPackage() {
        return DBGenPackage.eINSTANCE;
    }
}

