/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.protocol;

import org.eclipse.emf.cdo.server.Mapper;
import org.eclipse.emf.cdo.server.ResourceInfo;
import org.eclipse.emf.cdo.server.ResourceManager;
import org.eclipse.emf.cdo.server.ServerCDOProtocol;
import org.eclipse.net4j.core.impl.AbstractIndicationWithResponse;

public class ResourceRIDIndication
extends AbstractIndicationWithResponse {
    private int rid;

    public short getSignalId() {
        return 3;
    }

    public void indicate() {
        this.rid = this.receiveInt();
        if (this.isDebugEnabled()) {
            this.debug("Requested rid " + this.rid);
        }
    }

    public void respond() {
        Mapper mapper = ((ServerCDOProtocol)this.getProtocol()).getMapper();
        ResourceManager resourceManager = mapper.getResourceManager();
        ResourceInfo info = resourceManager.getResourceInfo(this.rid, mapper);
        if (info == null) {
            if (this.isDebugEnabled()) {
                this.debug("No resource with rid " + this.rid);
            }
            this.transmitString(null);
        } else {
            if (this.isDebugEnabled()) {
                this.debug("Responding path " + info.getPath());
            }
            this.transmitString(info.getPath());
        }
    }
}

